/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.item;

import com.necromancer.util.WandTooltipHelper;
import com.necromancer.util.WandUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class LightningWandItem
extends class_1792 {
    private static final String ENERGY_KEY = "LightningEnergy";
    private static final String STAGE_KEY = "CallOfLightStage";
    private static final String STAGE_TIME_KEY = "CallOfLightTime";
    private static final String DASH_TRAIL_KEY = "DashTrailTicks";
    private static final int STAGE_DURATION = 100;
    private static final int DASH_TRAIL_DURATION = 40;

    public LightningWandItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            this.triggerExplosion((class_3218)world, user, stack);
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return false;
    }

    private void triggerExplosion(class_3218 sw, class_1657 player, class_1799 stack) {
        float cost;
        float energy = LightningWandItem.getEnergy(stack);
        float f = cost = energy < 40.0f ? 20.0f : 40.0f;
        if (energy < cost) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cNot enough energy! (Need " + (int)cost + ")")), true);
            return;
        }
        LightningWandItem.useEnergy(stack, cost);
        float power = 0.0f;
        float range = 0.0f;
        String msg = "";
        if (energy < 50.0f) {
            power = 8.0f;
            range = 6.0f;
            msg = "\u00a7e\u26a1 Electric Zap!";
        } else if (energy < 70.0f) {
            power = 15.0f;
            range = 10.0f;
            msg = "\u00a76\u26a1 Thunderous Blast!";
        } else if (energy < 90.0f) {
            power = 25.0f;
            range = 15.0f;
            msg = "\u00a7c\u26a1 STORM STRIKE!";
        } else {
            power = energy / 2.5f;
            range = energy / 3.0f;
            msg = "\u00a7b\u00a7l\u26a1 GOD OF THUNDER! \u26a1";
        }
        player.method_7353((class_2561)class_2561.method_43470((String)msg), true);
        sw.method_8537((class_1297)player, player.method_23317(), player.method_23318(), player.method_23321(), range / 3.0f, false, class_1937.class_7867.field_40888);
        List entities = sw.method_8390(class_1309.class, player.method_5829().method_1014((double)range), e -> e != player);
        for (class_1309 target : entities) {
            target.method_5643(sw.method_48963().method_48815((class_1297)player, (class_1297)player), power);
            WandUtils.applyRuneEffects(player, target, stack);
            sw.method_14199((class_2394)class_2398.field_29644, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), (int)(energy / 5.0f), 0.3, 0.3, 0.3, 0.1);
        }
        sw.method_14199((class_2394)class_2398.field_17909, player.method_23317(), player.method_23318(), player.method_23321(), 10, 0.2, 0.2, 0.2, 0.0);
        sw.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14956, class_3419.field_15248, 1.5f, 0.8f);
        sw.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15152, class_3419.field_15248, 1.0f, 1.0f);
    }

    public static void triggerLightning(class_1657 player, class_1799 stack) {
        class_1937 world = player.method_37908();
        if (world.field_9236) {
            return;
        }
        int stage = stack.method_7948().method_10550(STAGE_KEY);
        long cooldown = stage == 2 ? 20L : (long)(stage == 1 ? 40 : 60);
        long lastUse = stack.method_7948().method_10537("LastLightningUse");
        if (world.method_8510() - lastUse < cooldown) {
            return;
        }
        class_239 hit = player.method_5745(64.0, 0.0f, false);
        if (hit.method_17783() != class_239.class_240.field_1333) {
            class_243 pos = hit.method_17784();
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883(world);
            if (lightning != null) {
                lightning.method_24203(pos.field_1352, pos.field_1351, pos.field_1350);
                if (player instanceof class_3222) {
                    lightning.method_6961((class_3222)player);
                }
                world.method_8649((class_1297)lightning);
                stack.method_7948().method_10544("LastLightningUse", world.method_8510());
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            boolean isHeld = player.method_6047() == stack || player.method_6079() == stack;
            class_2487 nbt = stack.method_7948();
            if (!world.field_9236) {
                float currentEnergy;
                float regen;
                float maxEnergy;
                int stageTime;
                int trailTicks = nbt.method_10550(DASH_TRAIL_KEY);
                if (trailTicks > 0) {
                    nbt.method_10569(DASH_TRAIL_KEY, trailTicks - 1);
                }
                if ((stageTime = nbt.method_10550(STAGE_TIME_KEY)) > 0) {
                    nbt.method_10569(STAGE_TIME_KEY, stageTime - 1);
                } else if (nbt.method_10550(STAGE_KEY) > 0) {
                    nbt.method_10569(STAGE_KEY, 0);
                    if (nbt.method_10583(ENERGY_KEY) > 100.0f) {
                        nbt.method_10548(ENERGY_KEY, 100.0f);
                    }
                }
                int stage = nbt.method_10550(STAGE_KEY);
                float f = stage == 2 ? 250.0f : (maxEnergy = stage == 1 ? 150.0f : 100.0f);
                float f2 = stage == 2 ? 1.0f : (regen = stage == 1 ? 0.75f : 0.25f);
                if (isHeld) {
                    float energy = LightningWandItem.getEnergy(stack);
                    int amplifier = energy >= maxEnergy ? 3 : 2;
                    player.method_6092(new class_1293(class_1294.field_5904, 20, amplifier, false, false, true));
                    if (world.field_9229.method_43057() < 0.1f) {
                        ((class_3218)world).method_14199((class_2394)class_2398.field_29644, player.method_23317(), player.method_23319(), player.method_23321(), 1, 0.3, 0.3, 0.3, 0.05);
                    }
                }
                if ((currentEnergy = nbt.method_10583(ENERGY_KEY)) < maxEnergy) {
                    nbt.method_10548(ENERGY_KEY, Math.min(maxEnergy, currentEnergy + regen));
                }
            } else if (isHeld) {
                class_2338 posAbove;
                float maxEnergy;
                int stage;
                int trailTicks = nbt.method_10550(DASH_TRAIL_KEY);
                if (trailTicks > 0) {
                    for (int i = 0; i < 3; ++i) {
                        world.method_8406((class_2394)class_2398.field_29644, player.method_23317() + (world.field_9229.method_43058() - 0.5) * 1.5, player.method_23318() + world.field_9229.method_43058() * 2.0, player.method_23321() + (world.field_9229.method_43058() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                    }
                    if (world.field_9229.method_43057() < 0.2f) {
                        world.method_8406((class_2394)class_2398.field_17909, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 0.0, 0.0, 0.0);
                    }
                }
                if (player.method_5624() && world.field_9229.method_43057() < 0.4f) {
                    world.method_8406((class_2394)class_2398.field_29644, player.method_23317(), player.method_23318() + 0.1, player.method_23321(), 0.0, 0.0, 0.0);
                }
                float f = (stage = nbt.method_10550(STAGE_KEY)) == 2 ? 250.0f : (maxEnergy = stage == 1 ? 150.0f : 100.0f);
                if (LightningWandItem.getEnergy(stack) >= maxEnergy && world.field_9229.method_43057() < 0.2f) {
                    world.method_8406((class_2394)class_2398.field_28479, player.method_23317() + (world.field_9229.method_43058() - 0.5), player.method_23318() + world.field_9229.method_43058() * 2.0, player.method_23321() + (world.field_9229.method_43058() - 0.5), 0.0, 0.1, 0.0);
                }
                if (isHeld && player.method_5816() && !player.method_5715() && world.method_8316(posAbove = player.method_24515().method_10084()).method_15769()) {
                    class_243 velocity = player.method_18798();
                    double newY = velocity.field_1351 < 0.0 ? 0.0 : velocity.field_1351;
                    double boost = player.method_5624() ? 1.22 : 1.15;
                    double newX = velocity.field_1352 * boost;
                    double newZ = velocity.field_1350 * boost;
                    player.method_18800(newX, newY, newZ);
                    player.method_24830(true);
                }
            }
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    public static void onDashHit(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        int currentStage = nbt.method_10550(STAGE_KEY);
        nbt.method_10569(STAGE_KEY, Math.min(2, currentStage + 1));
        nbt.method_10569(STAGE_TIME_KEY, 100);
    }

    public static void triggerDashTrail(class_1799 stack) {
        stack.method_7948().method_10569(DASH_TRAIL_KEY, 40);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (!player.method_37908().field_9236) {
                class_1937 world = player.method_37908();
                float damage = 4.0f;
                if (target.method_5816()) {
                    target.method_5643(world.method_48963().method_48815((class_1297)player, (class_1297)player), damage);
                    List neighbors = world.method_8390(class_1309.class, target.method_5829().method_1014(4.0), e -> e != attacker && e != target && e.method_5816());
                    for (class_1309 neighbor : neighbors) {
                        neighbor.method_5643(world.method_48963().method_48815((class_1297)player, (class_1297)player), damage * 2.0f);
                    }
                }
            }
        }
        return super.method_7873(stack, target, attacker);
    }

    public static float getEnergy(class_1799 stack) {
        if (!stack.method_7985()) {
            return 0.0f;
        }
        return stack.method_7969().method_10583(ENERGY_KEY);
    }

    public static float getMaxEnergy(class_1799 stack) {
        if (!stack.method_7985()) {
            return 100.0f;
        }
        int stage = stack.method_7969().method_10550(STAGE_KEY);
        return stage == 2 ? 250.0f : (stage == 1 ? 150.0f : 100.0f);
    }

    public static void setEnergy(class_1799 stack, float energy) {
        float max = LightningWandItem.getMaxEnergy(stack);
        stack.method_7948().method_10548(ENERGY_KEY, Math.max(0.0f, Math.min(max, energy)));
    }

    public static void useEnergy(class_1799 stack, float amount) {
        LightningWandItem.setEnergy(stack, LightningWandItem.getEnergy(stack) - amount);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        stack.method_7948().method_10569("HideFlags", 2);
        tooltip.add((class_2561)class_2561.method_43470((String)"RARE").method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        float energy = LightningWandItem.getEnergy(stack);
        float max = LightningWandItem.getMaxEnergy(stack);
        int stage = stack.method_7948().method_10550(STAGE_KEY);
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a7e\u26a1 Energy: " + (int)energy + "/" + (int)max)));
        if (stage > 0) {
            tooltip.add((class_2561)class_2561.method_43470((String)("\u00a7b\u00a7l\u26a1 CALL OF LIGHT: STAGE " + stage)).method_27692(class_124.field_1075));
        }
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7b\u26a1 Call Lightning \u00a78(L-Click)"));
        String cdStr = stage == 2 ? "1s" : (stage == 1 ? "2s" : "3s");
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a77Summon lightning at your target \u00a78(" + cdStr + " CD)")));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7b\ud83d\udca5 Overcharge Explosion \u00a78(R-Click)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Electrical blast \u00a78(20/40 Energy)"));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7b\u26a1 Lightning Dash \u00a78(C)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Surge forward \u00a78(Hit enemies to charge!)"));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        String speedType = energy >= max ? "IV" : "III";
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a76\ud83d\udee1 Passive: Speed " + speedType)));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a76\ud83d\udee1 Passive: Water Walking"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a76\ud83d\udee1 Passive: Conductivity"));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78\u2501\u2501\u2501\u2501\u2501 \u00a77DETAILS \u00a78\u2501\u2501\u2501\u2501\u2501"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Dash hits grant \u00a7bCall of Light\u00a77."));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Stage 1: 150 Max Energy, 15/s Regen, 2s Strike CD."));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Stage 2: 250 Max Energy, 20/s Regen, 1s Strike CD."));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Explosion costs 20 (minor) or 40 (heavy) energy."));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Power scales with energy (25-40+ max)."));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Cannot break blocks with this wand."));
            WandTooltipHelper.addLevelInfo(stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Hold \u00a77SHIFT \u00a78for details"));
        }
    }
}

