/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.necromancer.entity.ModEntities;
import com.necromancer.entity.SummonedSkeletonEntity;
import com.necromancer.util.WandTooltipHelper;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5150;
import org.jetbrains.annotations.Nullable;

public class NecromancerStaffItem
extends class_1792
implements class_5150 {
    public static final String SOUL_KEY = "Souls";
    public static final int MAX_SOULS = 500;
    public static final int SUMMON_COST = 10;
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public NecromancerStaffItem(class_1792.class_1793 settings) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", 17.0, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", -0.8, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        return true;
    }

    public static int getSouls(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null) {
            return 0;
        }
        return nbt.method_10550(SOUL_KEY);
    }

    public static void setSouls(class_1799 stack, int souls) {
        souls = Math.max(0, Math.min(souls, 500));
        stack.method_7948().method_10569(SOUL_KEY, souls);
    }

    public static boolean addSouls(class_1799 stack, int amount) {
        int current = NecromancerStaffItem.getSouls(stack);
        if (current >= 500) {
            return false;
        }
        NecromancerStaffItem.setSouls(stack, current + amount);
        return true;
    }

    public static boolean removeSouls(class_1799 stack, int amount) {
        int current = NecromancerStaffItem.getSouls(stack);
        if (current < amount) {
            return false;
        }
        NecromancerStaffItem.setSouls(stack, current - amount);
        return true;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_1799 stack = context.method_8041();
        if (world.field_9236 || player == null) {
            return class_1269.field_5811;
        }
        if (NecromancerStaffItem.getSouls(stack) < 10) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not enough souls! Need 10 souls.").method_27692(class_124.field_1061), true);
            return class_1269.field_5814;
        }
        NecromancerStaffItem.removeSouls(stack, 10);
        class_2338 pos = context.method_8037().method_10084();
        SummonedSkeletonEntity skeleton = new SummonedSkeletonEntity(ModEntities.SUMMONED_SKELETON, world);
        skeleton.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        skeleton.setOwner(player);
        world.method_8649((class_1297)skeleton);
        world.method_8396(null, pos, class_3417.field_15200, class_3419.field_15248, 0.5f, 1.5f);
        player.method_7353((class_2561)class_2561.method_43470((String)("A soul rises to serve you! (" + NecromancerStaffItem.getSouls(stack) + "/500 souls)")).method_27692(class_124.field_1076), true);
        return class_1269.field_5812;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        stack.method_7948().method_10569("HideFlags", 2);
        tooltip.add((class_2561)class_2561.method_43470((String)"MYTHIC").method_27692(class_124.field_1064).method_27692(class_124.field_1067));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        int souls = NecromancerStaffItem.getSouls(stack);
        int filled = (int)((float)souls / 500.0f * 10.0f);
        StringBuilder bar = new StringBuilder("\u00a75[");
        for (int i = 0; i < 10; ++i) {
            bar.append(i < filled ? "\u00a7d\u2588" : "\u00a78\u2591");
        }
        bar.append("\u00a75]");
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a7dSouls: \u00a7f" + souls + "/500 " + String.valueOf(bar))));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a75\ud83d\udc80 Summon Skeleton \u00a77(Right-Click)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Cost: 10 souls"));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a75\u2726 V Menu Abilities"));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78\u2501\u2501\u2501\u2501\u2501 \u00a77V MENU \u00a78\u2501\u2501\u2501\u2501\u2501"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7d\u26a1 Wraith Flight \u00a77- 1 soul/7 sec"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a75\ud83d\udc41 Soul Sight \u00a7a- FREE"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a74\u2764 Life Drain \u00a77- 1 soul/sec"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7c\ud83d\udc80 Corpse Nova \u00a77- Explode Minions"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a7b\u2694 Armored Skeleton \u00a77- 75 souls"));
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a76Press \u00a7eV \u00a76to open menu"));
            WandTooltipHelper.addLevelInfo(stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Hold \u00a77SHIFT \u00a78for details"));
        }
    }

    public boolean method_7886(class_1799 stack) {
        return false;
    }
}

