/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.necromancer.util.WandTooltipHelper;
import com.necromancer.util.WandUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class WebWandItem
extends class_1792 {
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5C2");
    private static final UUID ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785AC02");
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public WebWandItem(class_1792.class_1793 settings) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(ATTACK_DAMAGE_UUID, "Weapon modifier", 4.0, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(ATTACK_SPEED_UUID, "Weapon modifier", -2.0, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            class_3218 serverWorld = (class_3218)world;
            class_243 lookVec = player.method_5720();
            class_243 startPos = player.method_33571();
            class_2338 lastAirPos = null;
            for (int i = 1; i <= 20; ++i) {
                class_243 checkPos = startPos.method_1019(lookVec.method_1021((double)i));
                class_2338 blockPos = new class_2338((int)checkPos.field_1352, (int)checkPos.field_1351, (int)checkPos.field_1350);
                serverWorld.method_14199((class_2394)class_2398.field_23956, checkPos.field_1352, checkPos.field_1351, checkPos.field_1350, 2, 0.1, 0.1, 0.1, 0.0);
                if (!world.method_8320(blockPos).method_26215()) break;
                lastAirPos = blockPos;
            }
            class_238 searchBox = player.method_5829().method_18804(lookVec.method_1021(15.0)).method_1014(3.0);
            List enemies = world.method_8390(class_1309.class, searchBox, e -> e != player && e.method_5805());
            int trappedCount = 0;
            for (class_1309 enemy : enemies) {
                class_243 toEnemy = enemy.method_19538().method_1020(player.method_19538()).method_1029();
                if (!(lookVec.method_1026(toEnemy) > 0.7) || !(player.method_5739((class_1297)enemy) <= 15.0f)) continue;
                class_2338 enemyPos = enemy.method_24515();
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2338 webPos = enemyPos.method_10069(dx, 0, dz);
                        if (!world.method_8320(webPos).method_26215()) continue;
                        world.method_8501(webPos, class_2246.field_10343.method_9564());
                    }
                }
                enemy.method_6092(new class_1293(class_1294.field_5899, 100, 1));
                enemy.method_6092(new class_1293(class_1294.field_5909, 80, 3));
                WandUtils.applyRuneEffects(player, enemy, stack);
                serverWorld.method_14199((class_2394)class_2398.field_23956, enemy.method_23317(), enemy.method_23318() + 1.0, enemy.method_23321(), 30, 0.5, 0.5, 0.5, 0.1);
                if (++trappedCount < 3) continue;
                break;
            }
            if (trappedCount == 0 && lastAirPos != null) {
                world.method_8501(lastAirPos, class_2246.field_10343.method_9564());
            }
            world.method_8396(null, player.method_24515(), class_3417.field_14760, class_3419.field_15248, 1.0f, 1.5f);
            if (trappedCount > 0) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a77\ud83d\udd77 Trapped " + trappedCount + " enemies in webs!")), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a77\ud83d\udd78 Web shot!"), true);
            }
            if (!player.method_7337()) {
                player.method_7357().method_7906((class_1792)this, WandUtils.getCooldown(player, 30, stack));
            }
        }
        return class_1271.method_29237((Object)stack, (boolean)world.field_9236);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        stack.method_7948().method_10569("HideFlags", 2);
        tooltip.add((class_2561)class_2561.method_43470((String)"COMMON").method_27692(class_124.field_1068));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77\ud83d\udd78 Web Shot"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Trap enemies in sticky webs"));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77\ud83d\udd77 Spider Climb \u00a78(Passive)"));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Walk on walls \u00a78[V to toggle]"));
        if (class_437.method_25442()) {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78\u2501\u2501\u2501\u2501\u2501 \u00a77DETAILS \u00a78\u2501\u2501\u2501\u2501\u2501"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Trap up to \u00a7f3 \u00a77enemies"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Applies: \u00a72Poison \u00a77+ \u00a79Slowness"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Speed IV in cobwebs"));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Cooldown: \u00a7e1.5s"));
            WandTooltipHelper.addLevelInfo(stack, tooltip);
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            tooltip.add((class_2561)class_2561.method_43470((String)"\u00a78Hold \u00a77SHIFT \u00a78for details"));
        }
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    public static boolean isClimbingEnabled(class_1799 stack) {
        class_2487 nbt = stack.method_7969();
        return nbt == null || !nbt.method_10545("ClimbingEnabled") || nbt.method_10577("ClimbingEnabled");
    }

    public static void setClimbingEnabled(class_1799 stack, boolean enabled) {
        stack.method_7948().method_10556("ClimbingEnabled", enabled);
    }
}

