/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.screen;

import com.necromancer.item.ModItems;
import com.necromancer.screen.ModScreenHandlers;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class WandInfuserScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    public static final int[] XP_COSTS = new int[]{5, 10, 20, 35, 40};
    public static final int[] COOLDOWN_REDUCTIONS = new int[]{5, 10, 12, 15, 20};

    public WandInfuserScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory, (class_1263)new class_1277(1));
    }

    public WandInfuserScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
        super(ModScreenHandlers.WAND_INFUSER_SCREEN_HANDLER, syncId);
        WandInfuserScreenHandler.method_17359((class_1263)inventory, (int)1);
        this.inventory = inventory;
        inventory.method_5435(playerInventory.field_7546);
        this.method_7621(new WandSlot(inventory, 0, 40, 47));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public boolean tryUpgrade(class_1657 player) {
        class_1799 stack = this.inventory.method_5438(0);
        if (stack.method_7960() || !WandInfuserScreenHandler.isWand(stack.method_7909())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo wand in slot!"), true);
            return false;
        }
        int currentLevel = WandInfuserScreenHandler.getWandLevel(stack);
        if (currentLevel >= 5) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cMax level reached!"), true);
            return false;
        }
        int xpCost = XP_COSTS[currentLevel];
        if (player.field_7520 < xpCost && !player.method_7337()) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7cNot enough XP! Need " + xpCost + " levels.")), true);
            return false;
        }
        if (!player.method_7337()) {
            player.method_7316(-xpCost);
        }
        WandInfuserScreenHandler.setWandLevel(stack, currentLevel + 1);
        this.inventory.method_5431();
        player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a\u2726 Wand upgraded to Level " + (currentLevel + 1) + "!")), true);
        this.playUpgradeEffects(player, currentLevel + 1);
        return true;
    }

    public boolean tryFuse(class_1657 player) {
        class_1799 wand = this.inventory.method_5438(0);
        class_1799 rune = this.inventory.method_5438(1);
        if (wand.method_7960() || !WandInfuserScreenHandler.isWand(wand.method_7909())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo wand to fuse!"), true);
            return false;
        }
        if (rune.method_7960()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo rune to fuse!"), true);
            return false;
        }
        if (wand.method_7948().method_10545("SocketedRune")) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cWand already has a rune!"), true);
            return false;
        }
        String runeId = class_7923.field_41178.method_10221((Object)rune.method_7909()).toString();
        if (runeId.contains(":")) {
            runeId = runeId.split(":")[1];
        }
        wand.method_7948().method_10582("SocketedRune", runeId);
        if (!player.method_7337()) {
            rune.method_7934(1);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7d\u2726 Rune Fused Successfully!"), true);
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_19197, class_3419.field_15245, 1.0f, 1.2f);
        return true;
    }

    private void playUpgradeEffects(class_1657 player, int newLevel) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15119, class_3419.field_15245, 1.0f, 1.2f);
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.7f, 1.5f);
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14703, class_3419.field_15245, 0.5f, 1.8f);
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            double angle;
            int i;
            class_3218 serverWorld = (class_3218)class_19372;
            double px = player.method_23317();
            double py = player.method_23318() + 1.0;
            double pz = player.method_23321();
            for (i = 0; i < 30; ++i) {
                angle = (double)i * 0.4;
                double radius = 0.5 + (double)i * 0.05;
                double x = px + Math.cos(angle) * radius;
                double z = pz + Math.sin(angle) * radius;
                double y = py + (double)i * 0.05;
                serverWorld.method_14199((class_2394)class_2398.field_11215, x, y, z, 3, 0.1, 0.1, 0.1, 0.02);
            }
            serverWorld.method_14199((class_2394)class_2398.field_11207, px, py, pz, 25, 0.8, 0.8, 0.8, 0.05);
            for (i = 0; i < 16; ++i) {
                angle = (double)i * Math.PI / 8.0;
                double x = px + Math.cos(angle) * 1.2;
                double z = pz + Math.sin(angle) * 1.2;
                serverWorld.method_14199((class_2394)class_2398.field_22246, x, py, z, 2, 0.0, 0.2, 0.0, 0.01);
            }
            if (newLevel == 5) {
                serverWorld.method_14199((class_2394)class_2398.field_11220, px, py, pz, 50, 1.0, 1.0, 1.0, 0.3);
                player.method_37908().method_43128(null, px, py, pz, class_3417.field_14931, class_3419.field_15248, 0.6f, 1.5f);
            }
        }
    }

    public boolean confirmUpgradeAndReturn(class_1657 player) {
        class_1799 stack = this.inventory.method_5438(0);
        if (stack.method_7960()) {
            return false;
        }
        class_1799 wandCopy = stack.method_7972();
        this.inventory.method_5447(0, class_1799.field_8037);
        class_1799 rune = this.inventory.method_5438(1);
        if (!rune.method_7960()) {
            class_1799 runeCopy = rune.method_7972();
            this.inventory.method_5447(1, class_1799.field_8037);
            if (!player.method_7270(runeCopy)) {
                player.method_7328(runeCopy, false);
            }
        }
        if (!player.method_7270(wandCopy)) {
            player.method_7328(wandCopy, false);
        }
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, class_3419.field_15248, 1.0f, 1.0f);
        return true;
    }

    public static int getWandLevel(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545("WandLevel")) {
            return stack.method_7969().method_10550("WandLevel");
        }
        return 0;
    }

    public static void setWandLevel(class_1799 stack, int level) {
        stack.method_7948().method_10569("WandLevel", Math.min(level, 5));
    }

    public static int getCooldownReduction(class_1799 stack) {
        int level = WandInfuserScreenHandler.getWandLevel(stack);
        if (level > 0 && level <= 5) {
            return COOLDOWN_REDUCTIONS[level - 1];
        }
        return 0;
    }

    public static boolean isWand(class_1792 item) {
        return item == ModItems.APPRENTICE_WAND || item == ModItems.BUBBLE_WAND || item == ModItems.FROST_WAND || item == ModItems.WEB_WAND || item == ModItems.PETAL_WAND || item == ModItems.SOUL_SCYTHE_WAND || item == ModItems.VENOM_WAND || item == ModItems.VAMPIRE_SCEPTER || item == ModItems.GRAVITY_MASTER || item == ModItems.LIGHT_WAND || item == ModItems.WITHER_WAND || item == ModItems.LIGHTNING_WAND || item == ModItems.NECROMANCER_STAFF;
    }

    public class_1799 method_7601(class_1657 player, int invSlot) {
        class_1799 newStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(invSlot);
        if (slot != null && slot.method_7681()) {
            class_1799 originalStack = slot.method_7677();
            newStack = originalStack.method_7972();
            if (invSlot < 2 ? !this.method_7616(originalStack, 2, this.field_7761.size(), true) : !this.method_7616(originalStack, 0, 2, false)) {
                return class_1799.field_8037;
            }
            if (originalStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return newStack;
    }

    public boolean method_7597(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    private static class WandSlot
    extends class_1735 {
        public WandSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return WandInfuserScreenHandler.isWand(stack.method_7909());
        }
    }
}

