/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.util;

import com.necromancer.item.ModItems;
import com.necromancer.screen.WandInfuserScreenHandler;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class WandUtils {
    public static int getCooldown(class_1657 player, int baseCooldown, class_1799 wand) {
        float multiplier = 1.0f;
        if (WandUtils.isWearingWizardSet(player)) {
            multiplier -= 0.2f;
        }
        int wandLevelReduction = WandInfuserScreenHandler.getCooldownReduction(wand);
        multiplier -= (float)wandLevelReduction / 100.0f;
        multiplier = Math.max(multiplier, 0.1f);
        return (int)((float)baseCooldown * multiplier);
    }

    public static int getCooldown(class_1657 player, int baseCooldown) {
        if (WandUtils.isWearingWizardSet(player)) {
            return (int)((float)baseCooldown * 0.8f);
        }
        return baseCooldown;
    }

    public static boolean isWearingWizardSet(class_1657 player) {
        class_1799 head = player.method_6118(class_1304.field_6169);
        class_1799 chest = player.method_6118(class_1304.field_6174);
        class_1799 legs = player.method_6118(class_1304.field_6172);
        class_1799 feet = player.method_6118(class_1304.field_6166);
        return head.method_31574((class_1792)ModItems.WIZARD_HAT) && chest.method_31574((class_1792)ModItems.WIZARD_ROBE) && legs.method_31574((class_1792)ModItems.WIZARD_LEGGINGS) && feet.method_31574((class_1792)ModItems.WIZARD_BOOTS);
    }

    public static boolean isWand(class_1799 stack) {
        return stack.method_7909() == ModItems.APPRENTICE_WAND || stack.method_7909() == ModItems.BUBBLE_WAND || stack.method_7909() == ModItems.WEB_WAND || stack.method_7909() == ModItems.FROST_WAND || stack.method_7909() == ModItems.PETAL_WAND || stack.method_7909() == ModItems.SOUL_SCYTHE_WAND || stack.method_7909() == ModItems.LIGHT_WAND || stack.method_7909() == ModItems.WITHER_WAND || stack.method_7909() == ModItems.VENOM_WAND || stack.method_7909() == ModItems.VAMPIRE_SCEPTER || stack.method_7909() == ModItems.LIGHTNING_WAND || stack.method_7909() == ModItems.GRAVITY_MASTER || stack.method_7909() == ModItems.NECROMANCER_STAFF;
    }

    public static void incrementKillCount(class_1799 stack) {
        if (stack != null && !stack.method_7960() && stack.method_7948().method_10577("HasKillCounter")) {
            int currentKills = stack.method_7948().method_10550("KillCount");
            stack.method_7948().method_10569("KillCount", currentKills + 1);
        }
    }

    public static void applyRuneEffects(class_1657 attacker, class_1309 target, class_1799 wand) {
        String runeId;
        if (wand.method_7960() || !wand.method_7985() || !wand.method_7969().method_10545("SocketedRune")) {
            return;
        }
        switch (runeId = wand.method_7969().method_10558("SocketedRune")) {
            case "zephyr_core": {
                attacker.method_6092(new class_1293(class_1294.field_5904, 60, 1));
                break;
            }
            case "velocity_core": {
                target.method_6005(1.5, attacker.method_23317() - target.method_23317(), attacker.method_23321() - target.method_23321());
                break;
            }
            case "tempo_core": {
                target.method_6092(new class_1293(class_1294.field_5909, 60, 255));
                target.method_6092(new class_1293(class_1294.field_5901, 60, 255));
                break;
            }
            case "blood_core": {
                attacker.method_6025(2.0f);
                break;
            }
            case "vitality_core": {
                attacker.method_6092(new class_1293(class_1294.field_5924, 100, 1));
                break;
            }
            case "siphon_core": {
                target.method_6092(new class_1293(class_1294.field_5920, 100, 1));
                break;
            }
            case "magma_core": {
                target.method_5639(2);
                break;
            }
            case "inferno_core": {
                target.method_5639(4);
                target.method_6092(new class_1293(class_1294.field_5911, 100, 1));
                break;
            }
            case "frost_core": {
                target.method_6092(new class_1293(class_1294.field_5909, 80, 1));
                break;
            }
            case "glacial_core": {
                target.method_32317(200);
                target.method_6092(new class_1293(class_1294.field_5909, 60, 255));
            }
        }
    }
}

