/*
 * Decompiled with CFR 0.152.
 */
package com.necromancer.world;

import com.necromancer.NecromancerMod;
import com.necromancer.entity.ArcaneMerchantEntity;
import com.necromancer.entity.ModEntities;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_7477;

public class VillageStructureInjector {
    private static final Set<Long> processedVillages = new HashSet<Long>();
    private static int tickCounter = 0;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++tickCounter < 300) {
                return;
            }
            tickCounter = 0;
            for (class_3218 world : server.method_3738()) {
                for (class_3222 player : world.method_18456()) {
                    long villageKey;
                    class_2338 playerPos = player.method_24515();
                    class_2338 villageCenter = VillageStructureInjector.findVillageCenter(world, playerPos);
                    if (villageCenter == null || processedVillages.contains(villageKey = VillageStructureInjector.getVillageKey(villageCenter)) || !VillageStructureInjector.trySpawnMageHouse(world, villageCenter)) continue;
                    processedVillages.add(villageKey);
                }
            }
            if (processedVillages.size() > 1000) {
                processedVillages.clear();
            }
        });
        NecromancerMod.LOGGER.info("Village Mage House injector registered!");
    }

    private static long getVillageKey(class_2338 center) {
        int gridX = center.method_10263() >> 7;
        int gridZ = center.method_10260() >> 7;
        return class_1923.method_8331((int)gridX, (int)gridZ);
    }

    private static class_2338 findVillageCenter(class_3218 world, class_2338 nearPos) {
        class_4153 poiStorage = world.method_19494();
        List beds = poiStorage.method_19125(poiType -> poiType.method_40225(class_7477.field_39291), nearPos, 96, class_4153.class_4155.field_18489).collect(Collectors.toList());
        if (beds.size() < 4) {
            return null;
        }
        int sumX = 0;
        int sumY = 0;
        int sumZ = 0;
        for (class_4156 poi : beds) {
            class_2338 pos = poi.method_19141();
            sumX += pos.method_10263();
            sumY += pos.method_10264();
            sumZ += pos.method_10260();
        }
        return new class_2338(sumX / beds.size(), sumY / beds.size(), sumZ / beds.size());
    }

    private static boolean trySpawnMageHouse(class_3218 world, class_2338 villageCenter) {
        for (int radius = 3; radius <= 20; radius += 2) {
            for (int attempt = 0; attempt < 16; ++attempt) {
                double angle = (double)attempt / 16.0 * Math.PI * 2.0;
                int dx = (int)(Math.cos(angle) * (double)radius);
                int dz = (int)(Math.sin(angle) * (double)radius);
                class_2338 checkPos = villageCenter.method_10069(dx, 0, dz);
                int y = world.method_8624(class_2902.class_2903.field_13202, checkPos.method_10263(), checkPos.method_10260());
                class_2338 groundPos = new class_2338(checkPos.method_10263(), y, checkPos.method_10260());
                if (!VillageStructureInjector.isFlat3x3Area(world, groundPos)) continue;
                VillageStructureInjector.buildMageHouse(world, groundPos);
                NecromancerMod.LOGGER.info("Built Mage House at: " + String.valueOf(groundPos));
                return true;
            }
        }
        return false;
    }

    private static boolean isFlat3x3Area(class_3218 world, class_2338 origin) {
        int z;
        int x;
        int baseY = origin.method_10264();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                class_2338 groundCheck = origin.method_10069(x, -1, z);
                int surfaceY = world.method_8624(class_2902.class_2903.field_13202, groundCheck.method_10263(), groundCheck.method_10260());
                if (Math.abs(surfaceY - baseY) > 1) {
                    return false;
                }
                if (world.method_8320(groundCheck).method_26212((class_1922)world, groundCheck)) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                for (int y = 0; y < 4; ++y) {
                    class_2338 airCheck = origin.method_10069(x, y, z);
                    if (world.method_8320(airCheck).method_26215()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void buildMageHouse(class_3218 world, class_2338 origin) {
        int z;
        int x;
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                for (int y = 0; y < 4; ++y) {
                    class_2338 pos = origin.method_10069(x, y, z);
                    if (Math.abs(x) == 2 || Math.abs(z) == 2) {
                        if (y < 3) {
                            world.method_8652(pos, class_2246.field_10570.method_9564(), 3);
                        } else {
                            world.method_8652(pos, class_2246.field_10075.method_9564(), 3);
                        }
                    } else if (y == 0) {
                        world.method_8652(pos, class_2246.field_28892.method_9564(), 3);
                    } else {
                        world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
                    }
                    if (y != 2 || (Math.abs(x) != 2 || z != 0) && (Math.abs(z) != 2 || x != 0)) continue;
                    world.method_8652(pos, class_2246.field_10152.method_9564(), 3);
                }
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                world.method_8652(origin.method_10069(x, 4, z), class_2246.field_10570.method_9564(), 3);
            }
        }
        world.method_8652(origin.method_10069(0, 1, -2), class_2246.field_10124.method_9564(), 3);
        world.method_8652(origin.method_10069(0, 2, -2), class_2246.field_10124.method_9564(), 3);
        world.method_8652(origin.method_10069(-1, 1, 1), class_2246.field_10504.method_9564(), 3);
        world.method_8652(origin.method_10069(1, 1, 1), class_2246.field_9980.method_9564(), 3);
        world.method_8652(origin.method_10069(1, 1, 0), (class_2680)((class_2680)class_2246.field_10019.method_9564().method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12557)).method_11657((class_2769)class_2244.field_11177, (Comparable)class_2350.field_11035), 3);
        world.method_8652(origin.method_10069(1, 1, -1), (class_2680)((class_2680)class_2246.field_10019.method_9564().method_11657((class_2769)class_2244.field_9967, (Comparable)class_2742.field_12560)).method_11657((class_2769)class_2244.field_11177, (Comparable)class_2350.field_11035), 3);
        ArcaneMerchantEntity merchant = (ArcaneMerchantEntity)ModEntities.ARCANE_MERCHANT.method_5883((class_1937)world);
        if (merchant != null) {
            merchant.method_5808((double)origin.method_10263() + 0.5, origin.method_10264() + 1, (double)origin.method_10260() + 0.5, 0.0f, 0.0f);
            merchant.method_5971();
            world.method_8649((class_1297)merchant);
        }
    }
}

