/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.shelmarow.mine_chat.chat.MineChatManager;
import net.shelmarow.mine_chat.chat.message.AnimationMessage;
import net.shelmarow.mine_chat.chat.message.chat_enum.AnimationStatus;
import net.shelmarow.mine_chat.chat.texture.MineChatTextures;
import net.shelmarow.mine_chat.config.MineChatConfig;

@OnlyIn(value=Dist.CLIENT)
public class MineChatHudRenderer
implements IGuiOverlay {
    public static final MineChatHudRenderer instance = new MineChatHudRenderer();

    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Font font = forgeGui.m_93082_();
        PoseStack poseStack = guiGraphics.m_280168_();
        float offsetX = ((Double)MineChatConfig.RECENT_MESSAGES_OFFSET_X.get()).floatValue();
        float offsetY = ((Double)MineChatConfig.RECENT_MESSAGES_OFFSET_Y.get()).floatValue();
        float x = 4.0f + offsetX;
        float y = (float)screenHeight / 4.0f + offsetY;
        long millis = System.currentTimeMillis();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        if (MineChatManager.hasUncheckedMessage()) {
            poseStack.m_85836_();
            poseStack.m_252880_(8.0f, 24.0f, 0.0f);
            if (MineChatManager.shouldRotation()) {
                float rotationSpeed = 360.0f;
                float rotationAngle = (float)(millis % 36000L) * rotationSpeed / 36000.0f;
                poseStack.m_252781_(Axis.f_252403_.m_252961_(rotationAngle));
            }
            guiGraphics.m_280163_(MineChatTextures.CHAT_ICON_UNREAD, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
            poseStack.m_85849_();
            int i = 1500;
            int i1 = i / 2;
            long ratio = millis % (long)i;
            float alpha = ratio < (long)i1 ? Mth.m_14036_((float)(1.0f - (float)ratio / (float)i1), (float)0.1f, (float)1.0f) : Mth.m_14036_((float)((float)(ratio - (long)i1) / (float)i1), (float)0.1f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int lineOffset = 22;
            if (MineChatManager.isTeamChatUnchecked()) {
                guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"text.mine_chat.chat_unread_team"), 20, lineOffset, 0xFFFFFF);
                lineOffset -= 9;
            }
            if (MineChatManager.isDMChatUnchecked()) {
                guiGraphics.m_280430_(font, (Component)Component.m_237115_((String)"text.mine_chat.chat_unread_dm"), 20, lineOffset, 0xFFFFFF);
                lineOffset -= 9;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - MineChatManager.getIconDisplayRatio(partialTick)));
            guiGraphics.m_280163_(MineChatTextures.CHAT_ICON, 0, 16, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        poseStack.m_85849_();
        if (!((Boolean)MineChatConfig.DISPLAY_RECENT_MESSAGES.get()).booleanValue()) {
            return;
        }
        List<AnimationMessage> messages = MineChatManager.getLatestGlobeMessages();
        Collections.reverse(messages);
        float size = ((Double)MineChatConfig.RECENT_MESSAGES_SIZE.get()).floatValue();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + 32.0f, 0.0f);
        poseStack.m_85841_(size, size, 1.0f);
        float messageY = 0.0f;
        for (AnimationMessage message : messages) {
            if (messageY > 0.0f && messageY + 35.0f > (float)forgeGui.getMinecraft().m_91268_().m_85446_() * 0.33f) break;
            float fadeInRatio = 1.0f;
            float fadeOutRatio = 1.0f;
            if (message.getAnimationStatus() == AnimationStatus.FADE_IN) {
                fadeInRatio = message.getFadeInRatio(partialTick);
            } else if (message.getAnimationStatus() == AnimationStatus.FADE_OUT) {
                fadeOutRatio = message.getFadeOutRatio(partialTick);
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, messageY, 0.0f);
            poseStack.m_85841_(fadeInRatio, fadeInRatio, 1.0f);
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeOutRatio);
            guiGraphics.m_280163_(MineChatTextures.CHAT_RECENT_MESSAGE, 0, 0, 0.0f, 0.0f, 128, 35, 128, 35);
            List components = message.getMessage().m_240407_();
            MutableComponent name = Component.m_237119_();
            MutableComponent text = Component.m_237119_();
            for (int i = 0; i < components.size(); ++i) {
                if (i < message.getNameLength()) {
                    name.m_7220_((Component)components.get(i));
                    continue;
                }
                text.m_7220_((Component)components.get(i));
            }
            guiGraphics.m_280430_(font, (Component)name, 2, 5, 0xFFFFFF);
            ArrayList lines = new ArrayList(font.m_92923_((FormattedText)text, 120 - font.m_92895_("...")));
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
                Objects.requireNonNull(font);
                guiGraphics.m_280648_(font, formattedCharSequence, 6, 5 + (i + 1) * 9, 0xFFFFFF);
                if (i != 1 || lines.size() <= 2) continue;
                int n = 6 + font.m_92724_((FormattedCharSequence)lines.get(i));
                Objects.requireNonNull(font);
                guiGraphics.m_280488_(font, "...", n, 5 + (i + 1) * 9, 0xFFFFFF);
                break;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
            messageY += fadeInRatio * 35.0f;
        }
        poseStack.m_85849_();
    }
}

