/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.playercache;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.mine_chat.chat.playercache.PlayerCache;

@Mod.EventBusSubscriber(modid="mine_chat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class PlayerCacheManager {
    private static final Map<UUID, PlayerCache> PLAYER_CACHE_MAP = new ConcurrentHashMap<UUID, PlayerCache>();

    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER || Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_ != event.player) {
            return;
        }
        for (PlayerCache playerCache : PLAYER_CACHE_MAP.values()) {
            playerCache.updateOnlineStatus(PlayerCacheManager.checkPlayerOnline(playerCache.getProfile().getId()));
        }
    }

    public static void clearCache() {
        PLAYER_CACHE_MAP.clear();
    }

    public static PlayerInfo getPlayerInfo(UUID uuid) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            return mc.m_91403_().m_104949_(uuid);
        }
        return null;
    }

    public static void storePlayerCache(UUID uuid) {
        PlayerInfo playerInfo;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null && (playerInfo = mc.m_91403_().m_104949_(uuid)) != null) {
            GameProfile profile = playerInfo.m_105312_();
            ResourceLocation skinLocation = mc.m_91109_().m_240306_(profile);
            PLAYER_CACHE_MAP.put(uuid, new PlayerCache(profile, skinLocation));
        }
    }

    public static PlayerCache getPlayerCache(String name, boolean store) {
        PlayerInfo playerInfo;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null && (playerInfo = mc.m_91403_().m_104938_(name)) != null) {
            GameProfile profile = playerInfo.m_105312_();
            ResourceLocation skinLocation = mc.m_91109_().m_240306_(profile);
            if (store) {
                PLAYER_CACHE_MAP.put(profile.getId(), new PlayerCache(profile, skinLocation));
            }
            return new PlayerCache(profile, skinLocation);
        }
        return null;
    }

    public static List<PlayerCache> getPlayerCachesByName(String name) {
        ArrayList<PlayerCache> playerCaches = new ArrayList<PlayerCache>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            mc.m_91403_().m_105142_().forEach(player -> {
                if (player.m_105312_().getName().toLowerCase().startsWith(name.toLowerCase())) {
                    GameProfile profile = player.m_105312_();
                    ResourceLocation skinLocation = mc.m_91109_().m_240306_(profile);
                    playerCaches.add(new PlayerCache(profile, skinLocation));
                }
            });
        }
        return playerCaches;
    }

    public static PlayerCache getPlayerCache(UUID uuid) {
        return PlayerCacheManager.getPlayerCache(uuid, true);
    }

    public static PlayerCache getPlayerCache(UUID uuid, boolean shouldStore) {
        if (uuid.equals(Util.f_137441_)) {
            return null;
        }
        if (!PLAYER_CACHE_MAP.containsKey(uuid) && shouldStore) {
            PlayerCacheManager.storePlayerCache(uuid);
        }
        return PLAYER_CACHE_MAP.get(uuid);
    }

    public static boolean checkPlayerOnline(UUID targetUUID) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            return mc.m_91403_().m_104949_(targetUUID) != null;
        }
        return false;
    }
}

