/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.MineChatManager;
import net.shelmarow.mine_chat.chat.message.AnimationMessage;
import net.shelmarow.mine_chat.chat.screen.MineChatScreen;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MineChatTeamScreen
extends MineChatScreen {
    private boolean haveTeam = false;

    public MineChatTeamScreen() {
        this.currentPage = MineChatScreen.CurrentPage.TEAM;
        this.nameLeftOffsetX = -4;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            this.haveTeam = mc.f_91074_.m_5647_() != null;
        }
    }

    @Override
    @NotNull
    public List<AnimationMessage> getChatMessages() {
        if (this.haveTeam) {
            List<AnimationMessage> messages = MineChatManager.getTeamMessages();
            Collections.reverse(messages);
            MineChatManager.checkTeam();
            return messages;
        }
        MineChatManager.clearTeamMessage();
        return Collections.emptyList();
    }

    @Override
    protected void renderAfterBackground(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!this.haveTeam) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"text.mine_chat.not_in_team"), this.centerX, this.centerY, 0xFFFFFF);
        } else {
            PlayerTeam playerTeam;
            Team team = mc.f_91074_.m_5647_();
            if (team != null && (playerTeam = mc.f_91074_.m_36329_().m_83489_(team.m_5758_())) != null) {
                guiGraphics.m_280430_(this.f_96547_, (Component)playerTeam.m_83367_(), 176, 11, 0xFFFFFF);
            }
        }
    }

    @Override
    @NotNull
    public MineChatScreen.SenderWithMessage getDisplayMessage(AnimationMessage message) {
        return super.getDisplayMessage(message);
    }

    @Override
    protected void onEditBoxEnterPressed(LocalPlayer player) {
        super.onEditBoxEnterPressed(player);
        if (this.currentPage == MineChatScreen.CurrentPage.TEAM) {
            String message = this.mainEditBox.m_94155_();
            if (this.haveTeam && !message.isEmpty()) {
                player.f_108617_.m_246623_("teammsg " + message);
                this.resetScroll();
            }
            this.mainEditBox.m_94144_("");
        }
    }
}

