/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.screen.button;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.MineChatManager;
import net.shelmarow.mine_chat.chat.playercache.PlayerCache;
import net.shelmarow.mine_chat.chat.playercache.PlayerCacheManager;
import net.shelmarow.mine_chat.chat.texture.MineChatTextures;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PlayerInfoButton
extends AbstractButton {
    private static final ResourceLocation DM_PLAYER_INFO = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/dm_player_info.png");
    private static final ResourceLocation DM_PLAYER_INFO_HOVERED = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/dm_player_info_hovered.png");
    private final OnPress onPress;
    private final Font font;
    private final PlayerCache cache;

    public PlayerInfoButton(Font font, int pX, int pY, PlayerCache cache, OnPress onPress) {
        super(pX, pY, 74, 20, (Component)Component.m_237119_());
        this.onPress = onPress;
        this.font = font;
        this.cache = cache;
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PlayerInfoButton.m_280138_((GuiGraphics)guiGraphics, (Font)this.font, (Component)Component.m_237113_((String)this.cache.getProfile().getName()).m_130940_(this.cache.isOnline() ? ChatFormatting.WHITE : ChatFormatting.GRAY), (int)this.m_252754_(), (int)this.m_252907_(), (int)(this.m_252754_() + this.m_5711_()), (int)(this.m_252907_() + this.m_93694_()), (int)0xFFFFFF);
        if (this.m_274382_()) {
            guiGraphics.m_280163_(DM_PLAYER_INFO_HOVERED, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 74, 20, 74, 20);
        } else {
            guiGraphics.m_280163_(DM_PLAYER_INFO, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 74, 20, 74, 20);
        }
        if (MineChatManager.isDMPlayerMessageUnread(this.cache.getProfile().getId())) {
            guiGraphics.m_280163_(MineChatTextures.RED_POINT, this.m_252754_() + this.m_5711_() - 6, this.m_252907_(), 0.0f, 0.0f, 6, 6, 6, 6);
        }
    }

    public void updateOnlineStatues() {
        boolean online = PlayerCacheManager.checkPlayerOnline(this.cache.getProfile().getId());
        this.cache.updateOnlineStatus(online);
    }

    protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        this.m_168802_(pNarrationElementOutput);
    }

    public void m_5691_() {
        this.onPress.onPress(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(PlayerInfoButton var1);
    }
}

