/*
 * Decompiled with CFR 0.152.
 */
package com.owen233666.owenswindows.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class ConnectableWindowBlock
extends Block {
    protected static final VoxelShape EE = ConnectableWindowBlock.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape CORNER_NE = Shapes.or((VoxelShape)ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)});
    protected static final VoxelShape CORNER_NW = Shapes.or((VoxelShape)ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0), (VoxelShape[])new VoxelShape[]{ConnectableWindowBlock.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    protected static final VoxelShape CORNER_SE = Shapes.or((VoxelShape)ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ConnectableWindowBlock.box((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)});
    protected static final VoxelShape CORNER_SW = Shapes.or((VoxelShape)ConnectableWindowBlock.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{ConnectableWindowBlock.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    public static final EnumProperty<CornerType> CORNER_TYPE = EnumProperty.create((String)"corner_type", CornerType.class);
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Direction[])new Direction[]{Direction.NORTH, Direction.EAST});
    public static final BooleanProperty ABOVE = BooleanProperty.create((String)"above");
    public static final BooleanProperty BELOW = BooleanProperty.create((String)"below");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty IS_CORNER = BooleanProperty.create((String)"is_corner");

    public ConnectableWindowBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)IS_CORNER, (Comparable)Boolean.valueOf(false))).setValue(CORNER_TYPE, (Comparable)((Object)CornerType.RIGHT))).setValue((Property)ABOVE, (Comparable)Boolean.valueOf(false))).setValue((Property)BELOW, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Boolean)state.getValue((Property)IS_CORNER)).booleanValue()) {
            boolean north = (Boolean)state.getValue((Property)NORTH);
            boolean south = (Boolean)state.getValue((Property)SOUTH);
            boolean west = (Boolean)state.getValue((Property)WEST);
            boolean east = (Boolean)state.getValue((Property)EAST);
            if (north) {
                if (west) {
                    return CORNER_NW;
                }
                if (east) {
                    return CORNER_NE;
                }
            } else if (south) {
                if (west) {
                    return CORNER_SW;
                }
                if (east) {
                    return CORNER_SE;
                }
            }
        } else {
            return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? NN : EE;
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? NN : EE;
    }

    protected BlockState WindowState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() instanceof ConnectableWindowBlock;
        boolean below = level.getBlockState(pos.below()).getBlock() instanceof ConnectableWindowBlock;
        boolean north = level.getBlockState(pos.north()).getBlock() instanceof ConnectableWindowBlock;
        boolean east = level.getBlockState(pos.east()).getBlock() instanceof ConnectableWindowBlock;
        boolean south = level.getBlockState(pos.south()).getBlock() instanceof ConnectableWindowBlock;
        boolean west = level.getBlockState(pos.west()).getBlock() instanceof ConnectableWindowBlock;
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean is_corner = this.isCorner(facing, north, south, east, west, level, pos);
        if ((north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0) >= 3) {
            return state;
        }
        if (is_corner) {
            if (above && ((Boolean)level.getBlockState(pos.above()).getValue((Property)IS_CORNER)).equals(true)) {
                state = (BlockState)state.setValue((Property)ABOVE, (Comparable)Boolean.valueOf(true));
            }
            if (below && ((Boolean)level.getBlockState(pos.below()).getValue((Property)IS_CORNER)).equals(true)) {
                state = (BlockState)state.setValue((Property)BELOW, (Comparable)Boolean.valueOf(true));
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)IS_CORNER, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west));
        } else {
            if (above) {
                BlockState aboveState = level.getBlockState(pos.above());
                state = (BlockState)state.setValue((Property)ABOVE, (Comparable)Boolean.valueOf(((Direction)aboveState.getValue((Property)FACING)).equals((Object)facing)));
            } else {
                state = (BlockState)state.setValue((Property)ABOVE, (Comparable)Boolean.valueOf(false));
            }
            if (below) {
                BlockState belowState = level.getBlockState(pos.below());
                state = (BlockState)state.setValue((Property)BELOW, (Comparable)Boolean.valueOf(((Direction)belowState.getValue((Property)FACING)).equals((Object)facing)));
            } else {
                state = (BlockState)state.setValue((Property)BELOW, (Comparable)Boolean.valueOf(false));
            }
            state = (BlockState)state.setValue((Property)IS_CORNER, (Comparable)Boolean.valueOf(false));
            if (facing == Direction.NORTH) {
                state = (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false));
                boolean westConnected = false;
                boolean eastConnected = false;
                if (east) {
                    BlockState eastState = level.getBlockState(pos.east());
                    boolean bl = westConnected = ((Direction)eastState.getValue((Property)FACING)).equals((Object)facing) || (Boolean)eastState.getValue((Property)IS_CORNER) != false;
                }
                if (west) {
                    BlockState westState = level.getBlockState(pos.west());
                    eastConnected = ((Direction)westState.getValue((Property)FACING)).equals((Object)facing) || (Boolean)westState.getValue((Property)IS_CORNER) != false;
                }
                state = (BlockState)state.setValue((Property)WEST, (Comparable)Boolean.valueOf(westConnected));
                state = (BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(eastConnected));
            } else {
                state = (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false));
                boolean southConnected = false;
                boolean northConnected = false;
                if (north) {
                    BlockState northState = level.getBlockState(pos.north());
                    boolean bl = southConnected = ((Direction)northState.getValue((Property)FACING)).equals((Object)facing) || (Boolean)northState.getValue((Property)IS_CORNER) != false;
                }
                if (south) {
                    BlockState southState = level.getBlockState(pos.south());
                    northConnected = ((Direction)southState.getValue((Property)FACING)).equals((Object)facing) || (Boolean)southState.getValue((Property)IS_CORNER) != false;
                }
                state = (BlockState)state.setValue((Property)SOUTH, (Comparable)Boolean.valueOf(southConnected));
                state = (BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(northConnected));
            }
        }
        return state;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.WindowState(state, (LevelAccessor)level, pos), 2);
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                BlockState neighborState = level.getBlockState(neighborPos);
                if (!(neighborState.getBlock() instanceof ConnectableWindowBlock)) continue;
                level.setBlock(neighborPos, this.WindowState(neighborState, (LevelAccessor)level, neighborPos), 3);
            }
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.WindowState(state, access, pos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_CORNER, CORNER_TYPE, FACING, ABOVE, BELOW, NORTH, SOUTH, EAST, WEST});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        Direction facingDirection = contx.getHorizontalDirection();
        Level world = contx.getLevel();
        BlockPos pos = contx.getClickedPos();
        if (facingDirection == Direction.WEST) {
            facingDirection = Direction.EAST;
        } else if (facingDirection == Direction.SOUTH) {
            facingDirection = Direction.NORTH;
        }
        BlockState baseState = super.getStateForPlacement(contx);
        if (baseState == null) {
            baseState = this.defaultBlockState();
        }
        BlockState stateWithFacing = (BlockState)baseState.setValue((Property)FACING, (Comparable)facingDirection);
        return this.WindowState(stateWithFacing, (LevelAccessor)world, pos);
    }

    private boolean isCorner(Direction facing, boolean north, boolean south, boolean east, boolean west, LevelAccessor level, BlockPos pos) {
        int cornerAmount = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
        if (cornerAmount == 2) {
            BlockState westState;
            BlockState southState;
            BlockState northState;
            BlockState eastState;
            if (facing.equals((Object)Direction.NORTH)) {
                BlockState southState2;
                BlockState westState2;
                BlockState eastState2;
                BlockState northState2;
                if (north && east) {
                    northState2 = level.getBlockState(pos.north());
                    eastState2 = level.getBlockState(pos.east());
                    if (northState2.getBlock() instanceof ConnectableWindowBlock && eastState2.getBlock() instanceof ConnectableWindowBlock && (((Boolean)northState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)northState2.getValue((Property)SOUTH)).equals(true) || ((Direction)northState2.getValue((Property)FACING)).equals((Object)Direction.EAST)) && (((Boolean)eastState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)eastState2.getValue((Property)WEST)).equals(true) || ((Direction)eastState2.getValue((Property)FACING)).equals((Object)facing))) {
                        return true;
                    }
                }
                if (north && west) {
                    northState2 = level.getBlockState(pos.north());
                    westState2 = level.getBlockState(pos.west());
                    if (northState2.getBlock() instanceof ConnectableWindowBlock && westState2.getBlock() instanceof ConnectableWindowBlock && (((Boolean)northState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)northState2.getValue((Property)SOUTH)).equals(true) || ((Direction)northState2.getValue((Property)FACING)).equals((Object)Direction.EAST)) && (((Boolean)westState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)westState2.getValue((Property)EAST)).equals(true) || ((Direction)westState2.getValue((Property)FACING)).equals((Object)facing))) {
                        return true;
                    }
                }
                if (south && east) {
                    southState2 = level.getBlockState(pos.south());
                    eastState2 = level.getBlockState(pos.east());
                    if (southState2.getBlock() instanceof ConnectableWindowBlock && eastState2.getBlock() instanceof ConnectableWindowBlock && (((Boolean)southState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)southState2.getValue((Property)NORTH)).equals(true) || ((Direction)southState2.getValue((Property)FACING)).equals((Object)Direction.EAST)) && (((Boolean)eastState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)eastState2.getValue((Property)WEST)).equals(true) || ((Direction)eastState2.getValue((Property)FACING)).equals((Object)facing))) {
                        return true;
                    }
                }
                if (south && west) {
                    southState2 = level.getBlockState(pos.south());
                    westState2 = level.getBlockState(pos.west());
                    if (southState2.getBlock() instanceof ConnectableWindowBlock && westState2.getBlock() instanceof ConnectableWindowBlock && (((Boolean)southState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)southState2.getValue((Property)NORTH)).equals(true) || ((Direction)southState2.getValue((Property)FACING)).equals((Object)Direction.EAST)) && (((Boolean)westState2.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)southState2.getValue((Property)NORTH)).equals(true) || ((Direction)westState2.getValue((Property)FACING)).equals((Object)facing))) {
                        return true;
                    }
                }
                return false;
            }
            if (east && north) {
                eastState = level.getBlockState(pos.east());
                northState = level.getBlockState(pos.north());
                if (eastState.getBlock() instanceof ConnectableWindowBlock && northState.getBlock() instanceof ConnectableWindowBlock && (((Boolean)eastState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)eastState.getValue((Property)WEST)).equals(true) || ((Direction)eastState.getValue((Property)FACING)).equals((Object)Direction.NORTH)) && (((Boolean)northState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)northState.getValue((Property)SOUTH)).equals(true) || ((Direction)northState.getValue((Property)FACING)).equals((Object)facing))) {
                    return true;
                }
            }
            if (east && south) {
                eastState = level.getBlockState(pos.east());
                southState = level.getBlockState(pos.south());
                if (eastState.getBlock() instanceof ConnectableWindowBlock && southState.getBlock() instanceof ConnectableWindowBlock && (((Boolean)eastState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)eastState.getValue((Property)WEST)).equals(true) || ((Direction)eastState.getValue((Property)FACING)).equals((Object)Direction.NORTH) && (((Boolean)southState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)southState.getValue((Property)NORTH)).equals(true) || ((Direction)southState.getValue((Property)FACING)).equals((Object)facing)))) {
                    return true;
                }
            }
            if (west && north) {
                westState = level.getBlockState(pos.west());
                northState = level.getBlockState(pos.north());
                if (westState.getBlock() instanceof ConnectableWindowBlock && northState.getBlock() instanceof ConnectableWindowBlock && (((Boolean)westState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)westState.getValue((Property)EAST)).equals(true) || ((Direction)westState.getValue((Property)FACING)).equals((Object)Direction.NORTH)) && (((Boolean)northState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)northState.getValue((Property)SOUTH)).equals(true) || ((Direction)northState.getValue((Property)FACING)).equals((Object)facing))) {
                    return true;
                }
            }
            if (west && south) {
                westState = level.getBlockState(pos.west());
                southState = level.getBlockState(pos.south());
                if (westState.getBlock() instanceof ConnectableWindowBlock && southState.getBlock() instanceof ConnectableWindowBlock && (((Boolean)westState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)westState.getValue((Property)EAST)).equals(true) || ((Direction)westState.getValue((Property)FACING)).equals((Object)Direction.NORTH)) && (((Boolean)southState.getValue((Property)IS_CORNER)).equals(true) && ((Boolean)southState.getValue((Property)NORTH)).equals(true) || ((Direction)southState.getValue((Property)FACING)).equals((Object)facing))) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static enum CornerType implements StringRepresentable
    {
        RIGHT("right"),
        ROUNDED("rounded");

        private final String name;

        private CornerType(String name) {
            this.name = name;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }
    }
}

