/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.shelmarow.mine_chat.chat.message.AnimationMessage;
import net.shelmarow.mine_chat.chat.message.chat_enum.AnimationStatus;
import net.shelmarow.mine_chat.chat.message.chat_enum.MessageType;
import net.shelmarow.mine_chat.chat.playercache.PlayerCache;
import net.shelmarow.mine_chat.chat.playercache.PlayerCacheManager;
import net.shelmarow.mine_chat.chat.screen.MineChatDMScreen;
import net.shelmarow.mine_chat.chat.screen.MineChatGlobeScreen;
import net.shelmarow.mine_chat.chat.screen.MineChatTeamScreen;
import net.shelmarow.mine_chat.chat.sound.MineChatSounds;
import org.checkerframework.checker.nullness.qual.NonNull;

@Mod.EventBusSubscriber(modid="mine_chat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class MineChatManager {
    private static final int MAX_SIZE = 200;
    private static final int MAX_DISPLAY_SIZE = 3;
    private static final ArrayDeque<AnimationMessage> CHAT_GLOBE = new ArrayDeque();
    private static final ArrayDeque<AnimationMessage> CHAT_GLOBE_DISPLAY = new ArrayDeque();
    private static final Map<UUID, Pair<ArrayDeque<AnimationMessage>, Long>> CHAT_DM_MAP = new HashMap<UUID, Pair<ArrayDeque<AnimationMessage>, Long>>();
    private static final Set<UUID> CHAT_DM_UNCHECKED = new HashSet<UUID>();
    private static final ArrayDeque<AnimationMessage> CHAT_TEAM = new ArrayDeque();
    private static boolean teamChatChecked = true;
    private static final long ICON_TIME = 100L;
    private static final long ICON_FADE_TIME = 80L;
    private static long showIconTime = 0L;
    private static boolean shouldRotation = false;

    @SubscribeEvent
    public static void onLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        MineChatManager.clearGlobeMessage();
        MineChatManager.clearDisplayMessage();
        MineChatManager.clearDMMessage();
        MineChatManager.clearTeamMessage();
        MineChatManager.clearUnread();
        PlayerCacheManager.clearCache();
    }

    private static void clearUnread() {
        CHAT_DM_UNCHECKED.clear();
        teamChatChecked = true;
        shouldRotation = false;
    }

    @SubscribeEvent
    public static void onScreenOpen(ScreenEvent.Opening event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof ChatScreen)) {
            return;
        }
        ChatScreen chatScreen = (ChatScreen)screen;
        String initial = chatScreen.f_95576_;
        if (initial.isEmpty()) {
            event.setCanceled(true);
            Minecraft.m_91087_().m_91152_((Screen)new MineChatGlobeScreen());
        }
    }

    @SubscribeEvent
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER || Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_ != event.player) {
            return;
        }
        if (!MineChatManager.hasUncheckedMessage() && shouldRotation) {
            shouldRotation = false;
        }
        for (AnimationMessage message : CHAT_GLOBE_DISPLAY) {
            message.tick();
            if (message.getAnimationStatus() != AnimationStatus.FINISHED) continue;
            CHAT_GLOBE_DISPLAY.remove(message);
        }
        if (CHAT_GLOBE_DISPLAY.isEmpty() && !MineChatManager.hasUncheckedMessage()) {
            if (showIconTime < 100L) {
                ++showIconTime;
            }
        } else if (showIconTime != 0L) {
            showIconTime = 0L;
        }
    }

    public static float getIconDisplayRatio(float partialTick) {
        if (showIconTime >= 80L) {
            return Mth.m_14036_((float)(((float)showIconTime + partialTick - 80.0f) / 20.0f), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    @SubscribeEvent
    public static void onChatReceived(ClientChatReceivedEvent event) {
        String chatType;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level == null || player == null) {
            return;
        }
        Component message = event.getMessage();
        UUID sender = event.getSender();
        MineChatManager.addMessage(event, player, sender, switch (chatType = event.getBoundChatType().f_240859_().f_237011_().f_238741_()) {
            case "chat.type.announcement" -> MessageType.SAY;
            case "chat.type.text" -> MessageType.PLAYER_GLOBE;
            case "commands.message.display.outgoing" -> MessageType.PLAYER_DM_OUT;
            case "commands.message.display.incoming" -> MessageType.PLAYER_DM_IN;
            case "chat.type.team.text" -> MessageType.PLAYER_TEAM_IN;
            case "chat.type.team.sent" -> MessageType.PLAYER_TEAM_OUT;
            default -> {
                if (event instanceof ClientChatReceivedEvent.System) {
                    ClientChatReceivedEvent.System systemEvent = (ClientChatReceivedEvent.System)event;
                    if (systemEvent.isOverlay()) {
                        yield MessageType.NOT_SHOWN;
                    }
                    yield MessageType.SYSTEM;
                }
                yield MessageType.OTHER;
            }
        }, message);
    }

    private static void addAnimationMessageToList(ArrayDeque<AnimationMessage> messages, AnimationMessage message) {
        MineChatManager.addAnimationMessageToList(messages, message, 200);
    }

    private static void addAnimationMessageToList(ArrayDeque<AnimationMessage> messages, AnimationMessage message, int maxSize) {
        if (messages.size() >= maxSize) {
            messages.pollFirst();
        }
        messages.addLast(message);
    }

    public static void addMessage(ClientChatReceivedEvent event, @NonNull LocalPlayer player, UUID sender, MessageType messageType, Component msg) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        TeamNameInfo nameInfo = MineChatManager.getNameLength(sender, messageType);
        long timestamp = player.m_9236_().m_46467_();
        switch (messageType) {
            case SYSTEM: 
            case OTHER: 
            case SAY: 
            case PLAYER_GLOBE: {
                if (messageType == MessageType.SYSTEM) {
                    msg = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"<").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237115_((String)"text.mine_chat.system").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"> ").m_130940_(ChatFormatting.YELLOW)).m_7220_(msg);
                } else if (messageType == MessageType.OTHER) {
                    msg = Component.m_237119_().m_7220_((Component)Component.m_237113_((String)"<")).m_7220_((Component)Component.m_237115_((String)"text.mine_chat.other")).m_7220_((Component)Component.m_237113_((String)"> ")).m_7220_(msg);
                }
                boolean isInGlobeScreen = screen instanceof MineChatGlobeScreen;
                MineChatManager.addAnimationMessageToList(CHAT_GLOBE, new AnimationMessage(sender, timestamp, nameInfo.totalLength, messageType, isInGlobeScreen ? 5 : 0, 0, 0, msg));
                MineChatManager.addAnimationMessageToList(CHAT_GLOBE_DISPLAY, new AnimationMessage(sender, timestamp, nameInfo.totalLength, messageType, msg), 3);
                break;
            }
            case PLAYER_DM_IN: {
                MineChatDMScreen dmScreen;
                event.setCanceled(true);
                if (event.isSystem()) {
                    return;
                }
                MutableComponent message = Component.m_237119_();
                List components = msg.m_240407_();
                for (int i = 0; i < components.size(); ++i) {
                    if (i == nameInfo.totalLength) continue;
                    if (i == 0) {
                        message.m_130946_("<");
                    }
                    message.m_130946_(((Component)components.get(i)).getString());
                    if (i != nameInfo.totalLength - 1) continue;
                    message.m_130946_(">");
                }
                Pair dmPair = CHAT_DM_MAP.computeIfAbsent(sender, k -> new Pair(new ArrayDeque(), (Object)timestamp));
                ArrayDeque dmMessages = (ArrayDeque)dmPair.getFirst();
                boolean isInDMScreen = screen instanceof MineChatDMScreen;
                MineChatManager.addAnimationMessageToList(dmMessages, new AnimationMessage(sender, timestamp, nameInfo.totalLength + 2, messageType, isInDMScreen ? 5 : 0, 0, 0, (Component)message));
                CHAT_DM_MAP.put(sender, (Pair<ArrayDeque<AnimationMessage>, Long>)new Pair((Object)dmMessages, (Object)timestamp));
                if (!(screen instanceof MineChatDMScreen) || !sender.equals((dmScreen = (MineChatDMScreen)screen).getSelectedTarget())) {
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)MineChatSounds.RECEIVE_MESSAGE, (float)1.0f));
                    CHAT_DM_UNCHECKED.add(sender);
                    MineChatManager.setRandomChanceRotation();
                }
                if (!(screen instanceof MineChatDMScreen) || !(dmScreen = (MineChatDMScreen)screen).getSearchText().isEmpty()) break;
                dmScreen.reflashPlayerInfo();
                break;
            }
            case PLAYER_DM_OUT: {
                UUID sendTarget;
                event.setCanceled(true);
                if (event.isSystem()) {
                    return;
                }
                MutableComponent message = Component.m_237119_();
                String targetName = "";
                List components = msg.m_240407_();
                for (int i = 0; i < components.size(); ++i) {
                    if (i == 0 || i == nameInfo.totalLength + 1) continue;
                    if (i == 1) {
                        message.m_130946_("<");
                    }
                    if (i == nameInfo.prefix + nameInfo.nameLength) {
                        targetName = ((Component)components.get(i)).getString();
                        message.m_7220_(player.m_5446_());
                    } else {
                        message.m_130946_(((Component)components.get(i)).getString());
                    }
                    if (i != nameInfo.totalLength) continue;
                    message.m_130946_(">");
                }
                PlayerCache playerCache = PlayerCacheManager.getPlayerCache(targetName, true);
                if (playerCache == null || (sendTarget = playerCache.getProfile().getId()).equals(player.m_20148_())) break;
                Pair dmPair = CHAT_DM_MAP.computeIfAbsent(sendTarget, k -> new Pair(new ArrayDeque(), (Object)timestamp));
                ArrayDeque dmMessages = (ArrayDeque)dmPair.getFirst();
                boolean isInDMScreen = screen instanceof MineChatDMScreen;
                MineChatManager.addAnimationMessageToList(dmMessages, new AnimationMessage(sender, timestamp, nameInfo.totalLength + 2, messageType, isInDMScreen ? 5 : 0, 0, 0, (Component)message));
                CHAT_DM_MAP.put(sendTarget, (Pair<ArrayDeque<AnimationMessage>, Long>)new Pair((Object)dmMessages, (Object)timestamp));
                break;
            }
            case PLAYER_TEAM_IN: 
            case PLAYER_TEAM_OUT: {
                if (event.isSystem()) {
                    return;
                }
                List components = msg.m_240407_();
                int skip = messageType == MessageType.PLAYER_TEAM_OUT ? 4 : 3;
                MutableComponent message = Component.m_237119_();
                components.stream().skip(skip).forEach(arg_0 -> ((MutableComponent)message).m_7220_(arg_0));
                boolean isInTeamScreen = screen instanceof MineChatTeamScreen;
                MineChatManager.addAnimationMessageToList(CHAT_TEAM, new AnimationMessage(sender, timestamp, nameInfo.totalLength, messageType, isInTeamScreen ? 5 : 0, 0, 0, (Component)message));
                if (isInTeamScreen) break;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)MineChatSounds.RECEIVE_MESSAGE, (float)1.0f));
                teamChatChecked = false;
                MineChatManager.setRandomChanceRotation();
            }
        }
    }

    public static void setRandomChanceRotation() {
        double chance = Math.random();
        if (chance < 0.05) {
            shouldRotation = true;
        }
    }

    public static boolean shouldRotation() {
        return shouldRotation;
    }

    private static TeamNameInfo getNameLength(UUID sender, MessageType messageType) {
        PlayerTeam team;
        PlayerInfo playerInfo;
        int nameLength = 3;
        int prefix = 0;
        int suffix = 0;
        if (messageType == MessageType.PLAYER_DM_IN || messageType == MessageType.PLAYER_DM_OUT) {
            nameLength = 1;
        }
        if ((playerInfo = PlayerCacheManager.getPlayerInfo(sender)) != null && (team = playerInfo.m_105340_()) != null) {
            prefix = team.m_83370_().getString().isEmpty() ? 0 : 1;
            suffix = team.m_83371_().getString().isEmpty() ? 0 : 1;
        }
        return new TeamNameInfo(nameLength, prefix, suffix);
    }

    public static List<PlayerCache> getDMPlayers(String name) {
        ArrayList<PlayerCache> playerCaches = new ArrayList<PlayerCache>();
        if (name == null || name.isEmpty()) {
            CHAT_DM_MAP.entrySet().stream().sorted((e1, e2) -> Long.compare((Long)((Pair)e2.getValue()).getSecond(), (Long)((Pair)e1.getValue()).getSecond())).forEach(entry -> {
                UUID uuid = (UUID)entry.getKey();
                PlayerCache cache = PlayerCacheManager.getPlayerCache(uuid);
                if (cache != null) {
                    playerCaches.add(cache);
                }
            });
        } else {
            playerCaches.addAll(PlayerCacheManager.getPlayerCachesByName(name));
        }
        return playerCaches;
    }

    public static boolean hasUncheckedMessage() {
        return MineChatManager.isDMChatUnchecked() || MineChatManager.isTeamChatUnchecked();
    }

    public static boolean isTeamChatUnchecked() {
        return !teamChatChecked;
    }

    public static boolean isDMChatUnchecked() {
        return !CHAT_DM_UNCHECKED.isEmpty();
    }

    public static void checkDM(UUID uuid) {
        if (CHAT_DM_MAP.containsKey(uuid)) {
            CHAT_DM_UNCHECKED.remove(uuid);
        }
    }

    public static boolean isDMPlayerMessageUnread(UUID id) {
        return CHAT_DM_UNCHECKED.contains(id);
    }

    public static void checkTeam() {
        teamChatChecked = true;
    }

    public static List<AnimationMessage> getGlobeMessages() {
        return new ArrayList<AnimationMessage>(CHAT_GLOBE);
    }

    public static List<AnimationMessage> getTeamMessages() {
        return new ArrayList<AnimationMessage>(CHAT_TEAM);
    }

    public static List<AnimationMessage> getDMMessages(UUID target) {
        return new ArrayList<AnimationMessage>((Collection)CHAT_DM_MAP.getOrDefault(target, (Pair<ArrayDeque<AnimationMessage>, Long>)new Pair(new ArrayDeque(), (Object)0L)).getFirst());
    }

    public static List<AnimationMessage> getLatestGlobeMessages() {
        return new ArrayList<AnimationMessage>(CHAT_GLOBE_DISPLAY);
    }

    public static void clearGlobeMessage() {
        CHAT_GLOBE.clear();
    }

    public static void clearDisplayMessage() {
        CHAT_GLOBE_DISPLAY.clear();
    }

    public static void clearDMMessage() {
        CHAT_DM_MAP.clear();
    }

    public static void clearTeamMessage() {
        CHAT_TEAM.clear();
    }

    public static class TeamNameInfo {
        int nameLength;
        int prefix;
        int suffix;
        int totalLength;

        public TeamNameInfo(int nameLength, int prefix, int suffix) {
            this.nameLength = nameLength;
            this.prefix = prefix;
            this.suffix = suffix;
            this.totalLength = nameLength + prefix + suffix;
        }
    }
}

