/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.message;

import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.message.ChatMessage;
import net.shelmarow.mine_chat.chat.message.chat_enum.AnimationStatus;
import net.shelmarow.mine_chat.chat.message.chat_enum.MessageType;

@OnlyIn(value=Dist.CLIENT)
public class AnimationMessage
extends ChatMessage {
    private final int maxRemainTime;
    private int fadeInTime;
    private int fadeOutTime;
    private int remainTime;
    private AnimationStatus animationStatus;

    public AnimationMessage(UUID sender, long timestamp, int nameLength, MessageType messageType, Component message) {
        this(sender, timestamp, nameLength, messageType, 230, 10, 20, message);
    }

    public AnimationMessage(UUID sender, long timestamp, int nameLength, MessageType messageType, int maxRemainTime, int fadeInTime, int fadeOutTime, Component message) {
        super(sender, timestamp, nameLength, messageType, message);
        this.maxRemainTime = maxRemainTime;
        this.fadeInTime = fadeInTime;
        this.fadeOutTime = fadeOutTime;
        this.animationStatus = AnimationStatus.FADE_IN;
    }

    public void tick() {
        if (this.animationStatus != AnimationStatus.FINISHED) {
            ++this.remainTime;
            this.animationStatus = this.remainTime <= this.fadeInTime ? AnimationStatus.FADE_IN : (this.remainTime <= this.maxRemainTime - this.fadeOutTime ? AnimationStatus.STAY : (this.remainTime > this.maxRemainTime - this.fadeOutTime && this.remainTime <= this.maxRemainTime ? AnimationStatus.FADE_OUT : AnimationStatus.FINISHED));
        }
    }

    public float getAnimationProgress(float partialTick) {
        if (this.isFinished()) {
            return 1.0f;
        }
        return Mth.m_14036_((float)(((float)this.remainTime + partialTick) / (float)this.maxRemainTime), (float)0.0f, (float)1.0f);
    }

    public float getFadeInRatio(float partialTick) {
        return Mth.m_14036_((float)(((float)this.remainTime + partialTick) / (float)this.fadeInTime), (float)0.0f, (float)1.0f);
    }

    public float getFadeOutRatio(float partialTick) {
        return Mth.m_14036_((float)(((float)this.maxRemainTime - ((float)this.remainTime + partialTick)) / (float)this.fadeOutTime), (float)0.0f, (float)1.0f);
    }

    public boolean isFinished() {
        return this.animationStatus == AnimationStatus.FINISHED;
    }

    public int getMaxRemainTime() {
        return this.maxRemainTime;
    }

    public AnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    public void setAnimationStatus(AnimationStatus animationStatus) {
        this.animationStatus = animationStatus;
    }

    public int getRemainTime() {
        return this.remainTime;
    }

    public void setRemainTime(int remainTime) {
        this.remainTime = remainTime;
    }

    public int getFadeInTime() {
        return this.fadeInTime;
    }

    public void setFadeInTime(int fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public int getFadeOutTime() {
        return this.fadeOutTime;
    }

    public void setFadeOutTime(int fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }
}

