/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.MineChatManager;
import net.shelmarow.mine_chat.chat.message.AnimationMessage;
import net.shelmarow.mine_chat.chat.playercache.PlayerCache;
import net.shelmarow.mine_chat.chat.playercache.PlayerCacheManager;
import net.shelmarow.mine_chat.chat.screen.MineChatScreen;
import net.shelmarow.mine_chat.chat.screen.button.PlayerInfoButton;
import net.shelmarow.mine_chat.chat.screen.editbox.MineChatDMEditBox;
import net.shelmarow.mine_chat.chat.screen.editbox.MineChatSearchEditBox;
import net.shelmarow.mine_chat.chat.texture.MineChatTextures;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MineChatDMScreen
extends MineChatScreen {
    private UUID targetUUID = Util.f_137441_;
    private MineChatSearchEditBox searchBox;
    private String searchText = "";
    private final List<InfoButton> renderableList = new ArrayList<InfoButton>();
    private int infoScrollDelta = 0;
    private int totalInfoHeight = 0;
    private MineChatScreen.ScissorBound buttonBound;

    public MineChatDMScreen() {
        this.currentPage = MineChatScreen.CurrentPage.DM;
        this.background = MineChatTextures.DM_CHANNEL;
    }

    public MineChatDMScreen(String searchText) {
        this();
        this.searchText = searchText;
        PlayerCache cache = PlayerCacheManager.getPlayerCache(searchText, false);
        if (cache != null) {
            this.targetUUID = cache.getProfile().getId();
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.updateTick == this.maxUpdateTick) {
            for (InfoButton infoButton : this.renderableList) {
                infoButton.infoButton.updateOnlineStatues();
            }
        }
    }

    @Override
    protected void reflashScreen() {
        this.searchText = "";
        this.infoScrollDelta = 0;
        this.targetUUID = Util.f_137441_;
        super.reflashScreen();
    }

    public void reflashPlayerInfo() {
        this.m_169411_((GuiEventListener)this.mainEditBox);
        for (InfoButton infoButton : this.renderableList) {
            this.m_169411_((GuiEventListener)infoButton.infoButton);
        }
        this.addPlayerInfoButtons();
        this.addMainEditBox();
    }

    @Override
    protected void initRenderOffset() {
        this.nameLeftOffsetX = 80;
        this.nameRightOffsetX = 0;
        this.messageLeftOffsetX = 80;
        this.frameLeftOffsetX = 80;
    }

    @Override
    protected void initScissorPos() {
        int scissorStartX = this.centerX - this.bgWidth / 2 + 92;
        int scissorStartY = this.centerY - this.bgHeight / 2 + 47;
        int scissorStartEndX = scissorStartX + 292;
        int scissorStartEndY = scissorStartY + 138;
        this.messageBound = new MineChatScreen.ScissorBound(scissorStartX, scissorStartY, scissorStartEndX, scissorStartEndY);
        int bStartX = this.startX + 13;
        int bStartY = this.startY + 47;
        int bEndX = this.startX + 87;
        int bEndY = this.startY + 202;
        this.buttonBound = new MineChatScreen.ScissorBound(bStartX, bStartY, bEndX, bEndY);
    }

    @Override
    protected void addScreenWidgets() {
        this.addPlayerInfoButtons();
        this.searchBox = new MineChatSearchEditBox(this.f_96547_, this.startX + 13, this.startY + 29);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.addMainEditBox();
    }

    private void addMainEditBox() {
        if (!this.targetUUID.equals(Util.f_137441_)) {
            this.mainEditBox = new MineChatDMEditBox(this.f_96547_, this.startX + 91, this.startY + 185, 374, 20);
            this.mainEditBox.m_94199_(256);
            this.m_142416_((GuiEventListener)this.mainEditBox);
            this.m_264313_((GuiEventListener)this.mainEditBox);
        }
    }

    private void addPlayerInfoButtons() {
        this.renderableList.clear();
        int i = 0;
        for (PlayerCache cache : MineChatManager.getDMPlayers(this.searchText)) {
            PlayerInfoButton button = new PlayerInfoButton(this.f_96547_, this.startX + 13, this.startY + 29 + 18 + i * 20, cache, b -> {
                UUID uuid = cache.getProfile().getId();
                this.targetUUID = this.targetUUID.equals(uuid) ? Util.f_137441_ : uuid;
                this.reflashPlayerInfo();
            });
            button.updateOnlineStatues();
            this.m_7787_((GuiEventListener)button);
            this.renderableList.add(new InfoButton(button));
            ++i;
        }
        this.totalInfoHeight = i * 20;
    }

    @Override
    protected void renderBeforeScissor(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        PlayerCache cache;
        MutableComponent displayName = Component.m_237115_((String)"text.mine_chat.select_player");
        int titleCenterX = 239 - this.f_96547_.m_92852_((FormattedText)displayName) / 2;
        int titleCenterY = 110;
        if (!this.targetUUID.equals(Util.f_137441_) && (cache = PlayerCacheManager.getPlayerCache(this.targetUUID)) != null) {
            displayName = Component.m_237113_((String)cache.getProfile().getName()).m_7220_((Component)Component.m_237115_((String)(cache.isOnline() ? "text.mine_chat.online" : "text.mine_chat.offline"))).m_130940_(cache.isOnline() ? ChatFormatting.WHITE : ChatFormatting.GRAY);
            titleCenterX = 238 - this.f_96547_.m_92852_((FormattedText)displayName) / 2;
            titleCenterY = 33;
            poseStack.m_85836_();
            poseStack.m_252880_((float)(titleCenterX - 16), 31.0f, 0.0f);
            poseStack.m_85841_(1.5f, 1.5f, 1.0f);
            ResourceLocation head = cache.getSkinLocation();
            guiGraphics.m_280163_(head, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280163_(head, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
            poseStack.m_85849_();
        }
        guiGraphics.m_280430_(this.f_96547_, (Component)displayName, titleCenterX, titleCenterY, 0xFFFFFF);
    }

    @Override
    protected void renderAfterRenderable(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280588_(this.startX + 13, this.startY + 48, this.startX + 87, this.startY + 201);
        for (InfoButton renderable : this.renderableList) {
            renderable.infoButton.m_253211_(renderable.baseY + this.infoScrollDelta);
            if (this.buttonBound.inScissorBound(renderable.infoButton.m_252754_(), renderable.infoButton.m_252907_(), renderable.infoButton.m_5711_(), renderable.infoButton.m_93694_())) {
                renderable.infoButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                renderable.infoButton.f_93623_ = true;
                continue;
            }
            renderable.infoButton.f_93623_ = false;
        }
        guiGraphics.m_280618_();
    }

    @Override
    @NotNull
    public List<AnimationMessage> getChatMessages() {
        if (this.targetUUID.equals(Util.f_137441_)) {
            return new ArrayList<AnimationMessage>();
        }
        List<AnimationMessage> chatMessages = MineChatManager.getDMMessages(this.targetUUID);
        Collections.reverse(chatMessages);
        MineChatManager.checkDM(this.targetUUID);
        return chatMessages;
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        LocalPlayer player;
        if (this.searchBox != null && this.searchBox.m_93696_() && this.searchBox.m_142518_() && (pKeyCode == 257 || pKeyCode == 335) && (player = Minecraft.m_91087_().f_91074_) != null) {
            this.searchText = this.searchBox.m_94155_();
            this.reflashPlayerInfo();
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    protected void onEditBoxEnterPressed(LocalPlayer player) {
        super.onEditBoxEnterPressed(player);
        if (this.currentPage == MineChatScreen.CurrentPage.DM && !this.targetUUID.equals(Util.f_137441_)) {
            String message = this.mainEditBox.m_94155_();
            PlayerCache playerCache = PlayerCacheManager.getPlayerCache(this.targetUUID);
            if (playerCache != null && playerCache.isOnline() && !message.isEmpty()) {
                player.f_108617_.m_246623_("tell " + playerCache.getProfile().getName() + " " + message);
                this.resetScroll();
            }
        }
        this.mainEditBox.m_94144_("");
    }

    @Override
    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        double d = pDelta == 0.0 ? 0.0 : (pDelta = (double)(pDelta < 0.0 ? -1 : 1));
        if (!MineChatDMScreen.m_96638_()) {
            pDelta *= 7.0;
        }
        if (this.buttonBound.inScissorBound((int)pMouseX, (int)pMouseY, 0, 0)) {
            if (this.totalInfoHeight > this.buttonBound.totalYHeight()) {
                this.infoScrollDelta = (int)Mth.m_14008_((double)((double)this.infoScrollDelta + pDelta), (double)(-(this.totalInfoHeight - this.buttonBound.totalYHeight())), (double)0.0);
            }
            return true;
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public UUID getSelectedTarget() {
        return this.targetUUID;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public static class InfoButton {
        PlayerInfoButton infoButton;
        int baseY;
        int baseX;

        public InfoButton(PlayerInfoButton infoButton) {
            this.infoButton = infoButton;
            this.baseX = infoButton.m_252754_();
            this.baseY = infoButton.m_252907_();
        }
    }
}

