/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.message.AnimationMessage;
import net.shelmarow.mine_chat.chat.message.chat_enum.MessageType;
import net.shelmarow.mine_chat.chat.playercache.PlayerCache;
import net.shelmarow.mine_chat.chat.playercache.PlayerCacheManager;
import net.shelmarow.mine_chat.chat.screen.MineChatDMScreen;
import net.shelmarow.mine_chat.chat.screen.MineChatGlobeScreen;
import net.shelmarow.mine_chat.chat.screen.MineChatTeamScreen;
import net.shelmarow.mine_chat.chat.screen.button.ChannelSwitchButton;
import net.shelmarow.mine_chat.chat.screen.editbox.MineChatCommonEditBox;
import net.shelmarow.mine_chat.chat.sound.MineChatSounds;
import net.shelmarow.mine_chat.chat.texture.MineChatTextures;
import net.shelmarow.mine_chat.config.MineChatConfig;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class MineChatScreen
extends Screen {
    protected ResourceLocation background = MineChatTextures.COMMON_CHANNEL;
    protected final List<RenderedChatLine> renderedLines = new ArrayList<RenderedChatLine>();
    protected final List<ChannelSwitchButton> channelSwitchButtons = new ArrayList<ChannelSwitchButton>();
    protected CurrentPage currentPage = CurrentPage.GLOBE;
    protected EditBox mainEditBox;
    protected int maxUpdateTick = 2;
    protected int updateTick = 0;
    protected int scrollDelta = 0;
    protected float totalLineHeight = 0.0f;
    protected int baseOffsetY = 30;
    protected int maxLineWidth = 150;
    protected int nameLeftOffsetX = 0;
    protected int nameRightOffsetX = 4;
    protected int messageLeftOffsetX = 0;
    protected int messageRightOffsetX = 0;
    protected int frameLeftOffsetX = 0;
    protected int frameRightOffsetX = 0;
    protected int bgWidth = 396;
    protected int bgHeight = 216;
    protected int centerX;
    protected int centerY;
    protected int startX;
    protected int startY;
    protected ScissorBound messageBound;
    protected long guiOpenTime = Long.MAX_VALUE;
    protected static boolean animationStarted = false;
    protected static float animationTimer = 0.0f;
    protected static List<AnimationParam> animationParams = new ArrayList<AnimationParam>();
    protected float screenPartialTick = 0.0f;
    protected List<AnimationMessage> displayedMessages = new ArrayList<AnimationMessage>();

    public MineChatScreen() {
        super((Component)Component.m_237119_());
        this.initAnimation();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            this.guiOpenTime = mc.f_91073_.m_46467_();
        }
        if (!animationStarted) {
            this.startAnimation();
        }
    }

    public void m_7856_() {
        this.m_169413_();
        Minecraft mc = Minecraft.m_91087_();
        this.initStartPos();
        this.initRenderOffset();
        this.initScissorPos();
        this.addTabButtons(mc);
        this.addScreenWidgets();
    }

    protected void initRenderOffset() {
        this.nameLeftOffsetX = 0;
        this.nameRightOffsetX = 4;
        this.messageLeftOffsetX = 0;
        this.messageRightOffsetX = 0;
        this.frameLeftOffsetX = 0;
        this.frameRightOffsetX = 0;
    }

    protected void initScissorPos() {
        int scissorStartX = this.centerX - this.bgWidth / 2 + 12;
        int scissorStartY = this.centerY - this.bgHeight / 2 + 28;
        int scissorStartEndX = scissorStartX + 372;
        int scissorStartEndY = scissorStartY + 157;
        this.messageBound = new ScissorBound(scissorStartX, scissorStartY, scissorStartEndX, scissorStartEndY);
    }

    protected void initStartPos() {
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.startX = this.centerX - this.bgWidth / 2;
        this.startY = this.centerY - this.bgHeight / 2;
    }

    protected void addScreenWidgets() {
        this.mainEditBox = new MineChatCommonEditBox(this.f_96547_, this.startX + 11, this.startY + 185);
        this.mainEditBox.m_94199_(256);
        this.m_142416_((GuiEventListener)this.mainEditBox);
        this.m_264313_((GuiEventListener)this.mainEditBox);
    }

    protected void addTabButtons(Minecraft mc) {
        this.channelSwitchButtons.clear();
        ChannelSwitchButton globe = new ChannelSwitchButton(this.startX + 8, this.startY + 6, this.currentPage == CurrentPage.GLOBE, CurrentPage.GLOBE, (Component)Component.m_237115_((String)"text.mine_chat.globe_channel"), (Component)Component.m_237115_((String)"text.mine_chat.globe_tool_tip"), b -> {
            if (this.currentPage != CurrentPage.GLOBE) {
                mc.m_91152_((Screen)new MineChatGlobeScreen());
            } else {
                boolean showRecent = (Boolean)MineChatConfig.DISPLAY_RECENT_MESSAGES.get();
                MineChatConfig.DISPLAY_RECENT_MESSAGES.set((Object)(!showRecent ? 1 : 0));
                MineChatConfig.CLIENT_CONFIG.save();
                if (mc.f_91074_ != null) {
                    if (showRecent) {
                        mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"text.mine_chat.recent_disabled"), false);
                    } else {
                        mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"text.mine_chat.recent_enabled"), false);
                    }
                }
                this.reflashScreen();
            }
        });
        this.m_142416_((GuiEventListener)globe);
        this.channelSwitchButtons.add(globe);
        ChannelSwitchButton dm = new ChannelSwitchButton(this.startX + 8 + 52 + 4, this.startY + 6, this.currentPage == CurrentPage.DM, CurrentPage.DM, (Component)Component.m_237115_((String)"text.mine_chat.dm_channel"), (Component)Component.m_237119_(), b -> {
            if (this.currentPage != CurrentPage.DM) {
                mc.m_91152_((Screen)new MineChatDMScreen());
            } else {
                this.reflashScreen();
            }
        });
        this.m_142416_((GuiEventListener)dm);
        this.channelSwitchButtons.add(dm);
        ChannelSwitchButton team = new ChannelSwitchButton(this.startX + 8 + 112, this.startY + 6, this.currentPage == CurrentPage.TEAM, CurrentPage.TEAM, (Component)Component.m_237115_((String)"text.mine_chat.team_channel"), (Component)Component.m_237119_(), b -> {
            if (this.currentPage != CurrentPage.TEAM) {
                mc.m_91152_((Screen)new MineChatTeamScreen());
            } else {
                this.reflashScreen();
            }
        });
        this.m_142416_((GuiEventListener)team);
        this.channelSwitchButtons.add(team);
        for (ChannelSwitchButton button : this.channelSwitchButtons) {
            button.updateUnchecked();
        }
    }

    protected void reflashScreen() {
        this.m_7856_();
    }

    protected void startAnimation() {
        animationStarted = true;
        animationTimer = 0.0f;
    }

    protected void stopAnimation() {
        animationStarted = false;
        animationTimer = 0.0f;
    }

    protected void initAnimation() {
        animationParams.clear();
        animationParams.addAll(List.of(new AnimationParam(0, 0, this.bgHeight, 0.0f), new AnimationParam(40, 0, 0, 1.0f)));
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.mainEditBox != null && this.mainEditBox.m_94155_().startsWith("/") && this.currentPage == CurrentPage.GLOBE) {
            Minecraft.m_91087_().m_91152_((Screen)new ChatScreen("/"));
        }
        if (animationStarted && animationTimer < 20.0f) {
            animationTimer += 1.0f;
        }
        this.screenPartialTick = 0.0f;
        List<AnimationMessage> messages = this.displayedMessages.stream().filter(m -> !m.isFinished()).toList();
        for (AnimationMessage message : messages) {
            message.tick();
        }
        if (--this.updateTick < 0) {
            this.updateTick = this.maxUpdateTick;
        }
        if (this.updateTick == this.maxUpdateTick) {
            for (ChannelSwitchButton button : this.channelSwitchButtons) {
                button.updateUnchecked();
            }
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Style hovered;
        this.screenPartialTick = Mth.m_14036_((float)(this.screenPartialTick + partialTick), (float)0.0f, (float)1.0f);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            return;
        }
        this.m_280273_(guiGraphics);
        PoseStack poseStack = guiGraphics.m_280168_();
        float animationProgress = 1.0f;
        if (animationStarted) {
            animationProgress = Mth.m_14036_((float)((animationTimer + this.screenPartialTick) / 2.0f), (float)0.0f, (float)1.0f);
        }
        animationProgress = (float)Mth.m_14197_((double)animationProgress);
        float bgAY = 0.05f * (float)this.bgWidth * (1.0f - animationProgress);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, bgAY, 0.0f);
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.startX, (float)this.startY, 0.0f);
        this.renderBeforeBackground(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        RenderSystem.enableBlend();
        guiGraphics.m_280163_(this.background, 0, 0, 0.0f, 0.0f, this.bgWidth, this.bgHeight, this.bgWidth, this.bgHeight);
        RenderSystem.disableBlend();
        this.renderAfterBackground(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        this.renderBeforeScissor(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        guiGraphics.m_280588_(this.messageBound.startX, (int)((float)this.messageBound.startY + bgAY), this.messageBound.endX, (int)((float)this.messageBound.endY + bgAY));
        this.renderBeforeMessage(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        List<AnimationMessage> messages = this.displayedMessages = this.getChatMessages();
        this.renderedLines.clear();
        poseStack.m_252880_(0.0f, (float)this.scrollDelta, 0.0f);
        float offsetY = 0.0f;
        for (AnimationMessage message : messages) {
            SenderWithMessage result = this.getDisplayMessage(message);
            boolean isSender = message.getSender().equals(mc.f_91074_.m_20148_());
            List lines = this.f_96547_.m_92923_((FormattedText)result.finalMessage(), this.maxLineWidth);
            int n = lines.size() - 1;
            Objects.requireNonNull(this.f_96547_);
            float progress = message.getAnimationProgress(this.screenPartialTick);
            float pX = (float)(isSender ? 25 : -25) * (1.0f - progress);
            float pY = -(offsetY += (float)Math.max(n * 9, 0)) + (float)this.baseOffsetY * (1.0f - progress);
            poseStack.m_85836_();
            poseStack.m_252880_(pX, pY, 0.0f);
            this.drawMessages(guiGraphics, isSender, lines, result, progress);
            this.drawFrame(guiGraphics, isSender, message, progress);
            offsetY += (float)this.baseOffsetY * progress;
            poseStack.m_85849_();
        }
        this.totalLineHeight = offsetY;
        poseStack.m_85849_();
        this.renderAfterMessage(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        guiGraphics.m_280618_();
        this.renderAfterScissor(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        this.renderBeforeRenderable(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.renderAfterRenderable(guiGraphics, poseStack, mouseX, mouseY, partialTick);
        if (this.messageBound.inScissorBound(mouseX, mouseY, 0, 0) && (hovered = this.getStyleAt(mouseX, mouseY)) != null && hovered.m_131186_() != null) {
            guiGraphics.m_280304_(this.f_96547_, hovered, mouseX, mouseY);
        }
        poseStack.m_85849_();
    }

    protected void renderBeforeBackground(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderAfterBackground(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderBeforeScissor(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderAfterScissor(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderBeforeMessage(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderAfterMessage(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderBeforeRenderable(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderAfterRenderable(@NotNull GuiGraphics guiGraphics, PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
    }

    public void drawMessages(@NotNull GuiGraphics guiGraphics, boolean isSender, List<FormattedCharSequence> lines, SenderWithMessage message, float progress) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
        int nameX = isSender ? 353 - this.f_96547_.m_92852_((FormattedText)message.senderName()) + this.nameRightOffsetX : 38 + this.nameLeftOffsetX;
        int nameY = 160;
        guiGraphics.m_280430_(this.f_96547_, (Component)message.senderName(), nameX, nameY, 0xFFFFFF);
        this.addRenderText((Component)message.senderName(), this.startX + nameX, this.startY + nameY + this.scrollDelta, this.f_96547_.m_92852_((FormattedText)message.senderName()));
        int maxLineWidth = 0;
        for (FormattedCharSequence line : lines) {
            maxLineWidth = Math.max(maxLineWidth, this.f_96547_.m_92724_(line));
        }
        int lineOffset = 0;
        for (FormattedCharSequence line : lines) {
            int messageX = isSender ? 351 - maxLineWidth + this.messageRightOffsetX : 40 + this.messageLeftOffsetX;
            int messageY = 171 + lineOffset;
            guiGraphics.m_280648_(this.f_96547_, line, messageX, messageY, 0xFFFFFF);
            this.addRenderText(line, this.startX + messageX, this.startY + messageY + this.scrollDelta, this.f_96547_.m_92724_(line));
            Objects.requireNonNull(this.f_96547_);
            lineOffset += 9;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    public void drawFrame(@NotNull GuiGraphics guiGraphics, boolean isSender, AnimationMessage message, float progress) {
        int headX;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)progress);
        int frameX = isSender ? 355 + this.frameRightOffsetX : 14 + this.frameLeftOffsetX;
        int n = headX = isSender ? 358 + this.frameRightOffsetX : 17 + this.frameLeftOffsetX;
        if (message.getMessageType() != MessageType.SYSTEM) {
            PlayerCache playerCache = PlayerCacheManager.getPlayerCache(message.getSender());
            if (playerCache != null) {
                guiGraphics.m_280163_(MineChatTextures.PLAYER_FRAME, frameX, 158, 0.0f, 0.0f, 22, 22, 22, 22);
                ResourceLocation head = playerCache.getSkinLocation();
                guiGraphics.m_280163_(head, headX, 161, 16.0f, 16.0f, 16, 16, 128, 128);
                guiGraphics.m_280163_(head, headX, 161, 80.0f, 16.0f, 16, 16, 128, 128);
            } else {
                guiGraphics.m_280163_(MineChatTextures.UNKNOW, frameX, 158, 0.0f, 0.0f, 22, 22, 22, 22);
            }
        } else {
            guiGraphics.m_280163_(MineChatTextures.SYSTEM_ICON, frameX, 158, 0.0f, 0.0f, 22, 22, 22, 22);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    protected void addRenderText(FormattedCharSequence text, int x, int y, int width) {
        this.renderedLines.add(new RenderedChatLine(text, x, y, width));
    }

    protected void addRenderText(Component text, int x, int y, int width) {
        this.renderedLines.add(new RenderedChatLine(text, x, y, width));
    }

    public void resetScroll() {
        this.scrollDelta = 0;
    }

    @NotNull
    protected SenderWithMessage getDisplayMessage(AnimationMessage message) {
        Component text = message.getMessage();
        MutableComponent senderName = Component.m_237119_();
        MutableComponent finalMessage = Component.m_237119_();
        List lists = text.m_240407_();
        for (int i = 0; i < lists.size(); ++i) {
            if (i < message.getNameLength()) {
                senderName.m_7220_((Component)lists.get(i));
                continue;
            }
            finalMessage.m_7220_((Component)lists.get(i));
        }
        return new SenderWithMessage(senderName, finalMessage);
    }

    @NotNull
    protected abstract List<AnimationMessage> getChatMessages();

    @Nullable
    protected Style getStyleAt(int mouseX, int mouseY) {
        for (RenderedChatLine line : this.renderedLines) {
            if (mouseX < line.getX() || mouseX > line.getX() + line.getWidth() || mouseY < line.getY()) continue;
            int n = line.getY();
            Objects.requireNonNull(this.f_96547_);
            if (mouseY > n + 9) continue;
            return this.f_96547_.m_92865_().m_92338_(line.getText(), mouseX - line.getX());
        }
        return null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        Style style;
        if (button == 0 && (style = this.getStyleAt((int)mouseX, (int)mouseY)) != null && this.m_5561_(style)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6697_(@NotNull String pText, boolean pOverwrite) {
        if (pText.startsWith("/tell")) {
            String[] text = pText.split(" ");
            Minecraft mc = Minecraft.m_91087_();
            mc.m_91152_((Screen)new MineChatDMScreen(text[text.length - 1]));
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.mainEditBox != null && this.mainEditBox.m_93696_() && this.mainEditBox.m_142518_()) {
            if (pKeyCode == 257 || pKeyCode == 335) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player != null) {
                    this.onEditBoxEnterPressed(player);
                    return true;
                }
            } else if (pKeyCode == 264 || pKeyCode == 265) {
                return false;
            }
            if (pKeyCode == 259) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)MineChatSounds.TYPING, (float)1.0f));
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    protected void onEditBoxEnterPressed(LocalPlayer player) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12497_, (float)1.0f));
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.messageBound.inScissorBound((int)pMouseX, (int)pMouseY, 0, 0)) {
            double d = pDelta == 0.0 ? 0.0 : (pDelta = (double)(pDelta < 0.0 ? -1 : 1));
            if (!MineChatScreen.m_96638_()) {
                pDelta *= 7.0;
            }
            if (this.totalLineHeight > (float)this.messageBound.totalYHeight()) {
                this.scrollDelta = (int)Mth.m_14008_((double)((double)this.scrollDelta + pDelta), (double)0.0, (double)(this.totalLineHeight - (float)this.messageBound.totalYHeight()));
            }
            return true;
        }
        return false;
    }

    public void m_7379_() {
        super.m_7379_();
        this.stopAnimation();
    }

    public boolean m_7043_() {
        return false;
    }

    public static enum CurrentPage {
        GLOBE,
        DM,
        TEAM;

    }

    public static class ScissorBound {
        private int startX;
        private int startY;
        private int endX;
        private int endY;

        public ScissorBound(int startX, int startY, int endX, int endY) {
            this.startX = startX;
            this.startY = startY;
            this.endX = endX;
            this.endY = endY;
        }

        public boolean inScissorBound(int posX, int posY, int width, int height) {
            return (posX >= this.startX && posX <= this.endX || posX + width >= this.startX && posX + width <= this.endX) && (posY >= this.startY && posY <= this.endY || posY + height >= this.startY && posY + height <= this.endY);
        }

        public int totalXHeight() {
            return this.endX - this.startX;
        }

        public int totalYHeight() {
            return this.endY - this.startY;
        }

        public int getStartX() {
            return this.startX;
        }

        public void setStartX(int startX) {
            this.startX = startX;
        }

        public int getStartY() {
            return this.startY;
        }

        public void setStartY(int startY) {
            this.startY = startY;
        }

        public int getEndX() {
            return this.endX;
        }

        public void setEndX(int endX) {
            this.endX = endX;
        }

        public int getEndY() {
            return this.endY;
        }

        public void setEndY(int endY) {
            this.endY = endY;
        }
    }

    public record AnimationParam(int timestamp, int posOffsetX, int posOffsetY, float transition) {
    }

    public record SenderWithMessage(MutableComponent senderName, MutableComponent finalMessage) {
    }

    public static class RenderedChatLine {
        private final FormattedCharSequence text;
        private final int x;
        private final int y;
        private final int width;

        RenderedChatLine(Component text, int x, int y, int width) {
            this.text = text.m_7532_();
            this.x = x;
            this.y = y;
            this.width = width;
        }

        RenderedChatLine(FormattedCharSequence text, int x, int y, int width) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public FormattedCharSequence getText() {
            return this.text;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

