/*
 * Decompiled with CFR 0.152.
 */
package net.shelmarow.mine_chat.chat.screen.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.shelmarow.mine_chat.chat.MineChatManager;
import net.shelmarow.mine_chat.chat.screen.MineChatScreen;
import net.shelmarow.mine_chat.chat.texture.MineChatTextures;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ChannelSwitchButton
extends AbstractButton {
    private static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/channel.png");
    private static final ResourceLocation CHANNEL_HOVERED = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/channel_hovered.png");
    private static final ResourceLocation CHANNEL_SELECTED = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/channel_selected.png");
    private static final ResourceLocation CHANNEL_SELECTED_HOVERED = ResourceLocation.fromNamespaceAndPath((String)"mine_chat", (String)"textures/mchat/channel_selected_hovered.png");
    protected final OnPress onPress;
    protected final boolean selected;
    protected final MineChatScreen.CurrentPage currentPage;
    protected boolean unchecked = false;
    protected Component toolTip;

    public ChannelSwitchButton(int pX, int pY, boolean selected, MineChatScreen.CurrentPage currentPage, Component pMessage, OnPress pOnPress) {
        this(pX, pY, selected, currentPage, pMessage, (Component)Component.m_237119_(), pOnPress);
    }

    public ChannelSwitchButton(int pX, int pY, boolean selected, MineChatScreen.CurrentPage currentPage, Component pMessage, Component toolTip, OnPress pOnPress) {
        super(pX, pY, 52, 16, pMessage);
        this.selected = selected;
        this.onPress = pOnPress;
        this.currentPage = currentPage;
        this.toolTip = toolTip;
    }

    protected void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.m_91087_();
        this.m_280139_(guiGraphics, mc.f_91062_, 0xFFFFFF);
        if (this.selected) {
            if (this.m_274382_()) {
                if (!this.toolTip.equals(Component.m_237119_())) {
                    guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, this.toolTip, mouseX, mouseY);
                }
                guiGraphics.m_280163_(CHANNEL_SELECTED_HOVERED, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 52, 19, 52, 19);
            } else {
                guiGraphics.m_280163_(CHANNEL_SELECTED, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 52, 19, 52, 19);
            }
        } else if (this.m_274382_()) {
            guiGraphics.m_280163_(CHANNEL_HOVERED, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 52, 16, 52, 16);
        } else {
            guiGraphics.m_280163_(CHANNEL, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 52, 16, 52, 16);
        }
        if (this.unchecked) {
            guiGraphics.m_280163_(MineChatTextures.RED_POINT, this.m_252754_() + this.m_5711_() - 6, this.m_252907_(), 0.0f, 0.0f, 6, 6, 6, 6);
        }
    }

    public void updateUnchecked() {
        this.unchecked = this.currentPage == MineChatScreen.CurrentPage.DM && MineChatManager.isDMChatUnchecked() || this.currentPage == MineChatScreen.CurrentPage.TEAM && MineChatManager.isTeamChatUnchecked();
    }

    protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        this.m_168802_(pNarrationElementOutput);
    }

    public void m_5691_() {
        this.onPress.onPress(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(ChannelSwitchButton var1);
    }
}

