/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block;

import com.yablon.furnitury.entity.SitEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty LEFT_ARM = BooleanProperty.m_61465_((String)"left_arm");
    public static final BooleanProperty RIGHT_ARM = BooleanProperty.m_61465_((String)"right_arm");
    private final VoxelShape defaultShape;
    private final VoxelShape leftArmShape;
    private final VoxelShape rightArmShape;
    private final VoxelShape noArmsShape;

    public SofaBlock(BlockBehaviour.Properties properties, VoxelShape defaultShape) {
        super(properties);
        this.defaultShape = defaultShape;
        this.leftArmShape = defaultShape;
        this.rightArmShape = defaultShape;
        this.noArmsShape = defaultShape;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!world.f_46443_ && !player.m_20159_()) {
            BlockPos sitPos = pos.m_7494_();
            SitEntity sitEntity = new SitEntity(world, sitPos, player);
            sitEntity.m_6034_(sitEntity.m_20185_(), sitEntity.m_20186_() - 0.5, sitEntity.m_20189_());
            world.m_7967_((Entity)sitEntity);
            player.m_20329_((Entity)sitEntity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LEFT_ARM, RIGHT_ARM});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean hasNeighbors = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof SofaBlock)) continue;
            hasNeighbors = true;
            break;
        }
        if (!hasNeighbors) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(this.shouldHaveLeftArm(world, pos)))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(this.shouldHaveRightArm(world, pos)));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)f_54117_)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean hasLeftArm = (Boolean)state.m_61143_((Property)LEFT_ARM);
        boolean hasRightArm = (Boolean)state.m_61143_((Property)RIGHT_ARM);
        if (hasLeftArm && hasRightArm) {
            return this.defaultShape;
        }
        if (hasLeftArm) {
            return this.leftArmShape;
        }
        if (hasRightArm) {
            return this.rightArmShape;
        }
        return this.noArmsShape;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        this.updateConnections(world, pos, state);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        this.updateConnections(world, pos, null);
    }

    private void updateConnections(Level world, BlockPos pos, BlockState currentState) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = world.m_8055_(neighborPos);
            if (!(neighborState.m_60734_() instanceof SofaBlock)) continue;
            boolean leftArm = this.shouldHaveLeftArm(world, neighborPos);
            boolean rightArm = this.shouldHaveRightArm(world, neighborPos);
            world.m_7731_(neighborPos, (BlockState)((BlockState)neighborState.m_61124_((Property)LEFT_ARM, (Comparable)Boolean.valueOf(leftArm))).m_61124_((Property)RIGHT_ARM, (Comparable)Boolean.valueOf(rightArm)), 3);
        }
    }

    private boolean shouldHaveLeftArm(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof SofaBlock)) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        Direction leftDirection = facing.m_122427_();
        BlockPos neighborPos = pos.m_121945_(leftDirection);
        BlockState neighborState = world.m_8055_(neighborPos);
        if (neighborState.m_60734_() instanceof SofaBlock) {
            Direction neighborFacing = (Direction)neighborState.m_61143_((Property)f_54117_);
            return neighborFacing != facing;
        }
        return true;
    }

    private boolean shouldHaveRightArm(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!(state.m_60734_() instanceof SofaBlock)) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        Direction rightDirection = facing.m_122428_();
        BlockPos neighborPos = pos.m_121945_(rightDirection);
        BlockState neighborState = world.m_8055_(neighborPos);
        if (neighborState.m_60734_() instanceof SofaBlock) {
            Direction neighborFacing = (Direction)neighborState.m_61143_((Property)f_54117_);
            return neighborFacing != facing;
        }
        return true;
    }
}

