/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.furnitury.block.entity;

import com.yablon.furnitury.block.entity.ModBlockEntities;
import com.yablon.furnitury.screen.ShelfMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ShelfBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private static final float[][] ITEM_RENDER_POSITIONS = new float[][]{{0.2f, 0.6f, 0.75f}, {0.5f, 0.6f, 0.75f}, {0.8f, 0.6f, 0.75f}};

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public ShelfBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.SHELF_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.tutorialmod.gem_polishing_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new ShelfMenu(pContainerId, pPlayerInventory, this, (ContainerData)new SimpleContainerData(2));
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag tag) {
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        super.m_142466_(tag);
    }

    public ItemStack getItem(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public float[] getRenderPosition(int slot, Direction direction) {
        float[][] basePositions = ITEM_RENDER_POSITIONS;
        float[] position = basePositions[slot];
        switch (direction) {
            case NORTH: {
                return new float[]{position[0], position[1], position[2]};
            }
            case SOUTH: {
                return new float[]{1.0f - position[0], position[1], 1.0f - position[2]};
            }
            case WEST: {
                return new float[]{position[2], position[1], 1.0f - position[0]};
            }
            case EAST: {
                return new float[]{1.0f - position[2], position[1], position[0]};
            }
        }
        return position;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

