/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockEntityItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;

public class ControllableStorageItemActionHandler
implements IBlockEntityItemActionHandler<IControllableStorage> {
    public static final ControllableStorageItemActionHandler INSTANCE = new ControllableStorageItemActionHandler();
    public static final Identifier ID = SophisticatedCore.getIdentifier((String)"controllable_storage");

    @Override
    public ItemMatchResult getItemMatch(ItemStackKey stackKey, IControllableStorage storage) {
        ISlotTracker slotTracker = storage.getStorageWrapper().getInventoryHandler().getSlotTracker();
        return ControllableStorageItemActionHandler.getItemMatchResult(stackKey, slotTracker, false);
    }

    private static ItemMatchResult getItemMatchResult(ItemStackKey stackKey, ISlotTracker slotTracker, boolean includeMemorizedAndFiltered) {
        if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey) || includeMemorizedAndFiltered && slotTracker.hasExactStackMemorized(stackKey)) {
            return ItemMatchResult.MATCHING_STACK;
        }
        if (slotTracker.getItems().contains(stackKey.stack().getItem()) || includeMemorizedAndFiltered && slotTracker.hasItemMemorizedOrFiltered(stackKey.stack().getItem())) {
            return ItemMatchResult.MATCHING_ITEM;
        }
        return ItemMatchResult.NO_MATCH;
    }

    @Override
    public Class<IControllableStorage> getObjectClass() {
        return IControllableStorage.class;
    }

    @Override
    public Identifier id() {
        return ID;
    }

    @Override
    public IRestockHandler getRestockHandler(final IControllableStorage storage) {
        return new IRestockHandler(){

            @Override
            public Vec3 getPosition() {
                return Vec3.atCenterOf((Vec3i)storage.getStorageBlockPos());
            }

            @Override
            public int extractItem(ItemStack stack) {
                return InventoryHelper.extract((ResourceHandler)storage.getStorageWrapper().getInventoryForInputOutput(), (ItemStack)stack);
            }
        };
    }

    @Override
    public BlockPos getDepositPosToActOn(BlockPos pos, IControllableStorage controllableStorage) {
        return controllableStorage.getControllerPos().orElse(pos);
    }

    @Override
    public IDepositHandler getDepositHandler(final IControllableStorage storage) {
        final Vec3 center = Vec3.atCenterOf((Vec3i)storage.getStorageBlockPos());
        return new IDepositHandler(){

            @Override
            public Vec3 getPosition() {
                return center;
            }

            @Override
            public ItemMatchResult getItemMatch(ItemStackKey stackKey) {
                ISlotTracker slotTracker = storage.getStorageWrapper().getInventoryHandler().getSlotTracker();
                return ControllableStorageItemActionHandler.getItemMatchResult(stackKey, slotTracker, true);
            }

            @Override
            public int insertItem(ItemStack stack) {
                return InventoryHelper.insert((ResourceHandler)storage.getStorageWrapper().getInventoryForInputOutput(), (ItemStack)stack);
            }
        };
    }
}

