/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.p3pp3rf1y.sophisticateditemactions.common.ControllableStorageItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ControllerItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IEntityItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.StandardStorageActionHandler;

public class ItemActionHandlerRegistry {
    private static final Map<Identifier, IBlockItemActionHandler> blockHandlersRegistry = new LinkedHashMap<Identifier, IBlockItemActionHandler>();
    private static final Map<Identifier, IEntityItemActionHandler> entityHandlersRegistry = new LinkedHashMap<Identifier, IEntityItemActionHandler>();

    private ItemActionHandlerRegistry() {
    }

    public static void register(IBlockItemActionHandler handler) {
        blockHandlersRegistry.put(handler.id(), handler);
    }

    public static Optional<IBlockItemActionHandler> getBlockHandler(Identifier id) {
        if (StandardStorageActionHandler.INSTANCE.id().equals((Object)id)) {
            return Optional.of(StandardStorageActionHandler.INSTANCE);
        }
        return Optional.ofNullable(blockHandlersRegistry.get(id));
    }

    public static Optional<Identifier> getBlockHandlerIdFor(Level level, BlockPos pos, BlockEntity blockEntity, IBlockItemActionHandler.Action action) {
        return ItemActionHandlerRegistry.getBlockHandlerFor(level, pos, blockEntity, action).map(IBlockItemActionHandler::id);
    }

    public static Optional<IBlockItemActionHandler> getBlockHandlerFor(Level level, BlockPos pos, BlockEntity blockEntity, IBlockItemActionHandler.Action action) {
        for (IBlockItemActionHandler h : blockHandlersRegistry.values()) {
            if (!h.handlesAction(action) || !h.canActOn(level, pos, blockEntity)) continue;
            return Optional.of(h);
        }
        StandardStorageActionHandler fallback = StandardStorageActionHandler.INSTANCE;
        if (fallback.handlesAction(action) && fallback.canActOn(level, pos, blockEntity)) {
            return Optional.of(fallback);
        }
        return Optional.empty();
    }

    public static void register(IEntityItemActionHandler handler) {
        entityHandlersRegistry.put(handler.id(), handler);
    }

    public static Optional<IEntityItemActionHandler> getEntityHandler(Identifier id) {
        if (StandardStorageActionHandler.INSTANCE.id().equals((Object)id)) {
            return Optional.of(StandardStorageActionHandler.INSTANCE);
        }
        return Optional.ofNullable(entityHandlersRegistry.get(id));
    }

    public static Optional<Identifier> getEntityHandlerIdFor(Entity entity) {
        for (IEntityItemActionHandler h : entityHandlersRegistry.values()) {
            if (!h.canActOn(entity)) continue;
            return Optional.of(h.id());
        }
        if (StandardStorageActionHandler.INSTANCE.canActOn(entity)) {
            return Optional.of(StandardStorageActionHandler.INSTANCE.id());
        }
        return Optional.empty();
    }

    static {
        ItemActionHandlerRegistry.register(ControllerItemActionHandler.INSTANCE);
        ItemActionHandlerRegistry.register(ControllableStorageItemActionHandler.INSTANCE);
    }
}

