/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;
import net.p3pp3rf1y.sophisticateditemactions.common.HighlightHandler;

public record RequestItemHighlightsPayload(ItemStack stack, Map<Identifier, List<BlockPos>> inventoryPositions, Map<Identifier, List<Integer>> entities) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestItemHighlightsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getIdentifier((String)"request_item_highlights"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestItemHighlightsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RequestItemHighlightsPayload::stack, (StreamCodec)StreamCodecHelper.ofMap((StreamCodec)Identifier.STREAM_CODEC, (StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), HashMap::new), RequestItemHighlightsPayload::inventoryPositions, (StreamCodec)StreamCodecHelper.ofMap((StreamCodec)Identifier.STREAM_CODEC, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), HashMap::new), RequestItemHighlightsPayload::entities, RequestItemHighlightsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(RequestItemHighlightsPayload payload, IPayloadContext context) {
        ItemStackKey stackKey = ItemStackKey.of((ItemStack)payload.stack());
        Player player = context.player();
        Map<Identifier, List<BlockPos>> inventoryPositions = payload.inventoryPositions();
        Map<Identifier, List<Integer>> entities = payload.entities();
        HighlightHandler.handleHighlight(player, stackKey, inventoryPositions, entities);
    }
}

