/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;
import net.p3pp3rf1y.sophisticateditemactions.client.render.ItemFlightAnimator;

public record SyncItemTransfersPayload(Map<Vec3, List<ItemStack>> itemsTransferred, Vec3 playerPos, boolean fromPlayer) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncItemTransfersPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getIdentifier((String)"sync_item_transfers"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncItemTransfersPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodecHelper.ofMap((StreamCodec)StreamCodecHelper.VEC3, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), HashMap::new), SyncItemTransfersPayload::itemsTransferred, (StreamCodec)StreamCodecHelper.VEC3, SyncItemTransfersPayload::playerPos, (StreamCodec)ByteBufCodecs.BOOL, SyncItemTransfersPayload::fromPlayer, SyncItemTransfersPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(SyncItemTransfersPayload payload, IPayloadContext context) {
        payload.itemsTransferred().forEach((pos, stacks) -> {
            Player player = context.player();
            Vec3 from = payload.fromPlayer() ? payload.playerPos : pos;
            Vec3 to = payload.fromPlayer() ? pos : payload.playerPos;
            Level level = player.level();
            for (ItemStack stack : stacks) {
                ItemFlightAnimator.startFlight(stack, from, to, level.getGameTime(), payload.fromPlayer() ? 10 : 5, level.getRandom());
            }
            float pitch = payload.fromPlayer() ? RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f + 0.2f : RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 1.4f + 2.0f;
            level.playSound((Entity)player, to.x(), to.y(), to.z(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.3f, pitch);
        });
    }
}

