/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.HashedStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RemoteSlot;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.neoforged.neoforge.world.inventory.StackCopySlot;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerRegistry;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncAdditionalSlotInfoPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncEmptySlotIconsPayload;
import net.p3pp3rf1y.sophisticatedcore.network.SyncSlotChangeErrorPayload;
import net.p3pp3rf1y.sophisticatedcore.network.TransferItemsPayload;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.DummySlot;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public abstract class StorageContainerMenuBase<S extends IStorageWrapper>
extends AbstractContainerMenu
implements IAdditionalSlotInfoMenu {
    public static final int NUMBER_OF_PLAYER_SLOTS = 36;
    public static final Identifier EMPTY_UPGRADE_SLOT_BACKGROUND = Identifier.fromNamespaceAndPath((String)"sophisticatedcore", (String)"container/slot/upgrade");
    public static final Identifier INACCESSIBLE_SLOT_BACKGROUND = SophisticatedCore.getIdentifier("container/slot/inaccessible");
    protected static final String UPGRADE_ENABLED_TAG = "upgradeEnabled";
    protected static final String UPGRADE_SLOT_TAG = "upgradeSlot";
    protected static final String ACTION_TAG = "action";
    protected static final String OPEN_TAB_ID_TAG = "openTabId";
    protected static final String SORT_BY_TAG = "sortBy";
    private static final String SEARCH_PHRASE_TAG = "searchPhrase";
    private static final Method ON_SWAP_CRAFT = ObfuscationReflectionHelper.findMethod(Slot.class, (String)"onSwapCraft", (Class[])new Class[]{Integer.TYPE});
    public final NonNullList<ItemStack> lastUpgradeSlots = NonNullList.create();
    public final List<Slot> upgradeSlots = Lists.newArrayList();
    public final NonNullList<RemoteSlot> remoteUpgradeSlots = NonNullList.create();
    public final NonNullList<ItemStack> lastRealSlots = NonNullList.create();
    public final List<Slot> realInventorySlots = Lists.newArrayList();
    private final Map<Integer, UpgradeContainerBase<?, ?>> upgradeContainers = new LinkedHashMap();
    private final NonNullList<RemoteSlot> remoteRealSlots = NonNullList.create();
    protected final Player player;
    protected final S storageWrapper;
    protected final IStorageWrapper parentStorageWrapper;
    private final int storageItemSlotIndex;
    private final boolean shouldLockStorageItemSlot;
    private final List<Slot> extraSlots;
    private int storageItemSlotNumber = -1;
    private Consumer<StorageContainerMenuBase<?>> upgradeChangeListener = null;
    private boolean isUpdatingFromPacket = false;
    private long errorResultExpirationTime = 0L;
    private @Nullable UpgradeSlotChangeResult errorUpgradeSlotChangeResult;
    private ContainerContents.SettingsData lastSettingsData = null;
    private boolean inventorySlotStackChanged = false;
    private final Set<Integer> inaccessibleSlots = new HashSet<Integer>();
    private final Map<Integer, Integer> slotLimitOverrides = new HashMap<Integer, Integer>();
    private final Set<Integer> infiniteSlots = new HashSet<Integer>();
    private final Map<Integer, ItemStack> slotFilterItems = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Identifier> emptySlotIcons = new HashMap<Integer, Identifier>();
    private boolean slotsChangedSinceStartOfClick = false;
    private boolean tryingToMergeUpgrade = false;
    private boolean initialBroadcast = true;
    private int extraSlotsSize = 0;
    private int columnsChange = 0;
    private int inventorySlotsBeforeClickHandled;

    protected StorageContainerMenuBase(MenuType<?> menuType, int containerId, Player player, S storageWrapper, IStorageWrapper parentStorageWrapper, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        this(menuType, containerId, player, storageWrapper, parentStorageWrapper, storageItemSlotIndex, shouldLockStorageItemSlot, Collections.emptyList());
    }

    protected StorageContainerMenuBase(MenuType<?> menuType, int containerId, Player player, S storageWrapper, IStorageWrapper parentStorageWrapper, int storageItemSlotIndex, boolean shouldLockStorageItemSlot, List<Slot> extraSlots) {
        super(menuType, containerId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.parentStorageWrapper = parentStorageWrapper;
        this.storageItemSlotIndex = storageItemSlotIndex;
        this.shouldLockStorageItemSlot = shouldLockStorageItemSlot;
        this.extraSlots = extraSlots;
        this.removeOpenTabIfKeepOff();
        storageWrapper.fillWithLoot(player);
        this.initSlotsAndContainers(player, storageItemSlotIndex, shouldLockStorageItemSlot, extraSlots);
        this.inventorySlotsBeforeClickHandled = this.getInventorySlotsSize();
    }

    public abstract Optional<BlockPos> getBlockPosition();

    public abstract Optional<Entity> getEntity();

    protected void initSlotsAndContainers(Player player, int storageItemSlotIndex, boolean shouldLockStorageItemSlot, List<Slot> extraSlots) {
        this.addStorageInventorySlots();
        this.addPlayerInventorySlots(player.getInventory(), storageItemSlotIndex, shouldLockStorageItemSlot);
        this.addExtraSlots(extraSlots);
        this.addUpgradeSlots();
        this.addUpgradeSettingsContainers(player);
    }

    private void addExtraSlots(List<Slot> extraSlots) {
        extraSlots.forEach(this::addExtraSlot);
    }

    protected void addExtraSlot(Slot slot) {
        ++this.extraSlotsSize;
        this.addSlot(slot);
    }

    public List<Slot> getExtraSlots() {
        return this.extraSlots;
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    protected void addUpgradeSettingsContainers(Player player) {
        UpgradeHandler upgradeHandler = this.storageWrapper.getUpgradeHandler();
        upgradeHandler.getSlotWrappers().forEach((slot, wrapper) -> UpgradeContainerRegistry.instantiateContainer(player, slot, wrapper).ifPresent(container -> this.upgradeContainers.put((Integer)slot, (UpgradeContainerBase<?, ?>)container)));
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            container.getSlots().forEach(this::addUpgradeSlot);
            container.onInit();
        }
        this.storageWrapper.getOpenTabId().ifPresent(id -> {
            if (this.upgradeContainers.containsKey(id)) {
                this.upgradeContainers.get(id).setIsOpen(true);
            }
        });
    }

    private void addUpgradeSlots() {
        UpgradeHandler upgradeHandler = this.storageWrapper.getUpgradeHandler();
        int numberOfSlots = upgradeHandler.size();
        if (numberOfSlots == 0) {
            return;
        }
        for (int slotIndex = 0; slotIndex < upgradeHandler.size(); ++slotIndex) {
            this.addUpgradeSlot((Slot)new StorageUpgradeSlot(upgradeHandler, slotIndex));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    public Optional<UpgradeSlotChangeResult> getErrorUpgradeSlotChangeResult() {
        if (this.errorUpgradeSlotChangeResult != null && this.player.level().getGameTime() >= this.errorResultExpirationTime) {
            this.clearErrorUpgradeSlotChangeResult();
        }
        return Optional.ofNullable(this.errorUpgradeSlotChangeResult);
    }

    private void clearErrorUpgradeSlotChangeResult() {
        this.errorResultExpirationTime = 0L;
        this.errorUpgradeSlotChangeResult = null;
    }

    protected void sendStorageSettingsToClient() {
    }

    protected void addUpgradeSlot(Slot slot) {
        slot.index = this.getTotalSlotsNumber();
        this.upgradeSlots.add(slot);
        this.lastUpgradeSlots.add((Object)ItemStack.EMPTY);
        this.remoteUpgradeSlots.add((Object)(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER));
    }

    protected void addNoSortSlot(Slot slot) {
        slot.index = this.getInventorySlotsSize();
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.EMPTY);
        this.remoteRealSlots.add((Object)(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER));
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.getInventorySlotsSize();
        this.slots.add((Object)slot);
        this.lastSlots.add((Object)ItemStack.EMPTY);
        this.remoteSlots.add((Object)(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER));
        this.realInventorySlots.add(slot);
        this.lastRealSlots.add((Object)ItemStack.EMPTY);
        this.remoteRealSlots.add((Object)(this.synchronizer != null ? this.synchronizer.createSlot() : RemoteSlot.PLACEHOLDER));
        return slot;
    }

    public int getInventorySlotsSize() {
        return this.realInventorySlots.size();
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().size();
    }

    public int getNumberOfUpgradeSlots() {
        return this.storageWrapper.getUpgradeHandler().size();
    }

    public Map<Integer, UpgradeContainerBase<?, ?>> getUpgradeContainers() {
        return this.upgradeContainers;
    }

    protected void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        for (int slotIndex = 0; slotIndex < inventoryHandler.size(); ++slotIndex) {
            final int finalSlotIndex = slotIndex;
            StorageInventorySlot slot = new StorageInventorySlot((IStorageWrapper)this.storageWrapper, finalSlotIndex, this.player){

                public @Nullable Identifier getNoItemIcon() {
                    return StorageContainerMenuBase.this.inaccessibleSlots.contains(finalSlotIndex) ? INACCESSIBLE_SLOT_BACKGROUND : (Identifier)StorageContainerMenuBase.this.emptySlotIcons.getOrDefault(finalSlotIndex, null);
                }

                @Override
                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return !StorageContainerMenuBase.this.inaccessibleSlots.contains(finalSlotIndex) && super.mayPlace(stack);
                }

                @Override
                public boolean mayPickup(Player playerIn) {
                    return !StorageContainerMenuBase.this.inaccessibleSlots.contains(finalSlotIndex) && super.mayPickup(playerIn);
                }

                @Override
                public int getMaxStackSize(ItemStack stack) {
                    return StorageContainerMenuBase.this.slotLimitOverrides.containsKey(finalSlotIndex) ? StorageContainerMenuBase.this.slotLimitOverrides.get(finalSlotIndex).intValue() : super.getMaxStackSize(stack);
                }

                @Override
                public int getMaxStackSize() {
                    return StorageContainerMenuBase.this.slotLimitOverrides.containsKey(finalSlotIndex) ? StorageContainerMenuBase.this.slotLimitOverrides.get(finalSlotIndex).intValue() : super.getMaxStackSize();
                }

                @Override
                public void set(ItemStack stack) {
                    super.set(stack);
                    StorageContainerMenuBase.this.onStorageInventorySlotSet(finalSlotIndex);
                }
            };
            if (noSortSlotIndexes.contains(slotIndex)) {
                this.addNoSortSlot(slot);
                continue;
            }
            this.addSlot(slot);
        }
    }

    protected void onStorageInventorySlotSet(int slotIndex) {
    }

    protected void addPlayerInventorySlots(Inventory playerInventory, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9 + 9;
                Slot slot = this.addStorageItemSafeSlot(playerInventory, slotIndex, storageItemSlotIndex, shouldLockStorageItemSlot);
                this.addSlotAndUpdateStorageItemSlotNumber(storageItemSlotIndex, shouldLockStorageItemSlot, slotIndex, slot);
            }
        }
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            Slot slot = this.addStorageItemSafeSlot(playerInventory, slotIndex, storageItemSlotIndex, shouldLockStorageItemSlot);
            this.addSlotAndUpdateStorageItemSlotNumber(storageItemSlotIndex, shouldLockStorageItemSlot, slotIndex, slot);
        }
    }

    private Slot addStorageItemSafeSlot(Inventory playerInventory, int slotIndex, int storageItemSlotIndex, boolean shouldLockStorageItemSlot) {
        Slot slot = shouldLockStorageItemSlot && slotIndex == storageItemSlotIndex ? new Slot(this, (Container)playerInventory, slotIndex, 0, 0){

            public boolean mayPickup(Player playerIn) {
                return false;
            }
        } : new Slot((Container)playerInventory, slotIndex, 0, 0);
        return this.addSlot(slot);
    }

    public boolean hasSomethingMessedWithStorage() {
        return !this.isClientSide() && (this.storageItemHasChanged() || this.realInventorySlots.size() != this.storageWrapper.getInventoryHandler().size() + 36 + this.extraSlotsSize);
    }

    protected boolean isClientSide() {
        return this.player.level().isClientSide();
    }

    private void addSlotAndUpdateStorageItemSlotNumber(int storageItemSlotIndex, boolean lockStorageItemSlot, int slotIndex, Slot slot) {
        if (lockStorageItemSlot && slotIndex == storageItemSlotIndex) {
            this.storageItemSlotNumber = slot.index;
        }
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    public int getFirstUpgradeSlot() {
        return this.getInventorySlotsSize();
    }

    public boolean isFirstLevelStorage() {
        return this.parentStorageWrapper == NoopStorageWrapper.INSTANCE;
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
        this.storageWrapper.setPersistent(this.player.level().isClientSide());
        this.isUpdatingFromPacket = true;
        super.initializeContents(stateId, items, carried);
        this.isUpdatingFromPacket = false;
        this.storageWrapper.setPersistent(true);
        this.storageWrapper.getInventoryHandler().saveInventory();
        this.storageWrapper.getUpgradeHandler().saveInventory();
    }

    protected boolean isUpgradeSettingsSlot(int index) {
        return index >= this.getNumberOfStorageInventorySlots() + this.getNumberOfUpgradeSlots() + 36 && index < this.getTotalSlotsNumber();
    }

    public boolean isStorageInventorySlot(int slotIndex) {
        return slotIndex >= 0 && slotIndex < this.getNumberOfStorageInventorySlots();
    }

    public boolean isStorageInventorySlot(Slot slot) {
        return slot instanceof StorageInventorySlot && this.isStorageInventorySlot(slot.index);
    }

    protected boolean isUpgradeSlot(int index) {
        return index >= this.getFirstUpgradeSlot() && index - this.getFirstUpgradeSlot() < this.getNumberOfUpgradeSlots();
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        Slot slot2;
        this.inventorySlotsBeforeClickHandled = this.getInventorySlotsSize();
        if (this.isUpgradeSettingsSlot(slotId) && this.getSlot(slotId) instanceof IFilterSlot && this.getSlot(slotId).mayPlace(this.getCarried())) {
            if (!player.level().isClientSide()) {
                Slot slot2 = this.getSlot(slotId);
                ItemStack cursorStack = this.getCarried().copy();
                if (cursorStack.getCount() > 1) {
                    cursorStack.setCount(1);
                }
                slot2.set(cursorStack);
            }
            return;
        }
        if (this.isUpgradeSlot(slotId) && (slot2 = this.getSlot(slotId)) instanceof StorageUpgradeSlot) {
            StorageUpgradeSlot slot3 = (StorageUpgradeSlot)slot2;
            ItemStack slotStack = slot3.getItem();
            if (slot3.mayPlace(this.getCarried())) {
                ItemStack carriedStack = this.getCarried();
                IUpgradeItem upgradeItem = (IUpgradeItem)carriedStack.getItem();
                int newColumnsTaken = upgradeItem.getInventoryColumnsTaken();
                int currentColumnsTaken = 0;
                if (!slotStack.isEmpty()) {
                    currentColumnsTaken = ((IUpgradeItem)slotStack.getItem()).getInventoryColumnsTaken();
                }
                if (this.needsSlotsThatAreOccupied(carriedStack, currentColumnsTaken, newColumnsTaken)) {
                    return;
                }
                int columnsToRemove = newColumnsTaken - currentColumnsTaken;
                if (slotStack.isEmpty()) {
                    slot3.set(carriedStack.split(1));
                    if (carriedStack.isEmpty()) {
                        this.setCarried(ItemStack.EMPTY);
                    }
                } else if (carriedStack.getCount() == 1) {
                    slot3.set(carriedStack);
                    this.setCarried(upgradeItem.getCleanedUpgradeStack(slotStack.copy()));
                }
                this.updateColumnsTaken(columnsToRemove);
                slot3.setChanged();
                if (columnsToRemove != 0 && player.level().isClientSide()) {
                    this.onUpgradesChanged();
                }
            } else if (this.getCarried().isEmpty() && !slotStack.isEmpty() && slot3.mayPickup(player)) {
                int k2 = dragType == 0 ? Math.min(slotStack.getCount(), slotStack.getMaxStackSize()) : Math.min(slotStack.getMaxStackSize() + 1, slotStack.getCount() + 1) / 2;
                IUpgradeItem upgradeItem = (IUpgradeItem)slotStack.getItem();
                int columnsTaken = upgradeItem.getInventoryColumnsTaken();
                if (clickType == ClickType.QUICK_MOVE) {
                    this.quickMoveStack(player, slotId);
                } else {
                    this.setCarried(upgradeItem.getCleanedUpgradeStack(slot3.remove(k2)));
                }
                this.updateColumnsTaken(-columnsTaken);
                slot3.onTake(player, this.getCarried());
            }
            return;
        }
        if (this.isOverflowLogicSlotAndAction(slotId, clickType) && this.handleOverflow(slotId, clickType, dragType, player)) {
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean isValidSlotIndex(int slotIndex) {
        return slotIndex == -1 || slotIndex == -999 || slotIndex < this.getTotalSlotsNumber();
    }

    private boolean handleOverflow(int slotId, ClickType clickType, int dragType, Player player) {
        ItemStack cursorStack = clickType == ClickType.SWAP ? player.getInventory().getItem(dragType) : this.getCarried();
        Consumer<ItemStack> updateCursorStack = clickType == ClickType.SWAP ? s -> player.getInventory().setItem(dragType, s) : arg_0 -> ((StorageContainerMenuBase)this).setCarried(arg_0);
        Slot slot = this.getSlot(slotId);
        if (clickType != ClickType.SWAP && cursorStack.isEmpty() || !slot.mayPlace(cursorStack)) {
            return false;
        }
        ItemStack slotStack = slot.getItem();
        if (slotStack.isEmpty() || slot.mayPickup(player) && slotStack.getItem() != cursorStack.getItem() && cursorStack.getCount() <= slot.getMaxStackSize(cursorStack) && slotStack.getCount() <= slotStack.getMaxStackSize()) {
            return this.processOverflowIfSlotWithSameItemFound(slotId, cursorStack, updateCursorStack);
        }
        if (slotStack.getItem() == cursorStack.getItem()) {
            return this.processOverflowForAnythingOverSlotMaxSize(cursorStack, updateCursorStack, slot, slotStack);
        }
        return false;
    }

    private boolean processOverflowForAnythingOverSlotMaxSize(ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, Slot slot, ItemStack slotStack) {
        int remainingSpaceInSlot = slot.getMaxStackSize(cursorStack) - slotStack.getCount();
        if (remainingSpaceInSlot < cursorStack.getCount()) {
            ItemStack overflow = cursorStack.copy();
            int overflowCount = cursorStack.getCount() - remainingSpaceInSlot;
            overflow.setCount(overflowCount);
            ItemStack result = this.processOverflowLogic(overflow);
            if (result.getCount() < overflowCount) {
                cursorStack.shrink(overflowCount - result.getCount());
                if (cursorStack.isEmpty()) {
                    updateCursorStack.accept(ItemStack.EMPTY);
                    return true;
                }
                updateCursorStack.accept(cursorStack);
            }
        }
        return false;
    }

    private boolean processOverflowIfSlotWithSameItemFound(int slotId, ItemStack cursorStack, Consumer<ItemStack> updateCursorStack) {
        for (IOverflowResponseUpgrade overflowUpgrade : this.storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IOverflowResponseUpgrade.class)) {
            if (!overflowUpgrade.stackMatchesFilter(cursorStack) || !overflowUpgrade.worksInGui() || !this.findSlotWithMatchingStack(slotId, cursorStack, updateCursorStack, overflowUpgrade)) continue;
            return true;
        }
        return false;
    }

    private boolean findSlotWithMatchingStack(int slotId, ItemStack cursorStack, Consumer<ItemStack> updateCursorStack, IOverflowResponseUpgrade overflowUpgrade) {
        for (int slotIndex = 0; slotIndex < this.getNumberOfStorageInventorySlots(); ++slotIndex) {
            ItemStack slotStack = this.getSlot(slotIndex).getItem();
            if (slotIndex == slotId || !overflowUpgrade.matchesFilter(slotStack.getItem(), slotStack.getDamageValue(), slotStack.isEmpty(), slotStack.getComponents(), cursorStack.getItem(), cursorStack.getDamageValue(), cursorStack.isEmpty(), cursorStack.getComponents())) continue;
            ItemStack result = cursorStack;
            result = overflowUpgrade.onOverflow(result);
            updateCursorStack.accept(result);
            if (!result.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isOverflowLogicSlotAndAction(int slotId, ClickType clickType) {
        return this.isStorageInventorySlot(slotId) && (clickType == ClickType.SWAP || clickType == ClickType.PICKUP);
    }

    protected void updateColumnsTaken(int columnsChange) {
        if (this.player.level().isClientSide()) {
            this.columnsChange = columnsChange;
        } else {
            this.actuallyUpdateColumnsTaken(columnsChange);
        }
    }

    private void actuallyUpdateColumnsTaken(int columnsChange) {
        if (columnsChange != 0) {
            AtomicInteger columnsTaken = new AtomicInteger(0);
            InventoryHelper.iterate((ResourceHandler<ItemResource>)this.storageWrapper.getUpgradeHandler(), (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> {
                Item patt0$temp = resource.getItem();
                if (patt0$temp instanceof UpgradeItemBase) {
                    UpgradeItemBase upgradeItem = (UpgradeItemBase)patt0$temp;
                    columnsTaken.addAndGet(upgradeItem.getInventoryColumnsTaken());
                }
            }));
            this.storageWrapper.setColumnsTaken(columnsTaken.get(), true);
            this.storageWrapper.onContentsUpdated();
            this.refreshAllSlots();
        }
    }

    protected boolean needsSlotsThatAreOccupied(ItemStack cursorStack, int currentColumnsTaken, int newColumnsTaken) {
        if (currentColumnsTaken >= newColumnsTaken) {
            return false;
        }
        int slotsToCheck = (newColumnsTaken - currentColumnsTaken) * this.getNumberOfRows();
        InventoryHandler invHandler = this.storageWrapper.getInventoryHandler();
        HashSet<Integer> errorSlots = new HashSet<Integer>();
        int slots = this.getNumberOfStorageInventorySlots();
        for (int slotIndex = slots - 1; slotIndex >= slots - slotsToCheck; --slotIndex) {
            if (invHandler.getResource(slotIndex).isEmpty()) continue;
            errorSlots.add(slotIndex);
        }
        if (!errorSlots.isEmpty()) {
            this.updateSlotChangeError(UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("add.needs_occupied_inventory_slots", slotsToCheck, cursorStack.getHoverName()), Collections.emptySet(), errorSlots, Collections.emptySet()));
            return true;
        }
        return false;
    }

    public int getUpgradeSlotsSize() {
        return this.upgradeSlots.size();
    }

    public List<Integer> getSlotOverlayColors(int slot) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.storageWrapper.getSettingsHandler().getCategoriesThatImplement(ISlotColorCategory.class).forEach(c -> c.getSlotColor(slot).ifPresent(ret::add));
        return ret;
    }

    public Optional<UpgradeContainerBase<?, ?>> getOpenContainer() {
        return this.storageWrapper.getOpenTabId().flatMap(id -> this.upgradeContainers.containsKey(id) ? Optional.of(this.upgradeContainers.get(id)) : Optional.empty());
    }

    protected void sendToServer(Consumer<CompoundTag> addData) {
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncContainerClientDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setUpgradeEnabled(int upgradeSlot, boolean enabled) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return;
        }
        if (this.isClientSide()) {
            this.sendToServer(data -> {
                data.putBoolean(UPGRADE_ENABLED_TAG, enabled);
                data.putInt(UPGRADE_SLOT_TAG, upgradeSlot);
            });
        }
        slotWrappers.get(upgradeSlot).setEnabled(enabled);
    }

    public boolean getUpgradeEnabled(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).isEnabled();
    }

    public boolean isUpgradeRunnable(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        IUpgradeWrapper upgradeWrapper = slotWrappers.get(upgradeSlot);
        return !(upgradeWrapper instanceof ITickableUpgrade) || this.storageWrapper.isUpgradeRunnable(upgradeWrapper.getUpgradeStack());
    }

    public boolean canDisableUpgrade(int upgradeSlot) {
        Map<Integer, IUpgradeWrapper> slotWrappers = this.storageWrapper.getUpgradeHandler().getSlotWrappers();
        if (!slotWrappers.containsKey(upgradeSlot)) {
            return false;
        }
        return slotWrappers.get(upgradeSlot).canBeDisabled();
    }

    public void sort() {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString(ACTION_TAG, "sort"));
            return;
        }
        this.storageWrapper.sort();
    }

    public void setOpenTabId(int tabId) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putInt(OPEN_TAB_ID_TAG, tabId));
        }
        if (tabId == -1) {
            this.storageWrapper.removeOpenTabId();
        } else {
            this.storageWrapper.setOpenTabId(tabId);
        }
    }

    public void removeOpenTabId() {
        this.setOpenTabId(-1);
    }

    public SortBy getSortBy() {
        return this.storageWrapper.getSortBy();
    }

    public void setSortBy(SortBy sortBy) {
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString(SORT_BY_TAG, sortBy.getSerializedName()));
        }
        this.storageWrapper.setSortBy(sortBy);
    }

    public void handlePacket(CompoundTag data) {
        data.getInt("containerId").ifPresent(containerId -> {
            if (this.upgradeContainers.containsKey(containerId)) {
                this.upgradeContainers.get(containerId).handlePacket(data);
            }
        });
        data.getInt(OPEN_TAB_ID_TAG).ifPresent(this::setOpenTabId);
        data.getString(SORT_BY_TAG).ifPresent(sortByName -> this.setSortBy(SortBy.fromName(sortByName)));
        data.getString(SEARCH_PHRASE_TAG).ifPresent(this::setSearchPhrase);
        data.getString(ACTION_TAG).ifPresent(actionName -> {
            switch (actionName) {
                case "sort": {
                    this.sort();
                    break;
                }
                case "openSettings": {
                    this.openSettings();
                    break;
                }
            }
        });
        data.getBoolean(UPGRADE_ENABLED_TAG).ifPresent(enabled -> data.getInt(UPGRADE_SLOT_TAG).ifPresent(upgradeSlot -> this.setUpgradeEnabled((int)upgradeSlot, (boolean)enabled)));
    }

    public Optional<UpgradeContainerBase<?, ?>> getSlotUpgradeContainer(Slot slot) {
        if (this.isUpgradeSettingsSlot(slot.index)) {
            for (UpgradeContainerBase<?, ?> upgradeContainer : this.upgradeContainers.values()) {
                if (!upgradeContainer.containsSlot(slot)) continue;
                return Optional.of(upgradeContainer);
            }
        }
        return Optional.empty();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = this.getSlot(index);
        if (slot.hasItem()) {
            ItemStack stackToMerge;
            Item item;
            Optional<UpgradeContainerBase<?, ?>> upgradeContainer = this.getSlotUpgradeContainer(slot);
            ItemStack slotStack = upgradeContainer.map(c -> c.getSlotStackToTransfer(slot)).orElse(slot.getItem());
            itemstack = slotStack.copy();
            if (this.isUpgradeSlot(index) && (item = slotStack.getItem()) instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)item;
                v0 = upgradeItem.getCleanedUpgradeStack(slotStack.copy());
            } else {
                v0 = stackToMerge = slotStack;
            }
            if (!this.mergeSlotStack(slot, index, stackToMerge)) {
                return ItemStack.EMPTY;
            }
            if (stackToMerge.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            slot.onQuickCraft(slotStack, itemstack);
            if (upgradeContainer.isPresent()) {
                upgradeContainer.ifPresent(c -> c.onTakeFromSlot(slot, player, slotStack));
            } else {
                slot.onTake(player, slotStack);
            }
        }
        return itemstack;
    }

    private boolean mergeSlotStack(Slot slot, int index, ItemStack slotStack) {
        if (this.isUpgradeSlot(index)) {
            return this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToExtraSlots(slot, slotStack) || this.mergeStackToStorage(slot, slotStack);
        }
        if (this.isStorageInventorySlot(index)) {
            if (this.shouldShiftClickIntoOpenTabFirst()) {
                return this.mergeStackToOpenUpgradeTab(slot, slotStack) || this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToExtraSlots(slot, slotStack);
            }
            return this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToExtraSlots(slot, slotStack) || this.mergeStackToOpenUpgradeTab(slot, slotStack);
        }
        if (this.isUpgradeSettingsSlot(index)) {
            if (this.getSlotUpgradeContainer(slot).map(c -> c.mergeIntoStorageFirst(slot)).orElse(true).booleanValue()) {
                return this.mergeStackToStorage(slot, slotStack) || this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToExtraSlots(slot, slotStack);
            }
            return this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToExtraSlots(slot, slotStack) || this.mergeStackToStorage(slot, slotStack);
        }
        if (this.isExtraSlot(index)) {
            return this.mergeStackToPlayersInventory(slot, slotStack) || this.mergeStackToStorage(slot, slotStack) || this.mergeStackToOpenUpgradeTab(slot, slotStack);
        }
        if (this.shouldShiftClickIntoOpenTabFirst()) {
            return this.mergeStackToExtraSlots(slot, slotStack) || this.mergeStackToOpenUpgradeTab(slot, slotStack) || this.mergeStackToUpgradeSlots(slot, slotStack) || this.mergeStackToStorage(slot, slotStack);
        }
        return this.mergeStackToExtraSlots(slot, slotStack) || this.mergeStackToUpgradeSlots(slot, slotStack) || this.mergeStackToStorage(slot, slotStack) || this.mergeStackToOpenUpgradeTab(slot, slotStack);
    }

    private boolean isExtraSlot(int slotIndex) {
        return slotIndex >= this.getInventorySlotsSize() - this.extraSlotsSize && slotIndex < this.getInventorySlotsSize();
    }

    private boolean shouldShiftClickIntoOpenTabFirst() {
        return this.storageWrapper.getSettingsHandler().getMainSettingValue(this.player, MainSettingsCategoryData::shiftClickIntoOpenTab);
    }

    public boolean shouldKeepSearchPhrase() {
        return this.storageWrapper.getSettingsHandler().getMainSettingValue(this.player, MainSettingsCategoryData::keepSearchPhrase);
    }

    public String getSearchPhrase() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        boolean keepSearchPhrase = settingsHandler.getMainSettingValue(this.player, MainSettingsCategoryData::keepSearchPhrase);
        return keepSearchPhrase ? settingsHandler.getSettingsData().searchPhrase() : "";
    }

    public void setSearchPhrase(String searchPhrase) {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        if (!settingsHandler.getMainSettingValue(this.player, MainSettingsCategoryData::keepSearchPhrase).booleanValue()) {
            return;
        }
        settingsHandler.setSearchPhrase(searchPhrase);
        if (this.isClientSide()) {
            this.sendToServer(data -> data.putString(SEARCH_PHRASE_TAG, searchPhrase));
        }
    }

    private boolean mergeStackToUpgradeSlots(Slot sourceSlot, ItemStack slotStack) {
        if (!(slotStack.getItem() instanceof IUpgradeItem)) {
            return false;
        }
        this.clearErrorUpgradeSlotChangeResult();
        this.tryingToMergeUpgrade = true;
        boolean result = !this.upgradeSlots.isEmpty() && this.moveItemStackTo(sourceSlot, slotStack, this.getInventorySlotsSize(), this.getInventorySlotsSize() + this.getNumberOfUpgradeSlots(), false);
        this.tryingToMergeUpgrade = false;
        this.showUpgradeSlotChangeError();
        return result;
    }

    private boolean mergeStackToOpenUpgradeTab(Slot sourceSlot, ItemStack slotStack) {
        return this.getOpenContainer().map(c -> {
            List<Slot> slots = c.getSlots();
            if (slots.isEmpty()) {
                return false;
            }
            int firstSlotIndex = slots.getFirst().index;
            int lastSlotIndex = slots.getLast().index;
            return this.mergeItemStack(sourceSlot, slotStack, firstSlotIndex, lastSlotIndex + 1, false, true);
        }).orElse(false);
    }

    private boolean mergeStackToStorage(Slot slot, ItemStack slotStack) {
        ItemStack remaining = this.mergeItemStack(slotStack, 0, this.getNumberOfStorageInventorySlots(), false, false, true);
        if (remaining.getCount() != slotStack.getCount()) {
            slot.set(remaining);
            return true;
        }
        return false;
    }

    private boolean mergeStackToExtraSlots(Slot sourceSlot, ItemStack slotStack) {
        return this.mergeItemStack(sourceSlot, slotStack, this.getInventorySlotsSize() - this.extraSlotsSize, this.getInventorySlotsSize(), true, true);
    }

    private boolean mergeStackToPlayersInventory(Slot sourceSlot, ItemStack slotStack) {
        return this.mergeItemStack(sourceSlot, slotStack, this.getNumberOfStorageInventorySlots(), this.getInventorySlotsSize() - this.extraSlotsSize, true, true);
    }

    public boolean isNotPlayersInventorySlot(int slotNumber) {
        return slotNumber < this.getNumberOfStorageInventorySlots() || slotNumber >= this.getInventorySlotsSize();
    }

    public Optional<ItemStack> getMemorizedStackInSlot(int slotId) {
        return this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getSlotFilterStack(slotId, false);
    }

    public void setUpgradeChangeListener(Consumer<StorageContainerMenuBase<?>> upgradeChangeListener) {
        this.upgradeChangeListener = upgradeChangeListener;
    }

    public abstract void openSettings();

    protected abstract boolean storageItemHasChanged();

    public <T extends UpgradeContainerBase<?, ?>> Optional<T> getOpenOrFirstCraftingContainer(RecipeType<?> recipeType) {
        UpgradeContainerBase<?, ?> firstContainer = null;
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            ICraftingContainer craftingContainer;
            if (!(container instanceof ICraftingContainer) || (craftingContainer = (ICraftingContainer)((Object)container)).getRecipeType() != recipeType) continue;
            if (container.isOpen()) {
                return Optional.of(container);
            }
            if (firstContainer != null) continue;
            firstContainer = container;
        }
        return Optional.ofNullable(firstContainer);
    }

    public int getTotalSlotsNumber() {
        return this.getInventorySlotsSize() + this.upgradeSlots.size();
    }

    protected void removeOpenTabIfKeepOff() {
        if (!this.storageWrapper.getSettingsHandler().getMainSettingValue(this.player, MainSettingsCategoryData::keepTabOpen).booleanValue()) {
            this.storageWrapper.removeOpenTabId();
        }
    }

    protected Set<Integer> getNoSortSlotIndexes() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        HashSet<Integer> slotIndexesExcludedFromSort = new HashSet<Integer>();
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(NoSortSettingsCategory.class).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(settingsHandler.getTypeCategory(MemorySettingsCategory.class).getSlotIndexes());
        return slotIndexesExcludedFromSort;
    }

    public void broadcastFullState() {
        this.broadcastFullStateOf(this.lastUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastFullStateOf(this.lastRealSlots, this.realInventorySlots, 0);
        this.sendAllDataToRemote();
    }

    private void broadcastFullStateOf(NonNullList<ItemStack> lastSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            Slot slot = slotsCollection.get(i);
            ItemStack itemstack = slot.getItem();
            this.triggerSlotListeners(i, itemstack, () -> ((ItemStack)itemstack).copy(), lastSlotsCollection, slotIndexOffset, slot);
        }
    }

    protected void triggerSlotListeners(int stackIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<ItemStack> lastSlotsCollection, int slotIndexOffset, Slot slot) {
        ItemStack itemstack = (ItemStack)lastSlotsCollection.get(stackIndex);
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            lastSlotsCollection.set(stackIndex, (Object)stackCopy);
            for (ContainerListener containerlistener : this.containerListeners) {
                containerlistener.slotChanged((AbstractContainerMenu)this, stackIndex + slotIndexOffset, stackCopy);
            }
            if (!this.initialBroadcast && this.isUpgradeSettingsSlot(slot.index)) {
                slot.setChanged();
            }
        }
    }

    public void sendAllDataToRemote() {
        ItemStack stack;
        int i;
        NonNullList allRemoteStacks = NonNullList.create();
        for (i = 0; i < this.getInventorySlotsSize(); ++i) {
            stack = this.realInventorySlots.get(i).getItem();
            allRemoteStacks.add(stack.copy());
            ((RemoteSlot)this.remoteRealSlots.get(i)).force(stack);
        }
        for (i = 0; i < this.upgradeSlots.size(); ++i) {
            stack = this.upgradeSlots.get(i).getItem();
            allRemoteStacks.add(stack.copy());
            ((RemoteSlot)this.remoteUpgradeSlots.get(i)).force(stack);
        }
        ItemStack carried = this.getCarried();
        this.remoteCarried.force(carried);
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData((AbstractContainerMenu)this, (List)allRemoteStacks, carried, new int[0]);
        }
        this.sendEmptySlotIcons();
        this.sendAdditionalSlotInfo();
    }

    public boolean isInfiniteSlot(int slot) {
        return this.infiniteSlots.contains(slot);
    }

    private void sendEmptySlotIcons() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashMap<Identifier, Set<Integer>> noItemSlotTextures = new HashMap<Identifier, Set<Integer>>();
        for (int slot = 0; slot < this.storageWrapper.getInventoryHandler().size(); ++slot) {
            Identifier noItemIcon = this.storageWrapper.getInventoryHandler().getNoItemIcon(slot);
            if (noItemIcon == null) continue;
            noItemSlotTextures.computeIfAbsent(noItemIcon, rl -> new HashSet()).add(slot);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncEmptySlotIconsPayload(noItemSlotTextures), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendAdditionalSlotInfo() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashSet<Integer> inaccessibleSlots = new HashSet<Integer>();
        HashMap<Integer, Integer> slotLimitOverrides = new HashMap<Integer, Integer>();
        HashSet<Integer> infiniteSlots = new HashSet<Integer>();
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        HashMap<Integer, Holder<Item>> slotFilterItems = new HashMap<Integer, Holder<Item>>();
        for (int slot = 0; slot < inventoryHandler.size(); ++slot) {
            ItemResource itemResource;
            int stackLimit;
            if (!inventoryHandler.isSlotAccessible(slot)) {
                inaccessibleSlots.add(slot);
            }
            if (inventoryHandler.isInfinite(slot)) {
                infiniteSlots.add(slot);
            }
            if ((stackLimit = inventoryHandler.getCapacityAsInt(slot, (Resource)(itemResource = inventoryHandler.getResource(slot)))) != inventoryHandler.getBaseCapacity(itemResource)) {
                slotLimitOverrides.put(slot, stackLimit);
            }
            if (inventoryHandler.getFilterItem(slot) == Items.AIR) continue;
            slotFilterItems.put(slot, (Holder<Item>)inventoryHandler.getFilterItem(slot).builtInRegistryHolder());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncAdditionalSlotInfoPayload(inaccessibleSlots, slotLimitOverrides, infiniteSlots, slotFilterItems), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setRemoteSlot(int slotIndex, ItemStack stack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            ((RemoteSlot)this.remoteRealSlots.get(slotIndex)).force(stack);
        } else {
            ((RemoteSlot)this.remoteUpgradeSlots.get(slotIndex)).force(stack.copy());
        }
    }

    public void setRemoteSlotUnsafe(int slotIndex, HashedStack hashedStack) {
        if (slotIndex < this.getInventorySlotsSize()) {
            ((RemoteSlot)this.remoteRealSlots.get(slotIndex)).receive(hashedStack);
            if (this.isStorageInventorySlot(slotIndex)) {
                this.inventorySlotStackChanged = true;
            }
        } else {
            ((RemoteSlot)this.remoteUpgradeSlots.get(slotIndex - this.inventorySlotsBeforeClickHandled)).receive(hashedStack);
        }
    }

    public OptionalInt findSlot(Container container, int slotIdx) {
        for (int i = 0; i < this.getTotalSlotsNumber(); ++i) {
            Slot slot = this.getSlot(i);
            if (slot.container != container || slotIdx != slot.getContainerSlot()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void refreshAllSlots() {
        this.slots.clear();
        this.lastSlots.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        this.upgradeSlots.clear();
        this.lastUpgradeSlots.clear();
        this.remoteUpgradeSlots.clear();
        this.upgradeContainers.clear();
        this.initSlotsAndContainers(this.player, this.storageItemSlotIndex, this.shouldLockStorageItemSlot, this.extraSlots);
        this.slotsChangedSinceStartOfClick = true;
    }

    protected ItemStack processOverflowLogic(ItemStack stack) {
        IOverflowResponseUpgrade overflowUpgrade;
        ItemStack result = stack;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IOverflowResponseUpgrade.class).iterator();
        while (!(!iterator.hasNext() || (overflowUpgrade = iterator.next()).worksInGui() && (result = overflowUpgrade.onOverflow(result)).isEmpty())) {
        }
        return result;
    }

    private void onSwapCraft(Slot slot, int numItemsCrafted) {
        try {
            ON_SWAP_CRAFT.invoke((Object)slot, numItemsCrafted);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            SophisticatedCore.LOGGER.error("Error invoking onSwapCraft method in Slot class", (Throwable)e);
        }
    }

    public static int getQuickCraftPlaceCount(Slot slot, int quickCraftSlotsSize, int quickCraftingType, ItemStack carriedStack) {
        return Math.min(slot.getMaxStackSize(carriedStack), switch (quickCraftingType) {
            case 0 -> Mth.floor((float)((float)carriedStack.getCount() / (float)quickCraftSlotsSize));
            case 1 -> 1;
            case 2 -> carriedStack.getMaxStackSize();
            default -> carriedStack.getCount();
        });
    }

    protected void doClick(int slotId, int dragType, ClickType clickType, Player player) {
        block51: {
            block62: {
                block58: {
                    ItemStack slotStack;
                    ItemStack itemstack4;
                    Slot slot2;
                    Inventory inventory;
                    block61: {
                        block60: {
                            block59: {
                                block56: {
                                    ClickAction clickaction;
                                    block57: {
                                        block55: {
                                            block49: {
                                                block54: {
                                                    ItemStack itemstack;
                                                    block53: {
                                                        block52: {
                                                            block50: {
                                                                if (slotId >= this.getTotalSlotsNumber()) {
                                                                    return;
                                                                }
                                                                this.slotsChangedSinceStartOfClick = false;
                                                                inventory = player.getInventory();
                                                                if (clickType != ClickType.QUICK_CRAFT) break block49;
                                                                int i = this.quickcraftStatus;
                                                                this.quickcraftStatus = StorageContainerMenuBase.getQuickcraftHeader((int)dragType);
                                                                if (i == 1 && this.quickcraftStatus == 2 || i == this.quickcraftStatus) break block50;
                                                                this.resetQuickCraft();
                                                                break block51;
                                                            }
                                                            if (!this.getCarried().isEmpty()) break block52;
                                                            this.resetQuickCraft();
                                                            break block51;
                                                        }
                                                        if (this.quickcraftStatus != 0) break block53;
                                                        this.quickcraftType = StorageContainerMenuBase.getQuickcraftType((int)dragType);
                                                        if (StorageContainerMenuBase.isValidQuickcraftType((int)this.quickcraftType, (Player)player)) {
                                                            this.quickcraftStatus = 1;
                                                            this.quickcraftSlots.clear();
                                                        } else {
                                                            this.resetQuickCraft();
                                                        }
                                                        break block51;
                                                    }
                                                    if (this.quickcraftStatus != 1) break block54;
                                                    Slot slot = this.getSlot(slotId);
                                                    if (!StorageContainerMenuBase.canItemQuickReplace(slot, itemstack = this.getCarried()) || !slot.mayPlace(itemstack) || this.quickcraftType != 2 && itemstack.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot)) break block51;
                                                    this.quickcraftSlots.add(slot);
                                                    break block51;
                                                }
                                                if (this.quickcraftStatus == 2) {
                                                    if (!this.quickcraftSlots.isEmpty()) {
                                                        if (this.quickcraftSlots.size() == 1) {
                                                            int l = ((Slot)this.quickcraftSlots.iterator().next()).index;
                                                            this.resetQuickCraft();
                                                            this.clicked(l, this.quickcraftType, ClickType.PICKUP, player);
                                                            return;
                                                        }
                                                        ItemStack carried = this.getCarried().copy();
                                                        int j1 = this.getCarried().getCount();
                                                        for (Slot slot1 : this.quickcraftSlots) {
                                                            ItemStack itemstack1 = this.getCarried();
                                                            if (slot1 == null || !StorageContainerMenuBase.canItemQuickReplace(slot1, itemstack1) || !slot1.mayPlace(itemstack1) || this.quickcraftType != 2 && itemstack1.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                            ItemStack carriedCopy = carried.copy();
                                                            int j = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                            int slotStackLimit = slot1.getMaxStackSize(carriedCopy);
                                                            if (!(slot1 instanceof StorageInventorySlot) && slotStackLimit > carriedCopy.getMaxStackSize()) {
                                                                slotStackLimit = carriedCopy.getMaxStackSize();
                                                            }
                                                            int l = Math.min(MathHelper.intMaxCappedAddition(StorageContainerMenuBase.getQuickCraftPlaceCount(slot1, this.quickcraftSlots.size(), this.quickcraftType, carriedCopy), j), slotStackLimit);
                                                            j1 -= l - j;
                                                            slot1.setByPlayer(carriedCopy.copyWithCount(l));
                                                        }
                                                        carried.setCount(j1);
                                                        this.setCarried(carried);
                                                    }
                                                    this.resetQuickCraft();
                                                } else {
                                                    this.resetQuickCraft();
                                                }
                                                break block51;
                                            }
                                            if (this.quickcraftStatus == 0) break block55;
                                            this.resetQuickCraft();
                                            break block51;
                                        }
                                        if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE || dragType != 0 && dragType != 1) break block56;
                                        ClickAction clickAction = clickaction = dragType == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                        if (slotId != -999) break block57;
                                        if (this.getCarried().isEmpty()) break block51;
                                        if (clickaction == ClickAction.PRIMARY) {
                                            player.drop(this.getCarried(), true);
                                            this.setCarried(ItemStack.EMPTY);
                                        } else {
                                            player.drop(this.getCarried().split(1), true);
                                        }
                                        break block51;
                                    }
                                    if (clickType == ClickType.QUICK_MOVE) {
                                        if (slotId < 0) {
                                            return;
                                        }
                                        Slot slot6 = this.getSlot(slotId);
                                        if (!slot6.mayPickup(player)) {
                                            return;
                                        }
                                        if (this.isStorageInventorySlot(slotId)) {
                                            this.quickMoveStack(this.player, slotId).copy();
                                        } else {
                                            ItemStack itemstack8 = this.quickMoveStack(this.player, slotId);
                                            if (this.getOpenOrFirstCraftingContainer(RecipeType.CRAFTING).map(rec$ -> ((ICraftingContainer)rec$).shouldRefillCraftingGrid()).orElse(false).booleanValue()) {
                                                int maxStackSize = itemstack8.getMaxStackSize();
                                                for (int i = 1; !itemstack8.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)slot6.getItem(), (ItemStack)itemstack8) && i < maxStackSize; ++i) {
                                                    itemstack8 = this.quickMoveStack(this.player, slotId);
                                                }
                                            } else {
                                                while (!this.slotsChangedSinceStartOfClick && !itemstack8.isEmpty() && ItemStack.isSameItem((ItemStack)slot6.getItem(), (ItemStack)itemstack8)) {
                                                    itemstack8 = this.quickMoveStack(this.player, slotId);
                                                }
                                            }
                                        }
                                    } else {
                                        if (slotId < 0) {
                                            return;
                                        }
                                        Slot slot7 = this.getSlot(slotId);
                                        ItemStack slotStack2 = slot7.getItem();
                                        ItemStack carriedStack = this.getCarried();
                                        player.updateTutorialInventoryAction(carriedStack, slotStack2, clickaction);
                                        if (!carriedStack.overrideStackedOnOther(slot7, clickaction, player) && !slotStack2.overrideOtherStackedOnMe(carriedStack, slot7, clickaction, player, this.createCarriedSlotAccess())) {
                                            if (slotStack2.isEmpty()) {
                                                if (!carriedStack.isEmpty()) {
                                                    int l2 = clickaction == ClickAction.PRIMARY ? carriedStack.getCount() : 1;
                                                    this.setCarried(slot7.safeInsert(carriedStack, l2));
                                                }
                                            } else if (slot7.mayPickup(player)) {
                                                if (carriedStack.isEmpty()) {
                                                    int countToRemove = Math.min(slotStack2.getCount(), slotStack2.getMaxStackSize());
                                                    if (clickaction == ClickAction.SECONDARY) {
                                                        countToRemove = countToRemove / 2 + countToRemove % 2;
                                                    }
                                                    Optional optional1 = slot7.tryRemove(countToRemove, Integer.MAX_VALUE, player);
                                                    optional1.ifPresent(p_150421_ -> {
                                                        this.setCarried((ItemStack)p_150421_);
                                                        slot7.onTake(player, p_150421_);
                                                    });
                                                } else if (slot7.mayPlace(carriedStack)) {
                                                    if (ItemStack.isSameItemSameComponents((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                                        int j3 = clickaction == ClickAction.PRIMARY ? carriedStack.getCount() : 1;
                                                        this.setCarried(slot7.safeInsert(carriedStack, j3));
                                                    } else if (carriedStack.getCount() <= slot7.getMaxStackSize(carriedStack) && slotStack2.getCount() <= slotStack2.getMaxStackSize()) {
                                                        slot7.set(carriedStack);
                                                        this.setCarried(slotStack2);
                                                    }
                                                } else if (ItemStack.isSameItemSameComponents((ItemStack)slotStack2, (ItemStack)carriedStack)) {
                                                    Optional optional = slot7.tryRemove(slotStack2.getCount(), carriedStack.getMaxStackSize() - carriedStack.getCount(), player);
                                                    optional.ifPresent(p_150428_ -> {
                                                        carriedStack.grow(p_150428_.getCount());
                                                        slot7.onTake(player, p_150428_);
                                                    });
                                                }
                                            }
                                        }
                                        slot7.setChanged();
                                    }
                                    break block51;
                                }
                                if (clickType != ClickType.SWAP) break block58;
                                slot2 = this.getSlot(slotId);
                                itemstack4 = inventory.getItem(dragType);
                                slotStack = slot2.getItem();
                                if (itemstack4.isEmpty() && slotStack.isEmpty()) break block51;
                                if (!itemstack4.isEmpty()) break block59;
                                if (!slot2.mayPickup(player)) break block51;
                                if (slotStack.getCount() <= slotStack.getMaxStackSize()) {
                                    inventory.setItem(dragType, slotStack.copy());
                                    this.onSwapCraft(slot2, slotStack.getCount());
                                    slot2.set(ItemStack.EMPTY);
                                    slot2.onTake(player, slotStack);
                                } else {
                                    inventory.setItem(dragType, slotStack.copyWithCount(slotStack.getMaxStackSize()));
                                    slot2.set(slotStack.copyWithCount(slotStack.getCount() - slotStack.getMaxStackSize()));
                                }
                                break block51;
                            }
                            if (!slotStack.isEmpty()) break block60;
                            if (!slot2.mayPlace(itemstack4)) break block51;
                            int l1 = slot2.getMaxStackSize(itemstack4);
                            if (itemstack4.getCount() > l1) {
                                slot2.set(itemstack4.split(l1));
                            } else {
                                slot2.set(itemstack4);
                                inventory.setItem(dragType, ItemStack.EMPTY);
                            }
                            break block51;
                        }
                        if (slotStack.getCount() > slotStack.getMaxStackSize() || !slot2.mayPickup(player) || !slot2.mayPlace(itemstack4)) break block51;
                        int i2 = slot2.getMaxStackSize(itemstack4);
                        if (itemstack4.getCount() <= i2) break block61;
                        slot2.set(itemstack4.split(i2));
                        slot2.onTake(player, slotStack);
                        if (inventory.add(slotStack)) break block51;
                        player.drop(slotStack, true);
                        break block51;
                    }
                    ItemStack slotStackCopy = slotStack.copy();
                    slot2.set(itemstack4);
                    inventory.setItem(dragType, slotStackCopy);
                    slot2.onTake(player, slotStackCopy);
                    break block51;
                }
                if (clickType != ClickType.CLONE || !player.getAbilities().instabuild || !this.getCarried().isEmpty() || slotId < 0) break block62;
                Slot slot5 = this.getSlot(slotId);
                if (!slot5.hasItem()) break block51;
                ItemStack itemstack6 = slot5.getItem().copy();
                itemstack6.setCount(itemstack6.getMaxStackSize());
                this.setCarried(itemstack6);
                break block51;
            }
            if (clickType == ClickType.THROW && this.getCarried().isEmpty() && slotId >= 0) {
                Slot slot4 = this.getSlot(slotId);
                int i1 = dragType == 0 ? 1 : slot4.getItem().getCount();
                ItemStack itemstack8 = slot4.safeTake(i1, slot4.getItem().getMaxStackSize(), player);
                player.drop(itemstack8, true);
            } else if (clickType == ClickType.PICKUP_ALL && slotId >= 0) {
                Slot slot3 = this.getSlot(slotId);
                ItemStack carriedStack = this.getCarried();
                if (!(carriedStack.isEmpty() || slot3.hasItem() && slot3.mayPickup(player))) {
                    int k1 = dragType == 0 ? 0 : this.getInventorySlotsSize() - 1;
                    int j2 = dragType == 0 ? 1 : -1;
                    for (int k2 = 0; k2 < 2; ++k2) {
                        for (int k3 = k1; k3 >= 0 && k3 < this.getInventorySlotsSize() && carriedStack.getCount() < carriedStack.getMaxStackSize(); k3 += j2) {
                            Slot slot8 = this.getSlot(k3);
                            if (!slot8.hasItem() || !StorageContainerMenuBase.canItemQuickReplace(slot8, carriedStack) || !slot8.mayPickup(player) || !this.canTakeItemForPickAll(carriedStack, slot8)) continue;
                            ItemStack itemstack12 = slot8.getItem();
                            if (k2 == 0 && itemstack12.getCount() == itemstack12.getMaxStackSize()) continue;
                            ItemStack itemstack13 = slot8.safeTake(itemstack12.getCount(), carriedStack.getMaxStackSize() - carriedStack.getCount(), player);
                            carriedStack.grow(itemstack13.getCount());
                        }
                    }
                    k1 = dragType == 0 ? 0 : this.upgradeSlots.size() - 1;
                    for (int j = 0; j < 2; ++j) {
                        for (int upgradeSlotId = k1; upgradeSlotId >= 0 && upgradeSlotId < this.upgradeSlots.size() && carriedStack.getCount() < carriedStack.getMaxStackSize(); upgradeSlotId += j2) {
                            Slot upgradeSlot = this.upgradeSlots.get(upgradeSlotId);
                            if (!upgradeSlot.hasItem() || !StorageContainerMenuBase.canItemQuickReplace(upgradeSlot, carriedStack) || !upgradeSlot.mayPickup(this.player) || !this.canTakeItemForPickAll(carriedStack, upgradeSlot)) continue;
                            ItemStack itemstack3 = upgradeSlot.getItem();
                            if (j == 0 && itemstack3.getCount() == itemstack3.getMaxStackSize()) continue;
                            int l = Math.min(carriedStack.getMaxStackSize() - carriedStack.getCount(), itemstack3.getCount());
                            ItemStack upgradeStack = upgradeSlot.remove(l);
                            carriedStack.grow(l);
                            if (upgradeStack.isEmpty()) {
                                upgradeSlot.set(ItemStack.EMPTY);
                            }
                            upgradeSlot.onTake(this.player, upgradeStack);
                        }
                    }
                }
            }
        }
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        IUpgradeItem upgradeItem;
        Item item;
        if (this.isUpgradeSlot(slot.index) && (item = slot.getItem().getItem()) instanceof IUpgradeItem && (upgradeItem = (IUpgradeItem)item).getInventoryColumnsTaken() > 0) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public void removed(Player player) {
        for (Slot slot : this.upgradeSlots) {
            if (slot instanceof StorageUpgradeSlot || !this.isInventorySlotInUpgradeTab(player, slot) || !this.shouldSlotItemBeDroppedFromStorage(slot)) continue;
            ItemStack slotStack = slot.getItem();
            slot.set(ItemStack.EMPTY);
            if (player.addItem(slotStack)) continue;
            player.drop(slotStack, false);
        }
        super.removed(player);
        if (!player.level().isClientSide()) {
            this.removeOpenTabIfKeepOff();
        }
    }

    protected ItemStack mergeItemStack(ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource, boolean runOverflowLogic) {
        int toTransfer;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        ItemStack result = sourceStack.copy();
        int n = toTransfer = transferMaxStackSizeFromSource ? Math.min(result.getMaxStackSize(), result.getCount()) : result.getCount();
        if (runOverflowLogic || result.isStackable() || this.getSlot(startIndex).getMaxStackSize() > 64) {
            while (toTransfer > 0 && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                ItemStack destStack;
                Slot slot = this.getSlot(i);
                if (slot.mayPlace(result) && !(destStack = slot.getItem()).isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)destStack)) {
                    ItemStack overflowResult;
                    int maxSize = slot.getMaxStackSize(result);
                    if (destStack.getCount() <= maxSize - toTransfer) {
                        result.shrink(toTransfer);
                        copy = destStack.copy();
                        copy.setCount(destStack.getCount() + toTransfer);
                        slot.set(copy);
                        toTransfer = 0;
                        slot.setChanged();
                    } else if (destStack.getCount() < maxSize) {
                        result.shrink(maxSize - destStack.getCount());
                        toTransfer -= maxSize - destStack.getCount();
                        copy = destStack.copy();
                        copy.setCount(maxSize);
                        slot.set(copy);
                        slot.setChanged();
                    }
                    if (runOverflowLogic && !result.isEmpty() && (overflowResult = this.processOverflowLogic(result)) != result) {
                        result.setCount(overflowResult.getCount());
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (toTransfer > 0) {
            int firstIndex = reverseDirection ? endIndex - 1 : startIndex;
            int increment = reverseDirection ? -1 : 1;
            MemorySettingsCategory memory = this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            int slotIndex = firstIndex;
            while ((reverseDirection ? slotIndex >= startIndex : slotIndex < endIndex) && toTransfer > 0) {
                ItemStack destStack;
                Slot slot;
                if (memory.isSlotSelected(slotIndex) && memory.matchesFilter(slotIndex, result) && (slot = this.getSlot(slotIndex)).mayPlace(result) && (destStack = slot.getItem()).isEmpty()) {
                    slot.set(result.split(slot.getMaxStackSize()));
                    slot.setChanged();
                    toTransfer = result.getCount();
                }
                slotIndex += increment;
            }
        }
        if (toTransfer > 0) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                Slot destSlot = this.getSlot(i);
                ItemStack itemstack1 = destSlot.getItem();
                if (itemstack1.isEmpty() && destSlot.mayPlace(result) && !(destSlot instanceof IFilterSlot)) {
                    boolean errorMerging = false;
                    if (toTransfer > destSlot.getMaxStackSize()) {
                        if (runOverflowLogic && this.processOverflowIfSlotWithSameItemFound(i, result, s -> {})) {
                            result.shrink(result.getCount());
                        } else if (this.isUpgradeSlot(i)) {
                            IUpgradeItem upgradeItem = (IUpgradeItem)result.getItem();
                            newColumnsTaken = upgradeItem.getInventoryColumnsTaken();
                            if (!this.needsSlotsThatAreOccupied(result, 0, newColumnsTaken)) {
                                destSlot.set(result.split(destSlot.getMaxStackSize()));
                                this.updateColumnsTaken(newColumnsTaken);
                            } else {
                                errorMerging = true;
                            }
                        } else {
                            destSlot.set(result.split(destSlot.getMaxStackSize()));
                        }
                    } else if (this.isUpgradeSlot(i)) {
                        IUpgradeItem upgradeItem = (IUpgradeItem)result.getItem();
                        newColumnsTaken = upgradeItem.getInventoryColumnsTaken();
                        if (!this.needsSlotsThatAreOccupied(result, 0, newColumnsTaken)) {
                            destSlot.set(result.split(toTransfer));
                            this.updateColumnsTaken(newColumnsTaken);
                            if (this.isClientSide()) {
                                this.onUpgradesChanged();
                            }
                        } else {
                            errorMerging = true;
                        }
                    } else if (runOverflowLogic && this.processOverflowIfSlotWithSameItemFound(i, result, s -> {})) {
                        result.shrink(result.getCount());
                    } else {
                        destSlot.set(result.split(toTransfer));
                    }
                    if (!errorMerging) {
                        destSlot.setChanged();
                        break;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return result;
    }

    protected boolean moveItemStackTo(Slot sourceSlot, ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.mergeItemStack(sourceSlot, stack, startIndex, endIndex, reverseDirection, false);
    }

    protected boolean mergeItemStack(Slot sourceSlot, ItemStack sourceStack, int startIndex, int endIndex, boolean reverseDirection, boolean transferMaxStackSizeFromSource) {
        ItemStack remaining = this.mergeItemStack(sourceStack, startIndex, endIndex, reverseDirection, transferMaxStackSizeFromSource, false);
        if (remaining.getCount() != sourceStack.getCount()) {
            sourceSlot.set(remaining);
            return true;
        }
        return false;
    }

    public void setSynchronizer(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.remoteRealSlots.replaceAll(rs -> synchronizer.createSlot());
            this.remoteUpgradeSlots.replaceAll(rs -> synchronizer.createSlot());
            super.setSynchronizer((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
            return;
        }
        super.setSynchronizer(synchronizer);
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, ItemStack stack) {
        boolean flag;
        boolean bl = flag = slot == null || !slot.hasItem();
        if (!flag && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slot.getItem())) {
            return slot.getItem().getCount() <= slot.getMaxStackSize(stack);
        }
        return flag;
    }

    public Slot getSlot(int slotId) {
        if (slotId >= this.getInventorySlotsSize()) {
            int upgradeSlotId = slotId - this.getInventorySlotsSize();
            return this.upgradeSlots.size() > upgradeSlotId ? this.upgradeSlots.get(upgradeSlotId) : DummySlot.INSTANCE;
        }
        return this.realInventorySlots.get(slotId);
    }

    public void setItem(int slotId, int stateId, ItemStack stack) {
        if (this.getTotalSlotsNumber() > slotId) {
            super.setItem(slotId, stateId, stack);
        }
    }

    public void broadcastChanges() {
        if (this.hasSomethingMessedWithStorage()) {
            this.player.closeContainer();
            return;
        }
        this.synchronizeCarriedToRemote();
        this.broadcastChangesIn(this.lastUpgradeSlots, this.remoteUpgradeSlots, this.upgradeSlots, this.getFirstUpgradeSlot());
        this.broadcastChangesIn(this.lastRealSlots, this.remoteRealSlots, this.realInventorySlots, 0);
        if (this.inventorySlotStackChanged) {
            this.inventorySlotStackChanged = false;
            this.sendAdditionalSlotInfo();
        }
        if (this.lastSettingsData == null || !this.lastSettingsData.equals(this.storageWrapper.getSettingsHandler().getSettingsData())) {
            this.lastSettingsData = this.storageWrapper.getSettingsHandler().getSettingsData().copy();
            this.sendStorageSettingsToClient();
            this.refreshInventorySlotsIfNeeded();
        }
        this.initialBroadcast = false;
    }

    public Optional<ItemStack> getVisibleStorageItem() {
        return this.storageItemSlotNumber != -1 ? Optional.of(this.getSlot(this.storageItemSlotNumber).getItem()) : Optional.empty();
    }

    private void broadcastChangesIn(NonNullList<ItemStack> lastSlotsCollection, NonNullList<RemoteSlot> remoteSlotsCollection, List<Slot> slotsCollection, int slotIndexOffset) {
        for (int i = 0; i < slotsCollection.size(); ++i) {
            Slot slot = slotsCollection.get(i);
            ItemStack itemstack = slot.getItem();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            this.triggerSlotListeners(i, itemstack, (Supplier<ItemStack>)supplier, lastSlotsCollection, slotIndexOffset, slot);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier<ItemStack>)supplier, remoteSlotsCollection, slotIndexOffset);
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy, NonNullList<RemoteSlot> remoteSlotsCollection, int slotIndexOffset) {
        RemoteSlot remoteSlot;
        if (!this.suppressRemoteUpdates && !(remoteSlot = (RemoteSlot)remoteSlotsCollection.get(slotIndex)).matches(slotStack)) {
            remoteSlot.force(slotStack);
            if (this.isStorageInventorySlot(slotIndex + slotIndexOffset)) {
                this.inventorySlotStackChanged = true;
            }
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange((AbstractContainerMenu)this, slotIndex + slotIndexOffset, slotStackCopy.get());
            }
        }
    }

    protected void refreshInventorySlotsIfNeeded() {
        Set<Integer> noSortSlotIndexes = this.getNoSortSlotIndexes();
        boolean needRefresh = false;
        if (this.getInventorySlotsSize() - this.slots.size() != noSortSlotIndexes.size()) {
            needRefresh = true;
        } else {
            for (Slot slot : this.realInventorySlots) {
                if (this.slots.contains((Object)slot) || noSortSlotIndexes.contains(slot.index)) continue;
                needRefresh = true;
                break;
            }
        }
        if (!needRefresh) {
            return;
        }
        this.slots.clear();
        this.lastSlots.clear();
        this.realInventorySlots.clear();
        this.lastRealSlots.clear();
        this.remoteRealSlots.clear();
        this.addStorageInventorySlots();
        this.addPlayerInventorySlots(this.player.getInventory(), this.storageItemSlotIndex, this.shouldLockStorageItemSlot);
        this.addExtraSlots(this.extraSlots);
    }

    public NonNullList<ItemStack> getItems() {
        NonNullList list = NonNullList.create();
        this.realInventorySlots.forEach(slot -> list.add((Object)slot.getItem()));
        this.upgradeSlots.forEach(upgradeSlot -> list.add((Object)upgradeSlot.getItem()));
        return list;
    }

    public abstract boolean detectSettingsChangeAndReload();

    protected boolean shouldSlotItemBeDroppedFromStorage(Slot slot) {
        return false;
    }

    private boolean isInventorySlotInUpgradeTab(Player player, Slot slot) {
        return slot.mayPickup(player) && !(slot instanceof ResultSlot);
    }

    private void reloadUpgradeControl(boolean removeOpenTabId) {
        if (!this.isUpdatingFromPacket && removeOpenTabId) {
            this.storageWrapper.removeOpenTabId();
        }
        NonNullList previousLastUpgradeSlots = NonNullList.create();
        previousLastUpgradeSlots.addAll(this.lastUpgradeSlots);
        NonNullList previousRemoteUpgradeSlots = NonNullList.create();
        previousRemoteUpgradeSlots.addAll(this.remoteUpgradeSlots);
        this.removeUpgradeSettingsSlots();
        this.upgradeContainers.clear();
        this.addUpgradeSettingsContainers(this.player);
        this.setPreviousLastAndRemoteSlots((NonNullList<ItemStack>)previousLastUpgradeSlots, (NonNullList<RemoteSlot>)previousRemoteUpgradeSlots);
        this.onUpgradesChanged();
        this.sendEmptySlotIcons();
        this.sendAdditionalSlotInfo();
    }

    private void setPreviousLastAndRemoteSlots(NonNullList<ItemStack> previousLastUpgradeSlots, NonNullList<RemoteSlot> previousRemoteUpgradeSlots) {
        int i;
        for (i = 0; i < this.lastUpgradeSlots.size() && i < previousLastUpgradeSlots.size(); ++i) {
            this.lastUpgradeSlots.set(i, (Object)((ItemStack)previousLastUpgradeSlots.get(i)));
        }
        for (i = 0; i < this.remoteUpgradeSlots.size() && i < previousRemoteUpgradeSlots.size(); ++i) {
            this.remoteUpgradeSlots.set(i, (Object)((RemoteSlot)previousRemoteUpgradeSlots.get(i)));
        }
    }

    private void removeUpgradeSettingsSlots() {
        ArrayList slotNumbersToRemove = new ArrayList();
        for (UpgradeContainerBase<?, ?> container : this.upgradeContainers.values()) {
            container.getSlots().forEach(slot -> {
                int upgradeSlotIndex = slot.index - this.getInventorySlotsSize();
                slotNumbersToRemove.add(upgradeSlotIndex);
                this.upgradeSlots.remove(slot);
            });
        }
        slotNumbersToRemove.sort(IntComparators.OPPOSITE_COMPARATOR);
        Iterator<UpgradeContainerBase<Object, Object>> iterator = slotNumbersToRemove.iterator();
        while (iterator.hasNext()) {
            int slotNumber = (Integer)((Object)iterator.next());
            this.lastUpgradeSlots.remove(slotNumber);
            this.remoteUpgradeSlots.remove(slotNumber);
        }
    }

    private void onUpgradesChanged() {
        if (this.upgradeChangeListener != null) {
            this.upgradeChangeListener.accept(this);
        }
    }

    @Override
    public void updateAdditionalSlotInfo(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Set<Integer> infiniteSlots, Map<Integer, Holder<Item>> slotFilterItems) {
        this.inaccessibleSlots.clear();
        this.inaccessibleSlots.addAll(inaccessibleSlots);
        this.slotLimitOverrides.clear();
        this.slotLimitOverrides.putAll(slotLimitOverrides);
        this.infiniteSlots.clear();
        this.infiniteSlots.addAll(infiniteSlots);
        Set<Integer> noSort = this.getNoSortSlotIndexes();
        noSort.addAll(infiniteSlots);
        ArrayList<Slot> slotsToMakeIntoNoSort = new ArrayList<Slot>();
        ArrayList<Slot> slotsToMakeSortable = new ArrayList<Slot>();
        for (int i = 0; i < this.getNumberOfStorageInventorySlots(); ++i) {
            Slot slot2 = this.realInventorySlots.get(i);
            if (noSort.contains(slot2.index) && this.slots.contains((Object)slot2)) {
                slotsToMakeIntoNoSort.add(slot2);
                continue;
            }
            if (noSort.contains(slot2.index) || this.slots.contains((Object)slot2)) continue;
            slotsToMakeSortable.add(slot2);
        }
        slotsToMakeIntoNoSort.forEach(arg_0 -> this.slots.remove(arg_0));
        this.slots.addAll(slotsToMakeSortable);
        this.slotFilterItems.clear();
        slotFilterItems.forEach((slot, item) -> this.slotFilterItems.put((Integer)slot, new ItemStack(item)));
    }

    @Override
    public void updateEmptySlotIcons(Map<Identifier, Set<Integer>> emptySlotIcons) {
        this.emptySlotIcons.clear();
        emptySlotIcons.forEach((textureName, slots) -> slots.forEach(slot -> this.emptySlotIcons.put((Integer)slot, (Identifier)textureName)));
    }

    public ItemStack getSlotFilterItem(int slot) {
        return this.slotFilterItems.getOrDefault(slot, ItemStack.EMPTY);
    }

    public void updateSlotChangeError(UpgradeSlotChangeResult result) {
        this.errorUpgradeSlotChangeResult = result;
        if (this.player.level().isClientSide() && this.errorUpgradeSlotChangeResult.successful() && this.columnsChange != 0) {
            this.actuallyUpdateColumnsTaken(this.columnsChange);
            this.onUpgradesChanged();
        }
        this.columnsChange = 0;
        this.showUpgradeSlotChangeError();
    }

    private void showUpgradeSlotChangeError() {
        if (this.errorUpgradeSlotChangeResult == null || this.tryingToMergeUpgrade) {
            return;
        }
        if (this.player.level().isClientSide()) {
            if (!this.errorUpgradeSlotChangeResult.successful()) {
                this.errorResultExpirationTime = this.player.level().getGameTime() + 60L;
            }
        } else {
            Player player = this.player;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncSlotChangeErrorPayload(this.errorUpgradeSlotChangeResult), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void transferItemsToPlayerInventory(boolean filterByContents) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new TransferItemsPayload(true, filterByContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void transferItemsToStorage(boolean filterByContents) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new TransferItemsPayload(false, filterByContents), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void onUpgradeChanged() {
    }

    public class StorageUpgradeSlot
    extends StackCopySlot {
        private final int slotIndex;
        private final UpgradeHandler upgradeHandler;

        public StorageUpgradeSlot(UpgradeHandler upgradeHandler, int slotIndex) {
            super(-15, 0);
            this.slotIndex = slotIndex;
            this.upgradeHandler = upgradeHandler;
        }

        public boolean mayPlace(ItemStack stack) {
            UpgradeSlotChangeResult result;
            if (stack.isEmpty() || !this.getResourceHandler().isValid(this.slotIndex, (Resource)ItemResource.of((ItemStack)stack))) {
                return false;
            }
            if (this.getItem().isEmpty()) {
                result = ((IUpgradeItem)stack.getItem()).canAddUpgradeTo((IStorageWrapper)StorageContainerMenuBase.this.storageWrapper, stack, StorageContainerMenuBase.this.isFirstLevelStorage(), StorageContainerMenuBase.this.player.level().isClientSide());
            } else {
                if (stack.getCount() > 1) {
                    return false;
                }
                result = ((IUpgradeItem)this.getItem().getItem()).canSwapUpgradeFor(stack, this.slotIndex, (IStorageWrapper)StorageContainerMenuBase.this.storageWrapper, StorageContainerMenuBase.this.player.level().isClientSide());
            }
            StorageContainerMenuBase.this.updateSlotChangeError(result);
            return result.successful();
        }

        public boolean mayPickup(Player player) {
            Set<Integer> errorUpgradeSlots;
            ItemResource resource = (ItemResource)this.upgradeHandler.getResource(this.slotIndex);
            if (resource.isEmpty()) {
                return false;
            }
            try (Transaction tx = Transaction.openRoot();){
                if (this.upgradeHandler.extract(this.slotIndex, (Resource)resource, 1, (TransactionContext)tx) != 1) {
                    boolean bl = false;
                    return bl;
                }
            }
            UpgradeSlotChangeResult result = ((IUpgradeItem)this.getItem().getItem()).canRemoveUpgradeFrom((IStorageWrapper)StorageContainerMenuBase.this.storageWrapper, player.level().isClientSide(), player);
            if (result.successful() && StorageContainerMenuBase.this.upgradeContainers.containsKey(this.slotIndex) && !(errorUpgradeSlots = StorageContainerMenuBase.this.upgradeContainers.get(this.slotIndex).getSlots().stream().filter(slot -> !(slot instanceof IFilterSlot) && StorageContainerMenuBase.this.shouldSlotItemBeDroppedFromStorage((Slot)slot)).map(slot -> slot.getSlotIndex() + StorageContainerMenuBase.this.getNumberOfUpgradeSlots()).collect(Collectors.toSet())).isEmpty()) {
                result = UpgradeSlotChangeResult.fail(TranslationHelper.INSTANCE.translError("remove.banned_item", new Object[0]), errorUpgradeSlots, Collections.emptySet(), Collections.emptySet());
            }
            StorageContainerMenuBase.this.updateSlotChangeError(result);
            return result.successful();
        }

        public @Nullable Identifier getNoItemIcon() {
            return EMPTY_UPGRADE_SLOT_BACKGROUND;
        }

        protected ItemStack getStackCopy() {
            return ((ItemResource)this.upgradeHandler.getResource(this.slotIndex)).toStack(this.upgradeHandler.getAmountAsInt(this.slotIndex));
        }

        protected void setStackCopy(ItemStack stack) {
            boolean wasEmpty = ((ItemResource)this.upgradeHandler.getResource(this.slotIndex)).isEmpty();
            this.upgradeHandler.setStackInSlot(this.slotIndex, stack);
            ReloadCheckResult reloadCheckResult = this.updateWrappersAndCheckForReloadNeeded(wasEmpty, stack);
            if (reloadCheckResult.reloadNeeded()) {
                StorageContainerMenuBase.this.reloadUpgradeControl(reloadCheckResult.removeOpenTabId());
                if (!StorageContainerMenuBase.this.isFirstLevelStorage()) {
                    StorageContainerMenuBase.this.parentStorageWrapper.getUpgradeHandler().refreshUpgradeWrappers();
                }
                StorageContainerMenuBase.this.onUpgradeChanged();
            }
        }

        private ReloadCheckResult updateWrappersAndCheckForReloadNeeded(boolean wasEmpty, ItemStack stack) {
            if (!StorageContainerMenuBase.this.isUpdatingFromPacket && wasEmpty != stack.isEmpty()) {
                return ReloadCheckResult.RELOAD_NEEDED;
            }
            int checkedContainersCount = 0;
            for (Map.Entry<Integer, IUpgradeWrapper> slotWrapper : StorageContainerMenuBase.this.storageWrapper.getUpgradeHandler().getSlotWrappers().entrySet()) {
                UpgradeContainerBase<?, ?> container = StorageContainerMenuBase.this.upgradeContainers.get(slotWrapper.getKey());
                if (slotWrapper.getValue().hideSettingsTab()) {
                    if (container == null) continue;
                    return ReloadCheckResult.RELOAD_NEEDED;
                }
                if (container == null || container.getUpgradeWrapper().isEnabled() != slotWrapper.getValue().isEnabled()) {
                    return ReloadCheckResult.RELOAD_NEEDED;
                }
                if (container.getUpgradeWrapper() != slotWrapper.getValue()) {
                    if (!StorageContainerMenuBase.this.player.level().isClientSide() || container.getUpgradeWrapper().getUpgradeStack().getItem() != slotWrapper.getValue().getUpgradeStack().getItem()) {
                        if (container.getUpgradeWrapper().getUpgradeStack().getItem() == slotWrapper.getValue().getUpgradeStack().getItem()) {
                            return ReloadCheckResult.RELOAD_NEEDED_KEEP_TAB;
                        }
                        return ReloadCheckResult.RELOAD_NEEDED;
                    }
                    container.setUpgradeWrapper(slotWrapper.getValue());
                    ++checkedContainersCount;
                    continue;
                }
                ++checkedContainersCount;
            }
            return checkedContainersCount != StorageContainerMenuBase.this.upgradeContainers.size() ? ReloadCheckResult.RELOAD_NEEDED : ReloadCheckResult.NO_RELOAD_NEEDED;
        }

        public void onQuickCraft(ItemStack oldStackIn, ItemStack newStackIn) {
        }

        public int getMaxStackSize() {
            return this.upgradeHandler.getCapacityAsInt(this.slotIndex, (Resource)ItemResource.EMPTY);
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.upgradeHandler.getCapacityAsInt(this.slotIndex, (Resource)ItemResource.of((ItemStack)stack));
        }

        public ResourceHandler<ItemResource> getResourceHandler() {
            return this.upgradeHandler;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isSameInventory(Slot other) {
            if (!(other instanceof StorageUpgradeSlot)) return false;
            StorageUpgradeSlot otherSlot = (StorageUpgradeSlot)other;
            if (otherSlot.upgradeHandler != this.upgradeHandler) return false;
            return true;
        }
    }

    private record ReloadCheckResult(boolean reloadNeeded, boolean removeOpenTabId) {
        public static final ReloadCheckResult NO_RELOAD_NEEDED = new ReloadCheckResult(false, false);
        public static final ReloadCheckResult RELOAD_NEEDED = new ReloadCheckResult(true, true);
        public static final ReloadCheckResult RELOAD_NEEDED_KEEP_TAB = new ReloadCheckResult(true, false);
    }
}

