/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public abstract class PropertyBasedSubtypeInterpreter {
    private final List<IPropertyDefinition<?>> propertyDefinitions = new ArrayList();

    protected List<IPropertyDefinition<?>> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    protected <T> void addOptionalProperty(Function<ItemStack, Optional<T>> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        this.addDefinition(s -> propertyGetter.andThen(i -> i.orElse(null)).apply(s), propertyName, propertyValueSerializer);
    }

    private <T> void addDefinition(final IPropertyValueGetter<T> getter, final String propertyName, final Function<T, String> propertyValueSerializer) {
        this.getPropertyDefinitions().add(new IPropertyDefinition<T>(){

            @Override
            public @Nullable T getPropertyValue(ItemStack itemStack) {
                return getter.getPropertyValue(itemStack);
            }

            @Override
            public String getPropertyName() {
                return propertyName;
            }

            @Override
            public String serializePropertyValue(@Nullable T property) {
                return property != null ? (String)propertyValueSerializer.apply(property) : "";
            }
        });
    }

    protected <T> void addProperty(IPropertyValueGetter<T> propertyGetter, String propertyName, Function<T, String> propertyValueSerializer) {
        this.addDefinition(propertyGetter, propertyName, propertyValueSerializer);
    }

    public final @Nullable Object getComparableData(ItemStack stack) {
        boolean allNulls = true;
        ArrayList results = new ArrayList(this.getPropertyDefinitions().size());
        for (IPropertyDefinition<?> definition : this.getPropertyDefinitions()) {
            @Nullable ? value = definition.getPropertyValue(stack);
            if (value != null) {
                allNulls = false;
            }
            results.add(value);
        }
        if (allNulls) {
            return null;
        }
        return results;
    }

    private <T> String getSerializedPropertyValue(IPropertyDefinition<T> definition, Object value) {
        return definition.serializePropertyValue(value);
    }

    public String getRegistrySanitizedItemString(ItemStack stack) {
        StringBuilder result = new StringBuilder();
        for (IPropertyDefinition<?> definition : this.getPropertyDefinitions()) {
            @Nullable ? value = definition.getPropertyValue(stack);
            if (value == null) continue;
            String serializedValue = this.sanitize(this.getSerializedPropertyValue(definition, value));
            if (!result.isEmpty()) {
                result.append('_');
            }
            result.append(definition.getPropertyName().toLowerCase(Locale.ROOT)).append('_').append(serializedValue);
        }
        return PropertyBasedSubtypeInterpreter.getItemPath(stack) + "_" + String.valueOf(result);
    }

    private String sanitize(String value) {
        return value.replaceAll(":", "_").toLowerCase(Locale.ROOT);
    }

    private static String getItemPath(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
    }

    public static interface IPropertyValueGetter<T> {
        public @Nullable T getPropertyValue(ItemStack var1);
    }

    public static interface IPropertyDefinition<T> {
        public @Nullable T getPropertyValue(ItemStack var1);

        public String getPropertyName();

        public String serializePropertyValue(@Nullable T var1);
    }
}

