/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.EmptyResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInsertBlockOverride;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.Nullable;

public abstract class ControllerBlockEntityBase
extends BlockEntity
implements ResourceHandler<ItemResource>,
IInsertBlockOverride {
    private List<BlockPos> storagePositions = new ArrayList<BlockPos>();
    private final Map<BlockPos, Integer> storagePositionIndexes = new HashMap<BlockPos, Integer>();
    private List<Integer> baseIndexes = new ArrayList<Integer>();
    private int totalSlots = 0;
    protected final Map<ItemStackKey, Set<BlockPos>> stackStorages = new HashMap<ItemStackKey, Set<BlockPos>>();
    private final Map<BlockPos, Set<ItemStackKey>> storageStacks = new HashMap<BlockPos, Set<ItemStackKey>>();
    protected final Map<Item, Set<ItemStackKey>> itemStackKeys = new HashMap<Item, Set<ItemStackKey>>();
    private final Comparator<BlockPos> distanceComparator = Comparator.comparingDouble(p -> p.distSqr((Vec3i)this.getBlockPos())).thenComparing(Comparator.naturalOrder());
    protected final Set<BlockPos> emptySlotsStorages = new TreeSet<BlockPos>(this.distanceComparator);
    protected final Map<Item, Set<BlockPos>> memorizedItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageMemorizedItems = new HashMap<BlockPos, Set<Item>>();
    protected final Map<Integer, Set<BlockPos>> memorizedStackStorages = new HashMap<Integer, Set<BlockPos>>();
    private final Map<BlockPos, Set<Integer>> storageMemorizedStacks = new HashMap<BlockPos, Set<Integer>>();
    protected final Map<Item, Set<BlockPos>> filterItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageFilterItems = new HashMap<BlockPos, Set<Item>>();
    private Set<BlockPos> linkedBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> connectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private Set<BlockPos> nonConnectingBlocks = new TreeSet<BlockPos>(this.distanceComparator);
    private WeakReference<ResourceHandler<ItemResource>>[] cachedHandlers = new WeakReference[0];

    public boolean addLinkedBlock(BlockPos linkedPos) {
        if (this.level != null && !this.level.isClientSide() && this.isWithinRange(linkedPos) && !this.linkedBlocks.contains(linkedPos) && !this.storagePositions.contains(linkedPos)) {
            this.linkedBlocks.add(linkedPos);
            this.setChanged();
            WorldHelper.getBlockEntity((BlockGetter)this.level, linkedPos, ILinkable.class).ifPresent(l -> {
                if (l.connectLinkedSelf()) {
                    LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
                    positionsToCheck.add(linkedPos);
                    this.searchAndAddBoundables(positionsToCheck, true);
                }
                this.searchAndAddBoundables(new LinkedHashSet<BlockPos>(l.getConnectablePositions()), false);
            });
            WorldHelper.notifyBlockUpdate(this);
            return true;
        }
        return false;
    }

    public void removeLinkedBlock(BlockPos storageBlockPos) {
        this.linkedBlocks.remove(storageBlockPos);
        this.setChanged();
        this.verifyStoragesConnected();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.stackStorages.clear();
            this.storageStacks.clear();
            this.itemStackKeys.clear();
            this.emptySlotsStorages.clear();
            this.storagePositions.forEach(this::addStorageStacksAndRegisterListeners);
        }
    }

    public boolean isStorageConnected(BlockPos storagePos) {
        return this.storagePositions.contains(storagePos);
    }

    public void searchAndAddBoundables() {
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            positionsToCheck.add(this.getBlockPos().offset(dir.getUnitVec3i()));
        }
        this.searchAndAddBoundables(positionsToCheck, false);
    }

    public void changeSlots(BlockPos storagePos, int newSlots, boolean hasEmptySlots) {
        this.updateBaseIndexesAndTotalSlots(storagePos, newSlots);
        this.updateEmptySlots(storagePos, hasEmptySlots);
    }

    public void updateEmptySlots(BlockPos storagePos, boolean hasEmptySlots) {
        if (this.emptySlotsStorages.contains(storagePos) && !hasEmptySlots) {
            this.emptySlotsStorages.remove(storagePos);
        } else if (!this.emptySlotsStorages.contains(storagePos) && hasEmptySlots) {
            this.emptySlotsStorages.add(storagePos);
        }
    }

    private void updateBaseIndexesAndTotalSlots(BlockPos storagePos, int newSlots) {
        int index = this.storagePositions.indexOf(storagePos);
        int originalSlots = this.getStorageSlots(index);
        int diff = newSlots - originalSlots;
        for (int i = index; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) + diff);
        }
        this.totalSlots += diff;
        WorldHelper.notifyBlockUpdate(this);
    }

    private int getStorageSlots(int index) {
        int previousBaseIndex = index == 0 ? 0 : this.baseIndexes.get(index - 1);
        return this.baseIndexes.get(index) - previousBaseIndex;
    }

    public int getSlots(int storageIndex) {
        if (storageIndex < 0 || storageIndex >= this.baseIndexes.size()) {
            return 0;
        }
        return this.getStorageSlots(storageIndex);
    }

    private void searchAndAddBoundables(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf) {
        HashSet positionsChecked = new HashSet();
        boolean first = true;
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            boolean finalFirst = first;
            WorldHelper.getLoadedBlockEntity(this.level, posToCheck, IControllerBoundable.class).ifPresentOrElse(boundable -> this.tryToConnectStorageAndAddPositionsToCheckAround(positionsToCheck, addingLinkedSelf, positionsChecked, posToCheck, finalFirst, (IControllerBoundable)boundable), () -> positionsChecked.add(posToCheck));
            first = false;
        }
    }

    private void tryToConnectStorageAndAddPositionsToCheckAround(Set<BlockPos> positionsToCheck, boolean addingLinkedSelf, Set<BlockPos> positionsChecked, BlockPos posToCheck, boolean finalFirst, IControllerBoundable boundable) {
        if (boundable.canBeConnected() || addingLinkedSelf && finalFirst) {
            IControllableStorage storage;
            ILinkable linkable;
            if (boundable instanceof ILinkable && (linkable = (ILinkable)boundable).isLinked() && (!addingLinkedSelf || !finalFirst)) {
                this.linkedBlocks.remove(posToCheck);
                linkable.setNotLinked();
                this.clearCachedHandlers();
            } else if (boundable instanceof IControllableStorage && (storage = (IControllableStorage)boundable).hasStorageData()) {
                this.addStorageData(posToCheck);
            } else {
                if (boundable.canConnectStorages()) {
                    this.connectingBlocks.add(posToCheck);
                } else {
                    this.nonConnectingBlocks.add(posToCheck);
                }
                boundable.registerController(this);
            }
            if (boundable.canConnectStorages()) {
                this.addUncheckedPositionsAround(positionsToCheck, positionsChecked, posToCheck);
            }
        }
    }

    private void clearCachedHandlers() {
        this.cachedHandlers = new WeakReference[this.storagePositions.size()];
    }

    public void clearCachedHandler(BlockPos storagePos) {
        Integer index = this.storagePositionIndexes.get(storagePos);
        if (index != null && index < this.cachedHandlers.length) {
            this.cachedHandlers[index.intValue()] = null;
        }
    }

    private void addUncheckedPositionsAround(Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked, BlockPos currentPos) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = currentPos.offset(dir.getUnitVec3i());
            if (positionsChecked.contains(pos) || (this.storagePositions.contains(pos) || this.connectingBlocks.contains(pos) || this.nonConnectingBlocks.contains(pos)) && !this.linkedBlocks.contains(pos) || !this.isWithinRange(pos)) continue;
            positionsToCheck.add(pos);
        }
    }

    private boolean isWithinRange(BlockPos pos) {
        return Math.abs(pos.getX() - this.getBlockPos().getX()) <= this.getSearchRange() && Math.abs(pos.getY() - this.getBlockPos().getY()) <= this.getSearchRange() && Math.abs(pos.getZ() - this.getBlockPos().getZ()) <= this.getSearchRange();
    }

    protected abstract int getSearchRange();

    public void addStorage(BlockPos storagePos) {
        if (this.storagePositions.contains(storagePos)) {
            this.removeStorageInventoryData(storagePos);
            this.clearCachedHandlers();
        }
        if (this.isWithinRange(storagePos)) {
            LinkedHashSet<BlockPos> positionsToCheck = new LinkedHashSet<BlockPos>();
            positionsToCheck.add(storagePos);
            this.searchAndAddBoundables(positionsToCheck, false);
        }
        WorldHelper.notifyBlockUpdate(this);
    }

    private void addStorageData(BlockPos storagePos) {
        this.storagePositions.add(storagePos);
        int index = this.storagePositions.size() - 1;
        this.storagePositionIndexes.put(storagePos, index);
        this.totalSlots += this.getHandlerFromIndex(index).size();
        this.baseIndexes.add(this.totalSlots);
        this.addStorageStacksAndRegisterListeners(storagePos);
        this.setChanged();
        WorldHelper.notifyBlockUpdate(this);
    }

    public void addStorageStacksAndRegisterListeners(BlockPos storagePos) {
        WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).ifPresent(storage -> {
            ITrackedContentsItemResourceHandler handler = storage.getStorageWrapper().getInventoryForInputOutput();
            handler.getTrackedStacks().forEach(k -> this.addStorageStack(storagePos, (ItemStackKey)k));
            if (handler.hasEmptySlots()) {
                this.emptySlotsStorages.add(storagePos);
            }
            MemorySettingsCategory memorySettings = storage.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
            memorySettings.getFilterItemSlots().keySet().forEach(i -> this.addStorageMemorizedItem(storagePos, (Item)i));
            memorySettings.getFilterStackSlots().keySet().forEach(stackHash -> this.addStorageMemorizedStack(storagePos, (int)stackHash));
            this.setStorageFilterItems(storagePos, storage.getStorageWrapper().getInventoryHandler().getFilterItems());
            storage.registerController(this);
        });
    }

    public void addStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedItems.computeIfAbsent(storagePos, pos -> new HashSet()).add(item);
    }

    public void addStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfAbsent(stackHash, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(stackHash);
    }

    public void removeStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfPresent(item, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedItemStorages.containsKey(item) && this.memorizedItemStorages.get(item).isEmpty()) {
            this.memorizedItemStorages.remove(item);
        }
        this.storageMemorizedItems.remove(storagePos);
    }

    public void removeStorageMemorizedStack(BlockPos storagePos, int stackHash) {
        this.memorizedStackStorages.computeIfPresent(stackHash, (i, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.memorizedStackStorages.containsKey(stackHash) && this.memorizedStackStorages.get(stackHash).isEmpty()) {
            this.memorizedStackStorages.remove(stackHash);
        }
        this.storageMemorizedStacks.remove(storagePos);
    }

    private <T> Optional<T> getWrapperValueFromHolder(BlockPos storagePos, Function<IStorageWrapper, T> valueGetter) {
        return WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).map(holder -> valueGetter.apply(holder.getStorageWrapper()));
    }

    public void addStorageStack(BlockPos storagePos, ItemStackKey itemStackKey) {
        this.stackStorages.computeIfAbsent(itemStackKey, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(itemStackKey);
        this.itemStackKeys.computeIfAbsent(itemStackKey.stack().getItem(), item -> new LinkedHashSet()).add(itemStackKey);
    }

    public void removeStorageStack(BlockPos storagePos, ItemStackKey stackKey) {
        this.stackStorages.computeIfPresent(stackKey, (sk, positions) -> {
            positions.remove(storagePos);
            return positions;
        });
        if (this.stackStorages.containsKey(stackKey) && this.stackStorages.get(stackKey).isEmpty()) {
            this.stackStorages.remove(stackKey);
            this.itemStackKeys.computeIfPresent(stackKey.stack().getItem(), (i, stackKeys) -> {
                stackKeys.remove(stackKey);
                return stackKeys;
            });
            if (this.itemStackKeys.containsKey(stackKey.stack().getItem()) && this.itemStackKeys.get(stackKey.stack().getItem()).isEmpty()) {
                this.itemStackKeys.remove(stackKey.stack().getItem());
            }
        }
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.storageStacks.containsKey(storagePos) && this.storageStacks.get(storagePos).isEmpty()) {
            this.storageStacks.remove(storagePos);
        }
    }

    public void removeStorageStacks(BlockPos storagePos) {
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.forEach(stackKey -> {
                Set<BlockPos> storages = this.stackStorages.get(stackKey);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.stackStorages.remove(stackKey);
                        this.itemStackKeys.computeIfPresent(stackKey.stack().getItem(), (i, positions) -> {
                            positions.remove(stackKey);
                            return positions;
                        });
                        if (this.itemStackKeys.containsKey(stackKey.stack().getItem()) && this.itemStackKeys.get(stackKey.stack().getItem()).isEmpty()) {
                            this.itemStackKeys.remove(stackKey.stack().getItem());
                        }
                    }
                }
            });
            return stackKeys;
        });
        this.storageStacks.remove(storagePos);
    }

    protected boolean hasItem(Item item) {
        return this.itemStackKeys.containsKey(item);
    }

    protected boolean isMemorizedItem(ItemStack stack) {
        return this.memorizedItemStorages.containsKey(stack.getItem()) || this.memorizedStackStorages.containsKey(ItemStack.hashItemAndComponents((ItemStack)stack));
    }

    protected boolean isFilterItem(Item item) {
        return this.filterItemStorages.containsKey(item);
    }

    public void removeBoundable(BlockPos boundablePos) {
        this.removeConnectingBlock(boundablePos);
        this.verifyStoragesConnected();
    }

    public void removeStorage(BlockPos storagePos) {
        this.removeConnectingBlock(storagePos);
        this.removeStorageInventoryDataAndUnregisterController(storagePos);
        this.verifyStoragesConnected();
    }

    private void removeConnectingBlock(BlockPos storagePos) {
        if (this.connectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController);
        }
    }

    public void removeNonConnectingBlock(BlockPos storagePos) {
        if (this.nonConnectingBlocks.remove(storagePos)) {
            WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController);
        }
    }

    private void removeStorageInventoryDataAndUnregisterController(BlockPos storagePos) {
        if (!this.storagePositions.contains(storagePos)) {
            return;
        }
        this.removeStorageInventoryData(storagePos);
        this.linkedBlocks.remove(storagePos);
        WorldHelper.getLoadedBlockEntity(this.level, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
        this.clearCachedHandlers();
        this.setChanged();
        WorldHelper.notifyBlockUpdate(this);
    }

    private void removeStorageInventoryData(BlockPos storagePos) {
        int idx = this.storagePositions.indexOf(storagePos);
        this.totalSlots -= this.getStorageSlots(idx);
        this.removeStorageStacks(storagePos);
        this.removeStorageMemorizedItems(storagePos);
        this.removeStorageMemorizedStacks(storagePos);
        this.removeStorageWithEmptySlots(storagePos);
        this.removeStorageFilterItems(storagePos);
        this.storagePositions.remove(idx);
        this.removeStoragePositionIndex(storagePos);
        this.removeBaseIndexAt(idx);
    }

    private void removeStoragePositionIndex(BlockPos storagePos) {
        Integer removedIndex = this.storagePositionIndexes.remove(storagePos);
        if (removedIndex == null) {
            return;
        }
        for (Map.Entry<BlockPos, Integer> entry : this.storagePositionIndexes.entrySet()) {
            int index = entry.getValue();
            if (index <= removedIndex) continue;
            entry.setValue(index - 1);
        }
    }

    private void removeStorageFilterItems(BlockPos storagePos) {
        this.storageFilterItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.filterItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.filterItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageFilterItems.remove(storagePos);
    }

    private void removeStorageMemorizedItems(BlockPos storagePos) {
        this.storageMemorizedItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.memorizedItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedItems.remove(storagePos);
    }

    private void removeStorageMemorizedStacks(BlockPos storagePos) {
        this.storageMemorizedStacks.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(stackHash -> {
                Set<BlockPos> storages = this.memorizedStackStorages.get(stackHash);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedStackStorages.remove(stackHash);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedStacks.remove(storagePos);
    }

    private void verifyStoragesConnected() {
        HashSet<BlockPos> toVerify = new HashSet<BlockPos>(this.storagePositions);
        toVerify.addAll(this.connectingBlocks);
        toVerify.addAll(this.nonConnectingBlocks);
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = this.getBlockPos().offset(dir.getUnitVec3i());
            if (!toVerify.contains(offsetPos)) continue;
            positionsToCheck.add(offsetPos);
        }
        HashSet<BlockPos> positionsChecked = new HashSet<BlockPos>();
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        this.linkedBlocks.forEach(linkedPosition -> WorldHelper.getBlockEntity((BlockGetter)this.getLevel(), linkedPosition, ILinkable.class).ifPresent(l -> {
            if (l.connectLinkedSelf() && toVerify.contains(linkedPosition)) {
                positionsToCheck.add((BlockPos)linkedPosition);
            }
            l.getConnectablePositions().forEach(p -> {
                if (toVerify.contains(p)) {
                    positionsToCheck.add((BlockPos)p);
                }
            });
        }));
        this.verifyConnected(toVerify, positionsToCheck, positionsChecked);
        toVerify.forEach(storagePos -> {
            this.removeConnectingBlock((BlockPos)storagePos);
            this.removeNonConnectingBlock((BlockPos)storagePos);
            this.removeStorageInventoryDataAndUnregisterController((BlockPos)storagePos);
        });
        this.clearCachedHandlers();
    }

    private void verifyConnected(HashSet<BlockPos> toVerify, Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked) {
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            positionsChecked.add(posToCheck);
            WorldHelper.getLoadedBlockEntity(this.level, posToCheck, IControllerBoundable.class).ifPresent(h -> {
                toVerify.remove(posToCheck);
                if (h.canConnectStorages()) {
                    for (Direction dir : Direction.values()) {
                        BlockPos pos = posToCheck.offset(dir.getUnitVec3i());
                        if (positionsChecked.contains(pos) || !toVerify.contains(pos)) continue;
                        positionsToCheck.add(pos);
                    }
                }
            });
        }
    }

    private void removeBaseIndexAt(int idx) {
        if (idx >= this.baseIndexes.size()) {
            return;
        }
        int slotsRemoved = this.getStorageSlots(idx);
        this.baseIndexes.remove(idx);
        for (int i = idx; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) - slotsRemoved);
        }
    }

    protected ControllerBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public int size() {
        return this.totalSlots;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndexes.size(); ++i) {
            if (slot - this.baseIndexes.get(i) >= 0) continue;
            return i;
        }
        return -1;
    }

    protected ResourceHandler<ItemResource> getHandlerFromIndex(int index) {
        ResourceHandler handler;
        if (index < 0 || index >= this.storagePositions.size()) {
            return EmptyResourceHandler.instance();
        }
        if (index >= this.cachedHandlers.length) {
            this.cachedHandlers = Arrays.copyOf(this.cachedHandlers, index + 1);
        }
        if (this.cachedHandlers[index] != null && (handler = (ResourceHandler)this.cachedHandlers[index].get()) != null) {
            return handler;
        }
        handler = this.getWrapperValueFromHolder(this.storagePositions.get(index), storageWrapper -> storageWrapper.getInventoryForInputOutput()).orElse((ResourceHandler)EmptyResourceHandler.instance());
        this.cachedHandlers[index] = new WeakReference<ResourceHandler>(handler);
        return handler;
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndexes.size()) {
            return slot;
        }
        return slot - this.baseIndexes.get(index - 1);
    }

    public ItemResource getResource(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemResource.EMPTY;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getResource")) {
            return (ItemResource)handler.getResource(slot);
        }
        return ItemResource.EMPTY;
    }

    public long getAmountAsLong(int i) {
        if (this.isSlotIndexInvalid(i)) {
            return 0L;
        }
        int handlerIndex = this.getIndexForSlot(i);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, i = this.getSlotFromIndex(i, handlerIndex), "getAmountAsLong")) {
            return handler.getAmountAsLong(i);
        }
        return 0L;
    }

    private boolean isSlotIndexInvalid(int slot) {
        return slot < 0 || slot >= this.totalSlots;
    }

    private boolean validateHandlerSlotIndex(ResourceHandler<ItemResource> handler, int handlerIndex, int slot, String methodName) {
        if (slot >= 0 && slot < handler.size()) {
            return true;
        }
        if (handlerIndex < 0 || handlerIndex >= this.storagePositions.size()) {
            SophisticatedCore.LOGGER.debug("Invalid handler index calculated {} in controller's {} method. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> handlerIndex, () -> methodName, () -> this.getBlockPos().toShortString()});
        } else {
            SophisticatedCore.LOGGER.debug("Invalid slot {} passed into controller's {} method for storage at {}. If you see many of these messages try replacing controller at {}", new Supplier[]{() -> slot, () -> methodName, () -> this.storagePositions.get(handlerIndex).toShortString(), () -> this.getBlockPos().toShortString()});
        }
        return false;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transactionContext) {
        if (this.isSlotIndexInvalid(index) || resource.isEmpty() || amount <= 0) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(index);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, index = this.getSlotFromIndex(index, handlerIndex), "insert(int index, ItemResource resource, int amount, TransactionContext transactionContext)")) {
            return handler.insert(index, (Resource)resource, amount, transactionContext);
        }
        return 0;
    }

    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        return this.insertItem(resource, amount, transaction, true);
    }

    protected int insertItem(ItemStack stack, TransactionContext tx, boolean insertIntoAnyEmpty) {
        return this.insertItem(ItemResource.of((ItemStack)stack), stack.getCount(), tx, insertIntoAnyEmpty);
    }

    protected int insertItem(ItemResource resource, int amount, TransactionContext tx, boolean insertIntoAnyEmpty) {
        ItemStackKey stackKey = ItemStackKey.of(resource);
        int inserted = 0;
        if ((inserted += this.insertIntoStoragesThatMatchStack(resource, amount, stackKey, tx)) >= amount) {
            return inserted;
        }
        int stackHash = stackKey.hashCode();
        if (this.memorizedStackStorages.containsKey(stackHash) && (inserted += this.insertIntoStorages(this.memorizedStackStorages.get(stackHash), resource, amount - inserted, tx, false)) >= amount) {
            return inserted;
        }
        if ((inserted += this.insertIntoStoragesThatMatchItem(resource, amount - inserted, tx)) >= amount) {
            return inserted;
        }
        if (this.memorizedItemStorages.containsKey(resource.getItem()) && (inserted += this.insertIntoStorages(this.memorizedItemStorages.get(resource.getItem()), resource, amount - inserted, tx, false)) >= amount) {
            return inserted;
        }
        if (this.filterItemStorages.containsKey(resource.getItem()) && (inserted += this.insertIntoStorages(this.filterItemStorages.get(resource.getItem()), resource, amount - inserted, tx, false)) >= amount) {
            return inserted;
        }
        return insertIntoAnyEmpty ? this.insertIntoStorages(this.emptySlotsStorages, resource, amount - inserted, tx, false) : inserted;
    }

    private int insertIntoStoragesThatMatchStack(ItemResource resource, int amount, ItemStackKey stackKey, TransactionContext tx) {
        if (this.stackStorages.containsKey(stackKey)) {
            Set<BlockPos> positions = this.stackStorages.get(stackKey);
            return this.insertIntoStorages(positions, resource, amount, tx, false);
        }
        return 0;
    }

    private int insertIntoStoragesThatMatchItem(ItemResource resource, int amount, TransactionContext tx) {
        int inserted;
        block2: {
            inserted = 0;
            if (this.emptySlotsStorages.isEmpty() || !this.itemStackKeys.containsKey(resource.getItem())) break block2;
            Set<ItemStackKey> matchingStackKeys = this.itemStackKeys.get(resource.getItem());
            if (amount > resource.getMaxStackSize()) {
                matchingStackKeys = new LinkedHashSet<ItemStackKey>(matchingStackKeys);
            }
            for (ItemStackKey key : matchingStackKeys) {
                Set<BlockPos> positions;
                if (this.stackStorages.containsKey(key) && (inserted += this.insertIntoStorages(positions = this.stackStorages.get(key), resource, amount - inserted, tx, true)) >= amount) break;
            }
        }
        return inserted;
    }

    private int insertIntoStorages(Set<BlockPos> positions, ItemResource resource, int amount, TransactionContext tx, boolean checkHasEmptySlotFirst) {
        int inserted = 0;
        LinkedHashSet<BlockPos> positionsCopy = new LinkedHashSet<BlockPos>(positions);
        for (BlockPos storagePos : positionsCopy) {
            if (checkHasEmptySlotFirst && !this.emptySlotsStorages.contains(storagePos) || (inserted += this.insertIntoStorage(storagePos, resource, amount - inserted, tx)) < amount) continue;
            return amount;
        }
        return inserted;
    }

    protected int insertIntoStorage(BlockPos storagePos, ItemResource resource, int amount, TransactionContext tx) {
        Integer idx = this.storagePositionIndexes.get(storagePos);
        if (idx == null) {
            return 0;
        }
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(idx);
        return handler.insert((Resource)resource, amount, tx);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext tx) {
        if (this.isSlotIndexInvalid(index)) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(index);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, index = this.getSlotFromIndex(index, handlerIndex), "extract(int index, ItemResource resource, int amount, TransactionContext tx)")) {
            return handler.extract(index, (Resource)resource, amount, tx);
        }
        return 0;
    }

    public int extract(ItemResource resource, int amount, TransactionContext tx) {
        if (resource.isEmpty() || amount <= 0) {
            return 0;
        }
        int extracted = 0;
        ItemStackKey stackKey = ItemStackKey.of(resource);
        if (this.stackStorages.containsKey(stackKey) && (extracted += this.extractFromStorages(stackKey, resource, amount, tx)) >= amount) {
            return extracted;
        }
        return extracted;
    }

    private int extractFromStorages(ItemStackKey stackKey, ItemResource resource, int amount, TransactionContext tx) {
        int extracted = 0;
        LinkedHashSet positionsCopy = new LinkedHashSet(this.stackStorages.get(stackKey));
        for (BlockPos storagePos : positionsCopy) {
            if ((extracted += this.extractFromStorage(storagePos, resource, amount - extracted, tx)) < amount) continue;
            return amount;
        }
        return extracted;
    }

    private int extractFromStorage(BlockPos pos, ItemResource resource, int amount, TransactionContext tx) {
        Integer idx = this.storagePositionIndexes.get(pos);
        if (idx == null) {
            return 0;
        }
        return this.getHandlerFromIndex(idx).extract((Resource)resource, amount, tx);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        if (this.isSlotIndexInvalid(index)) {
            return 0L;
        }
        int handlerIndex = this.getIndexForSlot(index);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, index = this.getSlotFromIndex(index, handlerIndex), "getCapacityAsLong(int index, ItemResource resource)")) {
            return handler.getCapacityAsLong(index, (Resource)resource);
        }
        return 0L;
    }

    public boolean isValid(int index, ItemResource resource) {
        if (this.isSlotIndexInvalid(index)) {
            return false;
        }
        int handlerIndex = this.getIndexForSlot(index);
        ResourceHandler<ItemResource> handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex(handler, handlerIndex, index = this.getSlotFromIndex(index, handlerIndex), "isValid(int index, ItemResource resource)")) {
            return handler.isValid(index, (Resource)resource);
        }
        return false;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachFromStoragesAndUnlinkBlocks();
    }

    public void detachFromStoragesAndUnlinkBlocks() {
        this.storagePositions.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
        this.connectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController));
        this.nonConnectingBlocks.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.level, pos, IControllerBoundable.class).ifPresent(IControllerBoundable::unregisterController));
        new HashSet<BlockPos>(this.linkedBlocks).forEach(linkedPos -> WorldHelper.getLoadedBlockEntity(this.level, linkedPos, ILinkable.class).ifPresent(ILinkable::unlinkFromController));
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        this.saveData(out);
    }

    private void saveData(ValueOutput out) {
        ValueIOHelper.saveList(out, "storagePositions", this.storagePositions, BlockPos.CODEC);
        ValueIOHelper.saveList(out, "connectingBlocks", this.connectingBlocks, BlockPos.CODEC);
        ValueIOHelper.saveList(out, "nonConnectingBlocks", this.nonConnectingBlocks, BlockPos.CODEC);
        ValueIOHelper.saveList(out, "linkedBlocks", this.linkedBlocks, BlockPos.CODEC);
        ValueIOHelper.saveList(out, "baseIndexes", this.baseIndexes, ExtraCodecs.POSITIVE_INT);
        out.putInt("totalSlots", this.totalSlots);
    }

    public void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.storagePositions = in.listOrEmpty("storagePositions", BlockPos.CODEC).stream().collect(Collectors.toCollection(ArrayList::new));
        this.setupStoragePositionIndexes();
        this.connectingBlocks = in.listOrEmpty("connectingBlocks", BlockPos.CODEC).stream().collect(Collectors.toCollection(LinkedHashSet::new));
        this.nonConnectingBlocks = in.listOrEmpty("nonConnectingBlocks", BlockPos.CODEC).stream().collect(Collectors.toCollection(LinkedHashSet::new));
        this.baseIndexes = in.listOrEmpty("baseIndexes", ExtraCodecs.POSITIVE_INT).stream().collect(Collectors.toCollection(ArrayList::new));
        this.totalSlots = in.getIntOr("totalSlots", 0);
        this.linkedBlocks = in.listOrEmpty("linkedBlocks", BlockPos.CODEC).stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void setupStoragePositionIndexes() {
        this.storagePositionIndexes.clear();
        for (int i = 0; i < this.storagePositions.size(); ++i) {
            this.storagePositionIndexes.put(this.storagePositions.get(i), i);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return super.getUpdateTag(registries).merge(ValueIOHelper.collectOutputToTag(registries, this::saveData));
    }

    public @Nullable ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void addStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.add(storageBlockPos);
    }

    public void removeStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.remove(storageBlockPos);
    }

    public Set<BlockPos> getLinkedBlocks() {
        return this.linkedBlocks;
    }

    public List<BlockPos> getStoragePositions() {
        return this.storagePositions;
    }

    public void setStorageFilterItems(BlockPos storagePos, Set<Item> filterItems) {
        this.removeStorageFilterItems(storagePos);
        if (filterItems.isEmpty()) {
            return;
        }
        for (Item item : filterItems) {
            this.filterItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        }
        this.storageFilterItems.put(storagePos, new LinkedHashSet<Item>(filterItems));
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.detachFromStoragesAndUnlinkBlocks();
    }

    public boolean hasMatchingStack(ItemStackKey stackKey) {
        return this.stackStorages.containsKey(stackKey) || this.memorizedStackStorages.containsKey(stackKey.hashCode());
    }

    public boolean hasMatchingItem(Item item) {
        return this.itemStackKeys.containsKey(item) || this.memorizedItemStorages.containsKey(item) || this.filterItemStorages.containsKey(item);
    }

    @Override
    public boolean isInsertBlocked() {
        return this.storagePositions.stream().allMatch(pos -> this.getWrapperValueFromHolder((BlockPos)pos, storageWrapper -> storageWrapper.getInventoryHandler().isInsertBlocked()).orElse(true));
    }
}

