/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.IResourceExtractor;
import net.p3pp3rf1y.sophisticatedcore.inventory.IResourceInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import org.jspecify.annotations.Nullable;

public interface IInventoryPartHandler {
    public static final IInventoryPartHandler EMPTY = () -> "EMPTY";

    default public int getSlotLimit(int slot) {
        return 0;
    }

    default public boolean isSlotAccessible(int slot) {
        return false;
    }

    default public int getCapacity(int slot, ItemResource resource) {
        return 0;
    }

    default public int extract(int slot, ItemResource resource, int amount, TransactionContext transaction, IResourceExtractor extractSuper) {
        return 0;
    }

    default public int insert(int slot, ItemResource resource, int amount, TransactionContext transaction, IResourceInserter insertSuper) {
        return 0;
    }

    default public void set(int slot, ItemResource resource, int amount, IndexModifier<ItemResource> setSuper) {
    }

    default public boolean isValid(int slot, ItemResource resource, @Nullable Player player, BiPredicate<Integer, ItemResource> isValidSuper) {
        return false;
    }

    default public boolean canBeReplaced() {
        return false;
    }

    default public int size() {
        return 0;
    }

    public String getName();

    default public @Nullable Identifier getNoItemIcon(int slot) {
        return null;
    }

    default public Item getFilterItem(int slot) {
        return Items.AIR;
    }

    default public void onSlotLimitChange() {
    }

    default public Set<Integer> getNoSortSlots() {
        return Set.of();
    }

    default public void onSlotFilterChanged(int slot) {
    }

    default public boolean isFilterItem(Item item) {
        return false;
    }

    default public Map<Item, Set<Integer>> getFilterItems() {
        return Map.of();
    }

    default public void onInit() {
    }

    default public boolean isInfinite(int slot) {
        return false;
    }

    default public ItemResource getResource(int index, IntFunction<ItemResource> getResourceSuper) {
        return ItemResource.EMPTY;
    }

    default public long getAmountAsLong(int index, IntFunction<Long> amountAsLongSuper) {
        return 0L;
    }

    default public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
        return ItemStack.EMPTY;
    }

    default public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotInternal) {
    }

    public static interface Factory {
        public IInventoryPartHandler create(InventoryHandler var1, SlotRange var2, Supplier<MemorySettingsCategory> var3);
    }

    public static class Default
    implements IInventoryPartHandler {
        public static final String NAME = "default";
        private final InventoryHandler parent;
        private final int slots;

        public Default(InventoryHandler parent, int slots) {
            this.parent = parent;
            this.slots = slots;
        }

        @Override
        public int getSlotLimit(int slot) {
            return this.parent.getBaseSlotLimit();
        }

        @Override
        public int getCapacity(int slot, ItemResource resource) {
            return this.parent.getBaseCapacity(resource);
        }

        @Override
        public int extract(int slot, ItemResource resource, int amount, TransactionContext transaction, IResourceExtractor extractSuper) {
            return extractSuper.extract(slot, resource, amount, transaction);
        }

        @Override
        public int insert(int slot, ItemResource resource, int amount, TransactionContext transaction, IResourceInserter insertSuper) {
            return insertSuper.insert(slot, resource, amount, transaction);
        }

        @Override
        public void set(int slot, ItemResource resource, int amount, IndexModifier<ItemResource> setSuper) {
            setSuper.set(slot, (Resource)resource, amount);
        }

        @Override
        public boolean isValid(int slot, ItemResource resource, @Nullable Player player, BiPredicate<Integer, ItemResource> isValidSuper) {
            return true;
        }

        @Override
        public boolean canBeReplaced() {
            return true;
        }

        @Override
        public boolean isSlotAccessible(int slot) {
            return true;
        }

        @Override
        public int size() {
            return this.slots;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public ItemResource getResource(int index, IntFunction<ItemResource> getResourceSuper) {
            return getResourceSuper.apply(index);
        }

        @Override
        public long getAmountAsLong(int index, IntFunction<Long> amountAsLongSuper) {
            return amountAsLongSuper.apply(index);
        }

        @Override
        public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
            return getStackInSlotSuper.apply(slot);
        }

        @Override
        public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotInternal) {
            setStackInSlotInternal.accept(slot, stack);
        }
    }
}

