/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.SlotValueMap;
import org.apache.logging.log4j.util.Supplier;
import org.jspecify.annotations.Nullable;

public class InventoryHandlerSlotTracker
implements ISlotTracker {
    private final Map<ItemStackKey, Set<Integer>> fullStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> fullSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Map<ItemStackKey, Set<Integer>> partiallyFilledStackSlots = new HashMap<ItemStackKey, Set<Integer>>();
    private final Map<Integer, ItemStackKey> partiallyFilledSlotStacks = new HashMap<Integer, ItemStackKey>();
    private final Map<Item, Set<ItemStackKey>> itemStackKeys = new HashMap<Item, Set<ItemStackKey>>();
    private final Set<Integer> emptySlots = new TreeSet<Integer>();
    private final MemorySettingsCategory memorySettings;
    private final SlotValueMap<Item> filterItemSlots;
    private Consumer<ItemStackKey> onAddStackKey = sk -> {};
    private Consumer<ItemStackKey> onRemoveStackKey = sk -> {};
    private Runnable onAddFirstEmptySlot = () -> {};
    private Runnable onRemoveLastEmptySlot = () -> {};
    private BooleanSupplier shouldInsertIntoEmpty = () -> true;

    public InventoryHandlerSlotTracker(MemorySettingsCategory memorySettings, SlotValueMap<Item> filterItemSlots) {
        this.memorySettings = memorySettings;
        this.filterItemSlots = filterItemSlots;
    }

    @Override
    public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        this.shouldInsertIntoEmpty = shouldInsertIntoEmpty;
    }

    public void addPartiallyFilled(int slot, ItemStack stack) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        this.partiallyFilledStackSlots.computeIfAbsent(stackKey, k -> {
            if (!this.fullStackSlots.containsKey(k)) {
                this.onAddStackKey.accept((ItemStackKey)k);
            }
            return new TreeSet();
        }).add(slot);
        this.partiallyFilledSlotStacks.put(slot, stackKey);
        this.itemStackKeys.computeIfAbsent(stack.getItem(), i -> new HashSet()).add(stackKey);
    }

    @Override
    public Set<ItemStackKey> getFullStacks() {
        return this.fullStackSlots.keySet();
    }

    @Override
    public Set<Integer> getFullSlots(ItemStackKey key) {
        return this.fullStackSlots.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<ItemStackKey> getPartialStacks() {
        return this.partiallyFilledStackSlots.keySet();
    }

    @Override
    public boolean hasExactStackMemorized(ItemStackKey stackKey) {
        return this.memorySettings.matchesStackKey(stackKey);
    }

    @Override
    public boolean hasItemMemorizedOrFiltered(Item item) {
        return this.memorySettings.matchesItem(item) || this.filterItemSlots.containsValue(item);
    }

    @Override
    public Set<Item> getItems() {
        return this.itemStackKeys.keySet();
    }

    public void addFull(int slot, ItemStack stack) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        this.fullStackSlots.computeIfAbsent(stackKey, k -> {
            if (!this.partiallyFilledStackSlots.containsKey(k)) {
                this.onAddStackKey.accept((ItemStackKey)k);
            }
            return new TreeSet();
        }).add(slot);
        this.fullSlotStacks.put(slot, stackKey);
        this.itemStackKeys.computeIfAbsent(stack.getItem(), i -> new HashSet()).add(stackKey);
    }

    public void removePartiallyFilled(int slot) {
        if (this.partiallyFilledSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.partiallyFilledSlotStacks.remove(slot);
            @Nullable Set<Integer> partialSlots = this.partiallyFilledStackSlots.get(stackKey);
            if (partialSlots == null) {
                SophisticatedCore.LOGGER.error("Unstable ItemStack detected in slot tracking: {}", new Supplier[]{() -> stackKey != null ? stackKey.stack().toString() : "null"});
            } else {
                partialSlots.remove(slot);
            }
            if (partialSlots == null || partialSlots.isEmpty()) {
                this.partiallyFilledStackSlots.remove(stackKey);
                if (!this.fullStackSlots.containsKey(stackKey)) {
                    this.onStackKeyRemoved(stackKey);
                }
            }
        }
    }

    private void removeFull(int slot) {
        if (this.fullSlotStacks.containsKey(slot)) {
            ItemStackKey stackKey = this.fullSlotStacks.remove(slot);
            @Nullable Set<Integer> fullSlots = this.fullStackSlots.get(stackKey);
            if (fullSlots == null) {
                SophisticatedCore.LOGGER.error("Unstable ItemStack detected in slot tracking: {}", new Supplier[]{() -> stackKey != null ? stackKey.stack().toString() : "null"});
            } else {
                fullSlots.remove(slot);
            }
            if (fullSlots == null || fullSlots.isEmpty()) {
                this.fullStackSlots.remove(stackKey);
                if (!this.partiallyFilledStackSlots.containsKey(stackKey)) {
                    this.onStackKeyRemoved(stackKey);
                }
            }
        }
    }

    private void onStackKeyRemoved(ItemStackKey stackKey) {
        this.itemStackKeys.computeIfPresent(stackKey.stack().getItem(), (i, stackKeys) -> {
            stackKeys.remove(stackKey);
            return stackKeys;
        });
        if (this.itemStackKeys.containsKey(stackKey.stack().getItem()) && this.itemStackKeys.get(stackKey.stack().getItem()).isEmpty()) {
            this.itemStackKeys.remove(stackKey.stack().getItem());
        }
        this.onRemoveStackKey.accept(stackKey);
    }

    @Override
    public void removeAndSetSlotIndexes(InventoryHandler inventoryHandler, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            this.removePartiallyFilled(slot);
            this.removeFull(slot);
            if (inventoryHandler.isSlotAccessible(slot)) {
                this.addEmptySlot(slot);
            }
            return;
        }
        if (this.emptySlots.contains(slot)) {
            this.removeEmpty(slot);
        }
        if (this.isPartiallyFilled(inventoryHandler, slot, stack)) {
            this.setPartiallyFilled(slot, stack);
        } else {
            this.setFull(slot, stack);
        }
    }

    private void setFull(int slot, ItemStack stack) {
        boolean containsSlot = this.fullSlotStacks.containsKey(slot);
        if (!containsSlot || this.fullSlotStacks.get(slot).hashCodeNotEquals(stack)) {
            if (containsSlot) {
                this.removeFull(slot);
            }
            this.addFull(slot, stack);
        }
        if (this.partiallyFilledSlotStacks.containsKey(slot)) {
            this.removePartiallyFilled(slot);
        }
    }

    private void setPartiallyFilled(int slot, ItemStack stack) {
        boolean containsSlot = this.partiallyFilledSlotStacks.containsKey(slot);
        if (!containsSlot || this.partiallyFilledSlotStacks.get(slot).hashCodeNotEquals(stack)) {
            if (containsSlot) {
                this.removePartiallyFilled(slot);
            }
            this.addPartiallyFilled(slot, stack);
        }
        if (this.fullSlotStacks.containsKey(slot)) {
            this.removeFull(slot);
        }
    }

    private void removeEmpty(int slot) {
        this.emptySlots.remove(slot);
        if (this.emptySlots.isEmpty()) {
            this.onRemoveLastEmptySlot.run();
        }
    }

    private void set(InventoryHandler inventoryHandler, int slot, ItemStack stack) {
        if (stack.isEmpty()) {
            if (inventoryHandler.isSlotAccessible(slot)) {
                this.addEmptySlot(slot);
            }
        } else if (this.isPartiallyFilled(inventoryHandler, slot, stack)) {
            this.addPartiallyFilled(slot, stack);
        } else {
            this.addFull(slot, stack);
        }
    }

    private void addEmptySlot(int slot) {
        this.emptySlots.add(slot);
        if (this.emptySlots.size() == 1) {
            this.onAddFirstEmptySlot.run();
        }
    }

    @Override
    public void clear() {
        this.partiallyFilledStackSlots.clear();
        this.partiallyFilledSlotStacks.clear();
    }

    @Override
    public void refreshSlotIndexesFrom(InventoryHandler itemHandler) {
        this.fullStackSlots.keySet().forEach(sk -> this.onRemoveStackKey.accept((ItemStackKey)sk));
        this.fullStackSlots.clear();
        this.fullSlotStacks.clear();
        this.partiallyFilledStackSlots.keySet().forEach(sk -> this.onRemoveStackKey.accept((ItemStackKey)sk));
        this.partiallyFilledStackSlots.clear();
        this.partiallyFilledSlotStacks.clear();
        this.itemStackKeys.clear();
        this.emptySlots.clear();
        this.onRemoveLastEmptySlot.run();
        for (int slot = 0; slot < itemHandler.size(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            this.set(itemHandler, slot, stack);
        }
    }

    private boolean isPartiallyFilled(InventoryHandler itemHandler, int slot, ItemStack stack) {
        return stack.getCount() < itemHandler.getCapacityNoInit(slot, ItemResource.of((ItemStack)stack));
    }

    @Override
    public void registerListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.onAddStackKey = onAddStackKey;
        this.onRemoveStackKey = onRemoveStackKey;
        this.onAddFirstEmptySlot = onAddFirstEmptySlot;
        this.onRemoveLastEmptySlot = onRemoveLastEmptySlot;
    }

    @Override
    public void unregisterStackKeyListeners() {
        this.onAddStackKey = sk -> {};
        this.onRemoveStackKey = sk -> {};
    }

    @Override
    public boolean hasEmptySlots() {
        return this.shouldInsertIntoEmpty.getAsBoolean() && !this.emptySlots.isEmpty();
    }

    @Override
    public int getFirstMatchingSlot(ItemStackKey stackKey) {
        Set<Integer> slots = this.partiallyFilledStackSlots.get(stackKey);
        if (slots != null && !slots.isEmpty()) {
            return slots.iterator().next();
        }
        slots = this.fullStackSlots.get(stackKey);
        if (slots != null && !slots.isEmpty()) {
            return slots.iterator().next();
        }
        return -1;
    }

    @Override
    public Set<Integer> getPartialSlots(ItemStackKey key) {
        return this.partiallyFilledStackSlots.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public Set<Integer> getEmptySlots() {
        return this.emptySlots;
    }
}

