/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartRegistry;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import org.jspecify.annotations.Nullable;

public class InventoryPartitioner {
    private IInventoryPartHandler[] inventoryPartHandlers;
    private ContainerContents.PartitionerData partitionerData;
    private final InventoryHandler parent;

    public InventoryPartitioner(ContainerContents.PartitionerData partitionerData, InventoryHandler parent, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.parent = parent;
        this.partitionerData = partitionerData;
        this.initPartHandlers(partitionerData, getMemorySettings);
    }

    private int getIndexForSlot(int slot) {
        int i;
        if (slot < 0) {
            return -1;
        }
        if (this.partitionerData.baseIndexes().length == 1) {
            return 0;
        }
        for (i = 0; i < this.partitionerData.baseIndexes().length; ++i) {
            if (slot - this.partitionerData.baseIndexes()[i] >= 0) continue;
            return i - 1;
        }
        return i - 1;
    }

    public IInventoryPartHandler getPartBySlot(int slot) {
        if (slot < 0 || slot >= this.parent.size()) {
            return IInventoryPartHandler.EMPTY;
        }
        int index = this.getIndexForSlot(slot);
        if (index < 0 || index >= this.inventoryPartHandlers.length) {
            return IInventoryPartHandler.EMPTY;
        }
        return this.inventoryPartHandlers[index];
    }

    public @Nullable Identifier getNoItemIcon(int slot) {
        return this.getPartBySlot(slot).getNoItemIcon(slot);
    }

    public void onSlotLimitChange() {
        for (IInventoryPartHandler inventoryPartHandler : this.inventoryPartHandlers) {
            inventoryPartHandler.onSlotLimitChange();
        }
    }

    public Set<Integer> getNoSortSlots() {
        HashSet<Integer> noSortSlots = new HashSet<Integer>();
        for (IInventoryPartHandler inventoryPartHandler : this.inventoryPartHandlers) {
            noSortSlots.addAll(inventoryPartHandler.getNoSortSlots());
        }
        return noSortSlots;
    }

    public boolean isFilterItem(Item item) {
        for (IInventoryPartHandler inventoryPartHandler : this.inventoryPartHandlers) {
            if (!inventoryPartHandler.isFilterItem(item)) continue;
            return true;
        }
        return false;
    }

    public Map<Item, Set<Integer>> getFilterItems() {
        HashMap<Item, Set<Integer>> filterItems = new HashMap<Item, Set<Integer>>();
        for (IInventoryPartHandler inventoryPartHandler : this.inventoryPartHandlers) {
            for (Map.Entry<Item, Set<Integer>> entry : inventoryPartHandler.getFilterItems().entrySet()) {
                filterItems.computeIfAbsent(entry.getKey(), k -> new HashSet()).addAll((Collection)entry.getValue());
            }
        }
        return filterItems;
    }

    public void onInit() {
        for (IInventoryPartHandler inventoryPartHandler : this.inventoryPartHandlers) {
            inventoryPartHandler.onInit();
        }
    }

    public Optional<SlotRange> getFirstSpace(int maxNumberOfSlots) {
        for (int partIndex = 0; partIndex < this.inventoryPartHandlers.length; ++partIndex) {
            if (!this.inventoryPartHandlers[partIndex].canBeReplaced()) continue;
            int firstSlot = this.partitionerData.baseIndexes()[partIndex];
            int numberOfSlots = this.partitionerData.baseIndexes().length > partIndex + 1 ? this.partitionerData.baseIndexes()[partIndex + 1] - firstSlot : this.parent.size() - firstSlot;
            numberOfSlots = Math.min(numberOfSlots, maxNumberOfSlots);
            return numberOfSlots > 0 ? Optional.of(new SlotRange(this.partitionerData.baseIndexes()[partIndex], numberOfSlots)) : Optional.empty();
        }
        return Optional.empty();
    }

    public void addInventoryPart(int inventorySlot, int numberOfSlots, IInventoryPartHandler inventoryPartHandler) {
        int index = this.getIndexForSlot(inventorySlot);
        if (index < 0 || index >= this.inventoryPartHandlers.length || this.partitionerData.baseIndexes()[index] != inventorySlot) {
            return;
        }
        ArrayList<IInventoryPartHandler> newParts = new ArrayList<IInventoryPartHandler>();
        ArrayList<Integer> newBaseIndexes = new ArrayList<Integer>();
        for (int i = 0; i < index; ++i) {
            newParts.add(this.inventoryPartHandlers[i]);
            newBaseIndexes.add(this.partitionerData.baseIndexes()[i]);
        }
        newParts.add(inventoryPartHandler);
        newBaseIndexes.add(inventorySlot);
        int newNextSlot = inventorySlot + numberOfSlots;
        if (this.inventoryPartHandlers[index].size() > newNextSlot) {
            newParts.add(new IInventoryPartHandler.Default(this.parent, this.parent.size() - newNextSlot));
            newBaseIndexes.add(newNextSlot);
        }
        for (int i = index + 1; i < this.inventoryPartHandlers.length; ++i) {
            newParts.add(this.inventoryPartHandlers[i]);
            newBaseIndexes.add(this.partitionerData.baseIndexes()[i]);
        }
        this.updatePartsAndIndexesFromLists(newParts, newBaseIndexes);
        inventoryPartHandler.onInit();
        this.parent.onFilterItemsChanged();
    }

    public void removeInventoryPart(int inventorySlot) {
        int i;
        int index = this.getIndexForSlot(inventorySlot);
        if (index < 0 || index >= this.inventoryPartHandlers.length || this.partitionerData.baseIndexes()[index] != inventorySlot) {
            return;
        }
        if (this.inventoryPartHandlers.length == 1) {
            this.updatePartsAndIndexesFromLists(List.of(new IInventoryPartHandler.Default(this.parent, this.parent.size())), List.of(Integer.valueOf(0)));
            this.parent.onFilterItemsChanged();
            return;
        }
        int slotsAtPartIndex = (this.partitionerData.baseIndexes().length > index + 1 ? this.partitionerData.baseIndexes()[index + 1] : this.parent.size()) - this.partitionerData.baseIndexes()[index];
        ArrayList<IInventoryPartHandler> newParts = new ArrayList<IInventoryPartHandler>();
        ArrayList<Integer> newBaseIndexes = new ArrayList<Integer>();
        boolean replacedNext = false;
        for (i = 0; i < index; ++i) {
            if (i == index - 1 && this.inventoryPartHandlers[i] instanceof IInventoryPartHandler.Default && this.partitionerData.baseIndexes().length > index + 1 && this.inventoryPartHandlers[index + 1] instanceof IInventoryPartHandler.Default) {
                newParts.add(new IInventoryPartHandler.Default(this.parent, this.inventoryPartHandlers[i].size() + this.inventoryPartHandlers[index + 1].size() + slotsAtPartIndex));
                newBaseIndexes.add(this.partitionerData.baseIndexes()[i]);
                replacedNext = true;
                continue;
            }
            newParts.add(this.inventoryPartHandlers[i]);
            newBaseIndexes.add(this.partitionerData.baseIndexes()[i]);
        }
        if (!replacedNext && this.partitionerData.baseIndexes().length > index + 1) {
            if (this.inventoryPartHandlers[index + 1] instanceof IInventoryPartHandler.Default) {
                newParts.add(new IInventoryPartHandler.Default(this.parent, this.inventoryPartHandlers[index + 1].size() + slotsAtPartIndex));
                newBaseIndexes.add(inventorySlot);
            } else {
                newParts.add(new IInventoryPartHandler.Default(this.parent, slotsAtPartIndex));
                newBaseIndexes.add(inventorySlot);
                newParts.add(this.inventoryPartHandlers[index + 1]);
                newBaseIndexes.add(this.partitionerData.baseIndexes()[index + 1]);
            }
        }
        for (i = index + 2; i < this.inventoryPartHandlers.length; ++i) {
            newParts.add(this.inventoryPartHandlers[i]);
            newBaseIndexes.add(this.partitionerData.baseIndexes()[i]);
        }
        this.updatePartsAndIndexesFromLists(newParts, newBaseIndexes);
        this.parent.onFilterItemsChanged();
    }

    private void updatePartsAndIndexesFromLists(List<IInventoryPartHandler> newParts, List<Integer> newBaseIndexes) {
        this.inventoryPartHandlers = newParts.toArray(new IInventoryPartHandler[0]);
        int[] baseIndexes = newBaseIndexes.stream().mapToInt(i -> i).toArray();
        ArrayList<String> partNames = new ArrayList<String>();
        for (int i2 = 0; i2 < newBaseIndexes.size(); ++i2) {
            partNames.add(this.inventoryPartHandlers[i2].getName());
        }
        this.partitionerData.setPartBaseIndexesAndNames(baseIndexes, partNames);
        this.parent.saveInventory();
    }

    private void initPartHandlers(ContainerContents.PartitionerData partitionerData, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.inventoryPartHandlers = new IInventoryPartHandler[partitionerData.baseIndexes().length];
        int i = 0;
        for (String partName : partitionerData.partNames()) {
            SlotRange slotRange = new SlotRange(partitionerData.baseIndexes()[i], (i + 1 < partitionerData.baseIndexes().length ? partitionerData.baseIndexes()[i + 1] : this.parent.size()) - partitionerData.baseIndexes()[i]);
            int finalI = i++;
            this.inventoryPartHandlers[finalI] = InventoryPartRegistry.instantiatePart(partName, this.parent, slotRange, getMemorySettings);
        }
    }

    public boolean isInfinite(int slot) {
        return this.getPartBySlot(slot).isInfinite(slot);
    }
}

