/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import org.apache.commons.io.IOUtils;

public class DatapackSettingsTemplateManager {
    private static final Map<String, Map<String, ContainerContents.SettingsData>> TEMPLATES = Maps.newHashMap();

    private DatapackSettingsTemplateManager() {
    }

    public static void putTemplate(String datapackName, String templateName, ContainerContents.SettingsData data) {
        templateName = templateName.replace('_', ' ');
        templateName = DatapackSettingsTemplateManager.capitalizeFirstLetterOfEachWord(templateName);
        TEMPLATES.computeIfAbsent(datapackName, n -> Maps.newTreeMap()).put(templateName, data);
    }

    private static String capitalizeFirstLetterOfEachWord(String input) {
        String[] words = input.split("\\s+");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            String capitalizedWord = word.substring(0, 1).toUpperCase() + word.substring(1);
            builder.append(capitalizedWord).append(" ");
        }
        return builder.toString().trim();
    }

    public static Map<String, Map<String, ContainerContents.SettingsData>> getTemplates() {
        return TEMPLATES;
    }

    public static Optional<ContainerContents.SettingsData> getTemplateData(String datapackName, String templateName) {
        Map<String, ContainerContents.SettingsData> datapackTemplates = TEMPLATES.get(datapackName);
        if (datapackTemplates == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(datapackTemplates.get(templateName));
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<Identifier, ContainerContents.SettingsData>> {
        public static final Identifier KEY = SophisticatedCore.getIdentifier("settings_templates");
        public static final Loader INSTANCE = new Loader();
        private static final String DIRECTORY = "sophisticated_settingstemplates";
        private static final String SUFFIX = ".snbt";
        private static final int PATH_SUFFIX_LENGTH = ".snbt".length();

        private Loader() {
        }

        protected Map<Identifier, ContainerContents.SettingsData> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            HashMap map = Maps.newHashMap();
            int i = DIRECTORY.length() + 1;
            resourceManager.listResources(DIRECTORY, fileName -> fileName.getPath().endsWith(SUFFIX)).forEach((identifier, resource) -> {
                String s = identifier.getPath();
                Identifier identifierWithoutSuffix = Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
                try (InputStream inputstream = resource.open();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    String fileContents = IOUtils.toString((Reader)reader);
                    RegistryOps ops = this.getRegistryLookup().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                    Pair decodeResult = (Pair)ContainerContents.SettingsData.CODEC.decode((DynamicOps)ops, (Object)TagParser.parseCompoundFully((String)fileContents)).getOrThrow();
                    if (map.put(identifierWithoutSuffix, (ContainerContents.SettingsData)decodeResult.getFirst()) != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(identifierWithoutSuffix));
                    }
                }
                catch (CommandSyntaxException | IOException | IllegalArgumentException | IllegalStateException ex) {
                    SophisticatedCore.LOGGER.error("Couldn't parse data file {} from {}", (Object)identifierWithoutSuffix, identifier, (Object)ex);
                }
            });
            return map;
        }

        protected void apply(Map<Identifier, ContainerContents.SettingsData> templates, ResourceManager resourceManager, ProfilerFiller profiler) {
            templates.forEach((identifier, data) -> {
                String datapackName = identifier.getNamespace();
                String templateName = identifier.getPath().substring(identifier.getPath().lastIndexOf(47) + 1);
                DatapackSettingsTemplateManager.putTemplate(datapackName, templateName, data);
            });
        }
    }
}

