/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;

public class ItemDisplaySettingsCategory
implements ISettingsCategory<ItemDisplaySettingsCategory, ItemDisplaySettingsCategoryData>,
ISlotColorCategory {
    public static final String NAME = "item_display";
    private final Supplier<InventoryHandler> inventoryHandlerSupplier;
    private final Supplier<RenderDataHandler> renderDataHandlerSupplier;
    private final Runnable save;
    private final int itemNumberLimit;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private ItemDisplaySettingsCategoryData data;

    public ItemDisplaySettingsCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderDataHandler> renderDataHandlerSupplier, ItemDisplaySettingsCategoryData data, Runnable save, int itemNumberLimit, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.inventoryHandlerSupplier = inventoryHandlerSupplier;
        this.renderDataHandlerSupplier = renderDataHandlerSupplier;
        this.data = data;
        this.save = save;
        this.itemNumberLimit = itemNumberLimit;
        this.getMemorySettings = getMemorySettings;
    }

    public int getItemNumberLimit() {
        return this.itemNumberLimit;
    }

    public void unselectSlot(int slotIndex) {
        this.data.removeSlotIndex(slotIndex);
        this.save();
        this.updateFullRenderData();
    }

    private boolean haveRenderedItemsChanged() {
        List<RenderData.DisplayItemData> previousDisplayItems = this.renderDataHandlerSupplier.get().getDisplayData().displayItems();
        List<Integer> inaccessibleSlots = this.renderDataHandlerSupplier.get().getDisplayData().inaccessibleSlots();
        if (previousDisplayItems.size() != this.data.slotIndexes().size()) {
            return true;
        }
        int i = 0;
        InventoryHandler inventoryHandler = this.inventoryHandlerSupplier.get();
        for (int slotIndex : this.data.slotIndexes()) {
            ItemStack newItem = this.getSlotItemCopy(slotIndex).orElse(ItemStack.EMPTY);
            ItemStack stack = previousDisplayItems.get(i).item();
            if (ItemStack.hashItemAndComponents((ItemStack)newItem) != ItemStack.hashItemAndComponents((ItemStack)stack) || inaccessibleSlots.contains(slotIndex) == inventoryHandler.isSlotAccessible(slotIndex)) {
                return true;
            }
            ++i;
        }
        return i != previousDisplayItems.size();
    }

    private boolean haveCountsOrFillRatiosChanged(InventoryHandler inventoryHandler) {
        if (this.renderDataHandlerSupplier.get().showsCountsAndFillRatios()) {
            List<Integer> previousSlotCounts = this.renderDataHandlerSupplier.get().getDisplayData().slotCounts();
            List<Float> previousSlotFillRatios = this.renderDataHandlerSupplier.get().getDisplayData().slotFillRatios();
            List<Integer> previousInfiniteSlots = this.renderDataHandlerSupplier.get().getDisplayData().infiniteSlots();
            if (previousSlotCounts.size() != inventoryHandler.size() || previousSlotFillRatios.size() != inventoryHandler.size()) {
                return true;
            }
            for (int slotIndex = 0; slotIndex < inventoryHandler.size(); ++slotIndex) {
                int previousSlotCount = previousSlotCounts.get(slotIndex);
                float previousSlotFillRatio = previousSlotFillRatios.get(slotIndex).floatValue();
                ItemStack stack = inventoryHandler.getStackInSlot(slotIndex);
                float currentSlotFillRatio = ItemDisplaySettingsCategory.calculateSlotFillRatio(stack, inventoryHandler, slotIndex);
                if (previousSlotCount == stack.getCount() && previousInfiniteSlots.contains(slotIndex) == inventoryHandler.isInfinite(slotIndex) && MathHelper.epsilonEquals(previousSlotFillRatio, currentSlotFillRatio)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateFullRenderData() {
        ArrayList<RenderData.DisplayItemData> displayItems = new ArrayList<RenderData.DisplayItemData>();
        ArrayList<Integer> inaccessibleSlots = new ArrayList<Integer>();
        InventoryHandler inventoryHandler = this.inventoryHandlerSupplier.get();
        this.collectDisplayItemsAndInaccessibleSlots(displayItems, inventoryHandler, inaccessibleSlots);
        ArrayList<Integer> slotCounts = new ArrayList<Integer>();
        ArrayList<Float> slotFillRatios = new ArrayList<Float>();
        ArrayList<Integer> infiniteSlots = new ArrayList<Integer>();
        RenderDataHandler renderDataHandler = this.renderDataHandlerSupplier.get();
        this.collectSlotCountsSlotFillRatiosAndInfiniteSlots(renderDataHandler, inventoryHandler, slotCounts, slotFillRatios, infiniteSlots);
        renderDataHandler.refreshDisplayData(displayItems, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
    }

    private void collectSlotCountsSlotFillRatiosAndInfiniteSlots(RenderDataHandler renderDataHandler, InventoryHandler inventoryHandler, List<Integer> slotCounts, List<Float> slotFillRatios, List<Integer> infiniteSlots) {
        if (renderDataHandler.showsCountsAndFillRatios()) {
            for (int slotIndex = 0; slotIndex < inventoryHandler.size(); ++slotIndex) {
                ItemStack stack = inventoryHandler.getStackInSlot(slotIndex);
                slotCounts.add(stack.getCount());
                slotFillRatios.add(Float.valueOf(ItemDisplaySettingsCategory.calculateSlotFillRatio(stack, inventoryHandler, slotIndex)));
                if (!inventoryHandler.isInfinite(slotIndex)) continue;
                infiniteSlots.add(slotIndex);
            }
        }
    }

    private void collectDisplayItemsAndInaccessibleSlots(List<RenderData.DisplayItemData> displayItems, InventoryHandler inventoryHandler, List<Integer> inaccessibleSlots) {
        for (int slotIndex : this.data.slotIndexes()) {
            displayItems.add(new RenderData.DisplayItemData(this.getSlotItemCopy(slotIndex).orElse(ItemStack.EMPTY), this.data.slotRotations().getOrDefault(slotIndex, 0), slotIndex, this.data.displaySide()));
            if (inventoryHandler.isSlotAccessible(slotIndex)) continue;
            inaccessibleSlots.add(slotIndex);
        }
    }

    private void updateDisplayItemsAndInaccessibleSlots() {
        ArrayList<RenderData.DisplayItemData> displayItems = new ArrayList<RenderData.DisplayItemData>();
        ArrayList<Integer> inaccessibleSlots = new ArrayList<Integer>();
        InventoryHandler inventoryHandler = this.inventoryHandlerSupplier.get();
        this.collectDisplayItemsAndInaccessibleSlots(displayItems, inventoryHandler, inaccessibleSlots);
        this.renderDataHandlerSupplier.get().refreshDisplayItemsAndInaccessibleSlots(displayItems, inaccessibleSlots);
    }

    private void updateCountsFillRatiosAndInfiniteSlots() {
        ArrayList<Integer> slotCounts = new ArrayList<Integer>();
        ArrayList<Float> slotFillRatios = new ArrayList<Float>();
        ArrayList<Integer> infiniteSlots = new ArrayList<Integer>();
        RenderDataHandler renderDataHandler = this.renderDataHandlerSupplier.get();
        this.collectSlotCountsSlotFillRatiosAndInfiniteSlots(renderDataHandler, this.inventoryHandlerSupplier.get(), slotCounts, slotFillRatios, infiniteSlots);
        renderDataHandler.refreshSlotCountsFillRatiosAndInfiniteSlots(slotCounts, slotFillRatios, infiniteSlots);
    }

    private static float calculateSlotFillRatio(ItemStack stack, InventoryHandler inventoryHandler, int slotIndex) {
        return stack.isEmpty() ? 0.0f : (float)stack.getCount() / (float)inventoryHandler.getCapacityAsInt(slotIndex, (Resource)ItemResource.of((ItemStack)stack));
    }

    private Optional<ItemStack> getSlotItemCopy(int slotIndex) {
        ItemStack slotStack = this.inventoryHandlerSupplier.get().getStackInSlot(slotIndex);
        if (slotStack.isEmpty()) {
            Item filterItem = this.inventoryHandlerSupplier.get().getFilterItem(slotIndex);
            if (filterItem != Items.AIR) {
                return Optional.of(new ItemStack((ItemLike)filterItem));
            }
            return this.getMemorySettings.get().getSlotFilterStack(slotIndex, true);
        }
        ItemStack stackCopy = slotStack.copy();
        stackCopy.setCount(1);
        return Optional.of(stackCopy);
    }

    public void selectSlot(int slotIndex) {
        if (this.data.slotIndexes().size() + 1 > this.itemNumberLimit) {
            return;
        }
        this.data.slotIndexes().add(slotIndex);
        this.save();
        this.updateFullRenderData();
    }

    private void save() {
        this.save.run();
    }

    public List<Integer> getSlots() {
        return this.data.slotIndexes();
    }

    public int getRotation(int slotIndex) {
        return this.data.slotRotations().getOrDefault(slotIndex, 0);
    }

    public void rotate(int slotIndex, boolean clockwise) {
        if (!this.data.slotIndexes().contains(slotIndex)) {
            return;
        }
        int rotation = this.getRotation(slotIndex);
        rotation = (rotation + (clockwise ? 1 : -1) * 45 + 360) % 360;
        this.data.setRotation(slotIndex, rotation);
        this.save();
        this.updateFullRenderData();
    }

    public void setColor(DyeColor color) {
        this.data.setColor(color);
        this.save();
    }

    public DyeColor getColor() {
        return this.data.color();
    }

    public DisplaySide getDisplaySide() {
        return this.data.displaySide();
    }

    public void setDisplaySide(DisplaySide displaySide) {
        this.data.setDisplaySide(displaySide);
        this.save();
        this.updateFullRenderData();
    }

    @Override
    public void reloadFrom(ItemDisplaySettingsCategoryData data) {
        this.data = data;
    }

    @Override
    public void overwriteWith(ItemDisplaySettingsCategory otherCategory) {
        this.data = otherCategory.data.copy();
        this.save();
        this.itemsChanged();
    }

    public void itemChanged(int changedSlotIndex) {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER || !this.data.slotIndexes().contains(changedSlotIndex)) {
            return;
        }
        if (this.haveRenderedItemsChanged()) {
            this.updateDisplayItemsAndInaccessibleSlots();
        }
        if (this.haveCountsOrFillRatiosChanged(this.inventoryHandlerSupplier.get())) {
            this.updateCountsFillRatiosAndInfiniteSlots();
        }
    }

    public void itemsChanged() {
        if (Thread.currentThread().getThreadGroup() != SidedThreadGroups.SERVER) {
            return;
        }
        if (this.haveRenderedItemsChanged()) {
            this.updateDisplayItemsAndInaccessibleSlots();
        }
        if (this.haveCountsOrFillRatiosChanged(this.inventoryHandlerSupplier.get())) {
            this.updateCountsFillRatiosAndInfiniteSlots();
        }
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.data.slotIndexes().contains(slotNumber) ? Optional.of(this.data.color().getTextureDiffuseColor()) : Optional.empty();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slotIndex = minSlot; slotIndex < maxSlot; ++slotIndex) {
            if (this.data.slotIndexes().size() + 1 > this.itemNumberLimit) {
                return;
            }
            this.data.addSlot(slotIndex);
        }
        this.save();
        this.updateFullRenderData();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return this.data.slotIndexes().stream().anyMatch(slotIndex -> slotIndex >= slots);
    }

    @Override
    public void copyTo(ItemDisplaySettingsCategory otherCategory, int startFromSlot, int slotOffset) {
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
        this.data.removeSlot(slotIndex);
        this.save();
    }
}

