/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotStackAccessor;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public class UpgradeHandler
extends ItemStacksResourceHandler
implements ISlotStackAccessor,
IndexModifier<ItemResource> {
    public static final String UPGRADE_INVENTORY_TAG = "upgradeInventory";
    private final IStorageWrapper storageWrapper;
    private final Runnable contentsSaveHandler;
    private final Runnable onInvalidateUpgradeCaches;
    private final ContainerContents.UpgradeData upgradeData;
    private @Nullable Runnable refreshCallBack = null;
    private final Map<Integer, IUpgradeWrapper> slotWrappers = new LinkedHashMap<Integer, IUpgradeWrapper>();
    private final Map<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>> typeWrappers = new HashMap<UpgradeType<? extends IUpgradeWrapper>, List<? extends IUpgradeWrapper>>();
    private boolean justSavingNbtChange = false;
    private boolean wrappersInitialized = false;
    private boolean typeWrappersInitialized = false;
    private @Nullable IUpgradeWrapperAccessor wrapperAccessor = null;
    private boolean persistent = true;
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();
    private final Set<Integer> runningOnBeforeRemovedOnSlots = new HashSet<Integer>();

    public UpgradeHandler(int numberOfUpgradeSlots, IStorageWrapper storageWrapper, ContainerContents containerContents, Runnable contentsSaveHandler, Runnable onInvalidateUpgradeCaches) {
        super(numberOfUpgradeSlots);
        this.upgradeData = containerContents.upgrades();
        this.storageWrapper = storageWrapper;
        this.contentsSaveHandler = contentsSaveHandler;
        this.onInvalidateUpgradeCaches = onInvalidateUpgradeCaches;
        this.loadUpgradesFromData();
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && storageWrapper.getRenderDataHandler().getUpgradeItems().size() != this.size()) {
            this.setRenderUpgradeItems();
        }
    }

    private void loadUpgradesFromData() {
        this.stacks = NonNullList.withSize((int)Math.max(this.stacks.size(), this.upgradeData.stacks().size()), (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < this.upgradeData.stacks().size(); ++slot) {
            ItemStack stack = (ItemStack)this.upgradeData.stacks().get(slot);
            this.stacks.set(slot, (Object)stack);
        }
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }

    public boolean isValid(int index, ItemResource resource) {
        return resource.isEmpty() || resource.getItem() instanceof IUpgradeItem;
    }

    protected void onContentsChanged(int slot, ItemStack previousContents) {
        super.onContentsChanged(slot, (Object)previousContents);
        if (this.persistent) {
            this.saveInventory();
            this.contentsSaveHandler.run();
        }
        ItemStack currentStack = this.getStackInSlot(slot);
        if (!this.justSavingNbtChange) {
            this.refreshUpgradeWrappers();
            this.setRenderUpgradeItems();
        }
        if (ItemStack.isSameItemSameComponents((ItemStack)previousContents, (ItemStack)currentStack)) {
            return;
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && !currentStack.isEmpty()) {
            this.onUpgradeAdded(slot);
        }
    }

    public void setRenderUpgradeItems() {
        ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
        InventoryHelper.iterate((ResourceHandler<ItemResource>)this, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(upgradeSlot, resource, amount) -> upgradeItems.add(resource.toStack(1))));
        this.storageWrapper.getRenderDataHandler().setUpgradeItems(upgradeItems);
    }

    public void deserialize(ValueInput input) {
        input.read("stacks", this.codec).ifPresent(list -> {
            NonNullList maxSized = list;
            if (this.stacks.size() != list.size()) {
                int newSize = Math.max(this.stacks.size(), list.size());
                maxSized = NonNullList.withSize((int)newSize, (Object)ItemStack.EMPTY);
                Collections.copy(maxSized, list);
            }
            this.stacks = maxSized;
        });
    }

    public void saveInventory() {
        NonNullList stacksCopy = NonNullList.withSize((int)this.stacks.size(), (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            stacksCopy.set(slot, (Object)((ItemStack)this.stacks.get(slot)));
        }
        this.upgradeData.setStacks((NonNullList<ItemStack>)stacksCopy);
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setRefreshCallBack(Runnable refreshCallBack) {
        this.refreshCallBack = refreshCallBack;
    }

    public void removeRefreshCallback() {
        this.refreshCallBack = null;
    }

    private void initializeWrappers() {
        if (this.wrappersInitialized) {
            return;
        }
        this.wrappersInitialized = true;
        this.slotWrappers.clear();
        this.typeWrappers.clear();
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        InventoryHelper.iterate(this, (slot, stack) -> {
            if (stack.isEmpty() || !(stack.getItem() instanceof IUpgradeItem)) {
                return;
            }
            UpgradeType type = ((IUpgradeItem)stack.getItem()).getType();
            Object wrapper = type.create(this.storageWrapper, (ItemStack)stack, upgradeStack -> {
                this.justSavingNbtChange = true;
                this.setStackInSlot((int)slot, (ItemStack)upgradeStack);
                this.justSavingNbtChange = false;
            });
            this.setUpgradeDefaults((IUpgradeWrapper)wrapper);
            this.slotWrappers.put((Integer)slot, (IUpgradeWrapper)wrapper);
        });
        this.initRenderDataCallbacks(false);
    }

    private void onUpgradeAdded(int slot) {
        Map<Integer, IUpgradeWrapper> wrappers = this.getSlotWrappers();
        if (wrappers.containsKey(slot)) {
            wrappers.get(slot).onAdded();
        }
    }

    private void setUpgradeDefaults(IUpgradeWrapper wrapper) {
        this.getUpgradeDefaultsHandler(wrapper).accept(wrapper);
    }

    private <T extends IUpgradeWrapper> Consumer<T> getUpgradeDefaultsHandler(T wrapper) {
        return this.upgradeDefaultsHandlers.getOrDefault(wrapper.getClass(), w -> {});
    }

    public void set(int index, ItemResource resource, int amount) {
        this.setStackInSlot(index, resource.toStack(amount));
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        ItemStack originalStack = this.getStackInSlot(slot);
        Objects.checkIndex(slot, this.size());
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && !originalStack.isEmpty() && !this.runningOnBeforeRemovedOnSlots.contains(slot)) {
            this.runningOnBeforeRemovedOnSlots.add(slot);
            if (!ItemStack.isSameItemSameComponents((ItemStack)originalStack, (ItemStack)stack)) {
                this.getSlotWrappers().get(slot).onBeforeRemoved();
            }
            this.runningOnBeforeRemovedOnSlots.remove(slot);
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot, originalStack);
    }

    private void initializeTypeWrappers() {
        if (this.typeWrappersInitialized) {
            return;
        }
        this.initializeWrappers();
        this.typeWrappersInitialized = true;
        this.typeWrappers.clear();
        this.slotWrappers.values().forEach(wrapper -> {
            Item patt0$temp = wrapper.getUpgradeStack().getItem();
            if (patt0$temp instanceof IUpgradeItem) {
                IUpgradeItem upgradeItem = (IUpgradeItem)patt0$temp;
                UpgradeType type = upgradeItem.getType();
                if (wrapper.isEnabled() && (!(wrapper instanceof ITickableUpgrade) || this.storageWrapper.isUpgradeRunnable(wrapper.getUpgradeStack()))) {
                    this.addTypeWrapper(type, wrapper);
                }
            }
        });
        this.initRenderDataCallbacks(false);
    }

    private <T extends IUpgradeWrapper> void addTypeWrapper(UpgradeType<?> type, T wrapper) {
        this.typeWrappers.computeIfAbsent(type, t -> new ArrayList()).add(wrapper);
    }

    public <T extends IUpgradeWrapper> List<T> getTypeWrappers(UpgradeType<T> type) {
        this.initializeTypeWrappers();
        return this.typeWrappers.getOrDefault(type, Collections.emptyList());
    }

    public <T extends IUpgradeWrapper> boolean hasUpgrade(UpgradeType<T> type) {
        return !this.getTypeWrappers(type).isEmpty();
    }

    public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplement(upgradeClass);
    }

    private IUpgradeWrapperAccessor getWrapperAccessor() {
        if (this.wrapperAccessor == null) {
            IUpgradeWrapperAccessor accessor = new Accessor(this);
            for (IUpgradeAccessModifier upgrade : this.getListOfWrappersThatImplement(IUpgradeAccessModifier.class)) {
                accessor = upgrade.wrapAccessor(accessor);
            }
            this.wrapperAccessor = accessor;
        }
        return this.wrapperAccessor;
    }

    public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
        this.initializeWrappers();
        return this.getWrapperAccessor().getWrappersThatImplementFromMainStorage(upgradeClass);
    }

    public <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList<IUpgradeWrapper> ret = new ArrayList<IUpgradeWrapper>();
        for (IUpgradeWrapper wrapper : this.slotWrappers.values()) {
            if (!wrapper.isEnabled() || !uc.isInstance(wrapper)) continue;
            ret.add(wrapper);
        }
        return ret;
    }

    public Map<Integer, IUpgradeWrapper> getSlotWrappers() {
        this.initializeWrappers();
        return this.slotWrappers;
    }

    public void copyTo(UpgradeHandler otherHandler) {
        InventoryHelper.copyTo((ResourceHandler<ItemResource>)this, (ResourceHandler<ItemResource>)otherHandler);
    }

    public void refreshWrappersThatImplementAndTypeWrappers() {
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.clearCache();
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
    }

    public void refreshUpgradeWrappers() {
        if (!this.wrappersInitialized && !this.typeWrappersInitialized) {
            return;
        }
        this.wrappersInitialized = false;
        this.typeWrappersInitialized = false;
        if (this.wrapperAccessor != null) {
            this.wrapperAccessor.onBeforeDeconstruct();
            this.wrapperAccessor = null;
        }
        if (this.refreshCallBack != null) {
            this.refreshCallBack.run();
        }
        this.onInvalidateUpgradeCaches.run();
        this.initRenderDataCallbacks(true);
    }

    private void initRenderDataCallbacks(boolean forceUpdateRenderData) {
        RenderDataHandler renderDataHandler = this.storageWrapper.getRenderDataHandler();
        if (forceUpdateRenderData) {
            renderDataHandler.resetUpgradeInfo(false);
        }
        this.initTankRenderDataCallbacks(forceUpdateRenderData, renderDataHandler);
        this.initBatteryRenderDataCallbacks(forceUpdateRenderData, renderDataHandler);
    }

    private void initBatteryRenderDataCallbacks(boolean forceUpdateRenderData, RenderDataHandler renderDataHandler) {
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedBatteryUpgrade) {
                IRenderedBatteryUpgrade batteryWrapper = (IRenderedBatteryUpgrade)((Object)wrapper);
                batteryWrapper.setBatteryRenderDataUpdateCallback(renderDataHandler::setBatteryRenderData);
                if (forceUpdateRenderData) {
                    batteryWrapper.forceUpdateBatteryRenderData();
                }
            }
        });
    }

    private void initTankRenderDataCallbacks(boolean forceUpdateRenderData, RenderDataHandler renderDataHandler) {
        AtomicBoolean singleTankRight = new AtomicBoolean(false);
        ArrayList tankRenderWrappers = new ArrayList();
        int minRightSlot = this.size() / 2;
        this.getSlotWrappers().forEach((slot, wrapper) -> {
            if (wrapper instanceof IRenderedTankUpgrade) {
                IRenderedTankUpgrade tankUpgrade = (IRenderedTankUpgrade)((Object)wrapper);
                tankRenderWrappers.add(tankUpgrade);
                if (slot >= minRightSlot) {
                    singleTankRight.set(true);
                }
            }
        });
        TankPosition currentTankPos = tankRenderWrappers.size() == 1 && singleTankRight.get() ? TankPosition.RIGHT : TankPosition.LEFT;
        for (IRenderedTankUpgrade tankRenderWrapper : tankRenderWrappers) {
            TankPosition finalCurrentTankPos = currentTankPos;
            tankRenderWrapper.setTankRenderDataUpdateCallback(data -> renderDataHandler.setTankRenderData(finalCurrentTankPos, (RenderData.TankRenderData)data));
            if (forceUpdateRenderData) {
                tankRenderWrapper.forceUpdateTankRenderData();
            }
            currentTankPos = TankPosition.RIGHT;
        }
    }

    public void increaseSize(int diff) {
        NonNullList previousStacks = this.stacks;
        this.stacks = NonNullList.withSize((int)(previousStacks.size() + diff), (Object)ItemStack.EMPTY);
        for (int slot = 0; slot < previousStacks.size(); ++slot) {
            this.stacks.set(slot, (Object)((ItemStack)previousStacks.get(slot)));
        }
        this.saveInventory();
        this.setRenderUpgradeItems();
    }

    protected int getCapacity(int index, ItemResource resource) {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        Objects.checkIndex(slot, this.size());
        return (ItemStack)this.stacks.get(slot);
    }

    private static class Accessor
    implements IUpgradeWrapperAccessor {
        private final Map<Class<?>, List<?>> interfaceWrappers = new HashMap();
        private final UpgradeHandler upgradeHandler;

        public Accessor(UpgradeHandler upgradeHandler) {
            this.upgradeHandler = upgradeHandler;
        }

        @Override
        public <T> List<T> getWrappersThatImplement(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public <T> List<T> getWrappersThatImplementFromMainStorage(Class<T> upgradeClass) {
            return this.interfaceWrappers.computeIfAbsent(upgradeClass, this.upgradeHandler::getListOfWrappersThatImplement);
        }

        @Override
        public void clearCache() {
            this.interfaceWrappers.clear();
        }
    }
}

