/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.blockconverter;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.blockconverter.BlockConverterUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.SimpleItemContent;
import org.jspecify.annotations.Nullable;

public abstract class BlockConverterUpgradeWrapper<U extends BlockConverterUpgradeItem<U, W>, W extends BlockConverterUpgradeWrapper<U, W>>
extends UpgradeWrapperBase<W, U> {
    private final ItemStacksResourceHandler inputInventory;

    public BlockConverterUpgradeWrapper(IStorageWrapper storageWrapper, final ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputInventory = new ItemStacksResourceHandler(1){

            protected void onContentsChanged(int slot, ItemStack previousContents) {
                super.onContentsChanged(slot, (Object)previousContents);
                if (slot == 0) {
                    upgrade.set(ModCoreDataComponents.INPUT_ITEM, (Object)SimpleItemContent.copyOf((ItemStack)this.stacks.getFirst()));
                }
                BlockConverterUpgradeWrapper.this.save();
            }
        };
        ItemStack inputItem = ((SimpleItemContent)upgrade.getOrDefault(ModCoreDataComponents.INPUT_ITEM, (Object)SimpleItemContent.EMPTY)).copy();
        this.inputInventory.set(0, (Resource)ItemResource.of((ItemStack)inputItem), inputItem.getCount());
    }

    public ResourceHandler<ItemResource> getInputInventory() {
        return this.inputInventory;
    }

    public void setRecipeId(@Nullable ResourceKey<Recipe<?>> recipeId) {
        if (recipeId == null) {
            this.upgrade.remove(ModCoreDataComponents.RECIPE_ID);
            return;
        }
        this.upgrade.set(ModCoreDataComponents.RECIPE_ID, recipeId);
        this.save();
    }

    public Optional<ResourceKey<Recipe<?>>> getRecipeId() {
        return Optional.ofNullable((ResourceKey)this.upgrade.get(ModCoreDataComponents.RECIPE_ID));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoStorage() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)true);
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        this.upgrade.set(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)shiftClickIntoStorage);
        this.save();
    }
}

