/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ComponentItemStacksHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.CraftingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class CraftingUpgradeWrapper
extends UpgradeWrapperBase<CraftingUpgradeWrapper, CraftingUpgradeItem> {
    private final ComponentItemStacksHandler inventory;

    public CraftingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        if (upgrade.has(DataComponents.CONTAINER)) {
            upgrade.set(ModCoreDataComponents.LENIENT_CONTAINER, (Object)((ItemContainerContents)upgrade.get(DataComponents.CONTAINER)));
        }
        upgrade.remove(DataComponents.CONTAINER);
        this.inventory = new ComponentItemStacksHandler((MutableDataComponentHolder)upgrade, ModCoreDataComponents.LENIENT_CONTAINER.get(), 9){

            @Override
            protected void onContentsChanged(int index, ItemStack previousContents) {
                super.onContentsChanged(index, previousContents);
                CraftingUpgradeWrapper.this.save();
            }

            @Override
            public boolean isValid(int slot, ItemResource resource) {
                return true;
            }
        };
    }

    public ComponentItemStacksHandler getInventory() {
        return this.inventory;
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public boolean shouldShiftClickIntoStorage() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)true);
    }

    public void setShiftClickIntoStorage(boolean shiftClickIntoStorage) {
        this.upgrade.set(ModCoreDataComponents.SHIFT_CLICK_INTO_STORAGE, (Object)shiftClickIntoStorage);
        this.save();
    }

    public boolean shouldRefillCraftingGridNBT() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.REFILL_CRAFTING_GRID, (Object)false);
    }

    public void setRefillCraftingGridNBT(boolean replenish) {
        this.upgrade.set(ModCoreDataComponents.REFILL_CRAFTING_GRID, (Object)replenish);
        this.save();
    }

    public boolean extractFromStorageOrPlayer(Player player, ItemStack stack) {
        return this.extractFromStorage(stack) || this.extractFromPlayer(player, stack);
    }

    private boolean extractFromPlayer(Player player, ItemStack stack) {
        int playerInvMatchingIndex = player.getInventory().findSlotMatchingItem(stack);
        if (playerInvMatchingIndex >= 0) {
            player.getInventory().removeItem(playerInvMatchingIndex, 1);
            return true;
        }
        return false;
    }

    private boolean extractFromStorage(ItemStack stack) {
        return InventoryHelper.extractMatching(this.storageWrapper.getInventoryHandler(), s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)stack), 1) > 0;
    }
}

