/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.feeding;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.feeding.HungerLevel;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import org.jspecify.annotations.Nullable;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int STILL_HUNGRY_COOLDOWN = 10;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((FeedingUpgradeItem)this.upgradeItem).getFilterSlotCount(), this::isEdible, ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    private boolean isEdible(ItemStack s) {
        FoodProperties foodProperties = (FoodProperties)s.get(DataComponents.FOOD);
        return foodProperties != null && foodProperties.nutrition() >= 1;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        boolean hungryPlayer = false;
        if (!(entity instanceof Player)) {
            AtomicBoolean stillHungryPlayer = new AtomicBoolean(false);
            level.getEntities((EntityTypeTest)EntityType.PLAYER, new AABB(pos).inflate(3.0), p -> true).forEach(p -> stillHungryPlayer.set(stillHungryPlayer.get() || this.feedPlayerAndGetHungry((Player)p, level)));
            hungryPlayer = stillHungryPlayer.get();
        } else if (this.feedPlayerAndGetHungry((Player)entity, level)) {
            hungryPlayer = true;
        }
        if (hungryPlayer) {
            this.setCooldown(level, 10);
            return;
        }
        this.setCooldown(level, 100);
    }

    private boolean feedPlayerAndGetHungry(Player player, Level level) {
        int hungerLevel = 20 - player.getFoodData().getFoodLevel();
        if (hungerLevel == 0) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.getFoodData().getFoodLevel() < 20;
    }

    private boolean tryFeedingFoodFromStorage(Level level, int hungerLevel, Player player) {
        ITrackedContentsItemResourceHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        return InventoryHelper.iterate(inventory, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (ItemStack)stack, inventory), () -> false, ret -> ret);
    }

    private boolean tryFeedingStack(Level level, int hungerLevel, Player player, Integer slot, ItemStack stack, ITrackedContentsItemResourceHandler inventory) {
        boolean isHurt;
        boolean bl = isHurt = player.getHealth() < player.getMaxHealth() - 0.1f;
        if (this.isEdible(stack) && this.filterLogic.matchesFilter(stack) && (this.isHungryEnoughForFood(hungerLevel, stack) || this.shouldFeedImmediatelyWhenHurt() && hungerLevel > 0 && isHurt)) {
            ItemStack mainHandItem = player.getMainHandItem();
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)stack);
            ItemStack singleItemCopy = stack.copy();
            singleItemCopy.setCount(1);
            if (singleItemCopy.use(level, player, InteractionHand.MAIN_HAND) == InteractionResult.CONSUME) {
                int inserted;
                stack.shrink(1);
                inventory.setStackInSlot(slot, stack);
                ItemStack resultItem = EventHooks.onItemUseFinish((LivingEntity)player, (ItemStack)singleItemCopy.copy(), (int)0, (ItemStack)singleItemCopy.getItem().finishUsingItem(singleItemCopy, level, (LivingEntity)player));
                if (!resultItem.isEmpty() && (inserted = InventoryHelper.insert(inventory, ItemResource.of((ItemStack)resultItem), resultItem.getCount())) < resultItem.getCount()) {
                    ItemStack remaining = resultItem.copyWithCount(resultItem.getCount() - inserted);
                    CapabilityHelper.runOnCapability((Entity)player, Capabilities.Item.ENTITY, null, playerInventory -> InventoryHelper.insertOrDropItem(player, remaining, (ResourceHandler<ItemResource>)playerInventory));
                }
                player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
                return true;
            }
            player.getInventory().getNonEquipmentItems().set(player.getInventory().getSelectedSlot(), (Object)mainHandItem);
        }
        return false;
    }

    private boolean isHungryEnoughForFood(int hungerLevel, ItemStack stack) {
        if (stack.getItem() == Items.OMINOUS_BOTTLE) {
            return false;
        }
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties == null) {
            return false;
        }
        HungerLevel feedAtHungerLevel = this.getFeedAtHungerLevel();
        if (feedAtHungerLevel == HungerLevel.ANY) {
            return true;
        }
        int nutrition = foodProperties.nutrition();
        return (feedAtHungerLevel == HungerLevel.HALF ? nutrition / 2 : nutrition) <= hungerLevel;
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public HungerLevel getFeedAtHungerLevel() {
        return (HungerLevel)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.FEED_AT_HUNGER_LEVEL, (Object)HungerLevel.HALF));
    }

    public void setFeedAtHungerLevel(HungerLevel hungerLevel) {
        this.upgrade.set(ModCoreDataComponents.FEED_AT_HUNGER_LEVEL, (Object)hungerLevel);
        this.save();
    }

    public boolean shouldFeedImmediatelyWhenHurt() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.FEED_IMMEDIATELY_WHEN_HURT, (Object)true);
    }

    public void setFeedImmediatelyWhenHurt(boolean feedImmediatelyWhenHurt) {
        this.upgrade.set(ModCoreDataComponents.FEED_IMMEDIATELY_WHEN_HURT, (Object)feedImmediatelyWhenHurt);
        this.save();
    }
}

