/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticateditemactions.SophisticatedItemActions;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockEntityItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;

public class ControllerItemActionHandler
implements IBlockEntityItemActionHandler<ControllerBlockEntityBase> {
    public static final ControllerItemActionHandler INSTANCE = new ControllerItemActionHandler();
    public static final ResourceLocation ID = SophisticatedItemActions.getRL("controller");

    @Override
    public boolean handlesAction(IBlockItemActionHandler.Action action) {
        return action != IBlockItemActionHandler.Action.HIGHLIGHT;
    }

    @Override
    public IDepositHandler getDepositHandler(final ControllerBlockEntityBase controller) {
        final Vec3 center = Vec3.atCenterOf((Vec3i)controller.getBlockPos());
        return new IDepositHandler(){

            @Override
            public Vec3 getPosition() {
                return center;
            }

            @Override
            public ItemMatchResult getItemMatch(ItemStackKey stackKey) {
                return ControllerItemActionHandler.this.getItemMatch(stackKey, controller);
            }

            @Override
            public int insertItem(ItemStack stack) {
                return InventoryHelper.insert((ResourceHandler)controller, (ItemStack)stack);
            }
        };
    }

    @Override
    public IRestockHandler getRestockHandler(final ControllerBlockEntityBase controller) {
        return new IRestockHandler(){

            @Override
            public Vec3 getPosition() {
                return Vec3.atCenterOf((Vec3i)controller.getBlockPos());
            }

            @Override
            public int extractItem(ItemStack stack) {
                return InventoryHelper.extract((ResourceHandler)controller, (ItemStack)stack);
            }
        };
    }

    @Override
    public ItemMatchResult getItemMatch(ItemStackKey stackKey, ControllerBlockEntityBase controller) {
        if (controller.hasMatchingStack(stackKey)) {
            return ItemMatchResult.MATCHING_STACK;
        }
        if (controller.hasMatchingItem(stackKey.stack().getItem())) {
            return ItemMatchResult.MATCHING_ITEM;
        }
        return ItemMatchResult.NO_MATCH;
    }

    @Override
    public Class<ControllerBlockEntityBase> getObjectClass() {
        return ControllerBlockEntityBase.class;
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }
}

