/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.network.SyncBlockHighlightsPayload;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticateditemactions.client.gui.ItemActionsTranslationHelper;
import net.p3pp3rf1y.sophisticateditemactions.common.IBlockItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemActionHandlerRegistry;
import net.p3pp3rf1y.sophisticateditemactions.network.RequestItemHighlightsPayload;
import net.p3pp3rf1y.sophisticateditemactions.network.SyncEntityHighlightsPayload;

public class HighlightHandler {
    public static final int MATCHING_STACK_HIGHLIGHT_COLOR = 5025616;
    public static final int MATCHING_ITEM_HIGHLIGHT_COLOR = 4367861;
    private static final int HIGHLIGHT_RANGE = 32;

    public static void highlightItem(Player player, ItemStack stack) {
        HashMap<ResourceLocation, List<BlockPos>> positions = new HashMap<ResourceLocation, List<BlockPos>>();
        WorldHelper.getBlockEntitiesInRange((Level)player.level(), (BlockPos)player.blockPosition(), (int)32).forEach(be -> ItemActionHandlerRegistry.getBlockHandlerIdFor(player.level(), be.getBlockPos(), be, IBlockItemActionHandler.Action.HIGHLIGHT).ifPresent(id -> positions.computeIfAbsent((ResourceLocation)id, k -> new ArrayList()).add(be.getBlockPos())));
        HashMap<ResourceLocation, List<Integer>> entities = new HashMap<ResourceLocation, List<Integer>>();
        player.level().getEntities((Entity)player, player.getBoundingBox().inflate(32.0), e -> e.distanceTo((Entity)player) <= 32.0f).forEach(e -> ItemActionHandlerRegistry.getEntityHandlerIdFor(e).ifPresent(id -> entities.computeIfAbsent((ResourceLocation)id, k -> new ArrayList()).add(e.getId())));
        if (!positions.isEmpty() || !entities.isEmpty()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new RequestItemHighlightsPayload(stack, positions, entities), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            player.displayClientMessage((Component)ItemActionsTranslationHelper.INSTANCE.translStatusMessage("no_storage_in_range", new Object[0]).setStyle(Style.EMPTY.withColor(0xFF5555)), true);
            player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), 1.0f, 0.45f + RandHelper.getRandomMinusOneToOne((RandomSource)player.level().random) * 0.1f);
        }
    }

    public static void handleHighlight(Player player, ItemStackKey stackKey, Map<ResourceLocation, List<BlockPos>> storagePositions, Map<ResourceLocation, List<Integer>> entities) {
        AtomicInteger stackMatchNumber = new AtomicInteger(0);
        AtomicInteger itemMatchNumber = new AtomicInteger(0);
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ArrayList stackPositions = new ArrayList();
        ArrayList itemPositions = new ArrayList();
        storagePositions.forEach((handlerId, positions) -> ItemActionHandlerRegistry.getBlockHandler(handlerId).ifPresent(handler -> positions.forEach(pos -> {
            switch (handler.getItemMatch(serverPlayer, stackKey, (BlockPos)pos)) {
                case MATCHING_STACK: {
                    stackPositions.add(pos);
                    break;
                }
                case MATCHING_ITEM: {
                    itemPositions.add(pos);
                }
            }
        })));
        stackMatchNumber.addAndGet(stackPositions.size());
        itemMatchNumber.addAndGet(itemPositions.size());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncBlockHighlightsPayload(Map.of(5025616, stackPositions, 4367861, itemPositions)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ArrayList stackEntities = new ArrayList();
        ArrayList itemEntities = new ArrayList();
        entities.forEach((handlerId, entityIds) -> ItemActionHandlerRegistry.getEntityHandler(handlerId).ifPresent(handler -> entityIds.forEach(entityId -> {
            Entity entity = player.level().getEntity(entityId.intValue());
            if (entity == null) {
                return;
            }
            switch (handler.getItemMatch(stackKey, entity)) {
                case MATCHING_STACK: {
                    stackEntities.add(entityId);
                    break;
                }
                case MATCHING_ITEM: {
                    itemEntities.add(entityId);
                }
            }
        })));
        stackMatchNumber.addAndGet(stackEntities.size());
        itemMatchNumber.addAndGet(itemEntities.size());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncEntityHighlightsPayload(Map.of(5025616, stackEntities, 4367861, itemEntities)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Level level = player.level();
        MutableComponent message = null;
        if (stackMatchNumber.get() == 0 && itemMatchNumber.get() == 0) {
            message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("no_matching_items_found", new Object[0]);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 1.0f, 0.7f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
        } else {
            if (stackMatchNumber.get() > 0) {
                message = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("matching_stacks_found", new Object[]{Component.literal((String)String.valueOf(stackMatchNumber.get())).withColor(5025616)});
            }
            if (itemMatchNumber.get() > 0) {
                MutableComponent itemMessage = ItemActionsTranslationHelper.INSTANCE.translStatusMessage("matching_items_found", new Object[]{Component.literal((String)String.valueOf(itemMatchNumber.get())).withColor(4367861)});
                message = message != null ? message.plainCopy().append(" ").append((Component)itemMessage) : itemMessage;
            }
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.PLAYERS, 1.0f, 0.95f + RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 0.1f);
        }
        player.displayClientMessage((Component)message, true);
    }
}

