/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticateditemactions.compat.sophisticatedstorageinmotion;

import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticateditemactions.SophisticatedItemActions;
import net.p3pp3rf1y.sophisticateditemactions.common.IDepositHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IEntityItemActionHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.IRestockHandler;
import net.p3pp3rf1y.sophisticateditemactions.common.ItemMatchResult;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public class MovingStorageItemActionHandler
implements IEntityItemActionHandler {
    public static final MovingStorageItemActionHandler INSTANCE = new MovingStorageItemActionHandler();
    public static final ResourceLocation ID = SophisticatedItemActions.getRL("sophisticatedstorageinmotion");

    @Override
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public boolean canActOn(Entity entity) {
        IMovingStorageEntity movingStorage;
        return entity instanceof IMovingStorageEntity && !(movingStorage = (IMovingStorageEntity)entity).getStorageItem().isEmpty();
    }

    @Override
    public ItemMatchResult getItemMatch(ItemStackKey stackKey, Entity entity) {
        return MovingStorageItemActionHandler.getItemMatch(stackKey, entity, false);
    }

    private static ItemMatchResult getItemMatch(ItemStackKey stackKey, Entity entity, boolean includeMemorizedAndFiltered) {
        if (!(entity instanceof IMovingStorageEntity)) {
            return ItemMatchResult.NO_MATCH;
        }
        IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        ISlotTracker slotTracker = movingStorage.getStorageHolder().getStorageWrapper().getInventoryHandler().getSlotTracker();
        if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey) || includeMemorizedAndFiltered && slotTracker.hasExactStackMemorized(stackKey)) {
            return ItemMatchResult.MATCHING_STACK;
        }
        if (slotTracker.getItems().contains(stackKey.stack().getItem()) || includeMemorizedAndFiltered && slotTracker.hasItemMemorizedOrFiltered(stackKey.stack().getItem())) {
            return ItemMatchResult.MATCHING_ITEM;
        }
        return ItemMatchResult.NO_MATCH;
    }

    @Override
    public Optional<IDepositHandler> getDepositHandler(final Entity entity) {
        if (!(entity instanceof IMovingStorageEntity)) {
            return Optional.empty();
        }
        final IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return Optional.of(new IDepositHandler(){

            @Override
            public Vec3 getPosition() {
                return entity.position();
            }

            @Override
            public ItemMatchResult getItemMatch(ItemStackKey stackKey) {
                return MovingStorageItemActionHandler.getItemMatch(stackKey, entity, true);
            }

            @Override
            public int insertItem(ItemStack stack) {
                return InventoryHelper.insert((ResourceHandler)movingStorage.getStorageHolder().getStorageWrapper().getInventoryForInputOutput(), (ItemStack)stack);
            }
        });
    }

    @Override
    public Optional<IRestockHandler> getRestockHandler(final Entity entity) {
        if (!(entity instanceof IMovingStorageEntity)) {
            return Optional.empty();
        }
        final IMovingStorageEntity movingStorage = (IMovingStorageEntity)entity;
        return Optional.of(new IRestockHandler(){

            @Override
            public Vec3 getPosition() {
                return entity.position();
            }

            @Override
            public int extractItem(ItemStack stack) {
                return InventoryHelper.extract((ResourceHandler)movingStorage.getStorageHolder().getStorageWrapper().getInventoryForInputOutput(), (ItemStack)stack);
            }
        });
    }
}

