/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.TextBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.util.Easing;

class SearchBox
extends TextBox {
    private static final List<Component> TOOLTIP = List.of(Component.translatable((String)TranslationHelper.INSTANCE.translGui("text_box.search_box")), Component.translatable((String)TranslationHelper.INSTANCE.translGui("text_box.search_box_detail")).withStyle(ChatFormatting.GRAY));
    public static final String MAGNIFYING_GLASS = "\ud83d\udd0d";
    public static final int UNFOCUSED_COLOR = ARGB.opaque((int)0xBBBBBB);
    private final StorageScreenBase<?> screen;
    private long lastFocusChangeTime = 0L;
    private final int maximizedX;
    private final int maximizedWidth;

    public SearchBox(Position position, Dimension dimension, StorageScreenBase<?> screen) {
        super(position, dimension);
        this.screen = screen;
        this.setTextColor(UNFOCUSED_COLOR);
        this.setTextColorUneditable(UNFOCUSED_COLOR);
        this.setBordered(false);
        this.setMaxLength(50);
        this.setUnfocusedEmptyHint(MAGNIFYING_GLASS);
        this.maximizedX = position.x();
        this.maximizedWidth = dimension.width();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClicked) {
        if (!this.isMouseOver(event.x(), event.y())) {
            return false;
        }
        if (this.isEditable()) {
            if (event.button() == 0) {
                this.setFocused(true);
                this.screen.setFocused(this);
            } else if (event.button() == 1) {
                this.setValue("");
            }
            return true;
        }
        return super.mouseClicked(event, doubleClicked);
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.isFocused() != focused) {
            this.lastFocusChangeTime = System.currentTimeMillis();
        }
        super.setFocused(focused);
        if (focused) {
            this.setTextColor(-1);
        } else {
            this.setTextColor(UNFOCUSED_COLOR);
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int minWidth = this.getHeight();
        if (this.isFocused() && this.maximizedWidth > this.getWidth() || !this.isFocused() && this.getValue().isEmpty() && this.getWidth() > minWidth) {
            float ratio = Easing.EASE_IN_OUT_CUBIC.ease(Math.min((float)(System.currentTimeMillis() - this.lastFocusChangeTime) / 200.0f, 1.0f));
            int currentWidth = this.isFocused() ? (int)((float)minWidth + (float)(this.maximizedWidth - minWidth) * ratio) : (int)((float)this.maximizedWidth - (float)(this.maximizedWidth - minWidth) * ratio);
            this.setPosition(new Position(this.maximizedX + this.maximizedWidth - currentWidth, this.y));
            this.updateDimensions(currentWidth, this.getHeight());
        }
        guiGraphics.fill(this.x, this.y, this.x + this.getWidth(), this.y + this.getHeight(), -8947849);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        if (!this.isFocused() && this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.setTooltipForNextFrame(screen.getFont(), TOOLTIP, Optional.empty(), mouseX, mouseY);
        }
    }
}

