/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.client.gui;

import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.HashedPatchMap;
import net.minecraft.network.HashedStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.NeoForge;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.ISlotDecorationRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SearchBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.SortButtonsPosition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageGuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeGuiManager;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.UpgradeSettingsTabControl;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.InventoryScrollPanel;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Label;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.TextBox;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageBackgroundProperties;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageInventorySlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.network.TransferFullSlotPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.crafting.ICraftingUIPart;
import net.p3pp3rf1y.sophisticatedcore.util.CountAbbreviator;
import org.joml.Matrix3x2fStack;

public abstract class StorageScreenBase<S extends StorageContainerMenuBase<?>>
extends AbstractContainerScreen<S>
implements InventoryScrollPanel.IInventoryScreen {
    private static final int UPGRADE_TOP_HEIGHT = 7;
    private static final int UPGRADE_SLOT_HEIGHT = 16;
    private static final int UPGRADE_BOTTOM_HEIGHT = 6;
    public static final int UPGRADE_INVENTORY_OFFSET = 21;
    public static final int DISABLED_SLOT_X_POS = -2000;
    static final int SLOTS_Y_OFFSET = 17;
    static final int SLOTS_X_OFFSET = 7;
    public static final int ERROR_SLOT_COLOR = DyeColor.RED.getTextureDiffuseColor() & 0xFFFFFF | 0xAA000000;
    private static final int ERROR_TEXT_COLOR = DyeColor.RED.getTextureDiffuseColor();
    public static final int HEIGHT_WITHOUT_STORAGE_SLOTS = 114;
    private UpgradeSettingsTabControl settingsTabControl;
    private final int numberOfUpgradeSlots;
    @Nullable
    private Button sortButton = null;
    @Nullable
    private ToggleButton<SortBy> sortByButton = null;
    private InventoryScrollPanel inventoryScrollPanel = null;
    private final Set<ToggleButton<Boolean>> upgradeSwitches = new HashSet<ToggleButton<Boolean>>();
    private final Map<Integer, UpgradeInventoryPartBase<?>> inventoryParts = new LinkedHashMap();
    private static ICraftingUIPart craftingUIPart = ICraftingUIPart.NOOP;
    private static ISlotDecorationRenderer slotDecorationRenderer = (guiGraphics, slot) -> {};
    protected StorageBackgroundProperties storageBackgroundProperties;
    @Nullable
    private Button transferToStorageButton;
    @Nullable
    private Button transferToInventoryButton;
    private TextBox searchBox;
    private Label noResultsLabel;
    private Predicate<ItemStack> stackFilter = stack -> this.searchBox == null || this.searchBox.getValue().isEmpty() || !stack.isEmpty() && stack.getHoverName().getString().toLowerCase().contains(this.searchBox.getValue().toLowerCase());
    private int visibleSlotsCount;
    private boolean initializing = true;

    public static void setCraftingUIPart(ICraftingUIPart part) {
        craftingUIPart = part;
    }

    public static void setSlotDecorationRenderer(ISlotDecorationRenderer renderer) {
        slotDecorationRenderer = renderer;
    }

    protected StorageScreenBase(S menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.numberOfUpgradeSlots = ((StorageContainerMenuBase)this.getMenu()).getNumberOfUpgradeSlots();
        this.visibleSlotsCount = ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots();
        this.updateDimensionsAndSlotPositions(Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public ICraftingUIPart getCraftingUIAddition() {
        return craftingUIPart;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        this.updateDimensionsAndSlotPositions(height);
        super.resize(minecraft, width, height);
    }

    private void updateDimensionsAndSlotPositions(int height) {
        int displayableNumberOfRows = Math.min((height - 114) / 18, ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows());
        int newImageHeight = 114 + this.getStorageInventoryHeight(displayableNumberOfRows);
        this.storageBackgroundProperties = ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots() + ((StorageContainerMenuBase)this.getMenu()).getColumnsTaken() * ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows() <= 81 ? StorageBackgroundProperties.REGULAR_9_SLOT : StorageBackgroundProperties.REGULAR_12_SLOT;
        this.imageWidth = this.storageBackgroundProperties.getSlotsOnLine() * 18 + 14;
        this.updateStorageSlotsPositions();
        this.updateNoResultsLabel();
        if (displayableNumberOfRows < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows()) {
            this.storageBackgroundProperties = this.storageBackgroundProperties == StorageBackgroundProperties.REGULAR_9_SLOT ? StorageBackgroundProperties.WIDER_9_SLOT : StorageBackgroundProperties.WIDER_12_SLOT;
            this.imageWidth += 6;
        }
        this.imageHeight = newImageHeight;
        this.inventoryLabelY = this.imageHeight - 94;
        this.inventoryLabelX = 8 + this.storageBackgroundProperties.getPlayerInventoryXOffset();
        this.updatePlayerSlotsPositions();
        this.updateExtraSlotsPositions();
        this.updateUpgradeSlotsPositions();
        this.updateTransferButtonsPositions();
    }

    public int getInventoryLabelX() {
        return this.inventoryLabelX;
    }

    protected void updateExtraSlotsPositions() {
    }

    protected int getStorageInventoryHeight(int displayableNumberOfRows) {
        return displayableNumberOfRows * 18;
    }

    @Override
    public Slot getSlot(int slotIndex) {
        return ((StorageContainerMenuBase)this.getMenu()).getSlot(slotIndex);
    }

    protected void updateUpgradeSlotsPositions() {
        int yPosition = 6;
        for (int slotIndex = 0; slotIndex < this.numberOfUpgradeSlots; ++slotIndex) {
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getFirstUpgradeSlot() + slotIndex);
            slot.y = yPosition;
            yPosition += 16;
        }
    }

    private void updateNoResultsLabel() {
        if (this.noResultsLabel != null) {
            if (this.visibleSlotsCount == 0) {
                if (!this.renderables.contains(this.noResultsLabel)) {
                    this.addRenderableWidget(this.noResultsLabel);
                }
            } else {
                this.removeWidget(this.noResultsLabel);
            }
        }
    }

    @Override
    public int getVisibleSlotsCount() {
        return this.visibleSlotsCount;
    }

    @Override
    public void setVisibleSlotsCount(int visibleSlotsCount) {
        this.visibleSlotsCount = visibleSlotsCount;
    }

    protected void updateStorageSlotsPositions() {
        int yPosition = 18;
        this.visibleSlotsCount = 0;
        for (int slotIndex = 0; slotIndex < ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots(); ++slotIndex) {
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(slotIndex);
            int lineIndex = this.visibleSlotsCount % this.getSlotsOnLine();
            if (this.stackFilter.test(slot.getItem())) {
                slot.x = 8 + lineIndex * 18;
                slot.y = yPosition;
                ++this.visibleSlotsCount;
                if (this.visibleSlotsCount % this.getSlotsOnLine() != 0) continue;
                yPosition += 18;
                continue;
            }
            slot.x = -2000;
        }
    }

    @Override
    public Predicate<ItemStack> getStackFilter() {
        return this.stackFilter;
    }

    protected void updatePlayerSlotsPositions() {
        int playerInventoryXOffset = this.storageBackgroundProperties.getPlayerInventoryXOffset();
        int yPosition = this.inventoryLabelY + 12;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int slotIndex = j + i * 9;
                int xPosition = playerInventoryXOffset + 8 + j * 18;
                Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getInventorySlotsSize() - ((StorageContainerMenuBase)this.getMenu()).getExtraSlots().size() - 36 + slotIndex);
                slot.x = xPosition;
                slot.y = yPosition;
            }
            yPosition += 18;
        }
        yPosition += 4;
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int xPosition = playerInventoryXOffset + 8 + slotIndex * 18;
            Slot slot = ((StorageContainerMenuBase)this.getMenu()).getSlot(((StorageContainerMenuBase)this.getMenu()).getInventorySlotsSize() - ((StorageContainerMenuBase)this.getMenu()).getExtraSlots().size() - 36 + 27 + slotIndex);
            slot.x = xPosition;
            slot.y = yPosition;
        }
    }

    protected void init() {
        super.init();
        this.updateInventoryScrollPanel();
        craftingUIPart.setStorageScreen(this);
        this.initUpgradeSettingsControl();
        this.initUpgradeInventoryParts();
        this.addUpgradeSwitches();
        ((StorageContainerMenuBase)this.getMenu()).setUpgradeChangeListener(c -> {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateExtraSlotsPositions();
            this.updateUpgradeSlotsPositions();
            this.updateInventoryScrollPanel();
            this.updateNoResultsLabel();
            this.children().remove(this.settingsTabControl);
            craftingUIPart.onCraftingSlotsHidden();
            this.initUpgradeSettingsControl();
            this.initUpgradeInventoryParts();
            this.addUpgradeSwitches();
        });
        if (this.shouldShowSortButtons()) {
            this.addSortButtons();
        }
        this.addTransferButtons();
        this.addSearchBox();
        this.initializing = false;
    }

    protected void addSearchBox() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        int x = 7;
        int xEnd = sortButtonsPosition == SortButtonsPosition.TITLE_LINE_RIGHT ? this.getSortButtonsPosition(sortButtonsPosition).x() - 1 - this.leftPos : this.imageWidth - 7;
        int width = xEnd - x;
        this.searchBox = new SearchBox(new Position(this.leftPos + x, this.topPos + 5), new Dimension(width, 10), this);
        this.searchBox.setResponder(this::onSearchPhraseChange);
        if (((StorageContainerMenuBase)this.getMenu()).shouldKeepSearchPhrase()) {
            this.searchBox.setValue(((StorageContainerMenuBase)this.getMenu()).getSearchPhrase());
        }
        this.addWidget(this.searchBox);
        if (this.noResultsLabel != null) {
            this.removeWidget(this.noResultsLabel);
        }
        this.noResultsLabel = new Label(new Position(this.leftPos + 7, this.topPos + 18), (Component)Component.translatable((String)TranslationHelper.INSTANCE.translGui("label.no_search_results")));
        if (this.visibleSlotsCount == 0) {
            this.addRenderableWidget(this.noResultsLabel);
        }
    }

    private void onSearchPhraseChange(String searchPhrase) {
        if (!this.initializing) {
            ((StorageContainerMenuBase)this.getMenu()).setSearchPhrase(searchPhrase);
        }
        this.updateSearchFilter(searchPhrase);
        if (this.inventoryScrollPanel != null) {
            this.inventoryScrollPanel.resetScrollDistance();
            this.inventoryScrollPanel.updateSlotsPosition();
        } else {
            this.updateStorageSlotsPositions();
        }
        this.updateNoResultsLabel();
    }

    private void updateSearchFilter(String searchPhrase) {
        if (searchPhrase.trim().isEmpty()) {
            this.stackFilter = stack -> true;
            return;
        }
        String[] searchTerms = searchPhrase.trim().split(" ");
        ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
        for (String searchTerm : searchTerms) {
            if (searchTerm.startsWith("@")) {
                String modName = searchTerm.substring(1).toLowerCase();
                filters.add(stack -> modName.isEmpty() || BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getNamespace().contains(modName));
                continue;
            }
            if (searchTerm.startsWith("#")) {
                String tooltipKeyword = searchTerm.substring(1).toLowerCase();
                filters.add(stack -> StorageScreenBase.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)stack).stream().anyMatch(line -> line.getString().toLowerCase().contains(tooltipKeyword)));
                continue;
            }
            filters.add(stack -> stack.getHoverName().getString().toLowerCase().contains(searchTerm.toLowerCase()));
        }
        this.stackFilter = stack -> !stack.isEmpty() && filters.stream().allMatch(f -> f.test(stack));
    }

    private void addTransferButtons() {
        this.transferToStorageButton = new TransferButton(this, filterByContents -> ((StorageContainerMenuBase)this.getMenu()).transferItemsToStorage((boolean)filterByContents), ButtonDefinitions.TRANSFER_TO_STORAGE, ButtonDefinitions.TRANSFER_TO_STORAGE_FILTERED);
        this.addRenderableWidget(this.transferToStorageButton);
        this.transferToInventoryButton = new TransferButton(this, filterByContents -> ((StorageContainerMenuBase)this.getMenu()).transferItemsToPlayerInventory((boolean)filterByContents), ButtonDefinitions.TRANSFER_TO_INVENTORY, ButtonDefinitions.TRANSFER_TO_INVENTORY_FILTERED);
        this.addRenderableWidget(this.transferToInventoryButton);
        this.updateTransferButtonsPositions();
    }

    protected boolean shouldShowSortButtons() {
        return true;
    }

    private void updateInventoryScrollPanel() {
        int numberOfVisibleRows;
        if (this.inventoryScrollPanel != null) {
            this.removeWidget((GuiEventListener)this.inventoryScrollPanel);
        }
        if ((numberOfVisibleRows = this.getNumberOfVisibleRows()) < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows()) {
            this.inventoryScrollPanel = new InventoryScrollPanel(Minecraft.getInstance(), this, 0, ((StorageContainerMenuBase)this.getMenu()).getNumberOfStorageInventorySlots(), this.getSlotsOnLine(), numberOfVisibleRows * 18, this.getGuiTop() + 17, this.getGuiLeft() + 7);
            this.addRenderableWidget((GuiEventListener)this.inventoryScrollPanel);
            this.inventoryScrollPanel.updateSlotsPosition();
        } else {
            this.inventoryScrollPanel = null;
        }
    }

    private void updateTransferButtonsPositions() {
        if (this.transferToStorageButton == null || this.transferToInventoryButton == null) {
            return;
        }
        this.transferToStorageButton.setPosition(new Position(this.leftPos + this.inventoryLabelX + 137, this.topPos + this.inventoryLabelY - 2));
        this.transferToInventoryButton.setPosition(new Position(this.leftPos + this.inventoryLabelX + 149, this.topPos + this.inventoryLabelY - 2));
    }

    private int getNumberOfVisibleRows() {
        return Math.min((this.imageHeight - 114) / 18, ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows());
    }

    public int getSlotsOnLine() {
        return this.storageBackgroundProperties.getSlotsOnLine() - ((StorageContainerMenuBase)this.getMenu()).getColumnsTaken();
    }

    private void initUpgradeInventoryParts() {
        this.inventoryParts.clear();
        if (((StorageContainerMenuBase)this.getMenu()).getColumnsTaken() == 0) {
            return;
        }
        int numberOfVisibleRows = this.getNumberOfVisibleRows();
        int scrollBarOffset = numberOfVisibleRows < ((StorageContainerMenuBase)this.getMenu()).getNumberOfRows() ? 6 : 0;
        AtomicReference<Position> pos = new AtomicReference<Position>(new Position(7 + this.getSlotsOnLine() * 18 + scrollBarOffset, 17));
        int height = numberOfVisibleRows * 18;
        for (Map.Entry<Integer, UpgradeContainerBase<?, ?>> entry : ((StorageContainerMenuBase)this.getMenu()).getUpgradeContainers().entrySet()) {
            UpgradeContainerBase<?, ?> container = entry.getValue();
            UpgradeGuiManager.getInventoryPart(entry.getKey(), container, pos.get(), height, this).ifPresent(part -> {
                this.inventoryParts.put((Integer)entry.getKey(), (UpgradeInventoryPartBase<?>)part);
                pos.set(new Position(((Position)pos.get()).x() + 36, ((Position)pos.get()).y()));
            });
        }
    }

    private void addUpgradeSwitches() {
        this.upgradeSwitches.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.upgradeSwitches.clear();
        int switchTop = this.topPos + 8;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.menu).canDisableUpgrade(slot)) {
                final int finalSlot = slot;
                ToggleButton<Boolean> upgradeSwitch = new ToggleButton<Boolean>(new Position(this.leftPos - 22, switchTop), ButtonDefinitions.UPGRADE_SWITCH, button -> ((StorageContainerMenuBase)this.getMenu()).setUpgradeEnabled(finalSlot, !((StorageContainerMenuBase)this.getMenu()).getUpgradeEnabled(finalSlot)), () -> ((StorageContainerMenuBase)this.getMenu()).getUpgradeEnabled(finalSlot)){

                    @Override
                    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        if (((StorageContainerMenuBase)StorageScreenBase.this.menu).isUpgradeRunnable(finalSlot)) {
                            super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                        } else {
                            GuiHelper.blit(guiGraphics, this.x, this.y, ButtonDefinitions.UPGRADE_SWITCH_INACTIVE.getForegroundTexture());
                        }
                    }

                    @Override
                    public void renderTooltip(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY) {
                        if (((StorageContainerMenuBase)StorageScreenBase.this.menu).isUpgradeRunnable(finalSlot)) {
                            super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
                        } else if (this.isMouseOver(mouseX, mouseY)) {
                            GuiHelper.renderTooltip(screen, guiGraphics, ButtonDefinitions.UPGRADE_SWITCH_INACTIVE.getTooltip(), mouseX, mouseY);
                        }
                    }

                    @Override
                    protected void renderHoveredBackground(GuiGraphics guiGraphics) {
                        if (((StorageContainerMenuBase)StorageScreenBase.this.menu).isUpgradeRunnable(finalSlot)) {
                            super.renderHoveredBackground(guiGraphics);
                        } else {
                            GuiHelper.blit(guiGraphics, this.x, this.y, ButtonDefinitions.UPGRADE_SWITCH_INACTIVE.getBackgroundTexture());
                        }
                    }
                };
                this.addRenderableWidget(upgradeSwitch);
                this.upgradeSwitches.add(upgradeSwitch);
            }
            switchTop += 16;
        }
    }

    private void addSortButtons() {
        SortButtonsPosition sortButtonsPosition = (SortButtonsPosition)((Object)Config.CLIENT.sortButtonsPosition.get());
        if (sortButtonsPosition == SortButtonsPosition.HIDDEN) {
            return;
        }
        Position pos = this.getSortButtonsPosition(sortButtonsPosition);
        this.sortButton = new Button(new Position(pos.x(), pos.y()), ButtonDefinitions.SORT, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.getMenu()).sort();
                Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Sorted"), true);
            }
        });
        this.addRenderableWidget(this.sortButton);
        this.sortByButton = new ToggleButton<SortBy>(new Position(pos.x() + 12, pos.y()), ButtonDefinitions.SORT_BY, button -> {
            if (button == 0) {
                ((StorageContainerMenuBase)this.getMenu()).setSortBy(((StorageContainerMenuBase)this.getMenu()).getSortBy().next());
            }
        }, () -> ((StorageContainerMenuBase)this.getMenu()).getSortBy());
        this.addRenderableWidget(this.sortByButton);
    }

    private Position getSortButtonsPosition(SortButtonsPosition sortButtonsPosition) {
        return switch (sortButtonsPosition) {
            case SortButtonsPosition.BELOW_UPGRADES -> new Position(this.leftPos - 21 - 2, this.topPos + this.getUpgradeHeightWithoutBottom() + 6 + 2);
            case SortButtonsPosition.BELOW_UPGRADE_TABS -> new Position(this.settingsTabControl.getX() + 2, this.settingsTabControl.getY() + Math.max(0, this.settingsTabControl.getHeight() + 2));
            default -> new Position(this.leftPos + this.imageWidth - 31, this.topPos + 4);
        };
    }

    private void initUpgradeSettingsControl() {
        this.settingsTabControl = new UpgradeSettingsTabControl(new Position(this.leftPos + this.imageWidth, this.topPos + 4), this, this.getStorageSettingsTabTooltip());
        this.addWidget(this.settingsTabControl);
    }

    protected abstract String getStorageSettingsTabTooltip();

    public int getUpgradeHeight() {
        return this.getUpgradeHeightWithoutBottom() + 7;
    }

    protected int getUpgradeHeightWithoutBottom() {
        return 6 + this.numberOfUpgradeSlots * 16;
    }

    public Optional<Rect2i> getSortButtonsRectangle() {
        if (this.sortButton == null || this.sortByButton == null) {
            return Optional.empty();
        }
        return GuiHelper.getPositiveRectangle(this.sortButton.getX(), this.sortButton.getY(), this.sortByButton.getX() + this.sortByButton.getWidth() - this.sortButton.getX(), this.sortByButton.getY() + this.sortByButton.getHeight() - this.sortButton.getY());
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (((StorageContainerMenuBase)this.menu).detectSettingsChangeAndReload()) {
            this.updateStorageSlotsPositions();
            this.updatePlayerSlotsPositions();
            this.updateExtraSlotsPositions();
            this.updateInventoryScrollPanel();
            this.updateNoResultsLabel();
            this.updateTransferButtonsPositions();
        }
        this.renderTransparentBackground(guiGraphics);
        this.settingsTabControl.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderSuper(guiGraphics, mouseX, mouseY, partialTicks);
        this.settingsTabControl.renderForeground(guiGraphics, mouseX, mouseY, partialTicks);
        if (((StorageContainerMenuBase)this.getMenu()).getCarried().isEmpty()) {
            this.settingsTabControl.renderTooltip((Screen)this, guiGraphics, mouseX, mouseY);
        }
        this.renderErrorOverlay(guiGraphics);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderSuper(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack itemstack;
        int i = this.leftPos;
        int j = this.topPos;
        for (Renderable widget : this.renderables) {
            widget.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        pose.translate((float)i, (float)j);
        this.renderLabels(guiGraphics, mouseX, mouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        pose.popMatrix();
        if (this.searchBox != null) {
            this.searchBox.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        pose.pushMatrix();
        pose.translate((float)i, (float)j);
        ItemStack itemStack = itemstack = this.draggingItem.isEmpty() ? ((StorageContainerMenuBase)this.menu).getCarried() : this.draggingItem;
        if (!itemstack.isEmpty()) {
            int l = this.draggingItem.isEmpty() ? 8 : 16;
            String s = null;
            if (!this.draggingItem.isEmpty() && this.isSplittingStack) {
                itemstack = itemstack.copyWithCount(Mth.ceil((float)((float)itemstack.getCount() / 2.0f)));
            } else if (this.isQuickCrafting && this.quickCraftSlots.size() > 1 && (itemstack = itemstack.copyWithCount(this.quickCraftingRemainder)).isEmpty()) {
                s = String.valueOf(ChatFormatting.YELLOW) + "0";
            }
            this.renderFloatingItem(guiGraphics, itemstack, mouseX - i - 8, mouseY - j - l, s);
        }
        pose.popMatrix();
    }

    @Nullable
    public Slot getHoveredSlot(double mouseX, double mouseY) {
        Slot slot;
        int i;
        for (i = 0; i < ((StorageContainerMenuBase)this.menu).upgradeSlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.menu).upgradeSlots.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return slot;
        }
        if (this.inventoryScrollPanel != null) {
            Optional<Slot> result = this.inventoryScrollPanel.getHoveredSlot(mouseX, mouseY);
            if (result.isPresent()) {
                return result.get();
            }
            slot = super.getHoveredSlot(mouseX, mouseY);
            return slot == null || ((StorageContainerMenuBase)this.menu).isStorageInventorySlot(slot) ? null : slot;
        }
        for (i = 0; i < ((StorageContainerMenuBase)this.menu).realInventorySlots.size(); ++i) {
            slot = ((StorageContainerMenuBase)this.menu).realInventorySlots.get(i);
            if (!this.isHovering(slot, mouseX, mouseY) || !slot.isActive()) continue;
            return slot;
        }
        return super.getHoveredSlot(mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        this.renderUpgradeInventoryParts(guiGraphics, mouseX, mouseY);
        this.renderUpgradeSlots(guiGraphics, mouseX, mouseY);
        if (this.inventoryScrollPanel == null) {
            this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY);
        }
        this.renderPlayerInventorySlots(guiGraphics, mouseX, mouseY);
    }

    private void renderUpgradeInventoryParts(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.inventoryParts.values().forEach(ip -> ip.render(guiGraphics, mouseX, mouseY));
    }

    private void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderStorageInventorySlots(guiGraphics, mouseX, mouseY, true);
    }

    @Override
    public void renderStorageInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover) {
        this.renderSlotsList(guiGraphics, mouseX, mouseY, ((StorageContainerMenuBase)this.menu).realInventorySlots, slot -> true, canShowHover, 0, ((StorageContainerMenuBase)this.menu).getNumberOfStorageInventorySlots());
    }

    private void renderPlayerInventorySlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderSlotsList(guiGraphics, mouseX, mouseY, ((StorageContainerMenuBase)this.menu).realInventorySlots, slot -> true, true, ((StorageContainerMenuBase)this.menu).getNumberOfStorageInventorySlots(), ((StorageContainerMenuBase)this.menu).realInventorySlots.size());
    }

    private void renderSlotsList(GuiGraphics guiGraphics, int mouseX, int mouseY, List<Slot> slots, Predicate<Slot> canShow, boolean canShowHover) {
        this.renderSlotsList(guiGraphics, mouseX, mouseY, slots, canShow, canShowHover, 0, slots.size());
    }

    private void renderSlotsList(GuiGraphics guiGraphics, int mouseX, int mouseY, List<Slot> slots, Predicate<Slot> canShow, boolean canShowHover, int startIndex, int endIndex) {
        Slot hoveredSlotBefore = this.hoveredSlot;
        this.hoveredSlot = this.getHoveredSlot(mouseX, mouseY);
        for (int i = startIndex; i < endIndex; ++i) {
            Slot slot = slots.get(i);
            if (!canShow.test(slot)) continue;
            if (canShowHover && slot == this.hoveredSlot) {
                this.renderSlotHighlightBack(guiGraphics);
            }
            this.renderSlot(guiGraphics, slot);
            if (!canShowHover || slot != this.hoveredSlot) continue;
            this.renderSlotHighlightFront(guiGraphics);
        }
        if (hoveredSlotBefore != null && hoveredSlotBefore != this.hoveredSlot) {
            this.onStopHovering(hoveredSlotBefore);
        }
    }

    private void renderUpgradeSlots(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderSlotsList(guiGraphics, mouseX, mouseY, ((StorageContainerMenuBase)this.menu).upgradeSlots, slot -> slot.x != -2000, true);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        int i = slot.x;
        int j = slot.y;
        ItemStack stackToRender = slot.getItem();
        boolean flag = false;
        boolean rightClickDragging = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack carriedStack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        Object stackCountText = null;
        if (((StorageContainerMenuBase)this.getMenu()).isInfiniteSlot(slot.index)) {
            stackCountText = "\u221e";
        }
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !stackToRender.isEmpty()) {
            stackToRender = stackToRender.copy();
            stackToRender.setCount(stackToRender.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !carriedStack.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (StorageContainerMenuBase.canItemQuickReplace(slot, carriedStack) && ((StorageContainerMenuBase)this.menu).canDragTo(slot)) {
                int slotLimit;
                flag = true;
                int slotStackCount = stackToRender.isEmpty() ? 0 : stackToRender.getCount();
                int renderCount = StorageContainerMenuBase.getQuickCraftPlaceCount(slot, this.quickCraftSlots.size(), this.quickCraftingType, carriedStack) + slotStackCount;
                int n = slotLimit = stackToRender.isEmpty() ? 64 : slot.getMaxStackSize(stackToRender);
                if (renderCount > slotLimit) {
                    stackCountText = String.valueOf(ChatFormatting.YELLOW) + CountAbbreviator.abbreviate(slotLimit);
                }
                stackToRender = carriedStack.copyWithCount(renderCount);
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        if (stackToRender.isEmpty() && slot.isActive()) {
            this.renderSlotBackground(guiGraphics, slot, i, j);
        } else if (!rightClickDragging) {
            this.renderStack(guiGraphics, i, j, stackToRender, flag, (String)stackCountText);
            slotDecorationRenderer.renderDecoration(guiGraphics, slot);
        }
    }

    private void renderStack(GuiGraphics guiGraphics, int x, int y, ItemStack itemstack, boolean flag, @Nullable String stackCountText) {
        if (flag) {
            guiGraphics.fill(x, y, x + 16, y + 16, -2130706433);
        }
        guiGraphics.renderItem(itemstack, x, y);
        if (this.shouldUseSpecialCountRender(itemstack)) {
            guiGraphics.renderItemDecorations(this.font, itemstack, x, y, "");
            if (stackCountText == null) {
                stackCountText = CountAbbreviator.abbreviate(itemstack.getCount());
            }
            this.renderStackCount(guiGraphics, stackCountText, x, y);
        } else {
            guiGraphics.renderItemDecorations(this.font, itemstack, x, y, stackCountText);
        }
    }

    private void renderSlotBackground(GuiGraphics guiGraphics, Slot slot, int i, int j) {
        ResourceLocation icon;
        Optional<ItemStack> memorizedStack = ((StorageContainerMenuBase)this.getMenu()).getMemorizedStackInSlot(slot.index);
        if (((StorageContainerMenuBase)this.getMenu()).isStorageInventorySlot(slot)) {
            if (memorizedStack.isPresent()) {
                guiGraphics.renderItem(memorizedStack.get(), i, j);
                this.drawStackOverlay(guiGraphics, i, j);
                return;
            }
            if (!((StorageContainerMenuBase)this.getMenu()).getSlotFilterItem(slot.index).isEmpty()) {
                guiGraphics.renderItem(((StorageContainerMenuBase)this.getMenu()).getSlotFilterItem(slot.index), i, j);
                this.drawStackOverlay(guiGraphics, i, j);
                return;
            }
        }
        if ((icon = slot.getNoItemIcon()) != null) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, icon, i, j, 16, 16);
        }
    }

    private void drawStackOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GuiHelper.GUI_CONTROLS, x, y, 77.0f, 0.0f, 16, 16, 256, 256);
    }

    private boolean shouldUseSpecialCountRender(ItemStack itemstack) {
        return itemstack.getCount() > 99;
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor) {
        this.renderSlotOverlay(guiGraphics, slot, slotColor, 0, 16);
    }

    private void renderSlotOverlay(GuiGraphics guiGraphics, Slot slot, int slotColor, int yOffset, int height) {
        this.renderOverlay(guiGraphics, slotColor, slot.x, slot.y + yOffset, 16, height);
    }

    public void renderOverlay(GuiGraphics guiGraphics, int slotColor, int xPos, int yPos, int width, int height) {
        guiGraphics.fillGradient(xPos, yPos, xPos + width, yPos + height, slotColor, slotColor);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.drawInventoryBg(guiGraphics, x, y, this.storageBackgroundProperties.getTextureName());
        if (this.inventoryScrollPanel == null) {
            this.drawSlotBg(guiGraphics, this.visibleSlotsCount);
        }
        this.drawUpgradeBackground(guiGraphics);
    }

    protected void drawSlotBg(GuiGraphics guiGraphics, int x, int y, int visibleSlotsCount) {
        int slotsOnLine = this.getSlotsOnLine();
        int slotRows = visibleSlotsCount / slotsOnLine;
        int remainingSlots = visibleSlotsCount % slotsOnLine;
        GuiHelper.renderSlotsBackground(guiGraphics, x + 7, y + 17, slotsOnLine, slotRows, remainingSlots);
    }

    private void drawSlotOverlays(GuiGraphics guiGraphics) {
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        pose.translate((float)this.getGuiLeft(), (float)this.getGuiTop());
        for (int slotNumber = 0; slotNumber < ((StorageContainerMenuBase)this.menu).getNumberOfStorageInventorySlots(); ++slotNumber) {
            List<Integer> colors = ((StorageContainerMenuBase)this.menu).getSlotOverlayColors(slotNumber);
            if (colors.isEmpty()) continue;
            int stripeHeight = 16 / colors.size();
            int i = 0;
            for (int slotColor : colors) {
                int yOffset = i * stripeHeight;
                this.renderSlotOverlay(guiGraphics, ((StorageContainerMenuBase)this.menu).getSlot(slotNumber), slotColor & 0xFFFFFF | 0x50000000, yOffset, i == colors.size() - 1 ? 16 - yOffset : stripeHeight);
                ++i;
            }
        }
        pose.popMatrix();
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        if (!((StorageContainerMenuBase)this.getMenu()).getCarried().isEmpty()) {
            return;
        }
        this.inventoryParts.values().forEach(part -> part.renderTooltip(this, guiGraphics, x, y));
        if (this.hoveredSlot != null) {
            if (this.hoveredSlot.hasItem()) {
                super.renderTooltip(guiGraphics, x, y);
            } else {
                INameableEmptySlot emptySlot;
                Slot slot = this.hoveredSlot;
                if (slot instanceof INameableEmptySlot && (emptySlot = (INameableEmptySlot)slot).hasEmptyTooltip()) {
                    guiGraphics.setComponentTooltipForNextFrame(this.font, Collections.singletonList(emptySlot.getEmptyTooltip()), x, y);
                }
            }
        }
        if (this.sortButton != null) {
            this.sortButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.sortByButton != null) {
            this.sortByButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.transferToStorageButton != null) {
            this.transferToStorageButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.transferToInventoryButton != null) {
            this.transferToInventoryButton.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        if (this.searchBox != null) {
            this.searchBox.renderTooltip((Screen)this, guiGraphics, x, y);
        }
        this.upgradeSwitches.forEach(us -> us.renderTooltip((Screen)this, guiGraphics, x, y));
    }

    protected List<Component> getTooltipFromContainerItem(ItemStack itemStack) {
        List ret = StorageScreenBase.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)itemStack);
        if (this.hoveredSlot != null && this.hoveredSlot instanceof StorageInventorySlot && this.hoveredSlot.getMaxStackSize() != itemStack.getMaxStackSize()) {
            ret.add(Component.translatable((String)TranslationHelper.INSTANCE.translGuiTooltip("stack_count"), (Object[])new Object[]{Component.literal((String)NumberFormat.getNumberInstance().format(itemStack.getCount())).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.literal((String)" / ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)NumberFormat.getNumberInstance().format(this.hoveredSlot.getMaxStackSize(itemStack))).withStyle(ChatFormatting.DARK_AQUA))}).withStyle(ChatFormatting.GRAY));
        }
        return ret;
    }

    public void drawInventoryBg(GuiGraphics guiGraphics, int x, int y, ResourceLocation textureName) {
        StorageGuiHelper.renderStorageBackground(new Position(x, y), guiGraphics, textureName, this.imageWidth, this.imageHeight - 114);
    }

    private void drawUpgradeBackground(GuiGraphics guiGraphics) {
        if (this.numberOfUpgradeSlots == 0) {
            return;
        }
        int heightWithoutBottom = this.getUpgradeHeightWithoutBottom();
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos, 0.0f, 0.0f, 26, 4, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos + 4, 0.0f, 4.0f, 25, heightWithoutBottom - 4, 256, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GuiHelper.GUI_CONTROLS, this.leftPos - 21, this.topPos + heightWithoutBottom, 0.0f, 198.0f, 25, 6, 256, 256);
        boolean previousHasSwitch = false;
        for (int slot = 0; slot < this.numberOfUpgradeSlots; ++slot) {
            if (((StorageContainerMenuBase)this.menu).canDisableUpgrade(slot)) {
                int y = this.topPos + 5 + slot * 16 + (previousHasSwitch ? 1 : 0);
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GuiHelper.GUI_CONTROLS, this.leftPos - 21 - 4, y, 0.0f, (float)(204 + (previousHasSwitch ? 1 : 0)), 7, 18 - (previousHasSwitch ? 1 : 0), 256, 256);
                previousHasSwitch = true;
                continue;
            }
            previousHasSwitch = false;
        }
    }

    public UpgradeSettingsTabControl getUpgradeSettingsControl() {
        return this.settingsTabControl;
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        for (UpgradeInventoryPartBase<?> inventoryPart : this.inventoryParts.values()) {
            if (!inventoryPart.handleMouseReleased(event)) continue;
            return true;
        }
        this.handleQuickMoveAll(event.x(), event.y(), event.button());
        return super.mouseReleased(event);
    }

    private void handleQuickMoveAll(double mouseX, double mouseY, int button) {
        Slot slot = this.getHoveredSlot(mouseX, mouseY);
        if (this.doubleclick && !((StorageContainerMenuBase)this.getMenu()).getCarried().isEmpty() && slot != null && button == 0 && ((StorageContainerMenuBase)this.menu).canTakeItemForPickAll(ItemStack.EMPTY, slot) && Minecraft.getInstance().hasShiftDown() && !this.lastQuickMoved.isEmpty()) {
            for (Slot slot2 : ((StorageContainerMenuBase)this.menu).realInventorySlots) {
                this.tryQuickMoveSlot(button, slot, slot2);
            }
        }
    }

    private void tryQuickMoveSlot(int button, Slot slot, Slot slot2) {
        ItemStack slotItem;
        if (slot2.mayPickup((Player)this.minecraft.player) && slot2.hasItem() && slot2.isSameInventory(slot) && ItemStack.isSameItemSameComponents((ItemStack)this.lastQuickMoved, (ItemStack)(slotItem = slot2.getItem()))) {
            if (slotItem.getCount() > slotItem.getMaxStackSize()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new TransferFullSlotPayload(slot2.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                this.slotClicked(slot2, slot2.index, button, ClickType.QUICK_MOVE);
            }
        }
    }

    protected void slotClicked(Slot slot, int slotNumber, int mouseButton, ClickType type) {
        if (type == ClickType.PICKUP_ALL && !((StorageContainerMenuBase)this.menu).getSlotUpgradeContainer(slot).map(c -> c.allowsPickupAll(slot)).orElse(true).booleanValue()) {
            type = ClickType.PICKUP;
        }
        this.handleInventoryMouseClick(slotNumber, mouseButton, type);
    }

    private void handleInventoryMouseClick(int slotNumber, int mouseButton, ClickType type) {
        ItemStack itemstack;
        int lastChecked;
        ItemStack slotStack;
        ItemStack itemstack2;
        StorageContainerMenuBase menu = (StorageContainerMenuBase)this.getMenu();
        ArrayList realInventoryItems = new ArrayList(menu.realInventorySlots.size());
        menu.realInventorySlots.forEach(slot -> realInventoryItems.add(slot.getItem().copy()));
        ArrayList upgradeItems = new ArrayList(menu.upgradeSlots.size());
        menu.upgradeSlots.forEach(slot -> upgradeItems.add(slot.getItem().copy()));
        menu.clicked(slotNumber, mouseButton, type, (Player)this.minecraft.player);
        int inventorySlotsToCheck = Math.min(realInventoryItems.size() - 36, menu.getInventorySlotsSize() - 36);
        Int2ObjectOpenHashMap changedSlotStacks = new Int2ObjectOpenHashMap();
        for (int slotIndex = 0; slotIndex < inventorySlotsToCheck; ++slotIndex) {
            ItemStack slotStack2;
            itemstack2 = (ItemStack)realInventoryItems.get(slotIndex);
            if (ItemStack.matches((ItemStack)itemstack2, (ItemStack)(slotStack2 = menu.getSlot(slotIndex).getItem()))) continue;
            changedSlotStacks.put(slotIndex, (Object)HashedStack.create((ItemStack)slotStack2, (HashedPatchMap.HashGenerator)this.minecraft.getConnection().decoratedHashOpsGenenerator()));
        }
        for (int i = 0; i < 36; ++i) {
            int slotIndex;
            itemstack2 = (ItemStack)realInventoryItems.get(realInventoryItems.size() - 36 + i);
            if (ItemStack.matches((ItemStack)itemstack2, (ItemStack)(slotStack = menu.getSlot(slotIndex = menu.getInventorySlotsSize() - 36 + i).getItem()))) continue;
            changedSlotStacks.put(slotIndex, (Object)HashedStack.create((ItemStack)slotStack, (HashedPatchMap.HashGenerator)this.minecraft.getConnection().decoratedHashOpsGenenerator()));
        }
        int upgradeSlotsToCheck = Math.min(menu.getUpgradeSlotsSize(), upgradeItems.size());
        for (lastChecked = 0; lastChecked < upgradeSlotsToCheck && ItemStack.matches((ItemStack)(itemstack = (ItemStack)upgradeItems.get(lastChecked)), (ItemStack)(slotStack = menu.getSlot(menu.getInventorySlotsSize() + lastChecked).getItem())); ++lastChecked) {
        }
        for (int i = upgradeSlotsToCheck - 1; i >= lastChecked; --i) {
            int slotIndex;
            ItemStack slotStack3;
            ItemStack itemstack3 = (ItemStack)upgradeItems.get(i);
            if (ItemStack.matches((ItemStack)itemstack3, (ItemStack)(slotStack3 = menu.getSlot(slotIndex = menu.getInventorySlotsSize() + i).getItem()))) continue;
            changedSlotStacks.put(slotIndex, (Object)HashedStack.create((ItemStack)slotStack3, (HashedPatchMap.HashGenerator)this.minecraft.getConnection().decoratedHashOpsGenenerator()));
        }
        HashedStack hashedCarried = HashedStack.create((ItemStack)menu.getCarried(), (HashedPatchMap.HashGenerator)this.minecraft.getConnection().decoratedHashOpsGenenerator());
        this.minecraft.player.connection.send((Packet)new ServerboundContainerClickPacket(menu.containerId, menu.getStateId(), Shorts.checkedCast((long)slotNumber), SignedBytes.checkedCast((long)mouseButton), type, (Int2ObjectMap)changedSlotStacks, hashedCarried));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClicked) {
        Slot slot = this.getHoveredSlot(event.x(), event.y());
        if (event.hasShiftDown() && event.hasControlDown() && slot instanceof StorageInventorySlot && event.button() == 0) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new TransferFullSlotPayload(slot.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        GuiEventListener focused = this.getFocused();
        if (focused != null && !focused.isMouseOver(event.x(), event.y()) && focused instanceof WidgetBase) {
            WidgetBase widgetBase = (WidgetBase)focused;
            widgetBase.setFocused(false);
        }
        return this.superMouseClicked(event, doubleClicked);
    }

    private boolean superMouseClicked(MouseButtonEvent event, boolean doubleClicked) {
        if (this.containerEventHandlerMouseClicked(event, doubleClicked)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.getOrCreate(event.button());
        boolean flag = this.minecraft.options.keyPickItem.isActiveAndMatches(mouseKey);
        Slot slot = this.getHoveredSlot(event.x(), event.y());
        this.doubleclick = this.lastClickSlot == slot && doubleClicked;
        this.skipNextRelease = false;
        if (event.button() != 0 && event.button() != 1 && !flag) {
            this.checkHotbarMouseClicked(event);
        } else {
            int i = this.leftPos;
            int j = this.topPos;
            boolean flag1 = this.hasClickedOutside(event.x(), event.y(), i, j);
            if (slot != null) {
                flag1 = false;
            }
            int k = -1;
            if (slot != null) {
                k = slot.index;
            }
            if (flag1) {
                k = -999;
            }
            if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue() && flag1 && ((StorageContainerMenuBase)this.menu).getCarried().isEmpty()) {
                this.onClose();
                return true;
            }
            if (k != -1) {
                if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue()) {
                    if (slot != null && slot.hasItem()) {
                        this.clickedSlot = slot;
                        this.draggingItem = ItemStack.EMPTY;
                        this.isSplittingStack = event.button() == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.isQuickCrafting) {
                    if (((StorageContainerMenuBase)this.menu).getCarried().isEmpty()) {
                        if (this.minecraft.options.keyPickItem.isActiveAndMatches(mouseKey)) {
                            this.slotClicked(slot, k, event.button(), ClickType.CLONE);
                        } else {
                            boolean flag2 = k != -999 && event.hasShiftDown();
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.lastQuickMoved = slot != null && slot.hasItem() ? slot.getItem().copy() : ItemStack.EMPTY;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (k == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.slotClicked(slot, k, event.button(), clicktype);
                        }
                        this.skipNextRelease = true;
                    } else {
                        this.isQuickCrafting = true;
                        this.quickCraftingButton = event.button();
                        this.quickCraftSlots.clear();
                        if (event.button() == 0) {
                            this.quickCraftingType = 0;
                        } else if (event.button() == 1) {
                            this.quickCraftingType = 1;
                        } else if (this.minecraft.options.keyPickItem.isActiveAndMatches(mouseKey)) {
                            this.quickCraftingType = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        return true;
    }

    private boolean containerEventHandlerMouseClicked(MouseButtonEvent event, boolean doubleClicked) {
        return this.getChildAt(event.x(), event.y()).map(child -> {
            if (child.mouseClicked(event, doubleClicked)) {
                this.setFocused((GuiEventListener)child);
                if (event.button() == 0) {
                    this.setDragging(true);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.getChildAt(mouseX, mouseY).filter(child -> child.mouseScrolled(mouseX, mouseY, scrollX, scrollY)).isPresent()) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        double mouseX = event.x();
        double mouseY = event.y();
        for (GuiEventListener child : this.children()) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(event, dragX, dragY)) continue;
            return true;
        }
        Slot slot = this.getHoveredSlot(mouseX, mouseY);
        ItemStack itemstack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        if (this.isQuickCrafting) {
            if (slot != null && !itemstack.isEmpty() && (itemstack.getCount() > this.quickCraftSlots.size() || this.quickCraftingType == 2) && StorageContainerMenuBase.canItemQuickReplace(slot, itemstack) && slot.mayPlace(itemstack) && ((StorageContainerMenuBase)this.menu).canDragTo(slot) && this.isAllowedSlotCombination(slot, itemstack)) {
                this.quickCraftSlots.add(slot);
                this.recalculateQuickCraftRemaining();
            }
            return true;
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    private boolean isAllowedSlotCombination(Slot slot, ItemStack carried) {
        UpgradeItemBase upgradeItem;
        Item item;
        if (this.quickCraftSlots.isEmpty() || !((item = carried.getItem()) instanceof UpgradeItemBase) || (upgradeItem = (UpgradeItemBase)item).getInventoryColumnsTaken() == 0) {
            return true;
        }
        return this.quickCraftSlots.contains(slot) || !(this.quickCraftSlots.iterator().next() instanceof StorageContainerMenuBase.StorageUpgradeSlot) && !(slot instanceof StorageContainerMenuBase.StorageUpgradeSlot);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn) {
        return super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn) && this.hasClickedOutsideOfUpgradeSlots(mouseX, mouseY) && this.hasClickedOutsideOfUpgradeSettings(mouseX, mouseY);
    }

    private boolean hasClickedOutsideOfUpgradeSettings(double mouseX, double mouseY) {
        return this.settingsTabControl.getTabRectangles().stream().noneMatch(r -> r.contains((int)mouseX, (int)mouseY));
    }

    private boolean hasClickedOutsideOfUpgradeSlots(double mouseX, double mouseY) {
        return this.getUpgradeSlotsRectangle().map(r -> r.contains((int)mouseX, (int)mouseY)).orElse(false) == false;
    }

    public Optional<Rect2i> getUpgradeSlotsRectangle() {
        return this.numberOfUpgradeSlots == 0 ? Optional.empty() : GuiHelper.getPositiveRectangle(this.leftPos - 21 - (!this.upgradeSwitches.isEmpty() ? 4 : 0), this.topPos, 25, this.getUpgradeHeight());
    }

    private void renderStackCount(GuiGraphics guiGraphics, String count, int x, int y) {
        Matrix3x2fStack pose = guiGraphics.pose();
        pose.pushMatrix();
        float scale = Math.min(1.0f, 16.0f / (float)this.font.width(count));
        if (scale < 1.0f) {
            pose.scale(scale, scale);
        }
        guiGraphics.drawString(this.font, count, (int)(((float)(x + 19 - 2) - (float)this.font.width(count) * scale) / scale), (int)(((float)(y + 6 + 3) + (1.0f / (scale * scale) - 1.0f)) / scale), ARGB.opaque((int)0xFFFFFF), true);
        pose.popMatrix();
    }

    protected void recalculateQuickCraftRemaining() {
        ItemStack carriedStack = ((StorageContainerMenuBase)this.getMenu()).getCarried();
        if (!carriedStack.isEmpty() && this.isQuickCrafting) {
            if (this.quickCraftingType == 2) {
                this.quickCraftingRemainder = carriedStack.getMaxStackSize();
            } else {
                this.quickCraftingRemainder = carriedStack.getCount();
                for (Slot slot : this.quickCraftSlots) {
                    ItemStack slotStack = slot.getItem();
                    int slotStackCount = slotStack.isEmpty() ? 0 : slotStack.getCount();
                    int maxStackSize = slot.getMaxStackSize(carriedStack);
                    int quickCraftPlaceCount = Math.min(StorageContainerMenuBase.getQuickCraftPlaceCount(slot, this.quickCraftSlots.size(), this.quickCraftingType, carriedStack) + slotStackCount, maxStackSize);
                    this.quickCraftingRemainder -= quickCraftPlaceCount - slotStackCount;
                }
            }
        }
    }

    private void renderErrorOverlay(GuiGraphics guiGraphics) {
        ((StorageContainerMenuBase)this.menu).getErrorUpgradeSlotChangeResult().ifPresent(upgradeSlotChangeResult -> upgradeSlotChangeResult.getErrorMessage().ifPresent(overlayErrorMessage -> {
            Matrix3x2fStack pose = guiGraphics.pose();
            pose.pushMatrix();
            pose.translate((float)this.getGuiLeft(), (float)this.getGuiTop());
            upgradeSlotChangeResult.errorUpgradeSlots().forEach(slotIndex -> {
                Slot upgradeSlot = ((StorageContainerMenuBase)this.menu).getSlot(((StorageContainerMenuBase)this.menu).getFirstUpgradeSlot() + slotIndex);
                this.renderSlotOverlay(guiGraphics, upgradeSlot, ERROR_SLOT_COLOR);
            });
            upgradeSlotChangeResult.errorInventorySlots().forEach(slotIndex -> {
                Slot slot = ((StorageContainerMenuBase)this.menu).getSlot((int)slotIndex);
                if (slot != null) {
                    this.renderSlotOverlay(guiGraphics, slot, ERROR_SLOT_COLOR);
                }
            });
            upgradeSlotChangeResult.errorInventoryParts().forEach(partIndex -> {
                UpgradeInventoryPartBase<?> inventoryPart = this.inventoryParts.get(partIndex);
                if (inventoryPart != null) {
                    inventoryPart.renderErrorOverlay(guiGraphics);
                }
            });
            pose.popMatrix();
            this.renderErrorMessage(guiGraphics, pose, (Component)overlayErrorMessage);
        }));
    }

    private void renderErrorMessage(GuiGraphics guiGraphics, Matrix3x2fStack pose, Component overlayErrorMessage) {
        pose.pushMatrix();
        pose.translate((float)this.width / 2.0f, (float)this.topPos + (float)this.inventoryLabelY + 4.0f);
        Font fontrenderer = Minecraft.getInstance().font;
        int tooltipWidth = this.font.width((FormattedText)overlayErrorMessage);
        ArrayList<FormattedCharSequence> wrappedTextLines = new ArrayList<FormattedCharSequence>();
        int maxLineWidth = 260;
        if (tooltipWidth > maxLineWidth) {
            int wrappedTooltipWidth = 0;
            List wrappedLine = this.font.split((FormattedText)overlayErrorMessage, maxLineWidth);
            for (FormattedCharSequence line : wrappedLine) {
                int lineWidth = this.font.width(line);
                if (lineWidth > wrappedTooltipWidth) {
                    wrappedTooltipWidth = lineWidth;
                }
                wrappedTextLines.add(line);
            }
            tooltipWidth = wrappedTooltipWidth;
        } else {
            wrappedTextLines.add(overlayErrorMessage.getVisualOrderText());
        }
        int tooltipHeight = 8;
        if (wrappedTextLines.size() > 1) {
            tooltipHeight += 2 + (wrappedTextLines.size() - 1) * 10;
        }
        int leftX = -tooltipWidth / 2;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)leftX, (int)0, (int)tooltipWidth, (int)tooltipHeight, (ResourceLocation)SophisticatedCore.getRL("error"));
        MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
        GuiHelper.writeTooltipLines(guiGraphics, wrappedTextLines, fontrenderer, leftX, 0, ERROR_TEXT_COLOR);
        renderTypeBuffer.endBatch();
        pose.popMatrix();
    }

    @Override
    public boolean isMouseOverSlot(Slot slot, double mouseX, double mouseY) {
        return this.isHovering(slot, mouseX, mouseY);
    }

    protected boolean isHovering(Slot slot, double mouseX, double mouseY) {
        return super.isHovering(slot, mouseX, mouseY) && this.getUpgradeSettingsControl().slotIsNotCoveredAt(slot, mouseX, mouseY);
    }

    @Override
    public int getTopY() {
        return this.getGuiTop();
    }

    @Override
    public void drawSlotBg(GuiGraphics guiGraphics, int visibleSlotsCount) {
        this.drawSlotBg(guiGraphics, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2, visibleSlotsCount);
        this.drawSlotOverlays(guiGraphics);
        ((StorageContainerMenuBase)this.getMenu()).getExtraSlots().forEach(slot -> GuiHelper.renderSlotsBackground(guiGraphics, slot.x + this.leftPos - 1, slot.y + this.topPos - 1, 1, 1));
    }

    @Override
    public int getLeftX() {
        return this.getGuiLeft();
    }

    protected void containerTick() {
        super.containerTick();
        this.settingsTabControl.tick();
    }

    private class TransferButton
    extends Button {
        private final ButtonDefinition shiftDefinition;
        private final ButtonDefinition definition;

        public TransferButton(StorageScreenBase storageScreenBase, Consumer<Boolean> transferItems, ButtonDefinition shiftDefinition, ButtonDefinition definition) {
            super(new Position(storageScreenBase.leftPos, storageScreenBase.topPos), definition, (int button) -> {
                if (button == 0) {
                    transferItems.accept(!Minecraft.getInstance().hasShiftDown());
                }
            });
            this.shiftDefinition = shiftDefinition;
            this.definition = definition;
        }

        @Override
        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (Minecraft.getInstance().hasShiftDown()) {
                if (this.shiftDefinition.getForegroundTexture() != null) {
                    GuiHelper.blit(guiGraphics, this.x, this.y, this.shiftDefinition.getForegroundTexture());
                }
            } else if (this.definition.getForegroundTexture() != null) {
                GuiHelper.blit(guiGraphics, this.x, this.y, this.definition.getForegroundTexture());
            }
        }

        @Override
        protected List<Component> getTooltip() {
            if (Minecraft.getInstance().hasShiftDown()) {
                return this.shiftDefinition.getTooltip();
            }
            return this.definition.getTooltip();
        }
    }
}

