/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.drag.DraggableBoundsProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IFilterSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.SetGhostSlotPayload;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.rei.ReiGhostTarget;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeTab;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;

public class ReiStorageGhostIngredientHandler<S extends StorageScreenBase<?>>
implements DraggableStackVisitor<S> {
    private final Class<S> handingScreenClass;

    public ReiStorageGhostIngredientHandler(Class<S> handingScreenClass) {
        this.handingScreenClass = handingScreenClass;
    }

    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<S> context, DraggableStack stack) {
        Point cursor = context.getCurrentPosition();
        if (cursor != null) {
            Optional<ReiGhostTarget> target = this.getDraggableAcceptingBounds(context, stack).map(ReiGhostTarget.class::cast).filter(b -> b.contains(cursor.getX(), cursor.getY())).findFirst();
            if (target.isPresent()) {
                target.get().accept();
                return DraggedAcceptorResult.CONSUMED;
            }
        }
        return super.acceptDraggedStack(context, stack);
    }

    public Stream<DraggableStackVisitor.BoundsProvider> getDraggableAcceptingBounds(DraggingContext<S> context, DraggableStack stack) {
        ArrayList targets = new ArrayList();
        final StorageScreenBase screen = (StorageScreenBase)context.getScreen();
        if (stack.getStack().getType() == VanillaEntryTypes.ITEM) {
            StorageContainerMenuBase menu = (StorageContainerMenuBase)((StorageScreenBase)context.getScreen()).getMenu();
            Object object = stack.getStack().getValue();
            if (object instanceof ItemStack) {
                ItemStack ghostStack = (ItemStack)object;
                net.neoforged.neoforge.fluids.FluidStack fluidStack = CapabilityHelper.getFromCapability(ItemAccess.forStack((ItemStack)ghostStack), Capabilities.Fluid.ITEM, fluidHandler -> fluidHandler.size() > 0 ? ((FluidResource)fluidHandler.getResource(0)).toStack(1000) : net.neoforged.neoforge.fluids.FluidStack.EMPTY, net.neoforged.neoforge.fluids.FluidStack.EMPTY);
                if (!fluidStack.isEmpty()) {
                    screen.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, fluidStack, targets));
                    return targets.stream();
                }
                menu.getOpenContainer().ifPresent(c -> c.getSlots().forEach(s -> {
                    if (s instanceof IFilterSlot && s.mayPlace(ghostStack)) {
                        targets.add(new ReiGhostTarget(this, (Slot)s, ghostStack){
                            final /* synthetic */ Slot val$s;
                            final /* synthetic */ ItemStack val$ghostStack;
                            {
                                this.val$s = slot;
                                this.val$ghostStack = itemStack;
                            }

                            public VoxelShape bounds() {
                                return DraggableBoundsProvider.fromRectangle((Rectangle)new Rectangle(screen.getGuiLeft() + this.val$s.x, screen.getGuiTop() + this.val$s.y, 17, 17));
                            }

                            @Override
                            public void accept() {
                                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetGhostSlotPayload(this.val$ghostStack, this.val$s.index), (CustomPacketPayload[])new CustomPacketPayload[0]);
                            }
                        });
                    }
                }));
            }
        } else if (stack.getStack().getType() == VanillaEntryTypes.FLUID) {
            screen.getUpgradeSettingsControl().getOpenTab().filter(tab -> tab instanceof PumpUpgradeTab.Advanced).map(PumpUpgradeTab.Advanced.class::cast).ifPresent(pumpUpgradeTab -> {
                FluidStack ghostFluidStack = (FluidStack)stack.getStack().castValue();
                this.addFluidTargets((PumpUpgradeTab.Advanced)pumpUpgradeTab, new net.neoforged.neoforge.fluids.FluidStack(ghostFluidStack.getFluid(), (int)ghostFluidStack.getAmount()), targets);
            });
        }
        return targets.stream();
    }

    private void addFluidTargets(final PumpUpgradeTab.Advanced pumpUpgradeTab, final net.neoforged.neoforge.fluids.FluidStack ghostFluid, List<DraggableStackVisitor.BoundsProvider> targets) {
        List<Position> slotTopLeftPositions = pumpUpgradeTab.getFluidFilterControl().getSlotTopLeftPositions();
        final AtomicInteger slot = new AtomicInteger();
        slot.set(0);
        while (slot.get() < slotTopLeftPositions.size()) {
            final Position position = slotTopLeftPositions.get(slot.get());
            targets.add(new ReiGhostTarget(this){
                private final int slotIndex;
                {
                    this.slotIndex = slot.get();
                }

                public VoxelShape bounds() {
                    return DraggableBoundsProvider.fromRectangle((Rectangle)new Rectangle(position.x(), position.y(), 17, 17));
                }

                @Override
                public void accept() {
                    pumpUpgradeTab.getFluidFilterControl().setFluid(this.slotIndex, ghostFluid);
                }
            });
            slot.incrementAndGet();
        }
    }

    public <R extends Screen> boolean isHandingScreen(R screen) {
        return this.handingScreenClass.isInstance(screen);
    }
}

