/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.main;

import java.util.function.Consumer;
import java.util.function.Function;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.main.Context;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;

public class MainSettingsCategory
implements ISettingsCategory<MainSettingsCategory, MainSettingsCategoryData> {
    public static final String NAME = "global";
    private final Runnable save;
    private final String playerSettingsName;
    private final ContainerContents.SettingsData settingsData;
    private MainSettingsCategoryData data;

    public MainSettingsCategory(ContainerContents.SettingsData settingsData, MainSettingsCategoryData data, Runnable save, String playerSettingsName) {
        this.settingsData = settingsData;
        this.data = data;
        this.save = save;
        this.playerSettingsName = playerSettingsName;
    }

    public String getPlayerSettingsName() {
        return this.playerSettingsName;
    }

    @Override
    public void reloadFrom(MainSettingsCategoryData data) {
        this.data = data;
    }

    @Override
    public void overwriteWith(MainSettingsCategory otherCategory) {
    }

    public void toggleContext() {
        this.setContext(this.getContext() == Context.PLAYER ? Context.CONTAINER : Context.PLAYER);
        this.save.run();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return false;
    }

    @Override
    public void copyTo(MainSettingsCategory otherCategory, int startFromSlot, int slotOffset) {
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
    }

    public Context getContext() {
        return this.settingsData.mainSettingsContext();
    }

    public void setContext(Context context) {
        this.settingsData.setMainSettingsContext(context);
        this.save.run();
    }

    public void setValue(Consumer<MainSettingsCategoryData> setter) {
        setter.accept(this.data);
        this.save.run();
    }

    public <T> T getValue(Function<MainSettingsCategoryData, T> getter) {
        return getter.apply(this.data);
    }
}

