/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.nosort;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;

public class NoSortSettingsCategoryData
implements ContainerContents.ISettingsCategoryData<NoSortSettingsCategoryData> {
    public static final Codec<NoSortSettingsCategoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.setOf(Codec.INT).xmap(c -> new HashSet(c), Function.identity()).fieldOf("selectedSlots").forGetter(NoSortSettingsCategoryData::selectedSlots), (App)DyeColor.CODEC.fieldOf("color").forGetter(NoSortSettingsCategoryData::color)).apply((Applicative)instance, NoSortSettingsCategoryData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, NoSortSettingsCategoryData> STREAM_CODEC = StreamCodec.composite(StreamCodecHelper.ofCollection(ByteBufCodecs.VAR_INT, HashSet::new), NoSortSettingsCategoryData::selectedSlots, (StreamCodec)DyeColor.STREAM_CODEC, NoSortSettingsCategoryData::color, NoSortSettingsCategoryData::new);
    private Set<Integer> selectedSlots = new HashSet<Integer>();
    private DyeColor color = DyeColor.LIME;

    public NoSortSettingsCategoryData() {
    }

    public NoSortSettingsCategoryData(Set<Integer> selectedSlots, DyeColor color) {
        this.selectedSlots.addAll(selectedSlots);
        this.color = color;
    }

    public Set<Integer> selectedSlots() {
        return this.selectedSlots;
    }

    public DyeColor color() {
        return this.color;
    }

    @Override
    public String id() {
        return "no_sort";
    }

    @Override
    public NoSortSettingsCategoryData copy() {
        return new NoSortSettingsCategoryData(this.selectedSlots, this.color);
    }

    @Override
    public void reloadFrom(NoSortSettingsCategoryData other) {
        this.selectedSlots = new HashSet<Integer>(other.selectedSlots);
        this.color = other.color;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NoSortSettingsCategoryData)) {
            return false;
        }
        NoSortSettingsCategoryData that = (NoSortSettingsCategoryData)o;
        return Objects.equals(this.selectedSlots, that.selectedSlots) && this.color == that.color;
    }

    public int hashCode() {
        return Objects.hash(this.selectedSlots, this.color);
    }

    public void clearSelectedSlots() {
        this.selectedSlots.clear();
    }

    public void addSelectedSlot(int slot) {
        this.selectedSlots.add(slot);
    }

    public void removeSelectedSlot(int slotNumber) {
        this.selectedSlots.remove(slotNumber);
    }

    public void setColor(DyeColor color) {
        this.color = color;
    }

    public void addSelectedSlots(Set<Integer> noSortSlots) {
        this.selectedSlots.addAll(noSortSlots);
    }

    public void removeSelectedSlotAtOrAfter(int slotIndex) {
        this.selectedSlots.removeIf(slot -> slot >= slotIndex);
    }
}

