/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterAttributes;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;

public class ContentsFilterLogic
extends FilterLogic {
    private final Supplier<InventoryHandler> getInventoryHandler;
    private final MemorySettingsCategory memorySettings;

    public ContentsFilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Supplier<InventoryHandler> getInventoryHandler, MemorySettingsCategory memorySettings, DeferredHolder<DataComponentType<?>, DataComponentType<FilterAttributes>> filterAttributesComponent) {
        super(upgrade, saveHandler, filterSlotCount, filterAttributesComponent);
        this.getInventoryHandler = getInventoryHandler;
        this.memorySettings = memorySettings;
    }

    public ContentsFilterType getFilterType() {
        if (this.shouldFilterByStorage()) {
            return ContentsFilterType.STORAGE;
        }
        return this.isAllowList() ? ContentsFilterType.ALLOW : ContentsFilterType.BLOCK;
    }

    public void setDepositFilterType(ContentsFilterType contentsFilterType) {
        switch (contentsFilterType) {
            case ALLOW: {
                this.setFilterByStorage(false);
                this.setAllowList(true);
                break;
            }
            case BLOCK: {
                this.setFilterByStorage(false);
                this.setAllowList(false);
                break;
            }
            case STORAGE: {
                this.setFilterByStorage(true);
                this.save();
            }
        }
    }

    @Override
    protected boolean matchesFilter(Stream<TagKey<Item>> tags, Item item, int damageValue, boolean empty, DataComponentMap components) {
        if (!this.shouldFilterByStorage()) {
            return super.matchesFilter(tags, item, damageValue, empty, components);
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getFullStacks()) {
            if (!this.stackMatchesFilter(filterStack.stack(), item, damageValue, empty, components)) continue;
            return true;
        }
        for (ItemStackKey filterStack : this.getInventoryHandler.get().getSlotTracker().getPartialStacks()) {
            if (!this.stackMatchesFilter(filterStack.stack(), item, damageValue, empty, components)) continue;
            return true;
        }
        return this.memorySettings.matchesFilter(item, components);
    }

    private void setFilterByStorage(boolean filterByStorage) {
        this.setAttributes(attributes -> attributes.setFilterByStorage(filterByStorage));
        this.save();
    }

    protected boolean shouldFilterByStorage() {
        return this.getAttributes().filterByStorage();
    }
}

