/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.ThrownSplashPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ClearAllStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.RemoveStatusEffectsConsumeEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.network.EmitConsumableClientParticlesAndSoundsPayload;
import net.p3pp3rf1y.sophisticatedcore.upgrades.EntityMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyCondition;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyFilterAttribute;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class AlchemyUpgradeWrapper
extends UpgradeWrapperBase<AlchemyUpgradeWrapper, AlchemyUpgradeItem>
implements ITickableUpgrade {
    private static final int CHECK_INTERVAL = 5;
    private static final int CHECK_RADIUS = 3;
    private long nextCheckTime = 0L;
    private boolean applying = false;
    private LivingEntity applyingToEntity = null;
    private int remainingApplyTime = 0;
    private ItemStack stackBeingAplied = ItemStack.EMPTY;
    private AlchemyItemDefinition defBeingApplied = null;
    @Nullable
    private ObservableFilterItemStackHandler filterHandler = null;
    private static List<AlchemyItemDefinition> itemDefinitions = new ArrayList<AlchemyItemDefinition>();
    private static final Method ON_HIT;

    protected AlchemyUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
    }

    public List<AlchemyFilterAttribute> getFilterAttributes() {
        return (List)this.upgrade.getOrDefault(ModCoreDataComponents.ALCHEMY_FILTER_ATTRIBUTES, this.getEmptyAttributes());
    }

    private List<AlchemyFilterAttribute> getEmptyAttributes() {
        ArrayList<AlchemyFilterAttribute> emptyAttributes = new ArrayList<AlchemyFilterAttribute>();
        for (int i = 0; i < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount(); ++i) {
            emptyAttributes.add(new AlchemyFilterAttribute(ItemStack.EMPTY, AlchemyCondition.NEVER));
        }
        return emptyAttributes;
    }

    private void setFilter(int slot, ItemStack filter) {
        ArrayList<AlchemyFilterAttribute> attributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
        AlchemyFilterAttribute attribute = (AlchemyFilterAttribute)attributes.get(slot);
        if (attribute.filter().isEmpty()) {
            AlchemyCondition defaultConditionForPotion = itemDefinitions.stream().filter(def -> def.filter.test(filter)).findFirst().map(def -> def.getDefaultCondition.apply(filter)).orElse(AlchemyCondition.NEVER);
            attribute = attribute.setConditionAndValue(defaultConditionForPotion, defaultConditionForPotion.defaultValue());
        } else if (filter.isEmpty()) {
            attribute = attribute.setConditionAndValue(AlchemyCondition.NEVER, -1.0f);
        }
        attribute = attribute.setFilter(filter);
        attributes.set(slot, attribute);
        this.setUpgradeStackAlchemyAttributes(attributes);
        this.save();
    }

    public AlchemyCondition getCondition(int slot) {
        return this.getFilterAttributes().get(slot).condition();
    }

    public float getValue(int slot) {
        return this.getFilterAttributes().get(slot).value();
    }

    public void setConditionValue(int slot, AlchemyCondition condition, float value) {
        ArrayList<AlchemyFilterAttribute> attributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
        attributes.set(slot, ((AlchemyFilterAttribute)attributes.get(slot)).setConditionAndValue(condition, value));
        this.setUpgradeStackAlchemyAttributes(attributes);
        this.save();
    }

    private void setUpgradeStackAlchemyAttributes(List<AlchemyFilterAttribute> attributes) {
        this.upgrade.set(ModCoreDataComponents.ALCHEMY_FILTER_ATTRIBUTES, (Object)(attributes instanceof ImmutableList ? attributes : ImmutableList.copyOf(attributes)));
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.isClientSide() || this.nextCheckTime > level.getGameTime()) {
            return;
        }
        if (this.remainingApplyTime > 0) {
            --this.remainingApplyTime;
            if (this.remainingApplyTime <= 0) {
                if (this.defBeingApplied.hasItemUseEffects()) {
                    this.triggerItemUseEffects();
                }
                this.applying = false;
                ItemStack remainingStack = this.defBeingApplied.finishUsing.apply(this.stackBeingAplied, this.applyingToEntity);
                this.stackBeingAplied = ItemStack.EMPTY;
                this.applyingToEntity = null;
                this.defBeingApplied = null;
                InventoryHelper.insert(this.storageWrapper.getInventoryForUpgradeProcessing(), ItemResource.of((ItemStack)remainingStack), remainingStack.getCount());
                this.nextCheckTime = level.getGameTime() + 5L;
            } else if (this.shouldTriggerItemUseEffects()) {
                this.triggerItemUseEffects();
            }
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.applyTo(livingEntity);
        } else {
            List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(3.0), this::entityMatches);
            for (LivingEntity livingEntity : entities) {
                this.applyTo(livingEntity);
                if (!this.applying) continue;
                break;
            }
        }
        if (!this.applying) {
            this.nextCheckTime = level.getGameTime() + 5L;
        }
    }

    private boolean entityMatches(LivingEntity livingEntity) {
        if (!livingEntity.isAlive()) {
            return false;
        }
        switch (this.getEntityMatch()) {
            case PLAYERS: {
                return livingEntity instanceof Player;
            }
            case ENTITIES: {
                return !(livingEntity instanceof Player);
            }
            case PLAYERS_AND_ENTITIES: {
                return true;
            }
        }
        return false;
    }

    public void triggerItemUseEffects() {
        Consumable consumable = (Consumable)this.stackBeingAplied.get(DataComponents.CONSUMABLE);
        if (consumable == null) {
            return;
        }
        consumable.emitParticlesAndSounds(this.applyingToEntity.getRandom(), this.applyingToEntity, this.stackBeingAplied, 5);
        LivingEntity livingEntity = this.applyingToEntity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new EmitConsumableClientParticlesAndSoundsPayload(this.stackBeingAplied), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private boolean shouldTriggerItemUseEffects() {
        int effectDelay;
        if (this.remainingApplyTime < 2) {
            return false;
        }
        int applyTimePassed = this.stackBeingAplied.getUseDuration(this.applyingToEntity) - this.remainingApplyTime;
        boolean canStartTriggering = applyTimePassed > (effectDelay = (int)((float)this.stackBeingAplied.getUseDuration(this.applyingToEntity) * 0.21875f));
        return canStartTriggering && this.remainingApplyTime % 4 == 0;
    }

    private void applyTo(LivingEntity livingEntity) {
        for (AlchemyFilterAttribute filterAttribute : this.getFilterAttributes()) {
            if (filterAttribute.filter().isEmpty() || !filterAttribute.condition().test(livingEntity, filterAttribute.value())) continue;
            itemDefinitions.stream().filter(def -> def.filter.test(filterAttribute.filter())).findFirst().ifPresent(def -> {
                if (def.canApply.test(livingEntity, filterAttribute.filter(), this.shouldMatchAllEffects(), this.shouldMatchEffectAmplifier())) {
                    InventoryHelper.iterate(this.storageWrapper.getInventoryForUpgradeProcessing(), (slot, stack) -> {
                        if (def.filter().test((ItemStack)stack) && def.stackMatches.test((ItemStack)stack, filterAttribute.filter(), this.shouldMatchAllEffects(), this.shouldMatchEffectDuration(), this.shouldMatchEffectAmplifier())) {
                            this.remainingApplyTime = def.startUsing.applyAsInt((ItemStack)stack, livingEntity);
                            if (this.remainingApplyTime > 0) {
                                this.applying = true;
                                this.stackBeingAplied = stack.copyWithCount(1);
                                this.defBeingApplied = def;
                                this.applyingToEntity = livingEntity;
                            }
                            stack.shrink(1);
                            this.storageWrapper.getInventoryForUpgradeProcessing().setStackInSlot((int)slot, (ItemStack)stack);
                        }
                    }, () -> this.applying);
                }
            });
        }
    }

    public static void addItemDefinition(AlchemyItemDefinition itemDefinition) {
        itemDefinitions.add(itemDefinition);
    }

    private static AlchemyCondition getDefaultConditionForConsumable(ItemStack stack) {
        Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
        if (consumable == null) {
            return AlchemyCondition.NEVER;
        }
        List consumeEffects = consumable.onConsumeEffects();
        for (ConsumeEffect consumeEffect : consumeEffects) {
            if (consumeEffect instanceof ClearAllStatusEffectsConsumeEffect) {
                return AlchemyCondition.NEGATIVE_EFFECT;
            }
            if (consumeEffect instanceof RemoveStatusEffectsConsumeEffect) {
                return AlchemyCondition.NEGATIVE_EFFECT;
            }
            if (!(consumeEffect instanceof ApplyStatusEffectsConsumeEffect)) continue;
            ApplyStatusEffectsConsumeEffect applyStatusEffectsConsumeEffect = (ApplyStatusEffectsConsumeEffect)consumeEffect;
            List effects = applyStatusEffectsConsumeEffect.effects();
            if (effects.isEmpty()) {
                return AlchemyCondition.NEVER;
            }
            return AlchemyUpgradeWrapper.getDefaultConditionForEffect((Holder<MobEffect>)((MobEffectInstance)effects.getFirst()).getEffect());
        }
        return AlchemyCondition.NEVER;
    }

    private static boolean isEffectAffectingConsumable(ItemStack stack) {
        Consumable consumable = (Consumable)stack.get(DataComponents.CONSUMABLE);
        if (consumable == null) {
            return false;
        }
        List consumeEffects = consumable.onConsumeEffects();
        for (ConsumeEffect consumeEffect : consumeEffects) {
            if (!(consumeEffect instanceof ClearAllStatusEffectsConsumeEffect) && !(consumeEffect instanceof RemoveStatusEffectsConsumeEffect) && !(consumeEffect instanceof ApplyStatusEffectsConsumeEffect)) continue;
            return true;
        }
        return false;
    }

    private static void onHit(AbstractThrownPotion thrownPotion, EntityHitResult entityHitResult) {
        try {
            ON_HIT.invoke((Object)thrownPotion, entityHitResult);
        }
        catch (Exception e) {
            SophisticatedCore.LOGGER.error("Failed to invoke ThrownPotion::onHit method", (Throwable)e);
        }
    }

    public static boolean stackPotionEffectsMatch(ItemStack stack, ItemStack filter, boolean matchAllEffects, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        if (matchAllEffects && matchEffectDuration && matchEffectAmplifier) {
            return ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack);
        }
        PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        PotionContents filterPotionContents = (PotionContents)filter.get(DataComponents.POTION_CONTENTS);
        if (potioncontents == null || filterPotionContents == null) {
            return false;
        }
        if (!potioncontents.hasEffects() || !filterPotionContents.hasEffects()) {
            return false;
        }
        for (MobEffectInstance filterEffectInstance : filterPotionContents.getAllEffects()) {
            if (!AlchemyUpgradeWrapper.matchEffectIn(potioncontents, filterEffectInstance, matchEffectDuration, matchEffectAmplifier)) {
                return false;
            }
            if (matchAllEffects) continue;
            return true;
        }
        return true;
    }

    private static boolean matchEffectIn(PotionContents potionContents, MobEffectInstance filterEffectInstance, boolean matchEffectDuration, boolean matchEffectAmplifier) {
        for (MobEffectInstance effectInstance : potionContents.getAllEffects()) {
            Holder effect = effectInstance.getEffect();
            if (effect != filterEffectInstance.getEffect() || matchEffectDuration && effectInstance.getDuration() != filterEffectInstance.getDuration() || matchEffectAmplifier && effectInstance.getAmplifier() != filterEffectInstance.getAmplifier()) continue;
            return true;
        }
        return false;
    }

    public static AlchemyCondition getDefaultConditionForPotion(ItemStack potionStack) {
        PotionContents potioncontents = (PotionContents)potionStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        Iterator it = potioncontents.getAllEffects().iterator();
        if (!it.hasNext()) {
            return AlchemyCondition.NEVER;
        }
        Holder effect = ((MobEffectInstance)it.next()).getEffect();
        return AlchemyUpgradeWrapper.getDefaultConditionForEffect((Holder<MobEffect>)effect);
    }

    private static AlchemyCondition getDefaultConditionForEffect(Holder<MobEffect> effect) {
        if (effect == MobEffects.WATER_BREATHING) {
            return AlchemyCondition.UNDER_WATER;
        }
        if (effect == MobEffects.INSTANT_HEALTH || effect == MobEffects.REGENERATION) {
            return AlchemyCondition.HURT;
        }
        if (effect == MobEffects.FIRE_RESISTANCE) {
            return AlchemyCondition.ON_FIRE;
        }
        if (effect == MobEffects.SPEED) {
            return AlchemyCondition.SPRINTING;
        }
        if (effect == MobEffects.HASTE) {
            return AlchemyCondition.MINING;
        }
        if (effect == MobEffects.SLOW_FALLING) {
            return AlchemyCondition.FALLING;
        }
        return AlchemyCondition.ALWAYS;
    }

    public static boolean shouldApplyPotionEffectsTo(LivingEntity le, ItemStack potionStack, boolean matchAllEffects, boolean matchEffectAmplifier) {
        PotionContents potioncontents = (PotionContents)potionStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (!potioncontents.hasEffects()) {
            return false;
        }
        for (MobEffectInstance effectInstance : potioncontents.getAllEffects()) {
            if (matchAllEffects) {
                if (AlchemyUpgradeWrapper.effectPresent(le, (Holder<MobEffect>)effectInstance.getEffect(), matchEffectAmplifier, effectInstance.getAmplifier())) continue;
                return true;
            }
            if (!AlchemyUpgradeWrapper.effectPresent(le, (Holder<MobEffect>)effectInstance.getEffect(), matchEffectAmplifier, effectInstance.getAmplifier())) continue;
            return false;
        }
        return !matchAllEffects;
    }

    private static boolean effectPresent(LivingEntity le, Holder<MobEffect> effect, boolean matchEffectAmplifier, int amplifier) {
        MobEffectInstance leEffectInstance = le.getEffect(effect);
        return leEffectInstance != null && (!matchEffectAmplifier || leEffectInstance.getAmplifier() >= amplifier);
    }

    private static boolean shouldApplyConsumableEffectsTo(LivingEntity le, ItemStack potionStack, boolean matchAllEffects, boolean matchEffectAmplifier) {
        Consumable consumable = (Consumable)potionStack.get(DataComponents.CONSUMABLE);
        if (consumable == null) {
            return false;
        }
        for (ConsumeEffect consumeEffect : consumable.onConsumeEffects()) {
            if (consumeEffect instanceof ApplyStatusEffectsConsumeEffect) {
                ApplyStatusEffectsConsumeEffect applyStatusEffects = (ApplyStatusEffectsConsumeEffect)consumeEffect;
                return AlchemyUpgradeWrapper.areEffectsMissing(le, matchAllEffects, matchEffectAmplifier, applyStatusEffects.effects());
            }
            if (consumeEffect instanceof ClearAllStatusEffectsConsumeEffect) {
                return true;
            }
            if (!(consumeEffect instanceof RemoveStatusEffectsConsumeEffect)) continue;
            RemoveStatusEffectsConsumeEffect removeStatusEffects = (RemoveStatusEffectsConsumeEffect)consumeEffect;
            return AlchemyUpgradeWrapper.areEffectsPresent(le, matchAllEffects, matchEffectAmplifier, (HolderSet<MobEffect>)removeStatusEffects.effects());
        }
        return false;
    }

    private static boolean areEffectsMissing(LivingEntity le, boolean matchAllEffects, boolean matchEffectAmplifier, List<MobEffectInstance> effects) {
        for (MobEffectInstance effectInstance : effects) {
            if (matchAllEffects) {
                if (AlchemyUpgradeWrapper.effectPresent(le, (Holder<MobEffect>)effectInstance.getEffect(), matchEffectAmplifier, effectInstance.getAmplifier())) continue;
                return true;
            }
            if (!AlchemyUpgradeWrapper.effectPresent(le, (Holder<MobEffect>)effectInstance.getEffect(), matchEffectAmplifier, effectInstance.getAmplifier())) continue;
            return false;
        }
        return !matchAllEffects;
    }

    private static boolean areEffectsPresent(LivingEntity le, boolean matchAllEffects, boolean matchEffectAmplifier, HolderSet<MobEffect> effects) {
        for (Holder effect : effects) {
            if (le.hasEffect(effect)) {
                if (matchAllEffects) continue;
                return true;
            }
            if (!matchAllEffects) continue;
            return false;
        }
        return matchAllEffects;
    }

    public boolean isValidAlchemyItem(ItemStack stack) {
        return itemDefinitions.stream().anyMatch(def -> def.filter.test(stack)) && !InventoryHelper.hasItem((ResourceHandler<ItemResource>)this.getFilterHandler(), s -> s.matches(stack));
    }

    public ObservableFilterItemStackHandler getFilterHandler() {
        List<AlchemyFilterAttribute> filterAttributes = this.getFilterAttributes();
        if (this.filterHandler == null) {
            if (filterAttributes.size() < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount()) {
                filterAttributes = new ArrayList<AlchemyFilterAttribute>(this.getFilterAttributes());
                for (int i = filterAttributes.size(); i < ((AlchemyUpgradeItem)this.upgradeItem).getFilterSlotCount(); ++i) {
                    filterAttributes.add(new AlchemyFilterAttribute(ItemStack.EMPTY, AlchemyCondition.NEVER));
                }
                this.setUpgradeStackAlchemyAttributes(filterAttributes);
            }
            this.filterHandler = new ObservableFilterItemStackHandler(filterAttributes.size());
            this.filterHandler.initFilters(filterAttributes);
        }
        return this.filterHandler;
    }

    public void setMatchAllEffects(boolean matchAllEffects) {
        this.upgrade.set(ModCoreDataComponents.MATCH_ALL_EFFECTS, (Object)matchAllEffects);
        this.save();
    }

    public boolean shouldMatchAllEffects() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.MATCH_ALL_EFFECTS, (Object)true);
    }

    public boolean shouldMatchEffectDuration() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.MATCH_EFFECT_DURATION, (Object)true);
    }

    public void setMatchEffectDuration(boolean matchEffectDuration) {
        this.upgrade.set(ModCoreDataComponents.MATCH_EFFECT_DURATION, (Object)matchEffectDuration);
        this.save();
    }

    public boolean shouldMatchEffectAmplifier() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.MATCH_EFFECT_AMPLIFIER, (Object)true);
    }

    public void setMatchEffectAmplifier(boolean matchEffectAmplifier) {
        this.upgrade.set(ModCoreDataComponents.MATCH_EFFECT_AMPLIFIER, (Object)matchEffectAmplifier);
        this.save();
    }

    public EntityMatch getEntityMatch() {
        return (EntityMatch)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.ENTITY_MATCH, (Object)EntityMatch.PLAYERS_AND_ENTITIES));
    }

    public void setEntityMatch(EntityMatch entityMatch) {
        this.upgrade.set(ModCoreDataComponents.ENTITY_MATCH, (Object)entityMatch);
        this.save();
    }

    static {
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.getItem() == Items.OMINOUS_BOTTLE, stack -> AlchemyCondition.ALWAYS, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> !le.hasEffect(MobEffects.BAD_OMEN), (stack, filter, matchAllEffects, matchEffectDuration, matchEffectAmplifier) -> stack.getItem() == Items.OMINOUS_BOTTLE, ItemStack::getUseDuration, (stack, livingEntity) -> stack.finishUsingItem(livingEntity.level(), livingEntity)));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.getItem() == Items.SPLASH_POTION, AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, (stack, livingEntity) -> {
            Level level = livingEntity.level();
            level.playSound(null, livingEntity.getX() + (double)(livingEntity.getBbWidth() / 2.0f), livingEntity.getY(), livingEntity.getZ() + (double)(livingEntity.getBbWidth() / 2.0f), SoundEvents.SPLASH_POTION_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            ThrownSplashPotion thrownPotion = new ThrownSplashPotion(level, livingEntity.getX() + (double)(livingEntity.getBbWidth() / 2.0f), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ() + (double)(livingEntity.getBbWidth() / 2.0f), stack);
            AlchemyUpgradeWrapper.onHit((AbstractThrownPotion)thrownPotion, new EntityHitResult((Entity)livingEntity, new Vec3(livingEntity.getX(), livingEntity.getY() + (double)livingEntity.getEyeHeight(), livingEntity.getZ())));
            return 1;
        }, (stack, livingEntity) -> ItemStack.EMPTY, false));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.getItem() == Items.POTION, AlchemyUpgradeWrapper::getDefaultConditionForPotion, AlchemyUpgradeWrapper::shouldApplyPotionEffectsTo, AlchemyUpgradeWrapper::stackPotionEffectsMatch, ItemStack::getUseDuration, (stack, livingEntity) -> {
            ItemStack remainingItem = stack.finishUsingItem(livingEntity.level(), livingEntity);
            if (livingEntity instanceof Player) {
                return remainingItem;
            }
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(stack -> stack.getItem() == Items.GOLDEN_APPLE, stack -> AlchemyCondition.ALWAYS, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> {
            if (le instanceof ZombieVillager) {
                ZombieVillager zombieVillager = (ZombieVillager)le;
                return !zombieVillager.isConverting() && zombieVillager.hasEffect(MobEffects.WEAKNESS);
            }
            if (le instanceof Player) {
                return AlchemyUpgradeWrapper.shouldApplyConsumableEffectsTo(le, potionStack, matchAllEffects, matchEffectAmplifier);
            }
            return false;
        }, (stack, filter, matchAllEffects, matchEffectDuration, matchEffectAmplifier) -> ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack), ItemStack::getUseDuration, (stack, livingEntity) -> {
            ZombieVillager zombieVillager;
            if (livingEntity instanceof ZombieVillager && (zombieVillager = (ZombieVillager)livingEntity).hasEffect(MobEffects.WEAKNESS)) {
                zombieVillager.startConverting(null, livingEntity.level().random.nextInt(2401) + 3600);
                return ItemStack.EMPTY;
            }
            return stack.finishUsingItem(livingEntity.level(), livingEntity);
        }));
        AlchemyUpgradeWrapper.addItemDefinition(new AlchemyItemDefinition(AlchemyUpgradeWrapper::isEffectAffectingConsumable, AlchemyUpgradeWrapper::getDefaultConditionForConsumable, (le, potionStack, matchAllEffects, matchEffectAmplifier) -> {
            if (le instanceof Player) {
                return AlchemyUpgradeWrapper.shouldApplyConsumableEffectsTo(le, potionStack, matchAllEffects, matchEffectAmplifier);
            }
            return false;
        }, (stack, filter, matchAllEffects, matchEffectDuration, matchEffectAmplifier) -> ItemStack.isSameItemSameComponents((ItemStack)filter, (ItemStack)stack), ItemStack::getUseDuration, (stack, livingEntity) -> stack.finishUsingItem(livingEntity.level(), livingEntity)));
        ON_HIT = ObfuscationReflectionHelper.findMethod(AbstractThrownPotion.class, (String)"onHit", (Class[])new Class[]{HitResult.class});
    }

    public record AlchemyItemDefinition(Predicate<ItemStack> filter, Function<ItemStack, AlchemyCondition> getDefaultCondition, AlchemyItemEntityMatcher canApply, AlchemyItemStackMatcher stackMatches, StartUsing startUsing, FinishUsing finishUsing, boolean hasItemUseEffects) {
        public AlchemyItemDefinition(Predicate<ItemStack> filter, Function<ItemStack, AlchemyCondition> getDefaultCondition, AlchemyItemEntityMatcher canApply, AlchemyItemStackMatcher stackMatches, StartUsing startUsing, FinishUsing finishUsing) {
            this(filter, getDefaultCondition, canApply, stackMatches, startUsing, finishUsing, true);
        }
    }

    public class ObservableFilterItemStackHandler
    extends FilterItemStackHandler {
        public ObservableFilterItemStackHandler(int filterSlotCount) {
            super(filterSlotCount);
        }

        @Override
        protected void onContentsChanged(int slot, ItemStack previousContents) {
            super.onContentsChanged(slot, previousContents);
            AlchemyUpgradeWrapper.this.setFilter(slot, (ItemStack)this.stacks.get(slot));
            AlchemyUpgradeWrapper.this.save();
        }

        public boolean isValid(int index, ItemResource resource) {
            return resource.isEmpty() || this.doesNotContain(resource) && AlchemyUpgradeWrapper.this.isValidAlchemyItem(resource.toStack());
        }

        private boolean doesNotContain(ItemResource resource) {
            return !InventoryHelper.hasItem((ResourceHandler<ItemResource>)this, s -> s.equals((Object)resource));
        }

        public void initFilters(List<AlchemyFilterAttribute> filterAttributes) {
            for (int slot = 0; slot < filterAttributes.size(); ++slot) {
                this.setStackInSlot(slot, filterAttributes.get(slot).filter().copy());
            }
            this.updateEmptyFilters();
        }
    }

    public static interface FinishUsing {
        public ItemStack apply(ItemStack var1, LivingEntity var2);
    }

    public static interface AlchemyItemEntityMatcher {
        public boolean test(LivingEntity var1, ItemStack var2, boolean var3, boolean var4);
    }

    public static interface AlchemyItemStackMatcher {
        public boolean test(ItemStack var1, ItemStack var2, boolean var3, boolean var4, boolean var5);
    }

    public static interface StartUsing {
        public int applyAsInt(ItemStack var1, LivingEntity var2);
    }
}

