/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.client.gui.INameableEmptySlot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeWrapper;

public class BatteryUpgradeContainer
extends UpgradeContainerBase<BatteryUpgradeWrapper, BatteryUpgradeContainer> {
    public static final ResourceLocation EMPTY_BATTERY_INPUT_SLOT_BACKGROUND = SophisticatedCore.getRL("container/slot/battery_input");
    public static final ResourceLocation EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND = SophisticatedCore.getRL("container/slot/battery_output");

    public BatteryUpgradeContainer(Player player, int upgradeContainerId, BatteryUpgradeWrapper upgradeWrapper, UpgradeContainerType<BatteryUpgradeWrapper, BatteryUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        this.slots.add(new BatteryIOSlot(this, () -> ((BatteryUpgradeWrapper)this.upgradeWrapper).getInventory(), 0, -100, -100, TranslationHelper.INSTANCE.translUpgradeSlotTooltip("battery_input")){

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        }.setBackground(EMPTY_BATTERY_INPUT_SLOT_BACKGROUND));
        this.slots.add(new BatteryIOSlot(this, () -> ((BatteryUpgradeWrapper)this.upgradeWrapper).getInventory(), 1, -100, -100, TranslationHelper.INSTANCE.translUpgradeSlotTooltip("battery_output")){

            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        }.setBackground(EMPTY_BATTERY_OUTPUT_SLOT_BACKGROUND));
    }

    @Override
    public void handlePacket(CompoundTag data) {
    }

    public int getEnergyStored() {
        return ((BatteryUpgradeWrapper)this.upgradeWrapper).getAmountAsInt();
    }

    public int getMaxEnergyStored() {
        return ((BatteryUpgradeWrapper)this.upgradeWrapper).getCapacityAsInt();
    }

    private static class BatteryIOSlot
    extends SlotSuppliedHandler
    implements INameableEmptySlot {
        private final Component emptyTooltip;
        private final int slot;

        public BatteryIOSlot(Supplier<ResourceHandler<ItemResource>> itemHandlerSupplier, int slot, int xPosition, int yPosition, Component emptyTooltip) {
            super(itemHandlerSupplier, slot, xPosition, yPosition);
            this.emptyTooltip = emptyTooltip;
            this.slot = slot;
        }

        @Override
        public boolean hasEmptyTooltip() {
            return true;
        }

        @Override
        public Component getEmptyTooltip() {
            return this.emptyTooltip;
        }

        @Override
        public boolean mayPlace(ItemStack stack) {
            return super.mayPlace(stack) && this.isValidEnergyItem(stack, this.slot == 1);
        }

        private boolean isValidEnergyItem(ItemStack stack, boolean isOutput) {
            ItemAccess itemAccess = ItemAccess.forStack((ItemStack)stack);
            return this.isValidEnergyItem(itemAccess, isOutput);
        }

        private boolean isValidEnergyItem(ItemAccess itemAccess, boolean isOutput) {
            EnergyHandler energyStorage = (EnergyHandler)itemAccess.getCapability(Capabilities.Energy.ITEM);
            if (energyStorage == null) {
                return false;
            }
            if (isOutput) {
                return this.canReceive(energyStorage);
            }
            return this.canExtract(energyStorage) && energyStorage.getAmountAsLong() > 0L;
        }

        private boolean canReceive(EnergyHandler energyHandler) {
            try (Transaction tx = Transaction.openRoot();){
                boolean bl = energyHandler.insert(1, (TransactionContext)tx) > 0;
                return bl;
            }
        }

        private boolean canExtract(EnergyHandler energyHandler) {
            try (Transaction tx = Transaction.openRoot();){
                boolean bl = energyHandler.extract(1, (TransactionContext)tx) > 0;
                return bl;
            }
        }
    }
}

