/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.compacting;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class CompactingUpgradeWrapper
extends UpgradeWrapperBase<CompactingUpgradeWrapper, CompactingUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToCompact = new HashSet<Integer>();

    public CompactingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((CompactingUpgradeItem)this.upgradeItem).getFilterSlotCount(), stack -> RecipeHelper.getItemCompactingShapes(stack).stream().anyMatch(shape -> shape != RecipeHelper.CompactingShape.NONE), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    @Override
    public int onBeforeInsert(InventoryHandler inventoryHandler, int slot, ItemResource resource, int amount) {
        return 0;
    }

    @Override
    public void onAfterInsert(InventoryHandler inventoryHandler, int slot, TransactionContext tx) {
        this.compactSlot(inventoryHandler, slot, tx);
    }

    private void compactSlot(ITrackedContentsItemResourceHandler inventoryHandler, int slot, TransactionContext tx) {
        ItemStack stack = inventoryHandler.getStackInSlot(slot);
        if (stack.isEmpty() || !this.filterLogic.matchesFilter(stack)) {
            return;
        }
        Set<RecipeHelper.CompactingShape> shapes = RecipeHelper.getItemCompactingShapes(stack);
        if (((CompactingUpgradeItem)this.upgradeItem).shouldCompactThreeByThree() && (shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.THREE_BY_THREE))) {
            this.tryCompacting(inventoryHandler, stack, 3, 3, tx);
        } else if (shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) || this.shouldCompactNonUncraftable() && shapes.contains((Object)RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            this.tryCompacting(inventoryHandler, stack, 2, 2, tx);
        }
    }

    private void tryCompacting(ResourceHandler<ItemResource> inventoryHandler, ItemStack stack, int width, int height, TransactionContext tx) {
        int totalCount = width * height;
        RecipeHelper.CompactingResult compactingResult = RecipeHelper.getCompactingResult(stack, width, height);
        if (!compactingResult.getResult().isEmpty()) {
            try (Transaction childTx = Transaction.open((TransactionContext)tx);){
                ItemResource resource = ItemResource.of((ItemStack)stack);
                int extracted = inventoryHandler.extract((Resource)resource, totalCount, (TransactionContext)childTx);
                boolean hasCompacted = false;
                int insertBackIntoSlot = -1;
                block6: while (extracted == totalCount) {
                    List<ItemStack> remainingItemsCopy;
                    ItemStack resultCopy = compactingResult.getResult().copy();
                    List<ItemStack> list = remainingItemsCopy = compactingResult.getRemainingItems().isEmpty() ? Collections.emptyList() : compactingResult.getRemainingItems().stream().map(ItemStack::copy).toList();
                    if (inventoryHandler.insert((Resource)ItemResource.of((ItemStack)resultCopy), resultCopy.getCount(), (TransactionContext)childTx) != resultCopy.getCount() || !InventoryHelper.insertIntoInventory(remainingItemsCopy, inventoryHandler, (TransactionContext)childTx).isEmpty()) {
                        return;
                    }
                    hasCompacted = true;
                    extracted = 0;
                    for (int slot = 0; slot < inventoryHandler.size(); ++slot) {
                        if ((extracted += inventoryHandler.extract(slot, (Resource)resource, totalCount, (TransactionContext)childTx)) <= 0) continue;
                        if (insertBackIntoSlot == -1) {
                            insertBackIntoSlot = slot;
                        }
                        if (extracted == totalCount) continue block6;
                    }
                }
                if (hasCompacted) {
                    if (extracted > 0) {
                        inventoryHandler.insert(insertBackIntoSlot, (Resource)resource, extracted, (TransactionContext)childTx);
                    }
                    childTx.commit();
                }
            }
        }
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldCompactNonUncraftable() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.COMPACT_NON_UNCRAFTABLE, (Object)false);
    }

    public void setCompactNonUncraftable(boolean shouldCompactNonUncraftable) {
        this.upgrade.set(ModCoreDataComponents.COMPACT_NON_UNCRAFTABLE, (Object)shouldCompactNonUncraftable);
        this.save();
    }

    @Override
    public void onSlotChange(InventoryHandler inventoryHandler, int slot) {
        if (this.shouldWorkInGUI()) {
            this.slotsToCompact.add(slot);
        }
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.slotsToCompact.isEmpty()) {
            return;
        }
        try (Transaction tx = Transaction.openRoot();){
            for (int slot : this.slotsToCompact) {
                this.compactSlot(this.storageWrapper.getInventoryForUpgradeProcessing(), slot, (TransactionContext)tx);
            }
            tx.commit();
        }
        this.slotsToCompact.clear();
    }
}

