/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.RepeatMode;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class JukeboxUpgradeContainer
extends UpgradeContainerBase<JukeboxUpgradeWrapper, JukeboxUpgradeContainer> {
    private static final String ACTION_DATA = "action";

    public JukeboxUpgradeContainer(Player player, int upgradeContainerId, JukeboxUpgradeWrapper upgradeWrapper, UpgradeContainerType<JukeboxUpgradeWrapper, JukeboxUpgradeContainer> type) {
        super(player, upgradeContainerId, upgradeWrapper, type);
        for (int slot = 0; slot < upgradeWrapper.getDiscInventory().size(); ++slot) {
            int finalSlot = slot;
            this.slots.add(new ResourceHandlerSlot(this, (ResourceHandler)upgradeWrapper.getDiscInventory(), (index, resource, amount) -> {
                upgradeWrapper.getDiscInventory().set(index, resource, amount);
                if (upgradeWrapper.isPlaying() && finalSlot == upgradeWrapper.getDiscSlotActive()) {
                    upgradeWrapper.stop((LivingEntity)player);
                }
            }, slot, -100, -100){});
        }
    }

    @Override
    public void handlePacket(CompoundTag data) {
        data.getString(ACTION_DATA).ifPresent(actionName -> {
            switch (actionName) {
                case "play": {
                    AbstractContainerMenu patt0$temp = this.player.containerMenu;
                    if (!(patt0$temp instanceof StorageContainerMenuBase)) break;
                    StorageContainerMenuBase storageContainerMenu = (StorageContainerMenuBase)patt0$temp;
                    storageContainerMenu.getBlockPosition().ifPresentOrElse(pos -> ((JukeboxUpgradeWrapper)this.upgradeWrapper).play(this.player.level(), (BlockPos)pos), () -> ((JukeboxUpgradeWrapper)this.upgradeWrapper).play(storageContainerMenu.getEntity().orElse((Entity)this.player)));
                    break;
                }
                case "stop": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).stop((LivingEntity)this.player);
                    break;
                }
                case "next": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).next();
                    break;
                }
                case "previous": {
                    ((JukeboxUpgradeWrapper)this.upgradeWrapper).previous();
                }
            }
        });
        data.getBoolean("shuffle").ifPresent(((JukeboxUpgradeWrapper)this.upgradeWrapper)::setShuffleEnabled);
        NBTHelper.getEnumConstant(data, "repeat", RepeatMode::fromName).ifPresent(((JukeboxUpgradeWrapper)this.upgradeWrapper)::setRepeatMode);
    }

    public void play() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "play"));
    }

    public void stop() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "stop"));
    }

    public void next() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "next"));
    }

    public void previous() {
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_DATA, "previous"));
    }

    public boolean isShuffleEnabled() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).isShuffleEnabled();
    }

    public void toggleShuffle() {
        boolean newValue = !((JukeboxUpgradeWrapper)this.upgradeWrapper).isShuffleEnabled();
        ((JukeboxUpgradeWrapper)this.upgradeWrapper).setShuffleEnabled(newValue);
        this.sendBooleanToServer("shuffle", newValue);
    }

    public RepeatMode getRepeatMode() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).getRepeatMode();
    }

    public void toggleRepeat() {
        RepeatMode newValue = ((JukeboxUpgradeWrapper)this.upgradeWrapper).getRepeatMode().next();
        ((JukeboxUpgradeWrapper)this.upgradeWrapper).setRepeatMode(newValue);
        this.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundTag(), "repeat", newValue));
    }

    public Optional<Slot> getDiscSlotActive() {
        int discSlotActive = ((JukeboxUpgradeWrapper)this.upgradeWrapper).getDiscSlotActive();
        return discSlotActive > -1 ? Optional.of((Slot)this.slots.get(discSlotActive)) : Optional.empty();
    }

    public long getDiscFinishTime() {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).getDiscFinishTime();
    }

    public Optional<Holder<JukeboxSong>> getJukeboxSong(Level level) {
        return ((JukeboxUpgradeWrapper)this.upgradeWrapper).getJukeboxSongHolder(level);
    }
}

