/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.magnet;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.IMagnetPreventionChecker;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;

public class MagnetUpgradeWrapper
extends UpgradeWrapperBase<MagnetUpgradeWrapper, MagnetUpgradeItem>
implements IContentsFilteredUpgrade,
ITickableUpgrade,
IPickupResponseUpgrade {
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    private static final String ALLOW_MACHINE_MOVEMENT = "AllowMachineRemoteMovement";
    private static final int COOLDOWN_TICKS = 10;
    private static long nextTickTime = Long.MIN_VALUE;
    private static final int FULL_COOLDOWN_TICKS = 40;
    private final ContentsFilterLogic filterLogic;
    private static final Set<IMagnetPreventionChecker> magnetCheckers = new HashSet<IMagnetPreventionChecker>();

    public static void globalPostTick(LevelTickEvent.Pre event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        long gameTime = event.getLevel().getGameTime();
        if (gameTime > nextTickTime) {
            nextTickTime = gameTime + 10L;
        }
    }

    public static void onWorldUnload(LevelEvent.Unload evt) {
        nextTickTime = Long.MIN_VALUE;
    }

    public static void addMagnetPreventionChecker(IMagnetPreventionChecker checker) {
        magnetCheckers.add(checker);
    }

    public MagnetUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((MagnetUpgradeItem)this.upgradeItem).getFilterSlotCount(), storageWrapper::getInventoryHandler, storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    private boolean isInCooldown(Level level, @Nullable Entity entity) {
        if (!(entity instanceof Player)) {
            return super.isInCooldown(level);
        }
        return nextTickTime > level.getGameTime();
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    @Override
    public int pickup(Level level, ItemResource resource, int amount, TransactionContext tx) {
        if (!this.shouldPickupItems() || !this.filterLogic.matchesFilter(resource)) {
            return 0;
        }
        return this.storageWrapper.getInventoryForUpgradeProcessing().insert((Resource)resource, amount, tx);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        int cooldown;
        if (this.isInCooldown(level, entity)) {
            return;
        }
        int n = cooldown = this.shouldPickupItems() ? this.pickupItems(entity, level, pos) : 40;
        if (this.shouldPickupXp() && this.canFillStorageWithXp()) {
            cooldown = Math.min(cooldown, this.pickupXpOrbs(entity, level, pos));
        }
        this.setCooldown(level, cooldown);
    }

    private boolean canFillStorageWithXp() {
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> {
            try (Transaction tx = Transaction.openRoot();){
                Boolean bl = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, 1, (Fluid)ModFluids.XP_STILL.get(), (TransactionContext)tx) > 0;
                return bl;
            }
        }).orElse(false);
    }

    private int pickupXpOrbs(@Nullable Entity entity, Level level, BlockPos pos) {
        List xpEntities = level.getEntitiesOfClass(ExperienceOrb.class, new AABB(pos).inflate((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (xpEntities.isEmpty()) {
            return 10;
        }
        int cooldown = 10;
        for (ExperienceOrb xpOrb : xpEntities) {
            if (!xpOrb.isAlive() || this.canNotPickup((Entity)xpOrb, entity) || this.tryToFillTank(xpOrb, entity, level)) continue;
            cooldown = 40;
            break;
        }
        return cooldown;
    }

    private boolean tryToFillTank(ExperienceOrb xpOrb, @Nullable Entity entity, Level level) {
        int amountToTransfer = XpHelper.experienceToLiquid(xpOrb.getValue());
        return this.storageWrapper.getFluidHandler().map(fluidHandler -> {
            int amountAdded;
            try (Transaction tx = Transaction.openRoot();){
                amountAdded = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, amountToTransfer, (Fluid)ModFluids.XP_STILL.get(), (TransactionContext)tx);
                if (amountAdded > 0) {
                    tx.commit();
                }
            }
            if (amountAdded > 0) {
                Player player;
                Vec3 pos = xpOrb.position();
                xpOrb.setValue(0);
                xpOrb.discard();
                Player player2 = player = entity instanceof Player ? (Player)entity : null;
                if (player != null) {
                    MagnetUpgradeWrapper.playXpPickupSound(level, player);
                }
                if (amountToTransfer > amountAdded) {
                    level.addFreshEntity((Entity)new ExperienceOrb(level, pos.x(), pos.y(), pos.z(), (int)XpHelper.liquidToExperience(amountToTransfer - amountAdded)));
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int pickupItems(@Nullable Entity entity, Level level, BlockPos pos) {
        List itemEntities = level.getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate((double)((MagnetUpgradeItem)this.upgradeItem).getRadius()), e -> true);
        if (itemEntities.isEmpty()) {
            return 10;
        }
        Player player = entity instanceof Player ? (Player)entity : null;
        int cooldown = 40;
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.isAlive() || !this.filterLogic.matchesFilter(itemEntity.getItem()) || this.canNotPickup((Entity)itemEntity, entity) || !this.tryToInsertItem(player, itemEntity)) continue;
            if (player != null) {
                MagnetUpgradeWrapper.playItemPickupSound(level, player);
            }
            cooldown = 10;
        }
        return cooldown;
    }

    private static void playItemPickupSound(Level level, @Nonnull Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (level.random.nextFloat() - level.random.nextFloat()) * 1.4f + 2.0f);
    }

    private static void playXpPickupSound(Level level, @Nonnull Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, (level.random.nextFloat() - level.random.nextFloat()) * 0.35f + 0.9f);
    }

    private boolean isBlockedBySomething(Entity entity) {
        for (IMagnetPreventionChecker checker : magnetCheckers) {
            if (!checker.isBlocked(entity)) continue;
            return true;
        }
        return false;
    }

    private boolean canNotPickup(Entity pickedUpEntity, @Nullable Entity entity) {
        if (this.isBlockedBySomething(pickedUpEntity)) {
            return true;
        }
        CompoundTag data = pickedUpEntity.getPersistentData();
        return entity instanceof Player ? data.contains(PREVENT_REMOTE_MOVEMENT) : data.contains(PREVENT_REMOTE_MOVEMENT) && !data.contains(ALLOW_MACHINE_MOVEMENT);
    }

    private boolean tryToInsertItem(@Nullable Player player, ItemEntity itemEntity) {
        int inserted;
        ItemStack stack = itemEntity.getItem();
        ItemResource resource = ItemResource.of((ItemStack)stack);
        try (Transaction tx = Transaction.openRoot();){
            inserted = this.storageWrapper.getInventoryForUpgradeProcessing().insert((Resource)resource, stack.getCount(), (TransactionContext)tx);
            if (inserted == 0) {
                boolean bl = false;
                return bl;
            }
            tx.commit();
        }
        itemEntity.setItem(resource.toStack(stack.getCount() - inserted));
        if (player != null) {
            player.awardStat(Stats.ITEM_PICKED_UP.get((Object)stack.getItem()), stack.getCount() - inserted);
        }
        return true;
    }

    public void setPickupItems(boolean pickupItems) {
        this.upgrade.set(ModCoreDataComponents.PICKUP_ITEMS, (Object)pickupItems);
        this.save();
    }

    public boolean shouldPickupItems() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.PICKUP_ITEMS, (Object)true);
    }

    public void setPickupXp(boolean pickupXp) {
        this.upgrade.set(ModCoreDataComponents.PICKUP_XP, (Object)pickupXp);
        this.save();
    }

    public boolean shouldPickupXp() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.PICKUP_XP, (Object)true);
    }
}

