/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.PlayerInventoryWrapper;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotStackAccessor;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.commons.lang3.mutable.MutableInt;

public class InventoryHelper {
    private static final List<Function<Player, ResourceHandler<ItemResource>>> PLAYER_INVENTORY_PROVIDERS = new ArrayList<Function<Player, ResourceHandler<ItemResource>>>();
    private static final List<Function<Player, ResourceHandler<ItemResource>>> PLAYER_EQUIPMENT_INVENTORY_PROVIDERS = new ArrayList<Function<Player, ResourceHandler<ItemResource>>>();

    private InventoryHelper() {
    }

    public static void registerEquipmentInventoryProvider(Function<Player, ResourceHandler<ItemResource>> provider) {
        PLAYER_EQUIPMENT_INVENTORY_PROVIDERS.add(provider);
    }

    public static void registerPlayerInventoryProvider(Function<Player, ResourceHandler<ItemResource>> provider) {
        PLAYER_INVENTORY_PROVIDERS.add(provider);
    }

    public static Optional<ItemStack> getItemFromEitherHand(Player player, Item item) {
        ItemStack mainHandItem = player.getMainHandItem();
        if (mainHandItem.getItem() == item) {
            return Optional.of(mainHandItem);
        }
        ItemStack offhandItem = player.getOffhandItem();
        if (offhandItem.getItem() == item) {
            return Optional.of(offhandItem);
        }
        return Optional.empty();
    }

    public static boolean hasItem(ResourceHandler<ItemResource> inventory, Predicate<ItemResource> matches) {
        AtomicBoolean result = new AtomicBoolean(false);
        InventoryHelper.iterate(inventory, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> {
            if (!resource.isEmpty() && matches.test((ItemResource)resource)) {
                result.set(true);
            }
        }), result::get);
        return result.get();
    }

    public static Set<Integer> getItemSlots(InventoryHandler inventory, Predicate<ItemStack> matches) {
        HashSet<Integer> slots = new HashSet<Integer>();
        InventoryHelper.iterate(inventory, (Integer slot, ItemStack stack) -> {
            if (!stack.isEmpty() && matches.test((ItemStack)stack)) {
                slots.add((Integer)slot);
            }
        });
        return slots;
    }

    public static void copyTo(ResourceHandler<ItemResource> from, ResourceHandler<ItemResource> to) {
        try (Transaction tx = Transaction.openRoot();){
            int slots = Math.min(from.size(), to.size());
            for (int i = 0; i < slots; ++i) {
                ItemStack s = ((ItemResource)from.getResource(i)).toStack(from.getAmountAsInt(i));
                if (s.isEmpty()) continue;
                to.insert((Resource)ItemResource.of((ItemStack)s), s.getCount(), (TransactionContext)tx);
            }
            tx.commit();
        }
    }

    public static void insertOrDropItem(Player player, ItemStack stack, ResourceHandler<ItemResource> inventory) {
        ItemStack ret = stack.copy();
        int moved = InventoryHelper.insert(inventory, ItemResource.of((ItemStack)ret), ret.getCount());
        if (moved > 0) {
            ret.shrink(moved);
            if (ret.isEmpty()) {
                return;
            }
        }
        if (!ret.isEmpty()) {
            player.drop(ret, true);
        }
    }

    public static int runPickupOnPickupResponseUpgrades(Level level, UpgradeHandler upgradeHandler, ItemResource resource, int amount, TransactionContext tx) {
        List<IPickupResponseUpgrade> pickupUpgrades = upgradeHandler.getWrappersThatImplement(IPickupResponseUpgrade.class);
        int totalPickedup = 0;
        for (IPickupResponseUpgrade pickupUpgrade : pickupUpgrades) {
            int pickedUpCount = pickupUpgrade.pickup(level, resource, amount, tx);
            if ((totalPickedup += pickedUpCount) < amount) continue;
            return totalPickedup;
        }
        return totalPickedup;
    }

    public static void iteratePlayerInventory(Player player, BiConsumer<Integer, ItemStack> actOn) {
        for (int slot = 0; slot < player.getInventory().getContainerSize(); ++slot) {
            actOn.accept(slot, player.getInventory().getItem(slot));
        }
    }

    public static <T extends ResourceHandler<ItemResource> & ISlotStackAccessor> void iterate(T handler, BiConsumer<Integer, ItemStack> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static <T extends ResourceHandler<ItemResource> & ISlotStackAccessor> void iterate(T handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit) {
        InventoryHelper.iterate(handler, actOn, shouldExit, true);
    }

    public static <T extends ResourceHandler<ItemResource> & ISlotStackAccessor> void iterate(T handler, BiConsumer<Integer, ItemStack> actOn, BooleanSupplier shouldExit, boolean getVirtualCounts) {
        int slots = handler.size();
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack itemStack;
            if (!getVirtualCounts && handler instanceof InventoryHandler) {
                InventoryHandler inventoryHandler = (InventoryHandler)handler;
                itemStack = inventoryHandler.getInternalStack(slot);
            } else {
                itemStack = ((ISlotStackAccessor)handler).getStackInSlot(slot);
            }
            ItemStack stack = itemStack;
            actOn.accept(slot, stack);
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static void iterate(ResourceHandler<ItemResource> handler, TriConsumer<Integer, ItemResource, Integer> actOn) {
        InventoryHelper.iterate(handler, actOn, () -> false);
    }

    public static void iterate(ResourceHandler<ItemResource> handler, TriConsumer<Integer, ItemResource, Integer> actOn, BooleanSupplier shouldExit) {
        int slots = handler.size();
        for (int slot = 0; slot < slots; ++slot) {
            ItemResource resource = (ItemResource)handler.getResource(slot);
            int amount = handler.getAmountAsInt(slot);
            actOn.accept((Object)slot, (Object)resource, (Object)amount);
            if (shouldExit.getAsBoolean()) break;
        }
    }

    public static int getCountMissingInHandler(ResourceHandler<ItemResource> itemHandler, ItemResource filter, int expectedCount) {
        MutableInt missingCount = new MutableInt(expectedCount);
        InventoryHelper.iterate(itemHandler, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> {
            if (resource.equals((Object)filter)) {
                missingCount.subtract(Math.min(amount, missingCount.getValue()));
            }
        }), () -> missingCount.getValue() == 0);
        return missingCount.getValue();
    }

    public static <T, H extends ResourceHandler<ItemResource> & ISlotStackAccessor> T iterate(H handler, BiFunction<Integer, ItemStack, T> getFromStack, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        return (T)InventoryHelper.iterate(handler, (int slot) -> getFromStack.apply(slot, ((ISlotStackAccessor)handler).getStackInSlot(slot)), supplyDefault, shouldExit);
    }

    public static <T> T iterate(ResourceHandler<ItemResource> handler, TriFunction<Integer, ItemResource, Integer, T> getFromResource, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        return (T)InventoryHelper.iterate(handler, (int slot) -> getFromResource.apply((Object)slot, (Object)((ItemResource)handler.getResource(slot)), (Object)handler.getAmountAsInt(slot)), supplyDefault, shouldExit);
    }

    public static <T, H extends ResourceHandler<ItemResource>> T iterate(ResourceHandler<ItemResource> handler, IntFunction<T> getFromHandler, Supplier<T> supplyDefault, Predicate<T> shouldExit) {
        T apply;
        T ret = supplyDefault.get();
        int slots = handler.size();
        for (int slot = 0; slot < slots && !shouldExit.test(ret = (apply = getFromHandler.apply(slot))); ++slot) {
        }
        return ret;
    }

    public static ItemStack getAndRemove(ResourceHandler<ItemResource> itemHandler, int slot) {
        if (slot >= itemHandler.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ((ItemResource)itemHandler.getResource(slot)).toStack(itemHandler.getAmountAsInt(slot));
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        try (Transaction tx = Transaction.openRoot();){
            int moved = itemHandler.extract(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)tx);
            if (moved > 0) {
                tx.commit();
                ItemStack itemStack = stack.copyWithCount(moved);
                return itemStack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static List<Integer> getEmptySlotsRandomized(ResourceHandler<ItemResource> inventory) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.size(); ++i) {
            if (inventory.getAmountAsInt(i) != 0) continue;
            list.add(i);
        }
        Collections.shuffle(list, new Random());
        return list;
    }

    public static void shuffleItems(List<ItemStack> stacks, int emptySlotsCount, RandomSource rand) {
        ArrayList list = Lists.newArrayList();
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.isEmpty()) {
                iterator.remove();
                continue;
            }
            if (itemstack.getCount() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (emptySlotsCount - stacks.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.nextInt((RandomSource)rand, (int)0, (int)(list.size() - 1)));
            int i = Mth.nextInt((RandomSource)rand, (int)1, (int)(itemstack2.getCount() / 2));
            ItemStack itemstack1 = itemstack2.split(i);
            if (itemstack2.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack2);
            } else {
                stacks.add(itemstack2);
            }
            if (itemstack1.getCount() > 1 && rand.nextBoolean()) {
                list.add(itemstack1);
                continue;
            }
            stacks.add(itemstack1);
        }
        stacks.addAll(list);
        Collections.shuffle(stacks, new Random());
    }

    public static void dropResources(ResourceHandler<ItemResource> inventoryHandler, Level level, BlockPos pos) {
        InventoryHelper.dropResources(inventoryHandler, level, pos.getX(), pos.getY(), pos.getZ());
    }

    public static void dropResources(ResourceHandler<ItemResource> inventoryHandler, Level level, double x, double y, double z) {
        try (Transaction tx = Transaction.openRoot();){
            InventoryHelper.iterate(inventoryHandler, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> InventoryHelper.dropItem(inventoryHandler, level, x, y, z, slot, resource.toStack(amount.intValue()), tx)));
            tx.commit();
        }
    }

    public static <T extends ResourceHandler<ItemResource> & ISlotStackAccessor> void dropItems(T handler, Level level, double x, double y, double z) {
        try (Transaction tx = Transaction.openRoot();){
            InventoryHelper.iterate(handler, (Integer slot, ItemStack stack) -> InventoryHelper.dropItem(handler, level, x, y, z, slot, stack, tx), () -> false, false);
            tx.commit();
        }
    }

    public static void dropItem(ResourceHandler<ItemResource> handler, Level level, double x, double y, double z, Integer slot, ItemStack stack, Transaction tx) {
        int countToDrop;
        if (stack.isEmpty()) {
            return;
        }
        for (int totalCountToDrop = stack.getCount(); totalCountToDrop > 0; totalCountToDrop -= countToDrop) {
            countToDrop = Math.min(stack.getMaxStackSize(), totalCountToDrop);
            Containers.dropItemStack((Level)level, (double)x, (double)y, (double)z, (ItemStack)stack.copyWithCount(countToDrop));
        }
        handler.extract((Resource)((ItemResource)handler.getResource(slot.intValue())), handler.getAmountAsInt(slot.intValue()), (TransactionContext)tx);
    }

    public static int getAnalogOutputSignal(InventoryHandler handler) {
        AtomicDouble totalFilled = new AtomicDouble(0.0);
        AtomicBoolean isEmpty = new AtomicBoolean(true);
        InventoryHelper.iterate(handler, (Integer slot, ItemStack stack) -> {
            if (!stack.isEmpty()) {
                int slotLimit = handler.getInternalSlotLimit((int)slot);
                totalFilled.addAndGet((double)((float)stack.getCount() / ((float)slotLimit / (64.0f / (float)stack.getMaxStackSize()))));
                isEmpty.set(false);
            }
        });
        double percentFilled = totalFilled.get() / (double)handler.size();
        return Mth.floor((double)(percentFilled * 14.0)) + (isEmpty.get() ? 0 : 1);
    }

    public static List<ResourceHandler<ItemResource>> getItemHandlersFromPlayerIncludingContainers(Player player) {
        ArrayList<ResourceHandler<ItemResource>> itemHandlers = new ArrayList<ResourceHandler<ItemResource>>();
        PLAYER_INVENTORY_PROVIDERS.forEach(provider -> {
            ResourceHandler itemHandler = (ResourceHandler)provider.apply(player);
            itemHandlers.add(itemHandler);
            for (int slot = 0; slot < itemHandler.size(); ++slot) {
                ResourceHandler containerHandler;
                ItemStack slotStack = ((ItemResource)itemHandler.getResource(slot)).toStack(itemHandler.getAmountAsInt(slot));
                if (slotStack.isEmpty() || (containerHandler = (ResourceHandler)ItemAccess.forStack((ItemStack)slotStack).getCapability(Capabilities.Item.ITEM)) == null) continue;
                itemHandlers.add(containerHandler);
            }
        });
        return itemHandlers;
    }

    public static List<ResourceHandler<ItemResource>> getEquipmentItemHandlersFromPlayer(Player player) {
        ArrayList<ResourceHandler<ItemResource>> itemHandlers = new ArrayList<ResourceHandler<ItemResource>>();
        PLAYER_EQUIPMENT_INVENTORY_PROVIDERS.forEach(provider -> itemHandlers.add((ResourceHandler)provider.apply(player)));
        return itemHandlers;
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(InventoryHandler handler) {
        return InventoryHelper.getCompactedStacks(handler, new HashSet<Integer>());
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(InventoryHandler handler, Set<Integer> ignoreSlots) {
        return InventoryHelper.getCompactedStacks(handler, ignoreSlots, true);
    }

    static Map<ItemStackKey, Integer> getCompactedStacks(InventoryHandler handler, Set<Integer> ignoreSlots, boolean getVirtualCounts) {
        HashMap<ItemStackKey, Integer> ret = new HashMap<ItemStackKey, Integer>();
        InventoryHelper.iterate(handler, (Integer slot, ItemStack stack) -> {
            if (stack.isEmpty() || ignoreSlots.contains(slot)) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            ret.put(itemStackKey, ret.computeIfAbsent(itemStackKey, fs -> 0) + stack.getCount());
        }, () -> false, getVirtualCounts);
        return ret;
    }

    public static List<ItemStack> getCompactedStacksSortedByCount(InventoryHandler handler) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(InventorySorter.BY_COUNT);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        sortedList.forEach(e -> {
            ItemStack stackCopy = ((ItemStackKey)e.getKey()).stack().copy();
            stackCopy.setCount(((Integer)e.getValue()).intValue());
            ret.add(stackCopy);
        });
        return ret;
    }

    public static int mergeIntoPlayerInventory(Player player, ItemStack stack, int startSlot) {
        int moved = 0;
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int slot = startSlot; slot < player.getInventory().getNonEquipmentItems().size(); ++slot) {
            ItemStack slotStack = player.getInventory().getItem(slot);
            if (slotStack.isEmpty()) {
                emptySlots.add(slot);
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)stack)) continue;
            int count = Math.min(slotStack.getMaxStackSize() - slotStack.getCount(), stack.getCount() - moved);
            slotStack.grow(count);
            if ((moved += count) < stack.getCount()) continue;
            return moved;
        }
        Iterator iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack slotStack = stack.copyWithCount(Math.min(stack.getMaxStackSize(), stack.getCount() - moved));
            player.getInventory().setItem(slot, slotStack);
            if ((moved += slotStack.getCount()) < stack.getCount()) continue;
            return moved;
        }
        return moved;
    }

    public static Set<ItemStackKey> getUniqueStacks(InventoryHandler handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (Integer slot, ItemStack stack) -> {
            if (stack.isEmpty()) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(stack);
            uniqueStacks.add(itemStackKey);
        });
        return uniqueStacks;
    }

    public static Set<ItemStackKey> getUniqueStacks(ResourceHandler<ItemResource> handler) {
        HashSet<ItemStackKey> uniqueStacks = new HashSet<ItemStackKey>();
        InventoryHelper.iterate(handler, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> {
            if (resource.isEmpty()) {
                return;
            }
            ItemStackKey itemStackKey = ItemStackKey.of(resource);
            uniqueStacks.add(itemStackKey);
        }));
        return uniqueStacks;
    }

    public static List<ItemStack> insertIntoInventory(List<ItemStack> stacks, ResourceHandler<ItemResource> handler, TransactionContext tx) {
        if (stacks.isEmpty()) {
            return stacks;
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            int inserted = handler.insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), tx);
            if (inserted >= stack.getCount()) continue;
            remaining.add(stack.copyWithCount(stack.getCount() - inserted));
        }
        return remaining;
    }

    public static void set(ResourceHandler<ItemResource> handler, int index, ItemResource resource, int amount) {
        try (Transaction tx = Transaction.openRoot();){
            ItemResource currentResource = (ItemResource)handler.getResource(index);
            if (!currentResource.isEmpty()) {
                handler.extract(index, (Resource)currentResource, handler.getAmountAsInt(index), (TransactionContext)tx);
            }
            if (!resource.isEmpty()) {
                handler.insert(index, (Resource)resource, amount, (TransactionContext)tx);
            }
            tx.commit();
        }
    }

    public static int insert(int index, ResourceHandler<ItemResource> inv, ItemResource res, int amount) {
        try (Transaction tx = Transaction.openRoot();){
            int moved = inv.insert(index, (Resource)res, amount, (TransactionContext)tx);
            if (moved > 0) {
                tx.commit();
            }
            int n = moved;
            return n;
        }
    }

    public static List<ItemStack> getStacks(ResourceHandler<ItemResource> handler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        InventoryHelper.iterate(handler, (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> stacks.add(resource.toStack(amount.intValue()))));
        return stacks;
    }

    public static int insertMatchingFirst(ResourceHandler<ItemResource> inventory, ItemStack stack) {
        ItemResource resource = ItemResource.of((ItemStack)stack);
        int amount = stack.getCount();
        int inserted = 0;
        try (Transaction tx = Transaction.openRoot();){
            ItemResource slotResource;
            int index;
            for (index = 0; index < inventory.size(); ++index) {
                slotResource = (ItemResource)inventory.getResource(index);
                if (!slotResource.isEmpty() && slotResource.equals((Object)resource)) {
                    inserted += inventory.insert(index, (Resource)resource, amount - inserted, (TransactionContext)tx);
                }
                if (inserted == amount) break;
            }
            for (index = 0; index < inventory.size(); ++index) {
                slotResource = (ItemResource)inventory.getResource(index);
                if (slotResource.isEmpty()) {
                    inserted += inventory.insert(index, (Resource)resource, amount - inserted, (TransactionContext)tx);
                }
                if (inserted == amount) break;
            }
            if (inserted > 0) {
                tx.commit();
            }
        }
        return inserted;
    }

    public static int insert(ResourceHandler<ItemResource> inv, ItemStack stack) {
        return InventoryHelper.insert(inv, ItemResource.of((ItemStack)stack), stack.getCount());
    }

    public static int insert(ResourceHandler<ItemResource> inv, ItemResource res, int amount) {
        try (Transaction tx = Transaction.openRoot();){
            int moved = inv.insert((Resource)res, amount, (TransactionContext)tx);
            if (moved > 0) {
                tx.commit();
            }
            int n = moved;
            return n;
        }
    }

    public static int simulateInsert(ResourceHandler<ItemResource> inv, ItemResource res, int amount) {
        try (Transaction tx = Transaction.openRoot();){
            int n = inv.insert((Resource)res, amount, (TransactionContext)tx);
            return n;
        }
    }

    public static int extractMatching(ResourceHandler<ItemResource> inv, Predicate<ItemStack> match, int maxAmount, Transaction tx) {
        int moved = 0;
        int slots = inv.size();
        for (int i = 0; i < slots && moved < maxAmount; ++i) {
            ItemStack s = ((ItemResource)inv.getResource(i)).toStack(inv.getAmountAsInt(i));
            if (s.isEmpty() || !match.test(s)) continue;
            int want = Math.min(maxAmount - moved, s.getCount());
            moved += inv.extract(i, (Resource)ItemResource.of((ItemStack)s), want, (TransactionContext)tx);
        }
        return moved;
    }

    public static int extractMatching(ResourceHandler<ItemResource> inv, Predicate<ItemStack> match, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int moved = InventoryHelper.extractMatching(inv, match, maxAmount, tx);
            if (moved > 0) {
                tx.commit();
            }
            int n = moved;
            return n;
        }
    }

    public static int simulateExtractMatching(ResourceHandler<ItemResource> inv, Predicate<ItemStack> match, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int n = InventoryHelper.extractMatching(inv, match, maxAmount, tx);
            return n;
        }
    }

    public static int extract(ResourceHandler<ItemResource> inv, ItemStack wanted, int maxAmount, Transaction tx) {
        int limit = Math.min(maxAmount, wanted.getCount());
        return InventoryHelper.extractMatching(inv, s -> ItemStack.isSameItemSameComponents((ItemStack)s, (ItemStack)wanted), limit, tx);
    }

    public static int simulateExtractExact(ResourceHandler<ItemResource> inv, ItemResource wanted, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int n = inv.extract((Resource)wanted, maxAmount, (TransactionContext)tx);
            return n;
        }
    }

    public static int extract(ResourceHandler<ItemResource> inv, int index, ItemResource wanted, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int extracted = inv.extract(index, (Resource)wanted, maxAmount, (TransactionContext)tx);
            tx.commit();
            int n = extracted;
            return n;
        }
    }

    public static int extract(ResourceHandler<ItemResource> inv, ItemResource wanted, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int extracted = inv.extract((Resource)wanted, maxAmount, (TransactionContext)tx);
            tx.commit();
            int n = extracted;
            return n;
        }
    }

    public static int extract(ResourceHandler<ItemResource> inv, ItemStack stackToExtract) {
        try (Transaction tx = Transaction.openRoot();){
            int extracted = inv.extract((Resource)ItemResource.of((ItemStack)stackToExtract), stackToExtract.getCount(), (TransactionContext)tx);
            if (extracted > 0) {
                tx.commit();
            }
            int n = extracted;
            return n;
        }
    }

    public static int move(ResourceHandler<ItemResource> from, ResourceHandler<ItemResource> to, Predicate<ItemResource> filter, int maxAmount, Transaction tx) {
        return ResourceHandlerUtil.move(from, to, filter, (int)maxAmount, (TransactionContext)tx);
    }

    public static int move(ResourceHandler<ItemResource> from, ResourceHandler<ItemResource> to, Predicate<ItemResource> filter, int maxAmount) {
        try (Transaction tx = Transaction.openRoot();){
            int moved = InventoryHelper.move(from, to, filter, maxAmount, tx);
            if (moved > 0) {
                tx.commit();
            }
            int n = moved;
            return n;
        }
    }

    static {
        InventoryHelper.registerPlayerInventoryProvider(player -> (ResourceHandler)player.getCapability(Capabilities.Item.ENTITY));
        InventoryHelper.registerEquipmentInventoryProvider(player -> new CombinedResourceHandler(new ResourceHandler[]{PlayerInventoryWrapper.of((Player)player).getArmorSlots(), PlayerInventoryWrapper.of((Player)player).getHandSlots()}));
    }
}

