/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;

public class InventorySorter {
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_NAME = Comparator.comparing(o -> ((ItemStackKey)o.getKey()).stack().getHoverName().getString().toLowerCase());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_MOD = Comparator.comparing(o -> {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)((ItemStackKey)o.getKey()).stack().getItem());
        return registryName.getNamespace();
    }).thenComparing(o -> ((ItemStackKey)o.getKey()).stack().getHoverName().getString());
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_COUNT = (first, second) -> {
        int ret = ((Integer)second.getValue()).compareTo((Integer)first.getValue());
        return ret != 0 ? ret : InventorySorter.getRegistryName((ItemStackKey)first.getKey()).compareTo(InventorySorter.getRegistryName((ItemStackKey)second.getKey()));
    };
    public static final Comparator<Map.Entry<ItemStackKey, Integer>> BY_TAGS = new Comparator<Map.Entry<ItemStackKey, Integer>>(){

        @Override
        public int compare(Map.Entry<ItemStackKey, Integer> first, Map.Entry<ItemStackKey, Integer> second) {
            ItemStack secondStack;
            Item secondItem;
            ItemStack firstStack = first.getKey().stack();
            Item firstItem = firstStack.getItem();
            if (firstItem == (secondItem = (secondStack = second.getKey().stack()).getItem())) {
                return 0;
            }
            int ret = this.compareTags(firstStack.getTags().collect(Collectors.toSet()), secondStack.getTags().collect(Collectors.toSet()));
            return ret != 0 ? ret : InventorySorter.getRegistryName(first.getKey()).compareTo(InventorySorter.getRegistryName(second.getKey()));
        }

        private int compareTags(Set<TagKey<Item>> firstTags, Set<TagKey<Item>> secondTags) {
            int ret = Integer.compare(secondTags.size(), firstTags.size());
            if (ret != 0) {
                return ret;
            }
            if (firstTags.size() == 1) {
                return firstTags.iterator().next().location().compareTo(secondTags.iterator().next().location());
            }
            ArrayList<TagKey<Item>> firstTagsSorted = new ArrayList<TagKey<Item>>(firstTags);
            ArrayList<TagKey<Item>> secondTagsSorted = new ArrayList<TagKey<Item>>(secondTags);
            firstTagsSorted.sort(Comparator.comparing(TagKey::location));
            secondTagsSorted.sort(Comparator.comparing(TagKey::location));
            for (int i = 0; i < firstTagsSorted.size(); ++i) {
                ret = firstTagsSorted.get(i).location().compareTo(secondTagsSorted.get(i).location());
                if (ret == 0) continue;
                return ret;
            }
            return 0;
        }
    };

    private InventorySorter() {
    }

    private static String getRegistryName(ItemStackKey itemStackKey) {
        return BuiltInRegistries.ITEM.getKey((Object)itemStackKey.stack().getItem()).toString();
    }

    public static void sortHandler(InventoryHandler handler, Comparator<? super Map.Entry<ItemStackKey, Integer>> comparator, Set<Integer> noSortSlots) {
        Map<ItemStackKey, Integer> compactedStacks = InventoryHelper.getCompactedStacks(handler, noSortSlots, false);
        ArrayList<Map.Entry<ItemStackKey, Integer>> sortedList = new ArrayList<Map.Entry<ItemStackKey, Integer>>(compactedStacks.entrySet());
        sortedList.sort(comparator);
        int slots = handler.size();
        InventorySorter.sortIntoNoSortSlots(handler, noSortSlots, sortedList);
        InventorySorter.sortIntoOtherSlots(handler, noSortSlots, sortedList, slots);
    }

    private static void sortIntoOtherSlots(InventoryHandler handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList, int slots) {
        Iterator<Map.Entry<ItemStackKey, Integer>> ite = sortedList.iterator();
        ItemStackKey current = null;
        int count = 0;
        for (int slot = 0; slot < slots; ++slot) {
            if (noSortSlots.contains(slot)) continue;
            if ((current == null || count <= 0) && ite.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = ite.next();
                current = entry.getKey();
                count = entry.getValue();
            }
            if (current != null && count > 0) {
                count -= InventorySorter.placeStack(handler, current, count, slot, false);
                continue;
            }
            InventorySorter.emptySlot(handler, slot);
        }
    }

    private static void sortIntoNoSortSlots(InventoryHandler handler, Set<Integer> noSortSlots, List<Map.Entry<ItemStackKey, Integer>> sortedList) {
        Iterator<Map.Entry<ItemStackKey, Integer>> it = sortedList.iterator();
        if (!noSortSlots.isEmpty()) {
            block0: while (it.hasNext()) {
                Map.Entry<ItemStackKey, Integer> entry = it.next();
                ItemStackKey current = entry.getKey();
                Integer count = entry.getValue();
                for (int slot : noSortSlots) {
                    ItemStack slotStack = handler.getStackInSlot(slot);
                    if (!ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)current.stack())) continue;
                    int placedCount = InventorySorter.placeStack(handler, current, count, slot, true);
                    count = count - placedCount;
                    entry.setValue(count);
                    if (count > 0) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
    }

    private static void emptySlot(ResourceHandler<ItemResource> handler, int slot) {
        ItemResource resource = (ItemResource)handler.getResource(slot);
        if (!resource.isEmpty()) {
            if (handler instanceof InventoryHandler) {
                InventoryHandler inventoryHandler = (InventoryHandler)handler;
                inventoryHandler.setStackInSlot(slot, ItemStack.EMPTY);
            } else {
                InventoryHelper.extract(handler, resource, handler.getAmountAsInt(slot));
            }
        }
    }

    private static int placeStack(InventoryHandler handler, ItemStackKey current, int count, int slot, boolean countWithCurrentStack) {
        return InventorySorter.placeStack(current, count, slot, countWithCurrentStack, (s, stack) -> handler.getBaseCapacity(ItemResource.of((ItemStack)stack)), handler::getInternalStack, handler::setStackInSlot);
    }

    private static int placeStack(ItemStackKey current, int count, int slot, boolean countWithCurrentStack, IStackLimitGetter stackLimitGetter, ISlotStackGetter slotStackGetter, ISlotStackSetter slotStackSetter) {
        ItemStack copy = current.stack().copy();
        int slotLimit = stackLimitGetter.getStackLimit(slot, copy);
        int existingCount = slotStackGetter.getSlotStack(slot).getCount();
        if (countWithCurrentStack) {
            count += existingCount;
        }
        int countPlaced = Math.min(count, slotLimit);
        copy.setCount(countPlaced);
        if (!ItemStack.matches((ItemStack)slotStackGetter.getSlotStack(slot), (ItemStack)copy)) {
            slotStackSetter.setSlotStack(slot, copy);
        }
        return countWithCurrentStack ? countPlaced - existingCount : countPlaced;
    }

    private static interface IStackLimitGetter {
        public int getStackLimit(int var1, ItemStack var2);
    }

    private static interface ISlotStackGetter {
        public ItemStack getSlotStack(int var1);
    }

    private static interface ISlotStackSetter {
        public void setSlotStack(int var1, ItemStack var2);
    }
}

